/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.LongArray;
import com.objectspace.jgl.adapters.LongBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class LongIterator
implements RandomAccessIterator,
Serializable {
    long[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = -1074640010234074351L;

    public static LongIterator begin(long[] lArray) {
        return new LongIterator(lArray, 0);
    }

    public static LongIterator end(long[] lArray) {
        return new LongIterator(lArray, lArray.length);
    }

    public LongIterator() {
        this(new LongArray(), 0);
    }

    public LongIterator(LongIterator longIterator) {
        this.buffer = longIterator.buffer;
        this.original = longIterator.original;
        this.index = longIterator.index;
    }

    public LongIterator(long[] lArray, int n2) {
        this(new LongArray(lArray), n2);
    }

    public LongIterator(LongArray longArray, int n2) {
        this.buffer = longArray.array;
        this.original = longArray;
        this.index = n2;
    }

    public LongIterator(LongBuffer longBuffer, int n2) {
        this.buffer = longBuffer.storage;
        this.original = longBuffer;
        this.index = n2;
    }

    public Object clone() {
        return new LongIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof LongIterator)) break block2;
                LongIterator longIterator = (LongIterator)object;
                if (longIterator.index == this.index && (longIterator.buffer == this.buffer || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(LongIterator longIterator) {
        return longIterator.index == this.index && longIterator.buffer == this.buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((LongIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n2) {
        this.index += n2;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n2) {
        this.index -= n2;
    }

    public Object nextElement() {
        try {
            Long l2 = new Long(this.buffer[this.index]);
            ++this.index;
            return l2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("LongIterator");
        }
    }

    public Object get() {
        return new Long(this.buffer[this.index]);
    }

    public long getLong() {
        return this.buffer[this.index];
    }

    public Object get(int n2) {
        return new Long(this.buffer[this.index + n2]);
    }

    public long getLong(int n2) {
        return this.buffer[this.index + n2];
    }

    public void put(Object object) {
        long l2;
        this.buffer[this.index] = l2 = ((Number)object).longValue();
    }

    public void put(long l2) {
        this.buffer[this.index] = l2;
    }

    public void put(int n2, Object object) {
        long l2;
        this.buffer[this.index + n2] = l2 = ((Number)object).longValue();
    }

    public void put(int n2, long l2) {
        this.buffer[this.index + n2] = l2;
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof LongIterator) || this.buffer != ((LongIterator)forwardIterator2).buffer && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((LongIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof LongIterator && this.buffer == ((LongIterator)inputIterator).buffer;
    }
}

