/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.LongArray;
import com.objectspace.jgl.adapters.LongIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class LongBuffer
implements Sequence {
    static final long defaultValue = 0L;
    long[] storage;
    int length;
    static final long serialVersionUID = 568000230794422863L;

    public LongBuffer() {
        this.clear();
    }

    public LongBuffer(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to create an LongBuffer with a negative size");
        }
        this.length = n2;
        this.storage = new long[this.length];
    }

    public LongBuffer(int n2, long l2) {
        this(n2);
        int n3 = 0;
        while (n3 < this.length) {
            this.storage[n3] = l2;
            ++n3;
        }
    }

    public LongBuffer(long[] lArray) {
        this(lArray, true);
    }

    LongBuffer(long[] lArray, boolean bl) {
        long[] lArray2 = lArray;
        synchronized (lArray2) {
            this.length = lArray.length;
            if (bl) {
                this.storage = new long[this.length];
                System.arraycopy(lArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = lArray;
            }
            return;
        }
    }

    public LongBuffer(LongBuffer longBuffer) {
        this(longBuffer.storage);
    }

    public synchronized Object clone() {
        return new LongBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof LongBuffer && this.equals((LongBuffer)object) || object instanceof LongArray && this.equals((LongArray)object);
    }

    public boolean equals(LongBuffer longBuffer) {
        return this.equals(new LongArray(longBuffer.storage));
    }

    public synchronized boolean equals(LongArray longArray) {
        return longArray.equals(this.storage);
    }

    public boolean equals(long[] lArray) {
        return this.equals(new LongArray(lArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "LongBuffer");
    }

    public synchronized void copy(LongBuffer longBuffer) {
        if (this == longBuffer) {
            return;
        }
        LongBuffer longBuffer2 = longBuffer;
        synchronized (longBuffer2) {
            if (longBuffer.length > this.storage.length) {
                this.storage = longBuffer.get();
            } else {
                System.arraycopy(longBuffer.storage, 0, this.storage, 0, longBuffer.length);
                int n2 = longBuffer.length;
                while (n2 < this.length) {
                    this.storage[n2] = 0L;
                    ++n2;
                }
            }
            this.length = longBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(long[] lArray) {
        long[] lArray2 = lArray;
        synchronized (lArray2) {
            System.arraycopy(this.storage, 0, lArray, 0, Math.min(this.length, lArray.length));
            return;
        }
    }

    public synchronized long[] get() {
        long[] lArray = new long[this.length];
        this.copyTo(lArray);
        return lArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n2) {
        return new Long(this.longAt(n2));
    }

    public synchronized long longAt(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        return this.storage[n2];
    }

    public synchronized void put(int n2, Object object) {
        this.put(n2, ((Number)object).longValue());
    }

    public synchronized void put(int n2, long l2) {
        ArrayAdapter.checkIndex(n2, this.length);
        this.storage[n2] = l2;
    }

    public synchronized void clear() {
        this.storage = new long[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof LongIterator)) {
            throw new IllegalArgumentException("Enumeration not an LongIterator");
        }
        if (((LongIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this LongBuffer ");
        }
        Serializable serializable = (LongIterator)enumeration;
        serializable = new Long(serializable.buffer[serializable.index]);
        this.remove(((LongIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        Long l2 = new Long(this.storage[n2]);
        System.arraycopy(this.storage, n2 + 1, this.storage, n2, this.length - n2 - 1);
        this.storage[--this.length] = 0L;
        return l2;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof LongIterator) || !(enumeration2 instanceof LongIterator)) {
                    throw new IllegalArgumentException("Enumeration not an LongIterator");
                }
                if (((LongIterator)enumeration).buffer != this.storage) break block4;
                LongIterator longIterator = (LongIterator)enumeration;
                LongIterator longIterator2 = (LongIterator)enumeration2;
                if (!(longIterator2 instanceof LongIterator) || longIterator.buffer != longIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((LongIterator)enumeration).index, ((LongIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = n3 - n2 + 1;
        System.arraycopy(this.storage, n3 + 1, this.storage, n2, this.length - n3 - 1);
        int n5 = this.length - n4;
        while (n5 < this.length) {
            this.storage[n5] = 0L;
            ++n5;
        }
        this.length -= n4;
        return n4;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("LongBuffer is empty");
        }
        Long l2 = new Long(this.storage[--this.length]);
        this.storage[this.length] = 0L;
        return l2;
    }

    public synchronized Object add(Object object) {
        this.add(((Number)object).longValue());
        return null;
    }

    public synchronized void add(long l2) {
        if (this.length == this.storage.length) {
            long[] lArray = this.getNextStorage(1);
            this.copyTo(lArray);
            this.storage = lArray;
        }
        this.storage[this.length++] = l2;
    }

    public void pushBack(Object object) {
        this.add(((Number)object).longValue());
    }

    public void pushBack(long l2) {
        this.add(l2);
    }

    public LongIterator insert(LongIterator longIterator, Object object) {
        return this.insert(longIterator, ((Number)object).longValue());
    }

    public LongIterator insert(LongIterator longIterator, long l2) {
        this.insert(longIterator.index, l2);
        return new LongIterator(this, longIterator.index);
    }

    public void insert(int n2, Object object) {
        this.insert(n2, ((Number)object).longValue());
    }

    public synchronized void insert(int n2, long l2) {
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.length != this.storage.length) {
            if (n2 != this.length) {
                System.arraycopy(this.storage, n2, this.storage, n2 + 1, this.length - n2);
            }
        } else {
            long[] lArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, lArray, 0, n2);
            System.arraycopy(this.storage, n2, lArray, n2 + 1, this.length - n2);
            this.storage = lArray;
        }
        this.storage[n2] = l2;
        ++this.length;
    }

    public void insert(LongIterator longIterator, int n2, Object object) {
        this.insert(longIterator, n2, ((Number)object).longValue());
    }

    public void insert(LongIterator longIterator, int n2, long l2) {
        this.insert(longIterator.index, n2, l2);
    }

    public void insert(int n2, int n3, Object object) {
        this.insert(n2, n3, ((Number)object).longValue());
    }

    public synchronized void insert(int n2, int n3, long l2) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n3 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            long[] lArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, lArray, 0, n2);
            System.arraycopy(this.storage, n2, lArray, n2 + n3, this.length - n2);
            this.storage = lArray;
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.storage[n4] = l2;
            ++n4;
        }
        this.length += n3;
    }

    public void insert(LongIterator longIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(longIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n2, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n3 = forwardIterator.distance(forwardIterator2);
        if (n3 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            long[] lArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, lArray, 0, n2);
            System.arraycopy(this.storage, n2, lArray, n2 + n3, this.length - n2);
            this.storage = lArray;
        }
        this.length += n3;
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.put(n4, forwardIterator3.nextElement());
            ++n4;
        }
    }

    public synchronized void swap(LongBuffer longBuffer) {
        LongBuffer longBuffer2 = longBuffer;
        synchronized (longBuffer2) {
            int n2 = this.length;
            long[] lArray = this.storage;
            this.length = longBuffer.length;
            this.storage = longBuffer.storage;
            longBuffer.length = n2;
            longBuffer.storage = lArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized LongIterator begin() {
        return new LongIterator(this, 0);
    }

    public synchronized LongIterator end() {
        return new LongIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n2) {
            long[] lArray = new long[n2];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, lArray, 0, this.length);
            }
            this.storage = lArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("LongBuffer is empty");
        }
        Long l2 = new Long(this.storage[0]);
        this.remove(0);
        return l2;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(long l2) {
        this.insert(0, l2);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n2) {
        long l2 = ((Number)object).longValue();
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.indexOf(l2);
            if (n4 < 0) break;
            --n2;
            ++n3;
            this.remove(n4);
        }
        return n3;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        ((Number)object).longValue();
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        LongIterator longIterator = new LongIterator(this, n2);
        LongIterator longIterator2 = new LongIterator(this, n3 + 1);
        LongIterator longIterator3 = (LongIterator)Algorithms.Removing.remove(longIterator, longIterator2, object);
        return this.remove(longIterator3.index, n3);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Number)object).longValue(), ((Number)object2).longValue());
    }

    public int replace(long l2, long l3) {
        return this.replace(0, this.length - 1, l2, l3);
    }

    public int replace(int n2, int n3, Object object, Object object2) {
        return this.replace(n2, n3, ((Number)object).longValue(), ((Number)object2).longValue());
    }

    public synchronized int replace(int n2, int n3, long l2, long l3) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == l2) {
                this.storage[n2] = l3;
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int count(Object object) {
        return this.count(((Number)object).longValue());
    }

    public int count(long l2) {
        return this.count(0, this.length - 1, l2);
    }

    public int count(int n2, int n3, Object object) {
        return this.count(n2, n3, ((Number)object).longValue());
    }

    public synchronized int count(int n2, int n3, long l2) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == l2) {
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Number)object).longValue());
    }

    public int indexOf(long l2) {
        return this.indexOf(0, this.length - 1, l2);
    }

    public int indexOf(int n2, int n3, Object object) {
        return this.indexOf(n2, n3, ((Number)object).longValue());
    }

    public synchronized int indexOf(int n2, int n3, long l2) {
        if (n3 < n2) {
            return -1;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        while (n2 < n3) {
            if (this.storage[n2] == l2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized void setSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n2) {
            this.remove(n2, this.length - 1);
            return;
        }
        if (this.length < n2) {
            this.insert(this.length, n2 - this.length, 0L);
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Number)object).longValue());
    }

    public boolean contains(long l2) {
        return this.indexOf(l2) != -1;
    }

    private long[] getNextStorage(int n2) {
        int n3 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n2);
        long[] lArray = new long[n3];
        return lArray;
    }

    static long asLong(Object object) {
        return ((Number)object).longValue();
    }
}

