/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.DoubleArray;
import com.objectspace.jgl.adapters.DoubleIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class DoubleBuffer
implements Sequence {
    static final double defaultValue = 0.0;
    double[] storage;
    int length;
    static final long serialVersionUID = 2440304957869661623L;

    public DoubleBuffer() {
        this.clear();
    }

    public DoubleBuffer(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to create an DoubleBuffer with a negative size");
        }
        this.length = n2;
        this.storage = new double[this.length];
    }

    public DoubleBuffer(int n2, double d2) {
        this(n2);
        int n3 = 0;
        while (n3 < this.length) {
            this.storage[n3] = d2;
            ++n3;
        }
    }

    public DoubleBuffer(double[] dArray) {
        this(dArray, true);
    }

    DoubleBuffer(double[] dArray, boolean bl) {
        double[] dArray2 = dArray;
        synchronized (dArray2) {
            this.length = dArray.length;
            if (bl) {
                this.storage = new double[this.length];
                System.arraycopy(dArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = dArray;
            }
            return;
        }
    }

    public DoubleBuffer(DoubleBuffer doubleBuffer) {
        this(doubleBuffer.storage);
    }

    public synchronized Object clone() {
        return new DoubleBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof DoubleBuffer && this.equals((DoubleBuffer)object) || object instanceof DoubleArray && this.equals((DoubleArray)object);
    }

    public boolean equals(DoubleBuffer doubleBuffer) {
        return this.equals(new DoubleArray(doubleBuffer.storage));
    }

    public synchronized boolean equals(DoubleArray doubleArray) {
        return doubleArray.equals(this.storage);
    }

    public boolean equals(double[] dArray) {
        return this.equals(new DoubleArray(dArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "DoubleBuffer");
    }

    public synchronized void copy(DoubleBuffer doubleBuffer) {
        if (this == doubleBuffer) {
            return;
        }
        DoubleBuffer doubleBuffer2 = doubleBuffer;
        synchronized (doubleBuffer2) {
            if (doubleBuffer.length > this.storage.length) {
                this.storage = doubleBuffer.get();
            } else {
                System.arraycopy(doubleBuffer.storage, 0, this.storage, 0, doubleBuffer.length);
                int n2 = doubleBuffer.length;
                while (n2 < this.length) {
                    this.storage[n2] = 0.0;
                    ++n2;
                }
            }
            this.length = doubleBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(double[] dArray) {
        double[] dArray2 = dArray;
        synchronized (dArray2) {
            System.arraycopy(this.storage, 0, dArray, 0, Math.min(this.length, dArray.length));
            return;
        }
    }

    public synchronized double[] get() {
        double[] dArray = new double[this.length];
        this.copyTo(dArray);
        return dArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n2) {
        return new Double(this.doubleAt(n2));
    }

    public synchronized double doubleAt(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        return this.storage[n2];
    }

    public synchronized void put(int n2, Object object) {
        this.put(n2, ((Number)object).doubleValue());
    }

    public synchronized void put(int n2, double d2) {
        ArrayAdapter.checkIndex(n2, this.length);
        this.storage[n2] = d2;
    }

    public synchronized void clear() {
        this.storage = new double[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof DoubleIterator)) {
            throw new IllegalArgumentException("Enumeration not an DoubleIterator");
        }
        if (((DoubleIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this DoubleBuffer ");
        }
        Serializable serializable = (DoubleIterator)enumeration;
        serializable = new Double(serializable.buffer[serializable.index]);
        this.remove(((DoubleIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        Double d2 = new Double(this.storage[n2]);
        System.arraycopy(this.storage, n2 + 1, this.storage, n2, this.length - n2 - 1);
        this.storage[--this.length] = 0.0;
        return d2;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof DoubleIterator) || !(enumeration2 instanceof DoubleIterator)) {
                    throw new IllegalArgumentException("Enumeration not an DoubleIterator");
                }
                if (((DoubleIterator)enumeration).buffer != this.storage) break block4;
                DoubleIterator doubleIterator = (DoubleIterator)enumeration;
                DoubleIterator doubleIterator2 = (DoubleIterator)enumeration2;
                if (!(doubleIterator2 instanceof DoubleIterator) || doubleIterator.buffer != doubleIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((DoubleIterator)enumeration).index, ((DoubleIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = n3 - n2 + 1;
        System.arraycopy(this.storage, n3 + 1, this.storage, n2, this.length - n3 - 1);
        int n5 = this.length - n4;
        while (n5 < this.length) {
            this.storage[n5] = 0.0;
            ++n5;
        }
        this.length -= n4;
        return n4;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("DoubleBuffer is empty");
        }
        Double d2 = new Double(this.storage[--this.length]);
        this.storage[this.length] = 0.0;
        return d2;
    }

    public synchronized Object add(Object object) {
        this.add(((Number)object).doubleValue());
        return null;
    }

    public synchronized void add(double d2) {
        if (this.length == this.storage.length) {
            double[] dArray = this.getNextStorage(1);
            this.copyTo(dArray);
            this.storage = dArray;
        }
        this.storage[this.length++] = d2;
    }

    public void pushBack(Object object) {
        this.add(((Number)object).doubleValue());
    }

    public void pushBack(double d2) {
        this.add(d2);
    }

    public DoubleIterator insert(DoubleIterator doubleIterator, Object object) {
        return this.insert(doubleIterator, ((Number)object).doubleValue());
    }

    public DoubleIterator insert(DoubleIterator doubleIterator, double d2) {
        this.insert(doubleIterator.index, d2);
        return new DoubleIterator(this, doubleIterator.index);
    }

    public void insert(int n2, Object object) {
        this.insert(n2, ((Number)object).doubleValue());
    }

    public synchronized void insert(int n2, double d2) {
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.length != this.storage.length) {
            if (n2 != this.length) {
                System.arraycopy(this.storage, n2, this.storage, n2 + 1, this.length - n2);
            }
        } else {
            double[] dArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, dArray, 0, n2);
            System.arraycopy(this.storage, n2, dArray, n2 + 1, this.length - n2);
            this.storage = dArray;
        }
        this.storage[n2] = d2;
        ++this.length;
    }

    public void insert(DoubleIterator doubleIterator, int n2, Object object) {
        this.insert(doubleIterator, n2, ((Number)object).doubleValue());
    }

    public void insert(DoubleIterator doubleIterator, int n2, double d2) {
        this.insert(doubleIterator.index, n2, d2);
    }

    public void insert(int n2, int n3, Object object) {
        this.insert(n2, n3, ((Number)object).doubleValue());
    }

    public synchronized void insert(int n2, int n3, double d2) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n3 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            double[] dArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, dArray, 0, n2);
            System.arraycopy(this.storage, n2, dArray, n2 + n3, this.length - n2);
            this.storage = dArray;
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.storage[n4] = d2;
            ++n4;
        }
        this.length += n3;
    }

    public void insert(DoubleIterator doubleIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(doubleIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n2, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n3 = forwardIterator.distance(forwardIterator2);
        if (n3 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            double[] dArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, dArray, 0, n2);
            System.arraycopy(this.storage, n2, dArray, n2 + n3, this.length - n2);
            this.storage = dArray;
        }
        this.length += n3;
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.put(n4, forwardIterator3.nextElement());
            ++n4;
        }
    }

    public synchronized void swap(DoubleBuffer doubleBuffer) {
        DoubleBuffer doubleBuffer2 = doubleBuffer;
        synchronized (doubleBuffer2) {
            int n2 = this.length;
            double[] dArray = this.storage;
            this.length = doubleBuffer.length;
            this.storage = doubleBuffer.storage;
            doubleBuffer.length = n2;
            doubleBuffer.storage = dArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized DoubleIterator begin() {
        return new DoubleIterator(this, 0);
    }

    public synchronized DoubleIterator end() {
        return new DoubleIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n2) {
            double[] dArray = new double[n2];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, dArray, 0, this.length);
            }
            this.storage = dArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("DoubleBuffer is empty");
        }
        Double d2 = new Double(this.storage[0]);
        this.remove(0);
        return d2;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(double d2) {
        this.insert(0, d2);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n2) {
        double d2 = ((Number)object).doubleValue();
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.indexOf(d2);
            if (n4 < 0) break;
            --n2;
            ++n3;
            this.remove(n4);
        }
        return n3;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        ((Number)object).doubleValue();
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        DoubleIterator doubleIterator = new DoubleIterator(this, n2);
        DoubleIterator doubleIterator2 = new DoubleIterator(this, n3 + 1);
        DoubleIterator doubleIterator3 = (DoubleIterator)Algorithms.Removing.remove(doubleIterator, doubleIterator2, object);
        return this.remove(doubleIterator3.index, n3);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Number)object).doubleValue(), ((Number)object2).doubleValue());
    }

    public int replace(double d2, double d3) {
        return this.replace(0, this.length - 1, d2, d3);
    }

    public int replace(int n2, int n3, Object object, Object object2) {
        return this.replace(n2, n3, ((Number)object).doubleValue(), ((Number)object2).doubleValue());
    }

    public synchronized int replace(int n2, int n3, double d2, double d3) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == d2) {
                this.storage[n2] = d3;
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int count(Object object) {
        return this.count(((Number)object).doubleValue());
    }

    public int count(double d2) {
        return this.count(0, this.length - 1, d2);
    }

    public int count(int n2, int n3, Object object) {
        return this.count(n2, n3, ((Number)object).doubleValue());
    }

    public synchronized int count(int n2, int n3, double d2) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == d2) {
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Number)object).doubleValue());
    }

    public int indexOf(double d2) {
        return this.indexOf(0, this.length - 1, d2);
    }

    public int indexOf(int n2, int n3, Object object) {
        return this.indexOf(n2, n3, ((Number)object).doubleValue());
    }

    public synchronized int indexOf(int n2, int n3, double d2) {
        if (n3 < n2) {
            return -1;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        while (n2 < n3) {
            if (this.storage[n2] == d2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized void setSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n2) {
            this.remove(n2, this.length - 1);
            return;
        }
        if (this.length < n2) {
            this.insert(this.length, n2 - this.length, 0.0);
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Number)object).doubleValue());
    }

    public boolean contains(double d2) {
        return this.indexOf(d2) != -1;
    }

    private double[] getNextStorage(int n2) {
        int n3 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n2);
        double[] dArray = new double[n3];
        return dArray;
    }

    static double asDouble(Object object) {
        return ((Number)object).doubleValue();
    }
}

