/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.CharArray;
import com.objectspace.jgl.adapters.CharBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class CharIterator
implements RandomAccessIterator,
Serializable {
    char[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = 2176327841327675493L;

    public static CharIterator begin(char[] cArray) {
        return new CharIterator(cArray, 0);
    }

    public static CharIterator end(char[] cArray) {
        return new CharIterator(cArray, cArray.length);
    }

    public CharIterator() {
        this(new CharArray(), 0);
    }

    public CharIterator(CharIterator charIterator) {
        this.buffer = charIterator.buffer;
        this.original = charIterator.original;
        this.index = charIterator.index;
    }

    public CharIterator(char[] cArray, int n2) {
        this(new CharArray(cArray), n2);
    }

    public CharIterator(CharArray charArray, int n2) {
        this.buffer = charArray.array;
        this.original = charArray;
        this.index = n2;
    }

    public CharIterator(CharBuffer charBuffer, int n2) {
        this.buffer = charBuffer.storage;
        this.original = charBuffer;
        this.index = n2;
    }

    public Object clone() {
        return new CharIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof CharIterator)) break block2;
                CharIterator charIterator = (CharIterator)object;
                if (charIterator.index == this.index && (charIterator.buffer == this.buffer || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(CharIterator charIterator) {
        return charIterator.index == this.index && charIterator.buffer == this.buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((CharIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n2) {
        this.index += n2;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n2) {
        this.index -= n2;
    }

    public Object nextElement() {
        try {
            Character c2 = new Character(this.buffer[this.index]);
            ++this.index;
            return c2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("CharIterator");
        }
    }

    public Object get() {
        return new Character(this.buffer[this.index]);
    }

    public char getChar() {
        return this.buffer[this.index];
    }

    public Object get(int n2) {
        return new Character(this.buffer[this.index + n2]);
    }

    public char getChar(int n2) {
        return this.buffer[this.index + n2];
    }

    public void put(Object object) {
        char c2;
        this.buffer[this.index] = c2 = ((Character)object).charValue();
    }

    public void put(char c2) {
        this.buffer[this.index] = c2;
    }

    public void put(int n2, Object object) {
        char c2;
        this.buffer[this.index + n2] = c2 = ((Character)object).charValue();
    }

    public void put(int n2, char c2) {
        this.buffer[this.index + n2] = c2;
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof CharIterator) || this.buffer != ((CharIterator)forwardIterator2).buffer && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((CharIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof CharIterator && this.buffer == ((CharIterator)inputIterator).buffer;
    }
}

