/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.CharBuffer;
import com.objectspace.jgl.adapters.CharIterator;
import java.util.Enumeration;

public class CharArray
extends ArrayAdapter {
    char[] array;
    static final long serialVersionUID = -7920180968357434958L;

    public CharArray() {
        this(new char[0]);
    }

    public CharArray(CharArray charArray) {
        this(charArray.array);
    }

    public CharArray(CharBuffer charBuffer) {
        this(charBuffer.get());
    }

    public CharArray(char[] cArray) {
        this.array = cArray;
    }

    public synchronized Object clone() {
        return new CharArray(this);
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "char[]");
    }

    public boolean equals(Object object) {
        return object instanceof CharArray && this.equals((CharArray)object) || object instanceof CharBuffer && this.equals((CharBuffer)object);
    }

    public boolean equals(CharArray charArray) {
        return this.equals(charArray.array);
    }

    public boolean equals(CharBuffer charBuffer) {
        return this.equals(charBuffer.storage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(char[] cArray) {
        char[] cArray2 = cArray;
        synchronized (cArray2) {
            if (this.array.length != cArray.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < cArray.length) {
                if (this.array[n2] != cArray[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public char[] get() {
        return this.array;
    }

    public int size() {
        return this.array.length;
    }

    public int maxSize() {
        return this.array.length;
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized CharIterator begin() {
        return new CharIterator(this, 0);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized CharIterator end() {
        return new CharIterator(this, this.array.length);
    }

    public Object at(int n2) {
        return new Character(this.charAt(n2));
    }

    public synchronized char charAt(int n2) {
        return this.array[n2];
    }

    public void put(int n2, Object object) {
        this.put(n2, ((Character)object).charValue());
    }

    public synchronized void put(int n2, char c2) {
        this.array[n2] = c2;
    }
}

