/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.ByteArray;
import com.objectspace.jgl.adapters.ByteIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class ByteBuffer
implements Sequence {
    static final byte defaultValue = 0;
    byte[] storage;
    int length;
    static final long serialVersionUID = 4412460359937432540L;

    public ByteBuffer() {
        this.clear();
    }

    public ByteBuffer(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to create an ByteBuffer with a negative size");
        }
        this.length = n2;
        this.storage = new byte[this.length];
    }

    public ByteBuffer(int n2, byte by) {
        this(n2);
        int n3 = 0;
        while (n3 < this.length) {
            this.storage[n3] = by;
            ++n3;
        }
    }

    public ByteBuffer(byte[] byArray) {
        this(byArray, true);
    }

    ByteBuffer(byte[] byArray, boolean bl) {
        byte[] byArray2 = byArray;
        synchronized (byArray2) {
            this.length = byArray.length;
            if (bl) {
                this.storage = new byte[this.length];
                System.arraycopy(byArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = byArray;
            }
            return;
        }
    }

    public ByteBuffer(ByteBuffer byteBuffer) {
        this(byteBuffer.storage);
    }

    public synchronized Object clone() {
        return new ByteBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof ByteBuffer && this.equals((ByteBuffer)object) || object instanceof ByteArray && this.equals((ByteArray)object);
    }

    public boolean equals(ByteBuffer byteBuffer) {
        return this.equals(new ByteArray(byteBuffer.storage));
    }

    public synchronized boolean equals(ByteArray byteArray) {
        return byteArray.equals(this.storage);
    }

    public boolean equals(byte[] byArray) {
        return this.equals(new ByteArray(byArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "ByteBuffer");
    }

    public synchronized void copy(ByteBuffer byteBuffer) {
        if (this == byteBuffer) {
            return;
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        synchronized (byteBuffer2) {
            if (byteBuffer.length > this.storage.length) {
                this.storage = byteBuffer.get();
            } else {
                System.arraycopy(byteBuffer.storage, 0, this.storage, 0, byteBuffer.length);
                int n2 = byteBuffer.length;
                while (n2 < this.length) {
                    this.storage[n2] = 0;
                    ++n2;
                }
            }
            this.length = byteBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(byte[] byArray) {
        byte[] byArray2 = byArray;
        synchronized (byArray2) {
            System.arraycopy(this.storage, 0, byArray, 0, Math.min(this.length, byArray.length));
            return;
        }
    }

    public synchronized byte[] get() {
        byte[] byArray = new byte[this.length];
        this.copyTo(byArray);
        return byArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n2) {
        return new Byte(this.byteAt(n2));
    }

    public synchronized byte byteAt(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        return this.storage[n2];
    }

    public synchronized void put(int n2, Object object) {
        this.put(n2, ((Number)object).byteValue());
    }

    public synchronized void put(int n2, byte by) {
        ArrayAdapter.checkIndex(n2, this.length);
        this.storage[n2] = by;
    }

    public synchronized void clear() {
        this.storage = new byte[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof ByteIterator)) {
            throw new IllegalArgumentException("Enumeration not an ByteIterator");
        }
        if (((ByteIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this ByteBuffer ");
        }
        Serializable serializable = (ByteIterator)enumeration;
        serializable = new Byte(serializable.buffer[serializable.index]);
        this.remove(((ByteIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n2) {
        ArrayAdapter.checkIndex(n2, this.length);
        Byte by = new Byte(this.storage[n2]);
        System.arraycopy(this.storage, n2 + 1, this.storage, n2, this.length - n2 - 1);
        this.storage[--this.length] = 0;
        return by;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof ByteIterator) || !(enumeration2 instanceof ByteIterator)) {
                    throw new IllegalArgumentException("Enumeration not an ByteIterator");
                }
                if (((ByteIterator)enumeration).buffer != this.storage) break block4;
                ByteIterator byteIterator = (ByteIterator)enumeration;
                ByteIterator byteIterator2 = (ByteIterator)enumeration2;
                if (!(byteIterator2 instanceof ByteIterator) || byteIterator.buffer != byteIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((ByteIterator)enumeration).index, ((ByteIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = n3 - n2 + 1;
        System.arraycopy(this.storage, n3 + 1, this.storage, n2, this.length - n3 - 1);
        int n5 = this.length - n4;
        while (n5 < this.length) {
            this.storage[n5] = 0;
            ++n5;
        }
        this.length -= n4;
        return n4;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("ByteBuffer is empty");
        }
        Byte by = new Byte(this.storage[--this.length]);
        this.storage[this.length] = 0;
        return by;
    }

    public synchronized Object add(Object object) {
        this.add(((Number)object).byteValue());
        return null;
    }

    public synchronized void add(byte by) {
        if (this.length == this.storage.length) {
            byte[] byArray = this.getNextStorage(1);
            this.copyTo(byArray);
            this.storage = byArray;
        }
        this.storage[this.length++] = by;
    }

    public void pushBack(Object object) {
        this.add(((Number)object).byteValue());
    }

    public void pushBack(byte by) {
        this.add(by);
    }

    public ByteIterator insert(ByteIterator byteIterator, Object object) {
        return this.insert(byteIterator, ((Number)object).byteValue());
    }

    public ByteIterator insert(ByteIterator byteIterator, byte by) {
        this.insert(byteIterator.index, by);
        return new ByteIterator(this, byteIterator.index);
    }

    public void insert(int n2, Object object) {
        this.insert(n2, ((Number)object).byteValue());
    }

    public synchronized void insert(int n2, byte by) {
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.length != this.storage.length) {
            if (n2 != this.length) {
                System.arraycopy(this.storage, n2, this.storage, n2 + 1, this.length - n2);
            }
        } else {
            byte[] byArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, byArray, 0, n2);
            System.arraycopy(this.storage, n2, byArray, n2 + 1, this.length - n2);
            this.storage = byArray;
        }
        this.storage[n2] = by;
        ++this.length;
    }

    public void insert(ByteIterator byteIterator, int n2, Object object) {
        this.insert(byteIterator, n2, ((Number)object).byteValue());
    }

    public void insert(ByteIterator byteIterator, int n2, byte by) {
        this.insert(byteIterator.index, n2, by);
    }

    public void insert(int n2, int n3, Object object) {
        this.insert(n2, n3, ((Number)object).byteValue());
    }

    public synchronized void insert(int n2, int n3, byte by) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n3 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n2, this.length + 1);
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            byte[] byArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, byArray, 0, n2);
            System.arraycopy(this.storage, n2, byArray, n2 + n3, this.length - n2);
            this.storage = byArray;
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.storage[n4] = by;
            ++n4;
        }
        this.length += n3;
    }

    public void insert(ByteIterator byteIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(byteIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n2, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n3 = forwardIterator.distance(forwardIterator2);
        if (n3 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n3) {
            System.arraycopy(this.storage, n2, this.storage, n2 + n3, this.length - n2);
        } else {
            byte[] byArray = this.getNextStorage(n3);
            System.arraycopy(this.storage, 0, byArray, 0, n2);
            System.arraycopy(this.storage, n2, byArray, n2 + n3, this.length - n2);
            this.storage = byArray;
        }
        this.length += n3;
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.put(n4, forwardIterator3.nextElement());
            ++n4;
        }
    }

    public synchronized void swap(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        synchronized (byteBuffer2) {
            int n2 = this.length;
            byte[] byArray = this.storage;
            this.length = byteBuffer.length;
            this.storage = byteBuffer.storage;
            byteBuffer.length = n2;
            byteBuffer.storage = byArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized ByteIterator begin() {
        return new ByteIterator(this, 0);
    }

    public synchronized ByteIterator end() {
        return new ByteIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n2) {
            byte[] byArray = new byte[n2];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, byArray, 0, this.length);
            }
            this.storage = byArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("ByteBuffer is empty");
        }
        Byte by = new Byte(this.storage[0]);
        this.remove(0);
        return by;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(byte by) {
        this.insert(0, by);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n2) {
        byte by = ((Number)object).byteValue();
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.indexOf(by);
            if (n4 < 0) break;
            --n2;
            ++n3;
            this.remove(n4);
        }
        return n3;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        ((Number)object).byteValue();
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        ByteIterator byteIterator = new ByteIterator(this, n2);
        ByteIterator byteIterator2 = new ByteIterator(this, n3 + 1);
        ByteIterator byteIterator3 = (ByteIterator)Algorithms.Removing.remove(byteIterator, byteIterator2, object);
        return this.remove(byteIterator3.index, n3);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Number)object).byteValue(), ((Number)object2).byteValue());
    }

    public int replace(byte by, byte by2) {
        return this.replace(0, this.length - 1, by, by2);
    }

    public int replace(int n2, int n3, Object object, Object object2) {
        return this.replace(n2, n3, ((Number)object).byteValue(), ((Number)object2).byteValue());
    }

    public synchronized int replace(int n2, int n3, byte by, byte by2) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == by) {
                this.storage[n2] = by2;
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int count(Object object) {
        return this.count(((Number)object).byteValue());
    }

    public int count(byte by) {
        return this.count(0, this.length - 1, by);
    }

    public int count(int n2, int n3, Object object) {
        return this.count(n2, n3, ((Number)object).byteValue());
    }

    public synchronized int count(int n2, int n3, byte by) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        n4 = 0;
        while (n2 < n3) {
            if (this.storage[n2] == by) {
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Number)object).byteValue());
    }

    public int indexOf(byte by) {
        return this.indexOf(0, this.length - 1, by);
    }

    public int indexOf(int n2, int n3, Object object) {
        return this.indexOf(n2, n3, ((Number)object).byteValue());
    }

    public synchronized int indexOf(int n2, int n3, byte by) {
        if (n3 < n2) {
            return -1;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n2, n4);
        ArrayAdapter.checkIndex(n3, n4);
        while (n2 < n3) {
            if (this.storage[n2] == by) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized void setSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n2) {
            this.remove(n2, this.length - 1);
            return;
        }
        if (this.length < n2) {
            this.insert(this.length, n2 - this.length, (byte)0);
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Number)object).byteValue());
    }

    public boolean contains(byte by) {
        return this.indexOf(by) != -1;
    }

    private byte[] getNextStorage(int n2) {
        int n3 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n2);
        byte[] byArray = new byte[n3];
        return byArray;
    }

    static byte asByte(Object object) {
        return ((Number)object).byteValue();
    }
}

