/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Array;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.xHashComparator;
import java.util.Enumeration;

public class PriorityQueue
implements Container {
    protected Array myArray;
    protected BinaryPredicate myComparator;
    static final long serialVersionUID = 6264990747843793967L;

    public PriorityQueue() {
        this(new xHashComparator());
    }

    public PriorityQueue(BinaryPredicate binaryPredicate) {
        this.myArray = new Array();
        this.myComparator = binaryPredicate;
    }

    public PriorityQueue(PriorityQueue priorityQueue) {
        PriorityQueue priorityQueue2 = priorityQueue;
        synchronized (priorityQueue2) {
            this.myArray = (Array)priorityQueue.myArray.clone();
            this.myComparator = priorityQueue.myComparator;
            return;
        }
    }

    public synchronized String toString() {
        return "PriorityQueue( " + this.myArray.toString() + " )";
    }

    public synchronized Object clone() {
        return new PriorityQueue(this);
    }

    public synchronized void copy(PriorityQueue priorityQueue) {
        PriorityQueue priorityQueue2 = priorityQueue;
        synchronized (priorityQueue2) {
            if (this != priorityQueue) {
                this.myArray = (Array)priorityQueue.myArray.clone();
                this.myComparator = priorityQueue.myComparator;
            }
            return;
        }
    }

    public boolean equals(Object object) {
        return object instanceof PriorityQueue && this.equals((PriorityQueue)object);
    }

    public synchronized boolean equals(PriorityQueue priorityQueue) {
        PriorityQueue priorityQueue2 = priorityQueue;
        synchronized (priorityQueue2) {
            boolean bl = this.myArray.equals(priorityQueue.myArray);
            Object var4_4 = null;
            return bl;
        }
    }

    public synchronized int hashCode() {
        return this.myArray.hashCode();
    }

    public boolean isEmpty() {
        return this.myArray.isEmpty();
    }

    public int size() {
        return this.myArray.size();
    }

    public int maxSize() {
        return this.myArray.maxSize();
    }

    public synchronized void clear() {
        this.myArray.clear();
    }

    public synchronized BinaryPredicate getComparator() {
        return this.myComparator;
    }

    public synchronized Enumeration elements() {
        return this.myArray.elements();
    }

    public synchronized ForwardIterator start() {
        return this.myArray.start();
    }

    public synchronized ForwardIterator finish() {
        return this.myArray.finish();
    }

    public synchronized Object top() {
        return this.myArray.front();
    }

    public Object add(Object object) {
        this.push(object);
        return null;
    }

    public synchronized void push(Object object) {
        this.myArray.pushBack(object);
        ForwardIterator forwardIterator = this.myArray.start();
        ForwardIterator forwardIterator2 = this.myArray.finish();
        BinaryPredicate binaryPredicate = this.myComparator;
        PriorityQueue.pushHeap(forwardIterator, forwardIterator.distance(forwardIterator2) - 1, 0, forwardIterator2.get(-1), binaryPredicate);
    }

    public synchronized Object pop() {
        if (this.myArray.isEmpty()) {
            throw new InvalidOperationException("PriorityQueue is empty");
        }
        PriorityQueue.popHeap(this.myArray.start(), this.myArray.finish(), this.myComparator);
        return this.myArray.popBack();
    }

    public synchronized void swap(PriorityQueue priorityQueue) {
        PriorityQueue priorityQueue2 = priorityQueue;
        synchronized (priorityQueue2) {
            Array array = this.myArray;
            this.myArray = priorityQueue.myArray;
            priorityQueue.myArray = array;
            BinaryPredicate binaryPredicate = this.myComparator;
            this.myComparator = priorityQueue.myComparator;
            priorityQueue.myComparator = binaryPredicate;
            return;
        }
    }

    public Object remove(Enumeration enumeration) {
        throw new InvalidOperationException("cannot execute remove() on a priority queue");
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        throw new InvalidOperationException("cannot execute remove() on a priority queue");
    }

    private static void pushHeap(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        PriorityQueue.pushHeap(forwardIterator, forwardIterator.distance(forwardIterator2) - 1, 0, forwardIterator2.get(-1), binaryPredicate);
    }

    private static void pushHeap(ForwardIterator forwardIterator, int n2, int n3, Object object, BinaryPredicate binaryPredicate) {
        int n4 = (n2 - 1) / 2;
        while (n2 > n3 && binaryPredicate.execute(forwardIterator.get(n4), object)) {
            forwardIterator.put(n2, forwardIterator.get(n4));
            n2 = n4;
            n4 = (n2 - 1) / 2;
        }
        forwardIterator.put(n2, object);
    }

    private static void popHeap(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        Object object = forwardIterator2.get(-1);
        forwardIterator2.put(-1, forwardIterator.get());
        int n2 = 0;
        int n3 = forwardIterator.distance(forwardIterator2) - 1;
        int n4 = n2;
        int n5 = 2 * (n2 + 1);
        while (n5 < n3) {
            if (binaryPredicate.execute(forwardIterator.get(n5), forwardIterator.get(n5 - 1))) {
                --n5;
            }
            forwardIterator.put(n2, forwardIterator.get(n5));
            n2 = n5;
            n5 = 2 * (n5 + 1);
        }
        if (n5 == n3) {
            forwardIterator.put(n2, forwardIterator.get(n5 - 1));
            n2 = n5 - 1;
        }
        PriorityQueue.pushHeap(forwardIterator, n2, n4, object, binaryPredicate);
    }
}

