/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;

public class PushbuttonField
extends BaseField {
    public static final int LAYOUT_LABEL_ONLY = 1;
    public static final int LAYOUT_ICON_ONLY = 2;
    public static final int LAYOUT_ICON_TOP_LABEL_BOTTOM = 3;
    public static final int LAYOUT_LABEL_TOP_ICON_BOTTOM = 4;
    public static final int LAYOUT_ICON_LEFT_LABEL_RIGHT = 5;
    public static final int LAYOUT_LABEL_LEFT_ICON_RIGHT = 6;
    public static final int LAYOUT_LABEL_OVER_ICON = 7;
    public static final int SCALE_ICON_ALWAYS = 1;
    public static final int SCALE_ICON_NEVER = 2;
    public static final int SCALE_ICON_IS_TOO_BIG = 3;
    public static final int SCALE_ICON_IS_TOO_SMALL = 4;
    private int layout = 1;
    private Image image;
    private PdfTemplate template;
    private int scaleIcon = 1;
    private boolean proportionalIcon = true;
    private float iconVerticalAdjustment = 0.5f;
    private float iconHorizontalAdjustment = 0.5f;
    private boolean iconFitToBounds;
    private PdfTemplate tp;
    private PRIndirectReference iconReference;

    public PushbuttonField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        super(pdfWriter, rectangle, string);
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int n2) {
        if (n2 < 1 || n2 > 7) {
            throw new IllegalArgumentException("Layout out of bounds.");
        }
        this.layout = n2;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.template = null;
    }

    public PdfTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(PdfTemplate pdfTemplate) {
        this.template = pdfTemplate;
        this.image = null;
    }

    public int getScaleIcon() {
        return this.scaleIcon;
    }

    public void setScaleIcon(int n2) {
        if (n2 < 1 || n2 > 4) {
            n2 = 1;
        }
        this.scaleIcon = n2;
    }

    public boolean isProportionalIcon() {
        return this.proportionalIcon;
    }

    public void setProportionalIcon(boolean bl) {
        this.proportionalIcon = bl;
    }

    public float getIconVerticalAdjustment() {
        return this.iconVerticalAdjustment;
    }

    public void setIconVerticalAdjustment(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.iconVerticalAdjustment = f2;
    }

    public float getIconHorizontalAdjustment() {
        return this.iconHorizontalAdjustment;
    }

    public void setIconHorizontalAdjustment(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.iconHorizontalAdjustment = f2;
    }

    private float calculateFontSize(float f2, float f3) throws IOException, DocumentException {
        BaseFont baseFont = this.getRealFont();
        float f4 = this.fontSize;
        if (f4 == 0.0f) {
            float f5 = baseFont.getWidthPoint(this.text, 1.0f);
            f4 = f5 == 0.0f ? 12.0f : f2 / f5;
            float f6 = f3 / (1.0f - baseFont.getFontDescriptor(3, 1.0f));
            if ((f4 = Math.min(f4, f6)) < 4.0f) {
                f4 = 4.0f;
            }
        }
        return f4;
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        float f2;
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        Rectangle rectangle = new Rectangle(pdfAppearance.getBoundingBox());
        if ((this.text == null || this.text.length() == 0) && (this.layout == 1 || this.image == null && this.template == null && this.iconReference == null)) {
            return pdfAppearance;
        }
        if (this.layout == 2 && this.image == null && this.template == null && this.iconReference == null) {
            return pdfAppearance;
        }
        BaseFont baseFont = this.getRealFont();
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f3 = rectangle.getHeight() - this.borderWidth * 2.0f;
        float f4 = this.borderWidth;
        if (bl) {
            f3 -= this.borderWidth * 2.0f;
            f4 *= 2.0f;
        }
        float f5 = bl ? 2.0f * this.borderWidth : this.borderWidth;
        f5 = Math.max(f5, 1.0f);
        float f6 = Math.min(f4, f5);
        this.tp = null;
        float f7 = Float.NaN;
        float f8 = 0.0f;
        float f9 = this.fontSize;
        float f10 = rectangle.getWidth() - 2.0f * f6 - 2.0f;
        float f11 = rectangle.getHeight() - 2.0f * f6;
        float f12 = this.iconFitToBounds ? 0.0f : f6 + 1.0f;
        int n2 = this.layout;
        if (this.image == null && this.template == null && this.iconReference == null) {
            n2 = 1;
        }
        Rectangle rectangle2 = null;
        block18: while (true) {
            switch (n2) {
                case 1: 
                case 7: {
                    if (this.text != null && this.text.length() > 0 && f10 > 0.0f && f11 > 0.0f) {
                        f9 = this.calculateFontSize(f10, f11);
                        f7 = (rectangle.getWidth() - baseFont.getWidthPoint(this.text, f9)) / 2.0f;
                        f8 = (rectangle.getHeight() - baseFont.getFontDescriptor(1, f9)) / 2.0f;
                    }
                }
                case 2: {
                    if (n2 != 7 && n2 != 2) break block18;
                    rectangle2 = new Rectangle(rectangle.getLeft() + f12, rectangle.getBottom() + f12, rectangle.getRight() - f12, rectangle.getTop() - f12);
                    break block18;
                }
                case 3: {
                    if (this.text == null || this.text.length() == 0 || f10 <= 0.0f || f11 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    float f13 = rectangle.getHeight() * 0.35f - f6;
                    f9 = f13 > 0.0f ? this.calculateFontSize(f10, f13) : 4.0f;
                    f7 = (rectangle.getWidth() - baseFont.getWidthPoint(this.text, f9)) / 2.0f;
                    f8 = f6 - baseFont.getFontDescriptor(3, f9);
                    rectangle2 = new Rectangle(rectangle.getLeft() + f12, f8 + f9, rectangle.getRight() - f12, rectangle.getTop() - f12);
                    break block18;
                }
                case 4: {
                    if (this.text == null || this.text.length() == 0 || f10 <= 0.0f || f11 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    float f13 = rectangle.getHeight() * 0.35f - f6;
                    f9 = f13 > 0.0f ? this.calculateFontSize(f10, f13) : 4.0f;
                    f7 = (rectangle.getWidth() - baseFont.getWidthPoint(this.text, f9)) / 2.0f;
                    f8 = rectangle.getHeight() - f6 - f9;
                    if (f8 < f6) {
                        f8 = f6;
                    }
                    rectangle2 = new Rectangle(rectangle.getLeft() + f12, rectangle.getBottom() + f12, rectangle.getRight() - f12, f8 + baseFont.getFontDescriptor(3, f9));
                    break block18;
                }
                case 6: {
                    if (this.text == null || this.text.length() == 0 || f10 <= 0.0f || f11 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    f2 = rectangle.getWidth() * 0.35f - f6;
                    f9 = f2 > 0.0f ? this.calculateFontSize(f10, f2) : 4.0f;
                    if (baseFont.getWidthPoint(this.text, f9) >= f10) {
                        n2 = 1;
                        f9 = this.fontSize;
                        continue block18;
                    }
                    f7 = f6 + 1.0f;
                    f8 = (rectangle.getHeight() - baseFont.getFontDescriptor(1, f9)) / 2.0f;
                    rectangle2 = new Rectangle(f7 + baseFont.getWidthPoint(this.text, f9), rectangle.getBottom() + f12, rectangle.getRight() - f12, rectangle.getTop() - f12);
                    break block18;
                }
                case 5: {
                    if (this.text == null || this.text.length() == 0 || f10 <= 0.0f || f11 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    f2 = rectangle.getWidth() * 0.35f - f6;
                    f9 = f2 > 0.0f ? this.calculateFontSize(f10, f2) : 4.0f;
                    if (baseFont.getWidthPoint(this.text, f9) >= f10) {
                        n2 = 1;
                        f9 = this.fontSize;
                        continue block18;
                    }
                    f7 = rectangle.getWidth() - baseFont.getWidthPoint(this.text, f9) - f6 - 1.0f;
                    f8 = (rectangle.getHeight() - baseFont.getFontDescriptor(1, f9)) / 2.0f;
                    rectangle2 = new Rectangle(rectangle.getLeft() + f12, rectangle.getBottom() + f12, f7 - 1.0f, rectangle.getTop() - f12);
                }
            }
            break;
        }
        if (f8 < rectangle.getBottom() + f6) {
            f8 = rectangle.getBottom() + f6;
        }
        if (rectangle2 != null && (rectangle2.getWidth() <= 0.0f || rectangle2.getHeight() <= 0.0f)) {
            rectangle2 = null;
        }
        boolean bl2 = false;
        f2 = 0.0f;
        float f14 = 0.0f;
        PdfArray pdfArray = null;
        if (rectangle2 != null) {
            PdfDictionary pdfDictionary;
            if (this.image != null) {
                this.tp = new PdfTemplate(this.writer);
                this.tp.setBoundingBox(new Rectangle(this.image));
                this.writer.addDirectTemplateSimple(this.tp, PdfName.FRM);
                this.tp.addImage(this.image, this.image.getWidth(), 0.0f, 0.0f, this.image.getHeight(), 0.0f, 0.0f);
                bl2 = true;
                f2 = this.tp.getBoundingBox().getWidth();
                f14 = this.tp.getBoundingBox().getHeight();
            } else if (this.template != null) {
                this.tp = new PdfTemplate(this.writer);
                this.tp.setBoundingBox(new Rectangle(this.template.getWidth(), this.template.getHeight()));
                this.writer.addDirectTemplateSimple(this.tp, PdfName.FRM);
                this.tp.addTemplate(this.template, this.template.getBoundingBox().getLeft(), this.template.getBoundingBox().getBottom());
                bl2 = true;
                f2 = this.tp.getBoundingBox().getWidth();
                f14 = this.tp.getBoundingBox().getHeight();
            } else if (this.iconReference != null && (pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.iconReference)) != null) {
                Rectangle rectangle3 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BBOX)));
                pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MATRIX));
                bl2 = true;
                f2 = rectangle3.getWidth();
                f14 = rectangle3.getHeight();
            }
        }
        if (bl2) {
            float f15 = rectangle2.getWidth() / f2;
            float f16 = rectangle2.getHeight() / f14;
            if (this.proportionalIcon) {
                switch (this.scaleIcon) {
                    case 3: {
                        f15 = Math.min(f15, f16);
                        f15 = Math.min(f15, 1.0f);
                        break;
                    }
                    case 4: {
                        f15 = Math.min(f15, f16);
                        f15 = Math.max(f15, 1.0f);
                        break;
                    }
                    case 2: {
                        f15 = 1.0f;
                        break;
                    }
                    default: {
                        f15 = Math.min(f15, f16);
                    }
                }
                f16 = f15;
            } else {
                switch (this.scaleIcon) {
                    case 3: {
                        f15 = Math.min(f15, 1.0f);
                        f16 = Math.min(f16, 1.0f);
                        break;
                    }
                    case 4: {
                        f15 = Math.max(f15, 1.0f);
                        f16 = Math.max(f16, 1.0f);
                        break;
                    }
                    case 2: {
                        f16 = 1.0f;
                        f15 = 1.0f;
                        break;
                    }
                }
            }
            float f17 = rectangle2.getLeft() + (rectangle2.getWidth() - f2 * f15) * this.iconHorizontalAdjustment;
            float f18 = rectangle2.getBottom() + (rectangle2.getHeight() - f14 * f16) * this.iconVerticalAdjustment;
            pdfAppearance.saveState();
            pdfAppearance.rectangle(rectangle2.getLeft(), rectangle2.getBottom(), rectangle2.getWidth(), rectangle2.getHeight());
            pdfAppearance.clip();
            pdfAppearance.newPath();
            if (this.tp != null) {
                pdfAppearance.addTemplate(this.tp, f15, 0.0f, 0.0f, f16, f17, f18);
            } else {
                float f19 = 0.0f;
                float f20 = 0.0f;
                if (pdfArray != null && pdfArray.size() == 6) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject((PdfObject)pdfArray.getArrayList().get(4));
                    if (pdfNumber != null) {
                        f19 = pdfNumber.floatValue();
                    }
                    if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject((PdfObject)pdfArray.getArrayList().get(5))) != null) {
                        f20 = pdfNumber.floatValue();
                    }
                }
                pdfAppearance.addTemplateReference(this.iconReference, PdfName.FRM, f15, 0.0f, 0.0f, f16, f17 - f19 * f15, f18 - f20 * f16);
            }
            pdfAppearance.restoreState();
        }
        if (!Float.isNaN(f7)) {
            pdfAppearance.saveState();
            pdfAppearance.rectangle(f6, f6, rectangle.getWidth() - 2.0f * f6, rectangle.getHeight() - 2.0f * f6);
            pdfAppearance.clip();
            pdfAppearance.newPath();
            if (this.textColor == null) {
                pdfAppearance.resetGrayFill();
            } else {
                pdfAppearance.setColorFill(this.textColor);
            }
            pdfAppearance.beginText();
            pdfAppearance.setFontAndSize(baseFont, f9);
            pdfAppearance.setTextMatrix(f7, f8);
            pdfAppearance.showText(this.text);
            pdfAppearance.endText();
            pdfAppearance.restoreState();
        }
        return pdfAppearance;
    }

    public PdfFormField getField() throws IOException, DocumentException {
        PdfFormField pdfFormField = PdfFormField.createPushButton(this.writer);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
        }
        if (this.text != null) {
            pdfFormField.setMKNormalCaption(this.text);
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        if (this.tp != null) {
            pdfFormField.setMKNormalIcon(this.tp);
        }
        pdfFormField.setMKTextPosition(this.layout - 1);
        PdfName pdfName = PdfName.A;
        if (this.scaleIcon == 3) {
            pdfName = PdfName.B;
        } else if (this.scaleIcon == 4) {
            pdfName = PdfName.S;
        } else if (this.scaleIcon == 2) {
            pdfName = PdfName.N;
        }
        pdfFormField.setMKIconFit(pdfName, this.proportionalIcon ? PdfName.P : PdfName.A, this.iconHorizontalAdjustment, this.iconVerticalAdjustment, this.iconFitToBounds);
        return pdfFormField;
    }

    public boolean isIconFitToBounds() {
        return this.iconFitToBounds;
    }

    public void setIconFitToBounds(boolean bl) {
        this.iconFitToBounds = bl;
    }

    public PRIndirectReference getIconReference() {
        return this.iconReference;
    }

    public void setIconReference(PRIndirectReference pRIndirectReference) {
        this.iconReference = pRIndirectReference;
    }
}

