/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Cell;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfCell;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfTable
extends Rectangle {
    private int columns;
    private ArrayList headercells;
    private ArrayList cells;
    protected Table table;
    protected float[] positions;

    PdfTable(Table table, float f2, float f3, float f4) {
        super(f2, f4, f3, f4);
        this.table = table;
        table.complete();
        this.cloneNonPositionParameters(table);
        this.columns = table.getColumns();
        this.positions = table.getWidths(f2, f3 - f2);
        this.setLeft(this.positions[0]);
        this.setRight(this.positions[this.positions.length - 1]);
        this.headercells = new ArrayList();
        this.cells = new ArrayList();
        this.updateRowAdditionsInternal();
    }

    void updateRowAdditions() {
        this.table.complete();
        this.updateRowAdditionsInternal();
        this.table.deleteAllRows();
    }

    private void updateRowAdditionsInternal() {
        PdfCell pdfCell;
        int n2;
        int n3 = this.rows();
        int n4 = 0;
        int n5 = 0;
        int n6 = this.table.getLastHeaderRow() + 1;
        ArrayList<PdfCell> arrayList = new ArrayList<PdfCell>();
        int n7 = this.table.size() + 1;
        float[] fArray = new float[n7];
        for (int i2 = 0; i2 < n7; ++i2) {
            fArray[i2] = this.getBottom();
        }
        Iterator iterator = this.table.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            Row row = (Row)iterator.next();
            if (row.isEmpty()) {
                if (n4 < n7 - 1 && fArray[n4 + 1] > fArray[n4]) {
                    fArray[n4 + 1] = fArray[n4];
                }
            } else {
                for (n2 = 0; n2 < row.getColumns(); ++n2) {
                    Cell cell;
                    block13: {
                        cell = (Cell)row.getCell(n2);
                        if (cell == null) continue;
                        pdfCell = new PdfCell(cell, n4 + n3, this.positions[n2], this.positions[n2 + cell.getColspan()], fArray[n4], this.cellspacing(), this.cellpadding());
                        if (n4 < n6) {
                            pdfCell.setHeader();
                            this.headercells.add(pdfCell);
                            if (!this.table.isNotAddedYet()) continue;
                        }
                        try {
                            if (fArray[n4] - pdfCell.getHeight() - this.cellpadding() < fArray[n4 + pdfCell.rowspan()]) {
                                fArray[n4 + pdfCell.rowspan()] = fArray[n4] - pdfCell.getHeight() - this.cellpadding();
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            if (!(fArray[n4] - pdfCell.getHeight() < fArray[n7 - 1])) break block13;
                            fArray[n7 - 1] = fArray[n4] - pdfCell.getHeight();
                        }
                    }
                    pdfCell.setGroupNumber(n5);
                    bl |= cell.getGroupChange();
                    arrayList.add(pdfCell);
                }
            }
            ++n4;
            if (!bl) continue;
            ++n5;
        }
        int n8 = arrayList.size();
        for (n2 = 0; n2 < n8; ++n2) {
            pdfCell = (PdfCell)arrayList.get(n2);
            try {
                pdfCell.setBottom(fArray[pdfCell.rownumber() - n3 + pdfCell.rowspan()]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                pdfCell.setBottom(fArray[n7 - 1]);
            }
        }
        this.cells.addAll(arrayList);
        this.setBottom(fArray[n7 - 1]);
    }

    int rows() {
        return this.cells.isEmpty() ? 0 : ((PdfCell)this.cells.get(this.cells.size() - 1)).rownumber() + 1;
    }

    public int type() {
        return 22;
    }

    ArrayList getHeaderCells() {
        return this.headercells;
    }

    boolean hasHeader() {
        return !this.headercells.isEmpty();
    }

    ArrayList getCells() {
        return this.cells;
    }

    int columns() {
        return this.columns;
    }

    final float cellpadding() {
        return this.table.getPadding();
    }

    final float cellspacing() {
        return this.table.getSpacing();
    }

    public final boolean hasToFitPageTable() {
        return this.table.isTableFitsPage();
    }

    public final boolean hasToFitPageCells() {
        return this.table.isCellsFitPage();
    }

    public float getOffset() {
        return this.table.getOffset();
    }
}

