/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BadPasswordException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SequenceList;
import com.lowagie.text.pdf.interfaces.PdfViewerPreferences;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.InflaterInputStream;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.RecipientInformation;

public class PdfReader
implements PdfViewerPreferences {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    static final byte[] endstream = PdfEncodings.convertToBytes("endstream", null);
    static final byte[] endobj = PdfEncodings.convertToBytes("endobj", null);
    protected PRTokeniser tokens;
    protected int[] xref;
    protected HashMap objStmMark;
    protected IntHashtable objStmToOffset;
    protected boolean newXrefType;
    private ArrayList xrefObj;
    PdfDictionary rootPages;
    protected PdfDictionary trailer;
    protected PdfDictionary catalog;
    protected PageRefs pageRefs;
    protected PRAcroForm acroForm = null;
    protected boolean acroFormParsed = false;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;
    protected int freeXref;
    protected boolean tampered = false;
    protected int lastXref;
    protected int eofPos;
    protected char pdfVersion;
    protected PdfEncryption decrypt;
    protected byte[] password = null;
    protected Key certificateKey = null;
    protected Certificate certificate = null;
    protected String certificateKeyProvider = null;
    private boolean ownerPasswordUsed;
    protected ArrayList strings = new ArrayList();
    protected boolean sharedStreams = true;
    protected boolean consolidateNamedDestinations = false;
    protected int rValue;
    protected int pValue;
    private int objNum;
    private int objGen;
    private int fileLength;
    private boolean hybridXref;
    private int lastXrefPartial = -1;
    private boolean partial;
    private PRIndirectReference cryptoRef;
    private PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    private boolean encryptionError;
    private boolean appendable;

    protected PdfReader() {
    }

    public PdfReader(String string) throws IOException {
        this(string, null);
    }

    public PdfReader(String string, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(byte[] byArray) throws IOException {
        this(byArray, null);
    }

    public PdfReader(byte[] byArray, byte[] byArray2) throws IOException {
        this.password = byArray2;
        this.tokens = new PRTokeniser(byArray);
        this.readPdf();
    }

    public PdfReader(String string, Certificate certificate, Key key, String string2) throws IOException {
        this.certificate = certificate;
        this.certificateKey = key;
        this.certificateKeyProvider = string2;
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(URL uRL) throws IOException {
        this(uRL, null);
    }

    public PdfReader(URL uRL, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(uRL));
        this.readPdf();
    }

    public PdfReader(InputStream inputStream, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(inputStream));
        this.readPdf();
    }

    public PdfReader(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public PdfReader(RandomAccessFileOrArray randomAccessFileOrArray, byte[] byArray) throws IOException {
        this.password = byArray;
        this.partial = true;
        this.tokens = new PRTokeniser(randomAccessFileOrArray);
        this.readPdfPartial();
    }

    public PdfReader(PdfReader pdfReader) {
        this.appendable = pdfReader.appendable;
        this.consolidateNamedDestinations = pdfReader.consolidateNamedDestinations;
        this.encrypted = pdfReader.encrypted;
        this.rebuilt = pdfReader.rebuilt;
        this.sharedStreams = pdfReader.sharedStreams;
        this.tampered = pdfReader.tampered;
        this.password = pdfReader.password;
        this.pdfVersion = pdfReader.pdfVersion;
        this.eofPos = pdfReader.eofPos;
        this.freeXref = pdfReader.freeXref;
        this.lastXref = pdfReader.lastXref;
        this.tokens = new PRTokeniser(pdfReader.tokens.getSafeFile());
        if (pdfReader.decrypt != null) {
            this.decrypt = new PdfEncryption(pdfReader.decrypt);
        }
        this.pValue = pdfReader.pValue;
        this.rValue = pdfReader.rValue;
        this.xrefObj = new ArrayList(pdfReader.xrefObj);
        for (int i2 = 0; i2 < pdfReader.xrefObj.size(); ++i2) {
            this.xrefObj.set(i2, PdfReader.duplicatePdfObject((PdfObject)pdfReader.xrefObj.get(i2), this));
        }
        this.pageRefs = new PageRefs(pdfReader.pageRefs, this);
        this.trailer = (PdfDictionary)PdfReader.duplicatePdfObject(pdfReader.trailer, this);
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        this.rootPages = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        this.fileLength = pdfReader.fileLength;
        this.partial = pdfReader.partial;
        this.hybridXref = pdfReader.hybridXref;
        this.objStmToOffset = pdfReader.objStmToOffset;
        this.xref = pdfReader.xref;
        this.cryptoRef = (PRIndirectReference)PdfReader.duplicatePdfObject(pdfReader.cryptoRef, this);
        this.ownerPasswordUsed = pdfReader.ownerPasswordUsed;
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter pdfWriter) {
        return new PdfReaderInstance(this, pdfWriter);
    }

    public int getNumberOfPages() {
        return this.pageRefs.size();
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    public PRAcroForm getAcroForm() {
        if (!this.acroFormParsed) {
            this.acroFormParsed = true;
            PdfObject pdfObject = this.catalog.get(PdfName.ACROFORM);
            if (pdfObject != null) {
                try {
                    this.acroForm = new PRAcroForm(this);
                    this.acroForm.readAcroForm((PdfDictionary)PdfReader.getPdfObject(pdfObject));
                }
                catch (Exception exception) {
                    this.acroForm = null;
                }
            }
        }
        return this.acroForm;
    }

    public int getPageRotation(int n2) {
        return this.getPageRotation(this.pageRefs.getPageNRelease(n2));
    }

    int getPageRotation(PdfDictionary pdfDictionary) {
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ROTATE));
        if (pdfNumber == null) {
            return 0;
        }
        int n2 = pdfNumber.intValue();
        return (n2 %= 360) < 0 ? n2 + 360 : n2;
    }

    public Rectangle getPageSizeWithRotation(int n2) {
        return this.getPageSizeWithRotation(this.pageRefs.getPageNRelease(n2));
    }

    public Rectangle getPageSizeWithRotation(PdfDictionary pdfDictionary) {
        Rectangle rectangle = this.getPageSize(pdfDictionary);
        for (int i2 = this.getPageRotation(pdfDictionary); i2 > 0; i2 -= 90) {
            rectangle = rectangle.rotate();
        }
        return rectangle;
    }

    public Rectangle getPageSize(int n2) {
        return this.getPageSize(this.pageRefs.getPageNRelease(n2));
    }

    public Rectangle getPageSize(PdfDictionary pdfDictionary) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MEDIABOX));
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getCropBox(int n2) {
        PdfDictionary pdfDictionary = this.pageRefs.getPageNRelease(n2);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CROPBOX));
        if (pdfArray == null) {
            return this.getPageSize(pdfDictionary);
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getBoxSize(int n2, String string) {
        PdfDictionary pdfDictionary = this.pageRefs.getPageNRelease(n2);
        PdfArray pdfArray = null;
        if (string.equals("trim")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.TRIMBOX));
        } else if (string.equals("art")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.ARTBOX));
        } else if (string.equals("bleed")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.BLEEDBOX));
        } else if (string.equals("crop")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CROPBOX));
        } else if (string.equals("media")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.MEDIABOX));
        }
        if (pdfArray == null) {
            return null;
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public HashMap getInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.INFO));
        if (pdfDictionary == null) {
            return hashMap;
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
            if (pdfObject == null) continue;
            String string = pdfObject.toString();
            switch (pdfObject.type()) {
                case 3: {
                    string = ((PdfString)pdfObject).toUnicodeString();
                    break;
                }
                case 4: {
                    string = PdfName.decodeName(string);
                }
            }
            hashMap.put(PdfName.decodeName(pdfName.toString()), string);
        }
        return hashMap;
    }

    public static Rectangle getNormalizedRectangle(PdfArray pdfArray) {
        ArrayList arrayList = pdfArray.getArrayList();
        float f2 = ((PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(0))).floatValue();
        float f3 = ((PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(1))).floatValue();
        float f4 = ((PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(2))).floatValue();
        float f5 = ((PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(3))).floatValue();
        return new Rectangle(Math.min(f2, f4), Math.min(f3, f5), Math.max(f2, f4), Math.max(f3, f5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPdf() throws IOException {
        try {
            this.fileLength = this.tokens.getFile().length();
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception exception) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception exception2) {
                    throw new IOException("Rebuild failed: " + exception2.getMessage() + "; Original message: " + exception.getMessage());
                }
            }
            try {
                this.readDocObj();
            }
            catch (Exception exception) {
                if (this.rebuilt || this.encryptionError) {
                    throw new IOException(exception.getMessage());
                }
                this.rebuilt = true;
                this.encrypted = false;
                this.rebuildXref();
                this.lastXref = -1;
                this.readDocObj();
            }
            this.strings.clear();
            this.readPages();
            this.eliminateSharedStreams();
            this.removeUnusedObjects();
        }
        finally {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void readPdfPartial() throws IOException {
        try {
            this.fileLength = this.tokens.getFile().length();
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception exception) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception exception2) {
                    throw new IOException("Rebuild failed: " + exception2.getMessage() + "; Original message: " + exception.getMessage());
                }
            }
            this.readDocObjPartial();
            this.readPages();
        }
        catch (IOException iOException) {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private boolean equalsArray(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private void readDecryptedDocObj() throws IOException {
        Object object;
        String string;
        PdfObject pdfObject;
        if (this.encrypted) {
            return;
        }
        PdfObject pdfObject2 = this.trailer.get(PdfName.ENCRYPT);
        if (pdfObject2 == null || pdfObject2.toString().equals("null")) {
            return;
        }
        this.encryptionError = true;
        byte[] byArray = null;
        this.encrypted = true;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(this.trailer.get(PdfName.ID));
        byte[] byArray2 = null;
        if (pdfArray != null) {
            pdfObject = (PdfObject)pdfArray.getArrayList().get(0);
            this.strings.remove(pdfObject);
            string = pdfObject.toString();
            byArray2 = DocWriter.getISOBytes(string);
            if (pdfArray.size() > 1) {
                this.strings.remove(pdfArray.getArrayList().get(1));
            }
        }
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n2 = 0;
        int n3 = 0;
        PdfObject pdfObject3 = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.FILTER));
        if (pdfObject3.equals(PdfName.STANDARD)) {
            string = pdfDictionary.get(PdfName.U).toString();
            this.strings.remove(pdfDictionary.get(PdfName.U));
            byArray3 = DocWriter.getISOBytes(string);
            string = pdfDictionary.get(PdfName.O).toString();
            this.strings.remove(pdfDictionary.get(PdfName.O));
            byArray4 = DocWriter.getISOBytes(string);
            pdfObject = pdfDictionary.get(PdfName.R);
            if (!pdfObject.isNumber()) {
                throw new IOException("Illegal R value.");
            }
            this.rValue = ((PdfNumber)pdfObject).intValue();
            if (this.rValue != 2 && this.rValue != 3 && this.rValue != 4) {
                throw new IOException("Unknown encryption type (" + this.rValue + ")");
            }
            pdfObject = pdfDictionary.get(PdfName.P);
            if (!pdfObject.isNumber()) {
                throw new IOException("Illegal P value.");
            }
            this.pValue = ((PdfNumber)pdfObject).intValue();
            if (this.rValue == 3) {
                pdfObject = pdfDictionary.get(PdfName.LENGTH);
                if (!pdfObject.isNumber()) {
                    throw new IOException("Illegal Length value.");
                }
                n3 = ((PdfNumber)pdfObject).intValue();
                if (n3 > 128 || n3 < 40 || n3 % 8 != 0) {
                    throw new IOException("Illegal Length value.");
                }
                n2 = 1;
            } else if (this.rValue == 4) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)pdfDictionary.get(PdfName.CF);
                if (pdfDictionary2 == null) {
                    throw new IOException("/CF not found (encryption)");
                }
                if ((pdfDictionary2 = (PdfDictionary)pdfDictionary2.get(PdfName.STDCF)) == null) {
                    throw new IOException("/StdCF not found (encryption)");
                }
                if (PdfName.V2.equals(pdfDictionary2.get(PdfName.CFM))) {
                    n2 = 1;
                } else if (PdfName.AESV2.equals(pdfDictionary2.get(PdfName.CFM))) {
                    n2 = 2;
                } else {
                    throw new IOException("No compatible encryption found");
                }
                object = pdfDictionary.get(PdfName.ENCRYPTMETADATA);
                if (object != null && ((PdfObject)object).toString().equals("false")) {
                    n2 |= 8;
                }
            } else {
                n2 = 0;
            }
        } else if (pdfObject3.equals(PdfName.PUBSEC)) {
            Object object2;
            PdfObject pdfObject4;
            boolean bl = false;
            object = null;
            PdfArray pdfArray2 = null;
            pdfObject = pdfDictionary.get(PdfName.V);
            if (!pdfObject.isNumber()) {
                throw new IOException("Illegal V value.");
            }
            int n4 = ((PdfNumber)pdfObject).intValue();
            if (n4 != 1 && n4 != 2 && n4 != 4) {
                throw new IOException("Unknown encryption type V = " + this.rValue);
            }
            if (n4 == 2) {
                pdfObject = pdfDictionary.get(PdfName.LENGTH);
                if (!pdfObject.isNumber()) {
                    throw new IOException("Illegal Length value.");
                }
                n3 = ((PdfNumber)pdfObject).intValue();
                if (n3 > 128 || n3 < 40 || n3 % 8 != 0) {
                    throw new IOException("Illegal Length value.");
                }
                n2 = 1;
                pdfArray2 = (PdfArray)pdfDictionary.get(PdfName.RECIPIENTS);
            } else if (n4 == 4) {
                PdfDictionary pdfDictionary3 = (PdfDictionary)pdfDictionary.get(PdfName.CF);
                if (pdfDictionary3 == null) {
                    throw new IOException("/CF not found (encryption)");
                }
                if ((pdfDictionary3 = (PdfDictionary)pdfDictionary3.get(PdfName.DEFAULTCRYPTFILER)) == null) {
                    throw new IOException("/DefaultCryptFilter not found (encryption)");
                }
                if (PdfName.V2.equals(pdfDictionary3.get(PdfName.CFM))) {
                    n2 = 1;
                    n3 = 128;
                } else if (PdfName.AESV2.equals(pdfDictionary3.get(PdfName.CFM))) {
                    n2 = 2;
                    n3 = 128;
                } else {
                    throw new IOException("No compatible encryption found");
                }
                pdfObject4 = pdfDictionary3.get(PdfName.ENCRYPTMETADATA);
                if (pdfObject4 != null && pdfObject4.toString().equals("false")) {
                    n2 |= 8;
                }
                pdfArray2 = (PdfArray)pdfDictionary3.get(PdfName.RECIPIENTS);
            } else {
                n2 = 0;
                n3 = 40;
                pdfArray2 = (PdfArray)pdfDictionary.get(PdfName.RECIPIENTS);
            }
            for (int i2 = 0; i2 < pdfArray2.size(); ++i2) {
                pdfObject4 = (PdfObject)pdfArray2.getArrayList().get(i2);
                this.strings.remove(pdfObject4);
                object2 = null;
                try {
                    object2 = new CMSEnvelopedData(pdfObject4.getBytes());
                    Iterator iterator = object2.getRecipientInfos().getRecipients().iterator();
                    while (iterator.hasNext()) {
                        RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
                        if (!recipientInformation.getRID().match(this.certificate) || bl) continue;
                        object = recipientInformation.getContent(this.certificateKey, this.certificateKeyProvider);
                        bl = true;
                    }
                    continue;
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
            }
            if (!bl || object == null) {
                throw new IOException("Bad certificate and key.");
            }
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
                messageDigest.update((byte[])object, 0, 20);
                for (int i3 = 0; i3 < pdfArray2.size(); ++i3) {
                    object2 = ((PdfObject)pdfArray2.getArrayList().get(i3)).getBytes();
                    messageDigest.update((byte[])object2);
                }
                if ((n2 & 8) != 0) {
                    messageDigest.update(new byte[]{-1, -1, -1, -1});
                }
                byArray = messageDigest.digest();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        this.decrypt = new PdfEncryption();
        this.decrypt.setCryptoMode(n2, n3);
        if (pdfObject3.equals(PdfName.STANDARD)) {
            this.decrypt.setupByOwnerPassword(byArray2, this.password, byArray3, byArray4, this.pValue);
            if (!this.equalsArray(byArray3, this.decrypt.userKey, this.rValue == 3 || this.rValue == 4 ? 16 : 32)) {
                this.decrypt.setupByUserPassword(byArray2, this.password, byArray4, this.pValue);
                if (!this.equalsArray(byArray3, this.decrypt.userKey, this.rValue == 3 || this.rValue == 4 ? 16 : 32)) {
                    throw new BadPasswordException();
                }
            } else {
                this.ownerPasswordUsed = true;
            }
        } else if (pdfObject3.equals(PdfName.PUBSEC)) {
            this.decrypt.setupByEncryptionKey(byArray, n3);
            this.ownerPasswordUsed = true;
        }
        for (int i4 = 0; i4 < this.strings.size(); ++i4) {
            object = (PdfString)this.strings.get(i4);
            ((PdfString)object).decrypt(this);
        }
        if (pdfObject2.isIndirect()) {
            this.cryptoRef = (PRIndirectReference)pdfObject2;
            this.xrefObj.set(this.cryptoRef.getNumber(), null);
        }
        this.encryptionError = false;
    }

    public static PdfObject getPdfObjectRelease(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfObject);
        PdfReader.releaseLastXrefPartial(pdfObject);
        return pdfObject2;
    }

    public static PdfObject getPdfObject(PdfObject pdfObject) {
        if (pdfObject == null) {
            return null;
        }
        if (!pdfObject.isIndirect()) {
            return pdfObject;
        }
        try {
            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
            int n2 = pRIndirectReference.getNumber();
            boolean bl = pRIndirectReference.getReader().appendable;
            pdfObject = pRIndirectReference.getReader().getPdfObject(n2);
            if (pdfObject == null) {
                return null;
            }
            if (bl) {
                switch (pdfObject.type()) {
                    case 8: {
                        pdfObject = new PdfNull();
                        break;
                    }
                    case 1: {
                        pdfObject = new PdfBoolean(((PdfBoolean)pdfObject).booleanValue());
                        break;
                    }
                    case 4: {
                        pdfObject = new PdfName(pdfObject.getBytes());
                    }
                }
                pdfObject.setIndRef(pRIndirectReference);
            }
            return pdfObject;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static PdfObject getPdfObjectRelease(PdfObject pdfObject, PdfObject pdfObject2) {
        PdfObject pdfObject3 = PdfReader.getPdfObject(pdfObject, pdfObject2);
        PdfReader.releaseLastXrefPartial(pdfObject);
        return pdfObject3;
    }

    public static PdfObject getPdfObject(PdfObject pdfObject, PdfObject pdfObject2) {
        if (pdfObject == null) {
            return null;
        }
        if (!pdfObject.isIndirect()) {
            PRIndirectReference pRIndirectReference = null;
            if (pdfObject2 != null && (pRIndirectReference = pdfObject2.getIndRef()) != null && pRIndirectReference.getReader().isAppendable()) {
                switch (pdfObject.type()) {
                    case 8: {
                        pdfObject = new PdfNull();
                        break;
                    }
                    case 1: {
                        pdfObject = new PdfBoolean(((PdfBoolean)pdfObject).booleanValue());
                        break;
                    }
                    case 4: {
                        pdfObject = new PdfName(pdfObject.getBytes());
                    }
                }
                pdfObject.setIndRef(pRIndirectReference);
            }
            return pdfObject;
        }
        return PdfReader.getPdfObject(pdfObject);
    }

    public PdfObject getPdfObjectRelease(int n2) {
        PdfObject pdfObject = this.getPdfObject(n2);
        this.releaseLastXrefPartial();
        return pdfObject;
    }

    public PdfObject getPdfObject(int n2) {
        try {
            this.lastXrefPartial = -1;
            if (n2 < 0 || n2 >= this.xrefObj.size()) {
                return null;
            }
            PdfObject pdfObject = (PdfObject)this.xrefObj.get(n2);
            if (!this.partial || pdfObject != null) {
                return pdfObject;
            }
            if (n2 * 2 >= this.xref.length) {
                return null;
            }
            pdfObject = this.readSingleObject(n2);
            this.lastXrefPartial = -1;
            if (pdfObject != null) {
                this.lastXrefPartial = n2;
            }
            return pdfObject;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void resetLastXrefPartial() {
        this.lastXrefPartial = -1;
    }

    public void releaseLastXrefPartial() {
        if (this.partial && this.lastXrefPartial != -1) {
            this.xrefObj.set(this.lastXrefPartial, null);
            this.lastXrefPartial = -1;
        }
    }

    public static void releaseLastXrefPartial(PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        if (!pdfObject.isIndirect()) {
            return;
        }
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
        PdfReader pdfReader = pRIndirectReference.getReader();
        if (pdfReader.partial && pdfReader.lastXrefPartial != -1 && pdfReader.lastXrefPartial == pRIndirectReference.getNumber()) {
            pdfReader.xrefObj.set(pdfReader.lastXrefPartial, null);
        }
        pdfReader.lastXrefPartial = -1;
    }

    private void setXrefPartialObject(int n2, PdfObject pdfObject) {
        if (!this.partial || n2 < 0) {
            return;
        }
        this.xrefObj.set(n2, pdfObject);
    }

    public PRIndirectReference addPdfObject(PdfObject pdfObject) {
        this.xrefObj.add(pdfObject);
        return new PRIndirectReference(this, this.xrefObj.size() - 1);
    }

    protected void readPages() throws IOException {
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        this.rootPages = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        this.pageRefs = new PageRefs(this);
    }

    protected void readDocObjPartial() throws IOException {
        this.xrefObj = new ArrayList(this.xref.length / 2);
        this.xrefObj.addAll(Collections.nCopies(this.xref.length / 2, null));
        this.readDecryptedDocObj();
        if (this.objStmToOffset != null) {
            int[] nArray = this.objStmToOffset.getKeys();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                this.objStmToOffset.put(n2, this.xref[n2 * 2]);
                this.xref[n2 * 2] = -1;
            }
        }
    }

    protected PdfObject readSingleObject(int n2) throws IOException {
        PdfObject pdfObject;
        this.strings.clear();
        int n3 = n2 * 2;
        int n4 = this.xref[n3];
        if (n4 < 0) {
            return null;
        }
        if (this.xref[n3 + 1] > 0) {
            n4 = this.objStmToOffset.get(this.xref[n3 + 1]);
        }
        if (n4 == 0) {
            return null;
        }
        this.tokens.seek(n4);
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError("Invalid object number.");
        }
        this.objNum = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError("Invalid generation number.");
        }
        this.objGen = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("obj")) {
            this.tokens.throwError("Token 'obj' expected.");
        }
        try {
            pdfObject = this.readPRObject();
            for (int i2 = 0; i2 < this.strings.size(); ++i2) {
                PdfString pdfString = (PdfString)this.strings.get(i2);
                pdfString.decrypt(this);
            }
            if (pdfObject.isStream()) {
                this.checkPRStreamLength((PRStream)pdfObject);
            }
        }
        catch (Exception exception) {
            pdfObject = null;
        }
        if (this.xref[n3 + 1] > 0) {
            pdfObject = this.readOneObjStm((PRStream)pdfObject, this.xref[n3]);
        }
        this.xrefObj.set(n2, pdfObject);
        return pdfObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PdfObject readOneObjStm(PRStream pRStream, int n2) throws IOException {
        int n3 = ((PdfNumber)PdfReader.getPdfObject(pRStream.get(PdfName.FIRST))).intValue();
        byte[] byArray = PdfReader.getStreamBytes(pRStream, this.tokens.getFile());
        PRTokeniser pRTokeniser = this.tokens;
        this.tokens = new PRTokeniser(byArray);
        try {
            int n4 = 0;
            boolean bl = true;
            ++n2;
            for (int i2 = 0; i2 < n2 && (bl = this.tokens.nextToken()); ++i2) {
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                bl = this.tokens.nextToken();
                if (!bl) break;
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                n4 = this.tokens.intValue() + n3;
            }
            if (!bl) {
                throw new IOException("Error reading ObjStm");
            }
            this.tokens.seek(n4);
            PdfObject pdfObject = this.readPRObject();
            return pdfObject;
        }
        finally {
            this.tokens = pRTokeniser;
        }
    }

    public double dumpPerc() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.xrefObj.size(); ++i2) {
            if (this.xrefObj.get(i2) == null) continue;
            ++n2;
        }
        return (double)n2 * 100.0 / (double)this.xrefObj.size();
    }

    protected void readDocObj() throws IOException {
        int n2;
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        this.xrefObj = new ArrayList(this.xref.length / 2);
        this.xrefObj.addAll(Collections.nCopies(this.xref.length / 2, null));
        for (n2 = 2; n2 < this.xref.length; n2 += 2) {
            PdfObject pdfObject;
            int n3 = this.xref[n2];
            if (n3 <= 0 || this.xref[n2 + 1] > 0) continue;
            this.tokens.seek(n3);
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Invalid object number.");
            }
            this.objNum = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Invalid generation number.");
            }
            this.objGen = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (!this.tokens.getStringValue().equals("obj")) {
                this.tokens.throwError("Token 'obj' expected.");
            }
            try {
                pdfObject = this.readPRObject();
                if (pdfObject.isStream()) {
                    arrayList.add(pdfObject);
                }
            }
            catch (Exception exception) {
                pdfObject = null;
            }
            this.xrefObj.set(n2 / 2, pdfObject);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            this.checkPRStreamLength((PRStream)arrayList.get(n2));
        }
        this.readDecryptedDocObj();
        if (this.objStmMark != null) {
            Iterator iterator = this.objStmMark.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int n4 = (Integer)entry.getKey();
                IntHashtable intHashtable = (IntHashtable)entry.getValue();
                this.readObjStm((PRStream)this.xrefObj.get(n4), intHashtable);
                this.xrefObj.set(n4, null);
            }
            this.objStmMark = null;
        }
        this.xref = null;
    }

    private void checkPRStreamLength(PRStream pRStream) throws IOException {
        int n2;
        block8: {
            Object object;
            int n3 = this.tokens.length();
            int n4 = pRStream.getOffset();
            boolean bl = false;
            n2 = 0;
            PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.LENGTH));
            if (pdfObject != null && pdfObject.type() == 2) {
                n2 = ((PdfNumber)pdfObject).intValue();
                if (n2 + n4 > n3 - 20) {
                    bl = true;
                } else {
                    this.tokens.seek(n4 + n2);
                    object = this.tokens.readString(20);
                    if (!(((String)object).startsWith("\nendstream") || ((String)object).startsWith("\r\nendstream") || ((String)object).startsWith("\rendstream") || ((String)object).startsWith("endstream"))) {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                int n5;
                object = new byte[16];
                this.tokens.seek(n4);
                do {
                    n5 = this.tokens.getFilePointer();
                    if (!this.tokens.readLineSegment((byte[])object)) break block8;
                    if (!PdfReader.equalsn((byte[])object, endstream)) continue;
                    n2 = n5 - n4;
                    break block8;
                } while (!PdfReader.equalsn((byte[])object, endobj));
                this.tokens.seek(n5 - 16);
                String string = this.tokens.readString(16);
                int n6 = string.indexOf("endstream");
                if (n6 >= 0) {
                    n5 = n5 - 16 + n6;
                }
                n2 = n5 - n4;
            }
        }
        pRStream.setLength(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readObjStm(PRStream pRStream, IntHashtable intHashtable) throws IOException {
        int n2 = ((PdfNumber)PdfReader.getPdfObject(pRStream.get(PdfName.FIRST))).intValue();
        int n3 = ((PdfNumber)PdfReader.getPdfObject(pRStream.get(PdfName.N))).intValue();
        byte[] byArray = PdfReader.getStreamBytes(pRStream, this.tokens.getFile());
        PRTokeniser pRTokeniser = this.tokens;
        this.tokens = new PRTokeniser(byArray);
        try {
            int n4;
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            boolean bl = true;
            for (n4 = 0; n4 < n3 && (bl = this.tokens.nextToken()); ++n4) {
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                nArray2[n4] = this.tokens.intValue();
                bl = this.tokens.nextToken();
                if (!bl) break;
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                nArray[n4] = this.tokens.intValue() + n2;
            }
            if (!bl) {
                throw new IOException("Error reading ObjStm");
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (!intHashtable.containsKey(n4)) continue;
                this.tokens.seek(nArray[n4]);
                PdfObject pdfObject = this.readPRObject();
                this.xrefObj.set(nArray2[n4], pdfObject);
            }
        }
        finally {
            this.tokens = pRTokeniser;
        }
    }

    public static PdfObject killIndirect(PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            return null;
        }
        PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(pdfObject);
        if (pdfObject.isIndirect()) {
            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
            PdfReader pdfReader = pRIndirectReference.getReader();
            int n2 = pRIndirectReference.getNumber();
            pdfReader.xrefObj.set(n2, null);
            if (pdfReader.partial) {
                pdfReader.xref[n2 * 2] = -1;
            }
        }
        return pdfObject2;
    }

    private void ensureXrefSize(int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.xref == null) {
            this.xref = new int[n2];
        } else if (this.xref.length < n2) {
            int[] nArray = new int[n2];
            System.arraycopy(this.xref, 0, nArray, 0, this.xref.length);
            this.xref = nArray;
        }
    }

    protected void readXref() throws IOException {
        PdfNumber pdfNumber;
        int n2;
        this.hybridXref = false;
        this.newXrefType = false;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        this.lastXref = n2 = this.tokens.intValue();
        this.eofPos = this.tokens.getFilePointer();
        try {
            if (this.readXRefStream(n2)) {
                this.newXrefType = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xref = null;
        this.tokens.seek(n2);
        PdfDictionary pdfDictionary = this.trailer = this.readXrefSection();
        while ((pdfNumber = (PdfNumber)pdfDictionary.get(PdfName.PREV)) != null) {
            this.tokens.seek(pdfNumber.intValue());
            pdfDictionary = this.readXrefSection();
        }
    }

    protected PdfDictionary readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        block2: while (true) {
            int n6;
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            n2 = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            n3 = this.tokens.intValue() + n2;
            if (n2 == 1) {
                n6 = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n5 = this.tokens.intValue();
                if (n4 == 0 && n5 == 65535) {
                    --n2;
                    --n3;
                }
                this.tokens.seek(n6);
            }
            this.ensureXrefSize(n3 * 2);
            n6 = n2;
            while (true) {
                if (n6 >= n3) continue block2;
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n5 = this.tokens.intValue();
                this.tokens.nextValidToken();
                int n7 = n6 * 2;
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[n7] == 0 && this.xref[n7 + 1] == 0) {
                        this.xref[n7] = n4;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[n7] == 0 && this.xref[n7 + 1] == 0) {
                        this.xref[n7] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++n6;
            }
            break;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)this.readPRObject();
        PdfNumber pdfNumber = (PdfNumber)pdfDictionary.get(PdfName.SIZE);
        this.ensureXrefSize(pdfNumber.intValue() * 2);
        PdfObject pdfObject = pdfDictionary.get(PdfName.XREFSTM);
        if (pdfObject != null && pdfObject.isNumber()) {
            int n8 = ((PdfNumber)pdfObject).intValue();
            try {
                this.readXRefStream(n8);
                this.newXrefType = true;
                this.hybridXref = true;
            }
            catch (IOException iOException) {
                this.xref = null;
                throw iOException;
            }
        }
        return pdfDictionary;
    }

    protected boolean readXRefStream(int n2) throws IOException {
        PdfArray pdfArray;
        this.tokens.seek(n2);
        int n3 = 0;
        if (!this.tokens.nextToken()) {
            return false;
        }
        if (this.tokens.getTokenType() != 1) {
            return false;
        }
        n3 = this.tokens.intValue();
        if (!this.tokens.nextToken() || this.tokens.getTokenType() != 1) {
            return false;
        }
        if (!this.tokens.nextToken() || !this.tokens.getStringValue().equals("obj")) {
            return false;
        }
        PdfObject pdfObject = this.readPRObject();
        PRStream pRStream = null;
        if (pdfObject.isStream()) {
            pRStream = (PRStream)pdfObject;
            if (!PdfName.XREF.equals(pRStream.get(PdfName.TYPE))) {
                return false;
            }
        } else {
            return false;
        }
        if (this.trailer == null) {
            this.trailer = new PdfDictionary();
            this.trailer.putAll(pRStream);
        }
        pRStream.setLength(((PdfNumber)pRStream.get(PdfName.LENGTH)).intValue());
        int n4 = ((PdfNumber)pRStream.get(PdfName.SIZE)).intValue();
        PdfObject pdfObject2 = pRStream.get(PdfName.INDEX);
        if (pdfObject2 == null) {
            pdfArray = new PdfArray();
            pdfArray.add(new int[]{0, n4});
        } else {
            pdfArray = (PdfArray)pdfObject2;
        }
        PdfArray pdfArray2 = (PdfArray)pRStream.get(PdfName.W);
        int n5 = -1;
        pdfObject2 = pRStream.get(PdfName.PREV);
        if (pdfObject2 != null) {
            n5 = ((PdfNumber)pdfObject2).intValue();
        }
        this.ensureXrefSize(n4 * 2);
        if (this.objStmMark == null && !this.partial) {
            this.objStmMark = new HashMap();
        }
        if (this.objStmToOffset == null && this.partial) {
            this.objStmToOffset = new IntHashtable();
        }
        byte[] byArray = PdfReader.getStreamBytes(pRStream, this.tokens.getFile());
        int n6 = 0;
        ArrayList arrayList = pdfArray2.getArrayList();
        int[] nArray = new int[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            nArray[i2] = ((PdfNumber)arrayList.get(i2)).intValue();
        }
        ArrayList arrayList2 = pdfArray.getArrayList();
        for (int i3 = 0; i3 < arrayList2.size(); i3 += 2) {
            int n7 = ((PdfNumber)arrayList2.get(i3)).intValue();
            int n8 = ((PdfNumber)arrayList2.get(i3 + 1)).intValue();
            this.ensureXrefSize((n7 + n8) * 2);
            while (n8-- > 0) {
                int n9;
                int n10;
                int n11;
                int n12 = 1;
                if (nArray[0] > 0) {
                    n12 = 0;
                    for (n11 = 0; n11 < nArray[0]; ++n11) {
                        n12 = (n12 << 8) + (byArray[n6++] & 0xFF);
                    }
                }
                n11 = 0;
                for (n10 = 0; n10 < nArray[1]; ++n10) {
                    n11 = (n11 << 8) + (byArray[n6++] & 0xFF);
                }
                n10 = 0;
                for (n9 = 0; n9 < nArray[2]; ++n9) {
                    n10 = (n10 << 8) + (byArray[n6++] & 0xFF);
                }
                n9 = n7 * 2;
                if (this.xref[n9] == 0 && this.xref[n9 + 1] == 0) {
                    switch (n12) {
                        case 0: {
                            this.xref[n9] = -1;
                            break;
                        }
                        case 1: {
                            this.xref[n9] = n11;
                            break;
                        }
                        case 2: {
                            this.xref[n9] = n10;
                            this.xref[n9 + 1] = n11;
                            if (this.partial) {
                                this.objStmToOffset.put(n11, 0);
                                break;
                            }
                            Integer n13 = new Integer(n11);
                            IntHashtable intHashtable = (IntHashtable)this.objStmMark.get(n13);
                            if (intHashtable == null) {
                                intHashtable = new IntHashtable();
                                intHashtable.put(n10, 1);
                                this.objStmMark.put(n13, intHashtable);
                                break;
                            }
                            intHashtable.put(n10, 1);
                        }
                    }
                }
                ++n7;
            }
        }
        if ((n3 *= 2) < this.xref.length) {
            this.xref[n3] = -1;
        }
        if (n5 == -1) {
            return true;
        }
        return this.readXRefStream(n5);
    }

    protected void rebuildXref() throws IOException {
        Object object;
        int n2;
        this.hybridXref = false;
        this.newXrefType = false;
        this.tokens.seek(0);
        int[][] nArrayArray = new int[1024][];
        int n3 = 0;
        this.trailer = null;
        byte[] byArray = new byte[64];
        while (true) {
            n2 = this.tokens.getFilePointer();
            if (!this.tokens.readLineSegment(byArray)) break;
            if (byArray[0] == 116) {
                if (!PdfEncodings.convertToString(byArray, null).startsWith("trailer")) continue;
                this.tokens.seek(n2);
                this.tokens.nextToken();
                n2 = this.tokens.getFilePointer();
                try {
                    object = (PdfDictionary)this.readPRObject();
                    if (object.get(PdfName.ROOT) != null) {
                        this.trailer = object;
                        continue;
                    }
                    this.tokens.seek(n2);
                }
                catch (Exception exception) {
                    this.tokens.seek(n2);
                }
                continue;
            }
            if (byArray[0] < 48 || byArray[0] > 57 || (object = PRTokeniser.checkObjectStart(byArray)) == null) continue;
            int n4 = object[0];
            int n5 = object[1];
            if (n4 >= nArrayArray.length) {
                int n6 = n4 * 2;
                int[][] nArrayArray2 = new int[n6][];
                System.arraycopy(nArrayArray, 0, nArrayArray2, 0, n3);
                nArrayArray = nArrayArray2;
            }
            if (n4 >= n3) {
                n3 = n4 + 1;
            }
            if (nArrayArray[n4] != null && n5 < nArrayArray[n4][1]) continue;
            object[0] = n2;
            nArrayArray[n4] = object;
        }
        if (this.trailer == null) {
            throw new IOException("trailer not found.");
        }
        this.xref = new int[n3 * 2];
        for (n2 = 0; n2 < n3; ++n2) {
            object = nArrayArray[n2];
            if (object == null) continue;
            this.xref[n2 * 2] = object[0];
        }
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary pdfDictionary = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName pdfName = new PdfName(this.tokens.getStringValue(), false);
            PdfObject pdfObject = this.readPRObject();
            int n2 = pdfObject.type();
            if (-n2 == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-n2 == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            pdfDictionary.put(pdfName, pdfObject);
        }
        return pdfDictionary;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject pdfObject;
        int n2;
        PdfArray pdfArray = new PdfArray();
        while (-(n2 = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n2 == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            pdfArray.add(pdfObject);
        }
        return pdfArray;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int n2 = this.tokens.getTokenType();
        switch (n2) {
            case 7: {
                PdfDictionary pdfDictionary = this.readDictionary();
                int n3 = this.tokens.getFilePointer();
                if (this.tokens.nextToken() && this.tokens.getStringValue().equals("stream")) {
                    int n4 = this.tokens.read();
                    if (n4 != 10) {
                        n4 = this.tokens.read();
                    }
                    if (n4 != 10) {
                        this.tokens.backOnePosition(n4);
                    }
                    PRStream pRStream = new PRStream(this, this.tokens.getFilePointer());
                    pRStream.putAll(pdfDictionary);
                    pRStream.setObjNum(this.objNum, this.objGen);
                    return pRStream;
                }
                this.tokens.seek(n3);
                return pdfDictionary;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                PdfString pdfString = new PdfString(this.tokens.getStringValue(), null).setHexWriting(this.tokens.isHexString());
                pdfString.setObjNum(this.objNum, this.objGen);
                if (this.strings != null) {
                    this.strings.add(pdfString);
                }
                return pdfString;
            }
            case 3: {
                return new PdfName(this.tokens.getStringValue(), false);
            }
            case 9: {
                int n5 = this.tokens.getReference();
                PRIndirectReference pRIndirectReference = new PRIndirectReference(this, n5, this.tokens.getGeneration());
                return pRIndirectReference;
            }
        }
        String string = this.tokens.getStringValue();
        if ("null".equals(string)) {
            return PdfNull.PDFNULL;
        }
        if ("true".equals(string)) {
            return PdfBoolean.PDFTRUE;
        }
        if ("false".equals(string)) {
            return PdfBoolean.PDFFALSE;
        }
        return new PdfLiteral(-n2, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] byArray) {
        byte[] byArray2 = PdfReader.FlateDecode(byArray, true);
        if (byArray2 == null) {
            return PdfReader.FlateDecode(byArray, false);
        }
        return byArray2;
    }

    public static byte[] decodePredictor(byte[] byArray, PdfObject pdfObject) {
        if (pdfObject == null || !pdfObject.isDictionary()) {
            return byArray;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.PREDICTOR));
        if (pdfObject2 == null || !pdfObject2.isNumber()) {
            return byArray;
        }
        int n2 = ((PdfNumber)pdfObject2).intValue();
        if (n2 < 10) {
            return byArray;
        }
        int n3 = 1;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.COLUMNS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n3 = ((PdfNumber)pdfObject2).intValue();
        }
        int n4 = 1;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.COLORS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n4 = ((PdfNumber)pdfObject2).intValue();
        }
        int n5 = 8;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.BITSPERCOMPONENT));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n5 = ((PdfNumber)pdfObject2).intValue();
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n6 = n4 * n5 / 8;
        int n7 = (n4 * n3 * n5 + 7) / 8;
        byte[] byArray2 = new byte[n7];
        byte[] byArray3 = new byte[n7];
        while (true) {
            int n8 = 0;
            try {
                n8 = dataInputStream.read();
                if (n8 < 0) {
                    return byteArrayOutputStream.toByteArray();
                }
                dataInputStream.readFully(byArray2, 0, n7);
            }
            catch (Exception exception) {
                return byteArrayOutputStream.toByteArray();
            }
            switch (n8) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int i2 = n6; i2 < n7; ++i2) {
                        int n9 = i2;
                        byArray2[n9] = (byte)(byArray2[n9] + byArray2[i2 - n6]);
                    }
                    break;
                }
                case 2: {
                    for (int i3 = 0; i3 < n7; ++i3) {
                        int n10 = i3;
                        byArray2[n10] = (byte)(byArray2[n10] + byArray3[i3]);
                    }
                    break;
                }
                case 3: {
                    int n11;
                    for (n11 = 0; n11 < n6; ++n11) {
                        int n12 = n11;
                        byArray2[n12] = (byte)(byArray2[n12] + byArray3[n11] / 2);
                    }
                    for (n11 = n6; n11 < n7; ++n11) {
                        int n13 = n11;
                        byArray2[n13] = (byte)(byArray2[n13] + ((byArray2[n11 - n6] & 0xFF) + (byArray3[n11] & 0xFF)) / 2);
                    }
                    break;
                }
                case 4: {
                    int n14;
                    for (n14 = 0; n14 < n6; ++n14) {
                        int n15 = n14;
                        byArray2[n15] = (byte)(byArray2[n15] + byArray3[n14]);
                    }
                    n14 = n6;
                    while (n14 < n7) {
                        int n16 = byArray2[n14 - n6] & 0xFF;
                        int n17 = byArray3[n14] & 0xFF;
                        int n18 = byArray3[n14 - n6] & 0xFF;
                        int n19 = n16 + n17 - n18;
                        int n20 = Math.abs(n19 - n16);
                        int n21 = Math.abs(n19 - n17);
                        int n22 = Math.abs(n19 - n18);
                        int n23 = n20 <= n21 && n20 <= n22 ? n16 : (n21 <= n22 ? n17 : n18);
                        int n24 = n14++;
                        byArray2[n24] = (byte)(byArray2[n24] + (byte)n23);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("PNG filter unknown.");
                }
            }
            try {
                byteArrayOutputStream.write(byArray2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray4 = byArray3;
            byArray3 = byArray2;
            byArray2 = byArray4;
        }
    }

    public static byte[] FlateDecode(byte[] byArray, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[bl ? 4092 : 1];
        try {
            int n2;
            while ((n2 = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (bl) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] byArray) {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        int n3 = 0;
        for (int i2 = 0; i2 < byArray.length && (n2 = byArray[i2] & 0xFF) != 62; ++i2) {
            if (PRTokeniser.isWhitespace(n2)) continue;
            int n4 = PRTokeniser.getHex(n2);
            if (n4 == -1) {
                throw new RuntimeException("Illegal character in ASCIIHexDecode.");
            }
            if (bl) {
                n3 = n4;
            } else {
                byteArrayOutputStream.write((byte)((n3 << 4) + n4));
            }
            bl = !bl;
        }
        if (!bl) {
            byteArrayOutputStream.write((byte)(n3 << 4));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] byArray) {
        int n2;
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = 0;
        int[] nArray = new int[5];
        for (n3 = 0; n3 < byArray.length && (n2 = byArray[n3] & 0xFF) != 126; ++n3) {
            if (PRTokeniser.isWhitespace(n2)) continue;
            if (n2 == 122 && n4 == 0) {
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                continue;
            }
            if (n2 < 33 || n2 > 117) {
                throw new RuntimeException("Illegal character in ASCII85Decode.");
            }
            nArray[n4] = n2 - 33;
            if (++n4 != 5) continue;
            n4 = 0;
            int n5 = 0;
            for (int i2 = 0; i2 < 5; ++i2) {
                n5 = n5 * 85 + nArray[i2];
            }
            byteArrayOutputStream.write((byte)(n5 >> 24));
            byteArrayOutputStream.write((byte)(n5 >> 16));
            byteArrayOutputStream.write((byte)(n5 >> 8));
            byteArrayOutputStream.write((byte)n5);
        }
        n3 = 0;
        if (n4 == 2) {
            n3 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + 614125 + 7225 + 85;
            byteArrayOutputStream.write((byte)(n3 >> 24));
        } else if (n4 == 3) {
            n3 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + 7225 + 85;
            byteArrayOutputStream.write((byte)(n3 >> 24));
            byteArrayOutputStream.write((byte)(n3 >> 16));
        } else if (n4 == 4) {
            n3 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + nArray[3] * 85 + 85;
            byteArrayOutputStream.write((byte)(n3 >> 24));
            byteArrayOutputStream.write((byte)(n3 >> 16));
            byteArrayOutputStream.write((byte)(n3 >> 8));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] LZWDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isRebuilt() {
        return this.rebuilt;
    }

    public PdfDictionary getPageN(int n2) {
        PdfDictionary pdfDictionary = this.pageRefs.getPageN(n2);
        if (pdfDictionary == null) {
            return null;
        }
        if (this.appendable) {
            pdfDictionary.setIndRef(this.pageRefs.getPageOrigRef(n2));
        }
        return pdfDictionary;
    }

    public PdfDictionary getPageNRelease(int n2) {
        PdfDictionary pdfDictionary = this.getPageN(n2);
        this.pageRefs.releasePage(n2);
        return pdfDictionary;
    }

    public void releasePage(int n2) {
        this.pageRefs.releasePage(n2);
    }

    public void resetReleasePage() {
        this.pageRefs.resetReleasePage();
    }

    public PRIndirectReference getPageOrigRef(int n2) {
        return this.pageRefs.getPageOrigRef(n2);
    }

    public byte[] getPageContent(int n2, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfDictionary pdfDictionary = this.getPageNRelease(n2);
        if (pdfDictionary == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CONTENTS));
        if (pdfObject == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (pdfObject.isStream()) {
            return PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
        }
        if (pdfObject.isArray()) {
            PdfArray pdfArray = (PdfArray)pdfObject;
            ArrayList arrayList = pdfArray.getArrayList();
            byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                PdfObject pdfObject2 = PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(i2));
                if (pdfObject2 == null || !pdfObject2.isStream()) continue;
                byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject2, randomAccessFileOrArray);
                byteArrayOutputStream.write(byArray);
                if (i2 == arrayList.size() - 1) continue;
                byteArrayOutputStream.write(10);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPageContent(int n2) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = this.getPageContent(n2, randomAccessFileOrArray);
            return byArray;
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void killXref(PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect()) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                int n2 = ((PRIndirectReference)pdfObject).getNumber();
                pdfObject = (PdfObject)this.xrefObj.get(n2);
                this.xrefObj.set(n2, null);
                this.freeXref = n2;
                this.killXref(pdfObject);
                break;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    this.killXref((PdfObject)arrayList.get(i2));
                }
                break;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    this.killXref(pdfDictionary.get((PdfName)iterator.next()));
                }
                break;
            }
        }
    }

    public void setPageContent(int n2, byte[] byArray) {
        PdfDictionary pdfDictionary = this.getPageN(n2);
        if (pdfDictionary == null) {
            return;
        }
        PdfObject pdfObject = pdfDictionary.get(PdfName.CONTENTS);
        this.freeXref = -1;
        this.killXref(pdfObject);
        if (this.freeXref == -1) {
            this.xrefObj.add(null);
            this.freeXref = this.xrefObj.size() - 1;
        }
        pdfDictionary.put(PdfName.CONTENTS, new PRIndirectReference(this, this.freeXref));
        this.xrefObj.set(this.freeXref, new PRStream(this, byArray));
    }

    public static byte[] getStreamBytes(PRStream pRStream, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.FILTER));
        byte[] byArray = PdfReader.getStreamBytesRaw(pRStream, randomAccessFileOrArray);
        ArrayList arrayList = new ArrayList();
        if (pdfObject != null) {
            if (pdfObject.isName()) {
                arrayList.add(pdfObject);
            } else if (pdfObject.isArray()) {
                arrayList = ((PdfArray)pdfObject).getArrayList();
            }
        }
        ArrayList arrayList2 = new ArrayList();
        PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.DECODEPARMS));
        if (pdfObject2 == null || !pdfObject2.isDictionary() && !pdfObject2.isArray()) {
            pdfObject2 = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.DP));
        }
        if (pdfObject2 != null) {
            if (pdfObject2.isDictionary()) {
                arrayList2.add(pdfObject2);
            } else if (pdfObject2.isArray()) {
                arrayList2 = ((PdfArray)pdfObject2).getArrayList();
            }
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            PdfObject pdfObject3;
            String string = ((PdfName)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(i2))).toString();
            if (string.equals("/FlateDecode") || string.equals("/Fl")) {
                byArray = PdfReader.FlateDecode(byArray);
                pdfObject3 = null;
                if (i2 >= arrayList2.size()) continue;
                pdfObject3 = (PdfObject)arrayList2.get(i2);
                byArray = PdfReader.decodePredictor(byArray, pdfObject3);
                continue;
            }
            if (string.equals("/ASCIIHexDecode") || string.equals("/AHx")) {
                byArray = PdfReader.ASCIIHexDecode(byArray);
                continue;
            }
            if (string.equals("/ASCII85Decode") || string.equals("/A85")) {
                byArray = PdfReader.ASCII85Decode(byArray);
                continue;
            }
            if (string.equals("/LZWDecode")) {
                byArray = PdfReader.LZWDecode(byArray);
                pdfObject3 = null;
                if (i2 >= arrayList2.size()) continue;
                pdfObject3 = (PdfObject)arrayList2.get(i2);
                byArray = PdfReader.decodePredictor(byArray, pdfObject3);
                continue;
            }
            if (string.equals("/Crypt")) continue;
            throw new IOException("The filter " + string + " is not supported.");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getStreamBytes(PRStream pRStream) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = pRStream.getReader().getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = PdfReader.getStreamBytes(pRStream, randomAccessFileOrArray);
            return byArray;
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] getStreamBytesRaw(PRStream pRStream, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        byte[] byArray;
        PdfReader pdfReader = pRStream.getReader();
        if (pRStream.getOffset() < 0) {
            byArray = pRStream.getBytes();
        } else {
            byArray = new byte[pRStream.getLength()];
            randomAccessFileOrArray.seek(pRStream.getOffset());
            randomAccessFileOrArray.readFully(byArray);
            PdfEncryption pdfEncryption = pdfReader.getDecrypt();
            if (pdfEncryption != null) {
                PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.FILTER));
                ArrayList arrayList = new ArrayList();
                if (pdfObject != null) {
                    if (pdfObject.isName()) {
                        arrayList.add(pdfObject);
                    } else if (pdfObject.isArray()) {
                        arrayList = ((PdfArray)pdfObject).getArrayList();
                    }
                }
                boolean bl = false;
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    PdfObject pdfObject2 = PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(i2));
                    if (pdfObject2 == null || !pdfObject2.toString().equals("/Crypt")) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    pdfEncryption.setHashKey(pRStream.getObjNum(), pRStream.getObjGen());
                    byArray = pdfEncryption.decryptByteArray(byArray);
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getStreamBytesRaw(PRStream pRStream) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = pRStream.getReader().getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = PdfReader.getStreamBytesRaw(pRStream, randomAccessFileOrArray);
            return byArray;
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    public void eliminateSharedStreams() {
        PdfObject pdfObject;
        int n2;
        if (!this.sharedStreams) {
            return;
        }
        this.sharedStreams = false;
        if (this.pageRefs.size() == 1) {
            return;
        }
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList<PRStream> arrayList2 = new ArrayList<PRStream>();
        IntHashtable intHashtable = new IntHashtable();
        for (n2 = 1; n2 <= this.pageRefs.size(); ++n2) {
            PdfObject pdfObject2;
            PdfObject pdfObject3;
            pdfObject = this.pageRefs.getPageN(n2);
            if (pdfObject == null || (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.CONTENTS))) == null) continue;
            if (pdfObject3.isStream()) {
                pdfObject2 = (PRIndirectReference)((PdfDictionary)pdfObject).get(PdfName.CONTENTS);
                if (intHashtable.containsKey(((PdfIndirectReference)pdfObject2).getNumber())) {
                    arrayList.add(pdfObject2);
                    arrayList2.add(new PRStream((PRStream)pdfObject3, null));
                    continue;
                }
                intHashtable.put(((PdfIndirectReference)pdfObject2).getNumber(), 1);
                continue;
            }
            if (!pdfObject3.isArray()) continue;
            pdfObject2 = (PdfArray)pdfObject3;
            ArrayList arrayList3 = ((PdfArray)pdfObject2).getArrayList();
            for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)arrayList3.get(i2);
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    arrayList.add(pRIndirectReference);
                    arrayList2.add(new PRStream((PRStream)PdfReader.getPdfObject(pRIndirectReference), null));
                    continue;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
            }
        }
        if (arrayList2.isEmpty()) {
            return;
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            this.xrefObj.add(arrayList2.get(n2));
            pdfObject = (PRIndirectReference)arrayList.get(n2);
            ((PRIndirectReference)pdfObject).setNumber(this.xrefObj.size() - 1, 0);
        }
    }

    public boolean isTampered() {
        return this.tampered;
    }

    public void setTampered(boolean bl) {
        this.tampered = bl;
        this.pageRefs.keepPages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMetadata() throws IOException {
        PdfObject pdfObject = PdfReader.getPdfObject(this.catalog.get(PdfName.METADATA));
        if (!(pdfObject instanceof PRStream)) {
            return null;
        }
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        byte[] byArray = null;
        try {
            randomAccessFileOrArray.reOpen();
            byArray = PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public int getLastXref() {
        return this.lastXref;
    }

    public int getXrefSize() {
        return this.xrefObj.size();
    }

    public int getEofPos() {
        return this.eofPos;
    }

    public char getPdfVersion() {
        return this.pdfVersion;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public int getPermissions() {
        return this.pValue;
    }

    public boolean is128Key() {
        return this.rValue == 3;
    }

    public PdfDictionary getTrailer() {
        return this.trailer;
    }

    PdfEncryption getDecrypt() {
        return this.decrypt;
    }

    static boolean equalsn(byte[] byArray, byte[] byArray2) {
        int n2 = byArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    static boolean existsName(PdfDictionary pdfDictionary, PdfName pdfName, PdfName pdfName2) {
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(pdfName));
        if (pdfObject == null || !pdfObject.isName()) {
            return false;
        }
        PdfName pdfName3 = (PdfName)pdfObject;
        return pdfName3.equals(pdfName2);
    }

    static String getFontName(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.BASEFONT));
        if (pdfObject == null || !pdfObject.isName()) {
            return null;
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    static String getSubsetPrefix(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return null;
        }
        String string = PdfReader.getFontName(pdfDictionary);
        if (string == null) {
            return null;
        }
        if (string.length() < 8 || string.charAt(6) != '+') {
            return null;
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z') continue;
            return null;
        }
        return string;
    }

    public int shuffleSubsetNames() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.xrefObj.size(); ++i2) {
            String string;
            PdfDictionary pdfDictionary;
            Object object;
            Object object2;
            String string2;
            PdfDictionary pdfDictionary2;
            PdfObject pdfObject = this.getPdfObjectRelease(i2);
            if (pdfObject == null || !pdfObject.isDictionary() || !PdfReader.existsName(pdfDictionary2 = (PdfDictionary)pdfObject, PdfName.TYPE, PdfName.FONT)) continue;
            if (PdfReader.existsName(pdfDictionary2, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(pdfDictionary2, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(pdfDictionary2, PdfName.SUBTYPE, PdfName.TRUETYPE)) {
                string2 = PdfReader.getSubsetPrefix(pdfDictionary2);
                if (string2 == null) continue;
                object2 = BaseFont.createSubsetPrefix() + string2.substring(7);
                object = new PdfName((String)object2);
                pdfDictionary2.put(PdfName.BASEFONT, (PdfObject)object);
                this.setXrefPartialObject(i2, pdfDictionary2);
                ++n2;
                pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FONTDESCRIPTOR));
                if (pdfDictionary == null) continue;
                pdfDictionary.put(PdfName.FONTNAME, (PdfObject)object);
                continue;
            }
            if (!PdfReader.existsName(pdfDictionary2, PdfName.SUBTYPE, PdfName.TYPE0)) continue;
            string2 = PdfReader.getSubsetPrefix(pdfDictionary2);
            object2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.DESCENDANTFONTS));
            if (object2 == null || ((ArrayList)(object = ((PdfArray)object2).getArrayList())).isEmpty() || (string = PdfReader.getSubsetPrefix(pdfDictionary = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((ArrayList)object).get(0)))) == null) continue;
            String string3 = BaseFont.createSubsetPrefix();
            if (string2 != null) {
                pdfDictionary2.put(PdfName.BASEFONT, new PdfName(string3 + string2.substring(7)));
            }
            this.setXrefPartialObject(i2, pdfDictionary2);
            PdfName pdfName = new PdfName(string3 + string.substring(7));
            pdfDictionary.put(PdfName.BASEFONT, pdfName);
            ++n2;
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
            if (pdfDictionary3 == null) continue;
            pdfDictionary3.put(PdfName.FONTNAME, pdfName);
        }
        return n2;
    }

    public int createFakeFontSubsets() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.xrefObj.size(); ++i2) {
            String string;
            PdfDictionary pdfDictionary;
            PdfObject pdfObject = this.getPdfObjectRelease(i2);
            if (pdfObject == null || !pdfObject.isDictionary() || !PdfReader.existsName(pdfDictionary = (PdfDictionary)pdfObject, PdfName.TYPE, PdfName.FONT) || !PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TYPE1) && !PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.MMTYPE1) && !PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TRUETYPE) || (string = PdfReader.getSubsetPrefix(pdfDictionary)) != null || (string = PdfReader.getFontName(pdfDictionary)) == null) continue;
            String string2 = BaseFont.createSubsetPrefix() + string;
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
            if (pdfDictionary2 == null || pdfDictionary2.get(PdfName.FONTFILE) == null && pdfDictionary2.get(PdfName.FONTFILE2) == null && pdfDictionary2.get(PdfName.FONTFILE3) == null) continue;
            pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
            PdfName pdfName = new PdfName(string2);
            pdfDictionary.put(PdfName.BASEFONT, pdfName);
            pdfDictionary2.put(PdfName.FONTNAME, pdfName);
            this.setXrefPartialObject(i2, pdfDictionary);
            ++n2;
        }
        return n2;
    }

    private static PdfArray getNameArray(PdfObject pdfObject) {
        PdfObject pdfObject2;
        if (pdfObject == null) {
            return null;
        }
        if ((pdfObject = PdfReader.getPdfObjectRelease(pdfObject)) == null) {
            return null;
        }
        if (pdfObject.isArray()) {
            return (PdfArray)pdfObject;
        }
        if (pdfObject.isDictionary() && (pdfObject2 = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.D))) != null && pdfObject2.isArray()) {
            return (PdfArray)pdfObject2;
        }
        return null;
    }

    public HashMap getNamedDestination() {
        HashMap hashMap = this.getNamedDestinationFromNames();
        hashMap.putAll(this.getNamedDestinationFromStrings());
        return hashMap;
    }

    public HashMap getNamedDestinationFromNames() {
        HashMap<String, PdfArray> hashMap = new HashMap<String, PdfArray>();
        if (this.catalog.get(PdfName.DESTS) != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.DESTS));
            if (pdfDictionary == null) {
                return hashMap;
            }
            Set set = pdfDictionary.getKeys();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PdfName pdfName = (PdfName)iterator.next();
                String string = PdfName.decodeName(pdfName.toString());
                PdfArray pdfArray = PdfReader.getNameArray(pdfDictionary.get(pdfName));
                if (pdfArray == null) continue;
                hashMap.put(string, pdfArray);
            }
        }
        return hashMap;
    }

    public HashMap getNamedDestinationFromStrings() {
        PdfDictionary pdfDictionary;
        if (this.catalog.get(PdfName.NAMES) != null && (pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.NAMES))) != null && (pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.DESTS))) != null) {
            HashMap hashMap = PdfNameTree.readTree(pdfDictionary);
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                PdfArray pdfArray = PdfReader.getNameArray((PdfObject)entry.getValue());
                if (pdfArray != null) {
                    entry.setValue(pdfArray);
                    continue;
                }
                iterator.remove();
            }
            return hashMap;
        }
        return new HashMap();
    }

    private boolean replaceNamedDestination(PdfObject pdfObject, HashMap hashMap) {
        pdfObject = PdfReader.getPdfObject(pdfObject);
        int n2 = this.lastXrefPartial;
        this.releaseLastXrefPartial();
        if (pdfObject != null && pdfObject.isDictionary()) {
            PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.DEST));
            String string = null;
            if (pdfObject2 != null) {
                if (pdfObject2.isName()) {
                    string = PdfName.decodeName(pdfObject2.toString());
                } else if (pdfObject2.isString()) {
                    string = pdfObject2.toString();
                }
                PdfArray pdfArray = (PdfArray)hashMap.get(string);
                if (pdfArray != null) {
                    ((PdfDictionary)pdfObject).put(PdfName.DEST, pdfArray);
                    this.setXrefPartialObject(n2, pdfObject);
                    return true;
                }
            } else {
                pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.A));
                if (pdfObject2 != null) {
                    int n3 = this.lastXrefPartial;
                    this.releaseLastXrefPartial();
                    PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
                    PdfName pdfName = (PdfName)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.S));
                    if (PdfName.GOTO.equals(pdfName)) {
                        PdfArray pdfArray;
                        PdfObject pdfObject3 = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.D));
                        if (pdfObject3 != null) {
                            if (pdfObject3.isName()) {
                                string = PdfName.decodeName(pdfObject3.toString());
                            } else if (pdfObject3.isString()) {
                                string = pdfObject3.toString();
                            }
                        }
                        if ((pdfArray = (PdfArray)hashMap.get(string)) != null) {
                            pdfDictionary.put(PdfName.D, pdfArray);
                            this.setXrefPartialObject(n3, pdfObject2);
                            this.setXrefPartialObject(n2, pdfObject);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public void removeFields() {
        this.pageRefs.resetReleasePage();
        for (int i2 = 1; i2 <= this.pageRefs.size(); ++i2) {
            PdfDictionary pdfDictionary = this.pageRefs.getPageN(i2);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
            if (pdfArray == null) {
                this.pageRefs.releasePage(i2);
                continue;
            }
            ArrayList arrayList = pdfArray.getArrayList();
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                PdfDictionary pdfDictionary2;
                PdfObject pdfObject = PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(i3));
                if (pdfObject == null || !pdfObject.isDictionary() || !PdfName.WIDGET.equals((pdfDictionary2 = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                arrayList.remove(i3--);
            }
            if (arrayList.isEmpty()) {
                pdfDictionary.remove(PdfName.ANNOTS);
                continue;
            }
            this.pageRefs.releasePage(i2);
        }
        this.catalog.remove(PdfName.ACROFORM);
        this.pageRefs.resetReleasePage();
    }

    public void removeAnnotations() {
        this.pageRefs.resetReleasePage();
        for (int i2 = 1; i2 <= this.pageRefs.size(); ++i2) {
            PdfDictionary pdfDictionary = this.pageRefs.getPageN(i2);
            if (pdfDictionary.get(PdfName.ANNOTS) == null) {
                this.pageRefs.releasePage(i2);
                continue;
            }
            pdfDictionary.remove(PdfName.ANNOTS);
        }
        this.catalog.remove(PdfName.ACROFORM);
        this.pageRefs.resetReleasePage();
    }

    public ArrayList getLinks(int n2) {
        this.pageRefs.resetReleasePage();
        ArrayList<PdfAnnotation.PdfImportedLink> arrayList = new ArrayList<PdfAnnotation.PdfImportedLink>();
        PdfDictionary pdfDictionary = this.pageRefs.getPageN(n2);
        if (pdfDictionary.get(PdfName.ANNOTS) != null) {
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
            ArrayList arrayList2 = pdfArray.getArrayList();
            for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)arrayList2.get(i2));
                if (!PdfName.LINK.equals(pdfDictionary2.get(PdfName.SUBTYPE))) continue;
                arrayList.add(new PdfAnnotation.PdfImportedLink(pdfDictionary2));
            }
        }
        this.pageRefs.releasePage(n2);
        this.pageRefs.resetReleasePage();
        return arrayList;
    }

    private void iterateBookmarks(PdfObject pdfObject, HashMap hashMap) {
        while (pdfObject != null) {
            this.replaceNamedDestination(pdfObject, hashMap);
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfObject);
            PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIRST);
            if (pdfObject2 != null) {
                this.iterateBookmarks(pdfObject2, hashMap);
            }
            pdfObject = pdfDictionary.get(PdfName.NEXT);
        }
    }

    public void consolidateNamedDestinations() {
        if (this.consolidateNamedDestinations) {
            return;
        }
        this.consolidateNamedDestinations = true;
        HashMap hashMap = this.getNamedDestination();
        if (hashMap.isEmpty()) {
            return;
        }
        for (int i2 = 1; i2 <= this.pageRefs.size(); ++i2) {
            PdfDictionary pdfDictionary = this.pageRefs.getPageN(i2);
            PdfObject pdfObject = pdfDictionary.get(PdfName.ANNOTS);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfObject);
            int n2 = this.lastXrefPartial;
            this.releaseLastXrefPartial();
            if (pdfArray == null) {
                this.pageRefs.releasePage(i2);
                continue;
            }
            ArrayList arrayList = pdfArray.getArrayList();
            boolean bl = false;
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                PdfObject pdfObject2 = (PdfObject)arrayList.get(i3);
                if (!this.replaceNamedDestination(pdfObject2, hashMap) || pdfObject2.isIndirect()) continue;
                bl = true;
            }
            if (bl) {
                this.setXrefPartialObject(n2, pdfArray);
            }
            if (bl && !pdfObject.isIndirect()) continue;
            this.pageRefs.releasePage(i2);
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.OUTLINES));
        if (pdfDictionary == null) {
            return;
        }
        this.iterateBookmarks(pdfDictionary.get(PdfName.FIRST), hashMap);
    }

    protected static PdfDictionary duplicatePdfDictionary(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2, PdfReader pdfReader) {
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            pdfDictionary2.put(pdfName, PdfReader.duplicatePdfObject(pdfDictionary.get(pdfName), pdfReader));
        }
        return pdfDictionary2;
    }

    protected static PdfObject duplicatePdfObject(PdfObject pdfObject, PdfReader pdfReader) {
        if (pdfObject == null) {
            return null;
        }
        switch (pdfObject.type()) {
            case 6: {
                return PdfReader.duplicatePdfDictionary((PdfDictionary)pdfObject, null, pdfReader);
            }
            case 7: {
                PRStream pRStream = (PRStream)pdfObject;
                PRStream pRStream2 = new PRStream(pRStream, null, pdfReader);
                PdfReader.duplicatePdfDictionary(pRStream, pRStream2, pdfReader);
                return pRStream2;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                PdfArray pdfArray = new PdfArray();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    pdfArray.add(PdfReader.duplicatePdfObject((PdfObject)iterator.next(), pdfReader));
                }
                return pdfArray;
            }
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                return new PRIndirectReference(pdfReader, pRIndirectReference.getNumber(), pRIndirectReference.getGeneration());
            }
        }
        return pdfObject;
    }

    public void close() {
        if (!this.partial) {
            return;
        }
        try {
            this.tokens.close();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected void removeUnusedNode(PdfObject pdfObject, boolean[] blArray) {
        Stack<Object> stack = new Stack<Object>();
        stack.push(pdfObject);
        block5: while (!stack.empty()) {
            Object[] objectArray;
            PdfName[] pdfNameArray;
            PdfDictionary pdfDictionary;
            ArrayList arrayList;
            block18: {
                int n2;
                Object e2;
                block17: {
                    e2 = stack.pop();
                    if (e2 == null) continue;
                    arrayList = null;
                    pdfDictionary = null;
                    pdfNameArray = null;
                    objectArray = null;
                    n2 = 0;
                    if (!(e2 instanceof PdfObject)) break block17;
                    pdfObject = (PdfObject)e2;
                    switch (pdfObject.type()) {
                        case 6: 
                        case 7: {
                            pdfDictionary = (PdfDictionary)pdfObject;
                            pdfNameArray = new PdfName[pdfDictionary.size()];
                            pdfDictionary.getKeys().toArray(pdfNameArray);
                            break block18;
                        }
                        case 5: {
                            arrayList = ((PdfArray)pdfObject).getArrayList();
                            break block18;
                        }
                        case 10: {
                            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                            int n3 = pRIndirectReference.getNumber();
                            if (blArray[n3]) continue block5;
                            blArray[n3] = true;
                            stack.push(PdfReader.getPdfObjectRelease(pRIndirectReference));
                            break;
                        }
                    }
                    continue;
                }
                objectArray = (Object[])e2;
                if (objectArray[0] instanceof ArrayList) {
                    arrayList = (ArrayList)objectArray[0];
                    n2 = (Integer)objectArray[1];
                } else {
                    pdfNameArray = (PdfName[])objectArray[0];
                    pdfDictionary = (PdfDictionary)objectArray[1];
                    n2 = (Integer)objectArray[2];
                }
            }
            if (arrayList != null) {
                for (int i2 = n2; i2 < arrayList.size(); ++i2) {
                    int n4;
                    PdfObject pdfObject2 = (PdfObject)arrayList.get(i2);
                    if (!pdfObject2.isIndirect() || (n4 = ((PRIndirectReference)pdfObject2).getNumber()) < this.xrefObj.size() && (this.partial || this.xrefObj.get(n4) != null)) {
                        if (objectArray == null) {
                            stack.push(new Object[]{arrayList, new Integer(i2 + 1)});
                        } else {
                            objectArray[1] = new Integer(i2 + 1);
                            stack.push(objectArray);
                        }
                        stack.push(pdfObject2);
                        continue block5;
                    }
                    arrayList.set(i2, PdfNull.PDFNULL);
                }
                continue;
            }
            for (int i3 = n2; i3 < pdfNameArray.length; ++i3) {
                int n5;
                PdfName pdfName = pdfNameArray[i3];
                PdfObject pdfObject3 = pdfDictionary.get(pdfName);
                if (!pdfObject3.isIndirect() || (n5 = ((PRIndirectReference)pdfObject3).getNumber()) < this.xrefObj.size() && (this.partial || this.xrefObj.get(n5) != null)) {
                    if (objectArray == null) {
                        stack.push(new Object[]{pdfNameArray, pdfDictionary, new Integer(i3 + 1)});
                    } else {
                        objectArray[2] = new Integer(i3 + 1);
                        stack.push(objectArray);
                    }
                    stack.push(pdfObject3);
                    continue block5;
                }
                pdfDictionary.put(pdfName, PdfNull.PDFNULL);
            }
        }
    }

    public int removeUnusedObjects() {
        boolean[] blArray = new boolean[this.xrefObj.size()];
        this.removeUnusedNode(this.trailer, blArray);
        int n2 = 0;
        if (this.partial) {
            for (int i2 = 1; i2 < blArray.length; ++i2) {
                if (blArray[i2]) continue;
                this.xref[i2 * 2] = -1;
                this.xref[i2 * 2 + 1] = 0;
                this.xrefObj.set(i2, null);
                ++n2;
            }
        } else {
            for (int i3 = 1; i3 < blArray.length; ++i3) {
                if (blArray[i3]) continue;
                this.xrefObj.set(i3, null);
                ++n2;
            }
        }
        return n2;
    }

    public AcroFields getAcroFields() {
        return new AcroFields(this, null);
    }

    public String getJavaScript(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.NAMES));
        if (pdfDictionary == null) {
            return null;
        }
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.JAVASCRIPT));
        if (pdfDictionary2 == null) {
            return null;
        }
        HashMap hashMap = PdfNameTree.readTree(pdfDictionary2);
        Object[] objectArray = new String[hashMap.size()];
        objectArray = hashMap.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            PdfObject pdfObject;
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfIndirectReference)hashMap.get(objectArray[i2]));
            if (pdfDictionary3 == null || (pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary3.get(PdfName.JS))) == null) continue;
            if (pdfObject.isString()) {
                stringBuffer.append(((PdfString)pdfObject).toUnicodeString()).append('\n');
                continue;
            }
            if (!pdfObject.isStream()) continue;
            byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
            if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
                stringBuffer.append(PdfEncodings.convertToString(byArray, "UnicodeBig"));
            } else {
                stringBuffer.append(PdfEncodings.convertToString(byArray, "PDF"));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaScript() throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            String string = this.getJavaScript(randomAccessFileOrArray);
            return string;
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    public void selectPages(String string) {
        this.selectPages(SequenceList.expand(string, this.getNumberOfPages()));
    }

    public void selectPages(List list) {
        this.pageRefs.selectPages(list);
        this.removeUnusedObjects();
    }

    public void setViewerPreferences(int n2) {
        this.viewerPreferences.setViewerPreferences(n2);
        this.setViewerPreferences(this.viewerPreferences);
    }

    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.viewerPreferences.addViewerPreference(pdfName, pdfObject);
        this.setViewerPreferences(this.viewerPreferences);
    }

    void setViewerPreferences(PdfViewerPreferencesImp pdfViewerPreferencesImp) {
        pdfViewerPreferencesImp.addToCatalog(this.catalog);
    }

    public int getSimpleViewerPreferences() {
        return PdfViewerPreferencesImp.getViewerPreferences(this.catalog).getPageLayoutAndMode();
    }

    public boolean isAppendable() {
        return this.appendable;
    }

    public void setAppendable(boolean bl) {
        this.appendable = bl;
        if (bl) {
            PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        }
    }

    public boolean isNewXrefType() {
        return this.newXrefType;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public boolean isHybridXref() {
        return this.hybridXref;
    }

    PdfIndirectReference getCryptoRef() {
        if (this.cryptoRef == null) {
            return null;
        }
        return new PdfIndirectReference(0, this.cryptoRef.getNumber(), this.cryptoRef.getGeneration());
    }

    public void removeUsageRights() {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PERMS));
        if (pdfDictionary == null) {
            return;
        }
        pdfDictionary.remove(PdfName.UR);
        pdfDictionary.remove(PdfName.UR3);
        if (pdfDictionary.size() == 0) {
            this.catalog.remove(PdfName.PERMS);
        }
    }

    public int getCertificationLevel() {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PERMS));
        if (pdfDictionary == null) {
            return 0;
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DOCMDP))) == null) {
            return 0;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.REFERENCE));
        if (pdfArray == null || pdfArray.size() == 0) {
            return 0;
        }
        pdfDictionary = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pdfArray.getArrayList().get(0));
        if (pdfDictionary == null) {
            return 0;
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.TRANSFORMPARAMS))) == null) {
            return 0;
        }
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.P));
        if (pdfNumber == null) {
            return 0;
        }
        return pdfNumber.intValue();
    }

    public final boolean isOpenedWithFullPermissions() {
        return !this.encrypted || this.ownerPasswordUsed;
    }

    public int getCryptoMode() {
        if (this.decrypt == null) {
            return -1;
        }
        return this.decrypt.getCryptoMode();
    }

    public boolean isMetadataEncrypted() {
        if (this.decrypt == null) {
            return false;
        }
        return this.decrypt.isMetadataEncrypted();
    }

    public byte[] computeUserPassword() {
        if (!this.encrypted || !this.ownerPasswordUsed) {
            return null;
        }
        return this.decrypt.computeUserPassword(this.password);
    }

    static class PageRefs {
        private PdfReader reader;
        private IntHashtable refsp;
        private ArrayList refsn;
        private ArrayList pageInh;
        private int lastPageRead = -1;
        private int sizep;
        private boolean keepPages;

        private PageRefs(PdfReader pdfReader) throws IOException {
            this.reader = pdfReader;
            if (pdfReader.partial) {
                this.refsp = new IntHashtable();
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObjectRelease(pdfReader.rootPages.get(PdfName.COUNT));
                this.sizep = pdfNumber.intValue();
            } else {
                this.readPages();
            }
        }

        PageRefs(PageRefs pageRefs, PdfReader pdfReader) {
            this.reader = pdfReader;
            this.sizep = pageRefs.sizep;
            if (pageRefs.refsn != null) {
                this.refsn = new ArrayList(pageRefs.refsn);
                for (int i2 = 0; i2 < this.refsn.size(); ++i2) {
                    this.refsn.set(i2, PdfReader.duplicatePdfObject((PdfObject)this.refsn.get(i2), pdfReader));
                }
            } else {
                this.refsp = (IntHashtable)pageRefs.refsp.clone();
            }
        }

        int size() {
            if (this.refsn != null) {
                return this.refsn.size();
            }
            return this.sizep;
        }

        void readPages() throws IOException {
            if (this.refsn != null) {
                return;
            }
            this.refsp = null;
            this.refsn = new ArrayList();
            this.pageInh = new ArrayList();
            this.iteratePages((PRIndirectReference)this.reader.catalog.get(PdfName.PAGES));
            this.pageInh = null;
            this.reader.rootPages.put(PdfName.COUNT, new PdfNumber(this.refsn.size()));
        }

        void reReadPages() throws IOException {
            this.refsn = null;
            this.readPages();
        }

        public PdfDictionary getPageN(int n2) {
            PRIndirectReference pRIndirectReference = this.getPageOrigRef(n2);
            return (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        }

        public PdfDictionary getPageNRelease(int n2) {
            PdfDictionary pdfDictionary = this.getPageN(n2);
            this.releasePage(n2);
            return pdfDictionary;
        }

        public PRIndirectReference getPageOrigRefRelease(int n2) {
            PRIndirectReference pRIndirectReference = this.getPageOrigRef(n2);
            this.releasePage(n2);
            return pRIndirectReference;
        }

        public PRIndirectReference getPageOrigRef(int n2) {
            try {
                if (--n2 < 0 || n2 >= this.size()) {
                    return null;
                }
                if (this.refsn != null) {
                    return (PRIndirectReference)this.refsn.get(n2);
                }
                int n3 = this.refsp.get(n2);
                if (n3 == 0) {
                    PRIndirectReference pRIndirectReference = this.getSinglePage(n2);
                    this.lastPageRead = this.reader.lastXrefPartial == -1 ? -1 : n2;
                    this.reader.lastXrefPartial = -1;
                    this.refsp.put(n2, pRIndirectReference.getNumber());
                    if (this.keepPages) {
                        this.lastPageRead = -1;
                    }
                    return pRIndirectReference;
                }
                if (this.lastPageRead != n2) {
                    this.lastPageRead = -1;
                }
                if (this.keepPages) {
                    this.lastPageRead = -1;
                }
                return new PRIndirectReference(this.reader, n3);
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }

        void keepPages() {
            if (this.refsp == null || this.keepPages) {
                return;
            }
            this.keepPages = true;
            this.refsp.clear();
        }

        public void releasePage(int n2) {
            if (this.refsp == null) {
                return;
            }
            if (--n2 < 0 || n2 >= this.size()) {
                return;
            }
            if (n2 != this.lastPageRead) {
                return;
            }
            this.lastPageRead = -1;
            this.reader.lastXrefPartial = this.refsp.get(n2);
            this.reader.releaseLastXrefPartial();
            this.refsp.remove(n2);
        }

        public void resetReleasePage() {
            if (this.refsp == null) {
                return;
            }
            this.lastPageRead = -1;
        }

        void insertPage(int n2, PRIndirectReference pRIndirectReference) {
            --n2;
            if (this.refsn != null) {
                if (n2 >= this.refsn.size()) {
                    this.refsn.add(pRIndirectReference);
                } else {
                    this.refsn.add(n2, pRIndirectReference);
                }
            } else {
                ++this.sizep;
                this.lastPageRead = -1;
                if (n2 >= this.size()) {
                    this.refsp.put(this.size(), pRIndirectReference.getNumber());
                } else {
                    IntHashtable intHashtable = new IntHashtable((this.refsp.size() + 1) * 2);
                    Iterator iterator = this.refsp.getEntryIterator();
                    while (iterator.hasNext()) {
                        IntHashtable.Entry entry = (IntHashtable.Entry)iterator.next();
                        int n3 = entry.getKey();
                        intHashtable.put(n3 >= n2 ? n3 + 1 : n3, entry.getValue());
                    }
                    intHashtable.put(n2, pRIndirectReference.getNumber());
                    this.refsp = intHashtable;
                }
            }
        }

        private void pushPageAttributes(PdfDictionary pdfDictionary) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            if (!this.pageInh.isEmpty()) {
                pdfDictionary2.putAll((PdfDictionary)this.pageInh.get(this.pageInh.size() - 1));
            }
            for (int i2 = 0; i2 < pageInhCandidates.length; ++i2) {
                PdfObject pdfObject = pdfDictionary.get(pageInhCandidates[i2]);
                if (pdfObject == null) continue;
                pdfDictionary2.put(pageInhCandidates[i2], pdfObject);
            }
            this.pageInh.add(pdfDictionary2);
        }

        private void popPageAttributes() {
            this.pageInh.remove(this.pageInh.size() - 1);
        }

        private void iteratePages(PRIndirectReference pRIndirectReference) throws IOException {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) {
                pdfDictionary.put(PdfName.TYPE, PdfName.PAGE);
                PdfDictionary pdfDictionary2 = (PdfDictionary)this.pageInh.get(this.pageInh.size() - 1);
                Object object = pdfDictionary2.getKeys().iterator();
                while (object.hasNext()) {
                    PdfName pdfName = (PdfName)object.next();
                    if (pdfDictionary.get(pdfName) != null) continue;
                    pdfDictionary.put(pdfName, pdfDictionary2.get(pdfName));
                }
                if (pdfDictionary.get(PdfName.MEDIABOX) == null) {
                    object = new PdfArray(new float[]{0.0f, 0.0f, PageSize.LETTER.getRight(), PageSize.LETTER.getTop()});
                    pdfDictionary.put(PdfName.MEDIABOX, (PdfObject)object);
                }
                this.refsn.add(pRIndirectReference);
            } else {
                pdfDictionary.put(PdfName.TYPE, PdfName.PAGES);
                this.pushPageAttributes(pdfDictionary);
                ArrayList arrayList = pdfArray.getArrayList();
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    PdfObject pdfObject = (PdfObject)arrayList.get(i2);
                    if (!pdfObject.isIndirect()) {
                        while (i2 < arrayList.size()) {
                            arrayList.remove(i2);
                        }
                        break;
                    }
                    this.iteratePages((PRIndirectReference)pdfObject);
                }
                this.popPageAttributes();
            }
        }

        /*
         * Unable to fully structure code
         */
        protected PRIndirectReference getSinglePage(int var1_1) {
            var2_2 = new PdfDictionary();
            var3_3 = this.reader.rootPages;
            var4_4 = 0;
            while (true) lbl-1000:
            // 5 sources

            {
                for (var5_6 = 0; var5_6 < PdfReader.pageInhCandidates.length; ++var5_6) {
                    var6_7 = var3_3.get(PdfReader.pageInhCandidates[var5_6]);
                    if (var6_7 == null) continue;
                    var2_2.put(PdfReader.pageInhCandidates[var5_6], (PdfObject)var6_7);
                }
                var5_5 = (PdfArray)PdfReader.getPdfObjectRelease(var3_3.get(PdfName.KIDS));
                var6_7 = var5_5.listIterator();
                while (true) {
                    if (!var6_7.hasNext()) ** continue;
                    var7_8 = (PRIndirectReference)var6_7.next();
                    var8_9 = (PdfDictionary)PdfReader.getPdfObject(var7_8);
                    var9_10 = PdfReader.access$300(this.reader);
                    var10_11 = PdfReader.getPdfObjectRelease(var8_9.get(PdfName.COUNT));
                    PdfReader.access$302(this.reader, var9_10);
                    var11_12 = 1;
                    if (var10_11 != null && var10_11.type() == 2) {
                        var11_12 = ((PdfNumber)var10_11).intValue();
                    }
                    if (var1_1 < var4_4 + var11_12) {
                        if (var10_11 == null) {
                            var8_9.mergeDifferent(var2_2);
                            return var7_8;
                        }
                        this.reader.releaseLastXrefPartial();
                        var3_3 = var8_9;
                        ** continue;
                    }
                    this.reader.releaseLastXrefPartial();
                    var4_4 += var11_12;
                }
                break;
            }
        }

        private void selectPages(List list) {
            int n2;
            Object object;
            IntHashtable intHashtable = new IntHashtable();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n3 = this.size();
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                object = (Integer)object2.next();
                int n4 = (Integer)object;
                if (n4 < 1 || n4 > n3 || intHashtable.put(n4, 1) != 0) continue;
                arrayList.add(object);
            }
            if (this.reader.partial) {
                for (int i2 = 1; i2 <= n3; ++i2) {
                    this.getPageOrigRef(i2);
                    this.resetReleasePage();
                }
            }
            object2 = (PRIndirectReference)this.reader.catalog.get(PdfName.PAGES);
            object = (PdfDictionary)PdfReader.getPdfObject((PdfObject)object2);
            ArrayList<PRIndirectReference> arrayList2 = new ArrayList<PRIndirectReference>(arrayList.size());
            PdfArray pdfArray = new PdfArray();
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                n2 = (Integer)arrayList.get(i3);
                PRIndirectReference pRIndirectReference = this.getPageOrigRef(n2);
                this.resetReleasePage();
                pdfArray.add(pRIndirectReference);
                arrayList2.add(pRIndirectReference);
                this.getPageN(n2).put(PdfName.PARENT, (PdfObject)object2);
            }
            AcroFields acroFields = this.reader.getAcroFields();
            n2 = acroFields.getFields().size() > 0 ? 1 : 0;
            for (int i4 = 1; i4 <= n3; ++i4) {
                if (intHashtable.containsKey(i4)) continue;
                if (n2 != 0) {
                    acroFields.removeFieldsFromPage(i4);
                }
                PRIndirectReference pRIndirectReference = this.getPageOrigRef(i4);
                int n5 = pRIndirectReference.getNumber();
                this.reader.xrefObj.set(n5, null);
                if (!this.reader.partial) continue;
                this.reader.xref[n5 * 2] = -1;
                this.reader.xref[n5 * 2 + 1] = 0;
            }
            ((PdfDictionary)object).put(PdfName.COUNT, new PdfNumber(arrayList.size()));
            ((PdfDictionary)object).put(PdfName.KIDS, pdfArray);
            this.refsp = null;
            this.refsn = arrayList2;
        }
    }
}

