/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import java.awt.Color;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] canvasesPos;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (pdfPRow.cells[i2] == null) continue;
            this.cells[i2] = new PdfPCell(pdfPRow.cells[i2]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f2 = 0.0f;
        this.calculated = false;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            PdfPCell pdfPCell = this.cells[i2];
            pdfPCell.setLeft(f2);
            int n2 = i2 + pdfPCell.getColspan();
            while (i2 < n2) {
                f2 += fArray[i2];
                ++i2;
            }
            --i2;
            pdfPCell.setRight(f2);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            float f2;
            float f3;
            PdfPCell pdfPCell = this.cells[i2];
            if (pdfPCell == null) continue;
            Image image = pdfPCell.getImage();
            if (image != null) {
                image.scalePercent(100.0f);
                f3 = image.getScaledWidth();
                if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                    f3 = image.getScaledHeight();
                }
                f2 = (pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.getLeft()) / f3;
                image.scalePercent(f2 * 100.0f);
                float f4 = image.getScaledHeight();
                if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                    f4 = image.getScaledWidth();
                }
                pdfPCell.setBottom(pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom() - f4);
            } else if (pdfPCell.getRotation() == 0 || pdfPCell.getRotation() == 180) {
                f3 = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight();
                f2 = pdfPCell.getFixedHeight() > 0.0f ? pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop() + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getFixedHeight() : -1.0737418E9f;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                this.setColumn(columnText, pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft(), f2, f3, pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop());
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f5 = columnText.getYLine();
                if (pdfPCell.isUseDescender()) {
                    f5 += columnText.getDescender();
                }
                pdfPCell.setBottom(f5 - pdfPCell.getEffectivePaddingBottom());
            } else if (pdfPCell.getFixedHeight() > 0.0f) {
                pdfPCell.setBottom(pdfPCell.getTop() - pdfPCell.getFixedHeight());
            } else {
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                this.setColumn(columnText, 0.0f, pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft(), 20000.0f, pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight());
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                pdfPCell.setBottom(pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom() - columnText.getFilledWidth());
            }
            f3 = pdfPCell.getFixedHeight();
            if (f3 <= 0.0f) {
                f3 = pdfPCell.getHeight();
            }
            if (f3 < pdfPCell.getFixedHeight()) {
                f3 = pdfPCell.getFixedHeight();
            } else if (f3 < pdfPCell.getMinimumHeight()) {
                f3 = pdfPCell.getMinimumHeight();
            }
            if (!(f3 > this.maxHeight)) continue;
            this.maxHeight = f3;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float f2, float f3, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[2];
        PdfContentByte pdfContentByte2 = pdfContentByteArray[1];
        float f4 = pdfPCell.getLeft() + f2;
        float f5 = pdfPCell.getTop() + f3;
        float f6 = pdfPCell.getRight() + f2;
        float f7 = f5 - this.maxHeight;
        Color color = pdfPCell.getBackgroundColor();
        if (color != null) {
            pdfContentByte2.setColorFill(color);
            pdfContentByte2.rectangle(f4, f7, f6 - f4, f5 - f7);
            pdfContentByte2.fill();
        }
        if (pdfPCell.hasBorders()) {
            if (pdfPCell.isUseVariableBorders()) {
                Rectangle rectangle = new Rectangle(pdfPCell.getLeft() + f2, pdfPCell.getTop() - this.maxHeight + f3, pdfPCell.getRight() + f2, pdfPCell.getTop() + f3);
                rectangle.cloneNonPositionParameters(pdfPCell);
                rectangle.setBackgroundColor(null);
                pdfContentByte.rectangle(rectangle);
            } else {
                Color color2;
                if (pdfPCell.getBorderWidth() != -1.0f) {
                    pdfContentByte.setLineWidth(pdfPCell.getBorderWidth());
                }
                if ((color2 = pdfPCell.getBorderColor()) != null) {
                    pdfContentByte.setColorStroke(color2);
                }
                if (pdfPCell.hasBorder(15)) {
                    pdfContentByte.rectangle(f4, f7, f6 - f4, f5 - f7);
                } else {
                    if (pdfPCell.hasBorder(8)) {
                        pdfContentByte.moveTo(f6, f7);
                        pdfContentByte.lineTo(f6, f5);
                    }
                    if (pdfPCell.hasBorder(4)) {
                        pdfContentByte.moveTo(f4, f7);
                        pdfContentByte.lineTo(f4, f5);
                    }
                    if (pdfPCell.hasBorder(2)) {
                        pdfContentByte.moveTo(f4, f7);
                        pdfContentByte.lineTo(f6, f7);
                    }
                    if (pdfPCell.hasBorder(1)) {
                        pdfContentByte.moveTo(f4, f5);
                        pdfContentByte.lineTo(f6, f5);
                    }
                }
                pdfContentByte.stroke();
                if (color2 != null) {
                    pdfContentByte.resetRGBColorStroke();
                }
            }
        }
    }

    private void saveAndRotateCanvases(PdfContentByte[] pdfContentByteArray, float f2, float f3, float f4, float f5, float f6, float f7) {
        int n2 = 4;
        if (this.canvasesPos == null) {
            this.canvasesPos = new int[n2 * 2];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteBuffer byteBuffer = pdfContentByteArray[i2].getInternalBuffer();
            this.canvasesPos[i2 * 2] = byteBuffer.size();
            pdfContentByteArray[i2].saveState();
            pdfContentByteArray[i2].concatCTM(f2, f3, f4, f5, f6, f7);
            this.canvasesPos[i2 * 2 + 1] = byteBuffer.size();
        }
    }

    private void restoreCanvases(PdfContentByte[] pdfContentByteArray) {
        int n2 = 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteBuffer byteBuffer = pdfContentByteArray[i2].getInternalBuffer();
            int n3 = byteBuffer.size();
            pdfContentByteArray[i2].restoreState();
            if (n3 != this.canvasesPos[i2 * 2 + 1]) continue;
            byteBuffer.setSize(this.canvasesPos[i2 * 2]);
        }
    }

    private float setColumn(ColumnText columnText, float f2, float f3, float f4, float f5) {
        if (f2 > f4) {
            f4 = f2;
        }
        if (f3 > f5) {
            f5 = f3;
        }
        columnText.setSimpleColumn(f2, f3, f4, f5);
        return f5;
    }

    public void writeCells(int n2, int n3, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        int n4;
        if (!this.calculated) {
            this.calculateHeights();
        }
        if (n3 < 0) {
            n3 = this.cells.length;
        }
        n3 = Math.min(n3, this.cells.length);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= n3) {
            return;
        }
        for (n4 = n2; n4 >= 0 && this.cells[n4] == null; --n4) {
            f2 -= this.widths[n4 - 1];
        }
        f2 -= this.cells[n4].getLeft();
        for (int i2 = n4; i2 < n3; ++i2) {
            float f4;
            float f5;
            float f6;
            PdfPCell pdfPCell = this.cells[i2];
            if (pdfPCell == null) continue;
            this.writeBorderAndBackground(f2, f3, pdfPCell, pdfContentByteArray);
            Image image = pdfPCell.getImage();
            float f7 = 0.0f;
            switch (pdfPCell.getVerticalAlignment()) {
                case 6: {
                    f7 = pdfPCell.getTop() + f3 - this.maxHeight + pdfPCell.getHeight() - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                case 5: {
                    f7 = pdfPCell.getTop() + f3 + (pdfPCell.getHeight() - this.maxHeight) / 2.0f - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                default: {
                    f7 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                }
            }
            if (image != null) {
                if (pdfPCell.getRotation() != 0) {
                    image = Image.getInstance(image);
                    image.setRotation(image.getImageRotation() + (float)((double)pdfPCell.getRotation() * Math.PI / 180.0));
                }
                boolean bl = false;
                if (pdfPCell.getHeight() > this.maxHeight) {
                    image.scalePercent(100.0f);
                    f6 = (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom()) / image.getScaledHeight();
                    image.scalePercent(f6 * 100.0f);
                    bl = true;
                }
                f6 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                if (bl) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f6 = f2 + (pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft() + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            f6 = f2 + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth();
                            break;
                        }
                    }
                    f7 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                }
                image.setAbsolutePosition(f6, f7 - image.getScaledHeight());
                try {
                    pdfContentByteArray[3].addImage(image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                float f8 = this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom();
                f6 = pdfPCell.getWidth() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight();
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                columnText.setSimpleColumn(0.0f, 0.0f, f8 + 0.001f, -f6);
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f9 = -columnText.getYLine();
                if (f8 <= 0.0f || f6 <= 0.0f) {
                    f9 = 0.0f;
                }
                if (f9 > 0.0f) {
                    if (pdfPCell.isUseDescender()) {
                        f9 -= columnText.getDescender();
                    }
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                    columnText.setCanvases(pdfContentByteArray);
                    columnText.setSimpleColumn(0.0f, -0.001f, f8 + 0.001f, f9);
                    if (pdfPCell.getRotation() == 90) {
                        f5 = pdfPCell.getTop() + f3 - this.maxHeight + pdfPCell.getEffectivePaddingBottom();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight();
                                break;
                            }
                            case 5: {
                                f4 = pdfPCell.getLeft() + f2 + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() + f9) / 2.0f;
                                break;
                            }
                            default: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft() + f9;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, 1.0f, -1.0f, 0.0f, f4, f5);
                    } else {
                        f5 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                                break;
                            }
                            case 5: {
                                f4 = pdfPCell.getLeft() + f2 + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() - f9) / 2.0f;
                                break;
                            }
                            default: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight() - f9;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, -1.0f, 1.0f, 0.0f, f4, f5);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        this.restoreCanvases(pdfContentByteArray);
                    }
                }
            } else {
                float f10 = pdfPCell.getFixedHeight();
                f6 = pdfPCell.getRight() + f2 - pdfPCell.getEffectivePaddingRight();
                float f11 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                if (pdfPCell.isNoWrap()) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f6 += 10000.0f;
                            f11 -= 10000.0f;
                            break;
                        }
                        case 2: {
                            f11 -= 20000.0f;
                            break;
                        }
                        default: {
                            f6 += 20000.0f;
                        }
                    }
                }
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                f4 = f7 - (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom());
                if (f10 > 0.0f && pdfPCell.getHeight() > this.maxHeight) {
                    f7 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                    f4 = pdfPCell.getTop() + f3 - this.maxHeight + pdfPCell.getEffectivePaddingBottom();
                }
                if (f7 > f4 && f11 < f6) {
                    columnText.setSimpleColumn(f11, f4 - 0.001f, f6, f7);
                    if (pdfPCell.getRotation() == 180) {
                        f5 = f11 + f6;
                        float f12 = f3 + f3 - this.maxHeight + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getEffectivePaddingTop();
                        this.saveAndRotateCanvases(pdfContentByteArray, -1.0f, 0.0f, 0.0f, -1.0f, f5, f12);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        if (pdfPCell.getRotation() == 180) {
                            this.restoreCanvases(pdfContentByteArray);
                        }
                    }
                }
            }
            PdfPCellEvent pdfPCellEvent = pdfPCell.getCellEvent();
            if (pdfPCellEvent == null) continue;
            Rectangle rectangle = new Rectangle(pdfPCell.getLeft() + f2, pdfPCell.getTop() + f3 - this.maxHeight, pdfPCell.getRight() + f2, pdfPCell.getTop() + f3);
            pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f2) {
        this.maxHeight = f2;
    }

    float[] getEventWidth(float f2) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.cells[i2] == null) continue;
            ++n2;
        }
        float[] fArray = new float[n2 + 1];
        n2 = 0;
        fArray[n2++] = f2;
        for (int i3 = 0; i3 < this.cells.length; ++i3) {
            if (this.cells[i3] == null) continue;
            fArray[n2] = fArray[n2 - 1] + this.cells[i3].getWidth();
            ++n2;
        }
        return fArray;
    }

    public PdfPRow splitRow(float f2) {
        PdfPCell pdfPCell;
        int n2;
        PdfPCell[] pdfPCellArray = new PdfPCell[this.cells.length];
        float[] fArray = new float[this.cells.length * 2];
        boolean bl = true;
        for (n2 = 0; n2 < this.cells.length; ++n2) {
            pdfPCell = this.cells[n2];
            if (pdfPCell == null) continue;
            fArray[n2 * 2] = pdfPCell.getFixedHeight();
            fArray[n2 * 2 + 1] = pdfPCell.getMinimumHeight();
            Image image = pdfPCell.getImage();
            PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
            if (image != null) {
                if (f2 > pdfPCell.getEffectivePaddingBottom() + pdfPCell.getEffectivePaddingTop() + 2.0f) {
                    pdfPCell2.setPhrase(null);
                    bl = false;
                }
            } else {
                boolean bl2;
                int n3;
                float f3;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                    f3 = this.setColumn(columnText, pdfPCell.getTop() - f2 + pdfPCell.getEffectivePaddingBottom(), pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft(), pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop(), pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight());
                } else {
                    float f4 = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight();
                    float f5 = pdfPCell.getTop() - f2 + pdfPCell.getEffectivePaddingBottom();
                    float f6 = pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop();
                    f3 = this.setColumn(columnText, pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft(), f5, f4, f6);
                }
                try {
                    n3 = columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                boolean bl3 = bl2 = columnText.getYLine() == f3;
                if (bl2) {
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                }
                boolean bl4 = bl = bl && bl2;
                if ((n3 & 1) == 0 || bl2) {
                    pdfPCell2.setColumn(columnText);
                    columnText.setFilledWidth(0.0f);
                } else {
                    pdfPCell2.setPhrase(null);
                }
            }
            pdfPCellArray[n2] = pdfPCell2;
            pdfPCell.setFixedHeight(f2);
        }
        if (bl) {
            for (n2 = 0; n2 < this.cells.length; ++n2) {
                pdfPCell = this.cells[n2];
                if (pdfPCell == null) continue;
                float f7 = fArray[n2 * 2];
                float f8 = fArray[n2 * 2 + 1];
                if (f7 <= 0.0f) {
                    pdfPCell.setMinimumHeight(f8);
                    continue;
                }
                pdfPCell.setFixedHeight(f7);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow pdfPRow = new PdfPRow(pdfPCellArray);
        pdfPRow.widths = (float[])this.widths.clone();
        pdfPRow.calculateHeights();
        return pdfPRow;
    }
}

