/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNumberTree {
    private static final int leafSize = 64;

    public static PdfDictionary writeTree(HashMap hashMap, PdfWriter pdfWriter) throws IOException {
        int n2;
        int n3;
        int n4;
        if (hashMap.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Integer[hashMap.size()];
        objectArray = hashMap.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        if (objectArray.length <= 64) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                pdfArray.add(new PdfNumber((Integer)objectArray[i2]));
                pdfArray.add((PdfObject)hashMap.get(objectArray[i2]));
            }
            pdfDictionary.put(PdfName.NUMS, pdfArray);
            return pdfDictionary;
        }
        int n5 = 64;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[(objectArray.length + 64 - 1) / 64];
        for (n4 = 0; n4 < pdfIndirectReferenceArray.length; ++n4) {
            n2 = Math.min(n3 + 64, objectArray.length);
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            pdfArray.add(new PdfNumber((Integer)objectArray[n3]));
            pdfArray.add(new PdfNumber((Integer)objectArray[n2 - 1]));
            pdfDictionary.put(PdfName.LIMITS, pdfArray);
            pdfArray = new PdfArray();
            for (n3 = n4 * 64; n3 < n2; ++n3) {
                pdfArray.add(new PdfNumber((Integer)objectArray[n3]));
                pdfArray.add((PdfObject)hashMap.get(objectArray[n3]));
            }
            pdfDictionary.put(PdfName.NUMS, pdfArray);
            pdfIndirectReferenceArray[n4] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
        }
        n4 = pdfIndirectReferenceArray.length;
        while (true) {
            if (n4 <= 64) {
                PdfArray pdfArray = new PdfArray();
                for (n2 = 0; n2 < n4; ++n2) {
                    pdfArray.add(pdfIndirectReferenceArray[n2]);
                }
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                return pdfDictionary;
            }
            n3 = (objectArray.length + (n5 *= 64) - 1) / n5;
            for (n2 = 0; n2 < n3; ++n2) {
                int n6;
                int n7 = Math.min(n6 + 64, n4);
                PdfDictionary pdfDictionary = new PdfDictionary();
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfNumber((Integer)objectArray[n2 * n5]));
                pdfArray.add(new PdfNumber((Integer)objectArray[Math.min((n2 + 1) * n5, objectArray.length) - 1]));
                pdfDictionary.put(PdfName.LIMITS, pdfArray);
                pdfArray = new PdfArray();
                for (n6 = n2 * 64; n6 < n7; ++n6) {
                    pdfArray.add(pdfIndirectReferenceArray[n6]);
                }
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                pdfIndirectReferenceArray[n2] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
            }
            n4 = n3;
        }
    }

    private static void iterateItems(PdfDictionary pdfDictionary, HashMap hashMap) {
        block3: {
            PdfArray pdfArray;
            block2: {
                pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.NUMS));
                if (pdfArray == null) break block2;
                ArrayList arrayList = pdfArray.getArrayList();
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(i2++));
                    hashMap.put(new Integer(pdfNumber.intValue()), arrayList.get(i2));
                }
                break block3;
            }
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) break block3;
            ArrayList arrayList = pdfArray.getArrayList();
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(i3));
                PdfNumberTree.iterateItems(pdfDictionary2, hashMap);
            }
        }
    }

    public static HashMap readTree(PdfDictionary pdfDictionary) {
        HashMap hashMap = new HashMap();
        if (pdfDictionary != null) {
            PdfNumberTree.iterateItems(pdfDictionary, hashMap);
        }
        return hashMap;
    }
}

