/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.ListItem;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfFont;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfLine {
    protected ArrayList line;
    protected float left;
    protected float width;
    protected int alignment;
    protected float height;
    protected Chunk listSymbol = null;
    protected float symbolIndent;
    protected boolean newlineSplit = false;
    protected float originalWidth;
    protected boolean isRTL = false;

    PdfLine(float f2, float f3, int n2, float f4) {
        this.left = f2;
        this.originalWidth = this.width = f3 - f2;
        this.alignment = n2;
        this.height = f4;
        this.line = new ArrayList();
    }

    PdfLine(float f2, float f3, int n2, boolean bl, ArrayList arrayList, boolean bl2) {
        this.left = f2;
        this.width = f3;
        this.alignment = n2;
        this.line = arrayList;
        this.newlineSplit = bl;
        this.isRTL = bl2;
    }

    PdfChunk add(PdfChunk pdfChunk) {
        if (pdfChunk == null || pdfChunk.toString().equals("")) {
            return null;
        }
        PdfChunk pdfChunk2 = pdfChunk.split(this.width);
        boolean bl = this.newlineSplit = pdfChunk.isNewlineSplit() || pdfChunk2 == null;
        if (pdfChunk.length() > 0) {
            if (pdfChunk2 != null) {
                pdfChunk.trimLastSpace();
            }
            this.width -= pdfChunk.width();
            this.addToLine(pdfChunk);
        } else {
            if (this.line.size() < 1) {
                pdfChunk = pdfChunk2;
                pdfChunk2 = pdfChunk.truncate(this.width);
                this.width -= pdfChunk.width();
                if (pdfChunk.length() > 0) {
                    this.addToLine(pdfChunk);
                    return pdfChunk2;
                }
                if (pdfChunk2 != null) {
                    this.addToLine(pdfChunk2);
                }
                return null;
            }
            this.width += ((PdfChunk)this.line.get(this.line.size() - 1)).trimLastSpace();
        }
        return pdfChunk2;
    }

    private void addToLine(PdfChunk pdfChunk) {
        float f2;
        if (pdfChunk.changeLeading && pdfChunk.isImage() && (f2 = pdfChunk.getImage().getScaledHeight() + pdfChunk.getImageOffsetY()) > this.height) {
            this.height = f2;
        }
        this.line.add(pdfChunk);
    }

    public int size() {
        return this.line.size();
    }

    public Iterator iterator() {
        return this.line.iterator();
    }

    float height() {
        return this.height;
    }

    float indentLeft() {
        if (this.isRTL) {
            switch (this.alignment) {
                case 0: {
                    return this.left + this.width;
                }
                case 1: {
                    return this.left + this.width / 2.0f;
                }
            }
            return this.left;
        }
        switch (this.alignment) {
            case 2: {
                return this.left + this.width;
            }
            case 1: {
                return this.left + this.width / 2.0f;
            }
        }
        return this.left;
    }

    public boolean hasToBeJustified() {
        return (this.alignment == 3 || this.alignment == 8) && this.width != 0.0f;
    }

    public void resetAlignment() {
        if (this.alignment == 3) {
            this.alignment = 0;
        }
    }

    void setExtraIndent(float f2) {
        this.left += f2;
        this.width -= f2;
    }

    float widthLeft() {
        return this.width;
    }

    int numberOfSpaces() {
        String string = this.toString();
        int n2 = string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) != ' ') continue;
            ++n3;
        }
        return n3;
    }

    public void setListItem(ListItem listItem) {
        this.listSymbol = listItem.getListSymbol();
        this.symbolIndent = listItem.getIndentationLeft();
    }

    public Chunk listSymbol() {
        return this.listSymbol;
    }

    public float listIndent() {
        return this.symbolIndent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.line.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((PdfChunk)iterator.next()).toString());
        }
        return stringBuffer.toString();
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit && this.alignment != 8;
    }

    public int getLastStrokeChunk() {
        PdfChunk pdfChunk;
        int n2;
        for (n2 = this.line.size() - 1; n2 >= 0 && !(pdfChunk = (PdfChunk)this.line.get(n2)).isStroked(); --n2) {
        }
        return n2;
    }

    public PdfChunk getChunk(int n2) {
        if (n2 < 0 || n2 >= this.line.size()) {
            return null;
        }
        return (PdfChunk)this.line.get(n2);
    }

    public float getOriginalWidth() {
        return this.originalWidth;
    }

    float getMaxSizeSimple() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.line.size(); ++i2) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(i2);
            f2 = !pdfChunk.isImage() ? Math.max(pdfChunk.font().size(), f2) : Math.max(pdfChunk.getImage().getScaledHeight() + pdfChunk.getImageOffsetY(), f2);
        }
        return f2;
    }

    boolean isRTL() {
        return this.isRTL;
    }

    public float getWidthCorrected(float f2, float f3) {
        float f4 = 0.0f;
        for (int i2 = 0; i2 < this.line.size(); ++i2) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(i2);
            f4 += pdfChunk.getWidthCorrected(f2, f3);
        }
        return f4;
    }

    public float getAscender() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.line.size(); ++i2) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(i2);
            if (pdfChunk.isImage()) {
                f2 = Math.max(f2, pdfChunk.getImage().getScaledHeight() + pdfChunk.getImageOffsetY());
                continue;
            }
            PdfFont pdfFont = pdfChunk.font();
            f2 = Math.max(f2, pdfFont.getFont().getFontDescriptor(1, pdfFont.size()));
        }
        return f2;
    }

    public float getDescender() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.line.size(); ++i2) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(i2);
            if (pdfChunk.isImage()) {
                f2 = Math.min(f2, pdfChunk.getImageOffsetY());
                continue;
            }
            PdfFont pdfFont = pdfChunk.font();
            f2 = Math.min(f2, pdfFont.getFont().getFontDescriptor(3, pdfFont.size()));
        }
        return f2;
    }
}

