/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.OutputStreamEncryption;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPublicKeyRecipient;
import com.lowagie.text.pdf.PdfPublicKeySecurityHandler;
import com.lowagie.text.pdf.StandardDecryption;
import com.lowagie.text.pdf.crypto.ARCFOUREncryption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;

public class PdfEncryption {
    public static final int STANDARD_ENCRYPTION_40 = 2;
    public static final int STANDARD_ENCRYPTION_128 = 3;
    public static final int AES_128 = 4;
    private static final byte[] pad = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final byte[] salt = new byte[]{115, 65, 108, 84};
    private static final byte[] metadataPad = new byte[]{-1, -1, -1, -1};
    byte[] key;
    int keySize;
    byte[] mkey;
    byte[] extra = new byte[5];
    MessageDigest md5;
    byte[] ownerKey = new byte[32];
    byte[] userKey = new byte[32];
    protected PdfPublicKeySecurityHandler publicKeyHandler = null;
    int permissions;
    byte[] documentID;
    static long seq = System.currentTimeMillis();
    private int revision;
    private ARCFOUREncryption arcfour = new ARCFOUREncryption();
    private int keyLength;
    private boolean encryptMetadata;
    private int cryptoMode;

    public PdfEncryption() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.publicKeyHandler = new PdfPublicKeySecurityHandler();
    }

    public PdfEncryption(PdfEncryption pdfEncryption) {
        this();
        this.mkey = (byte[])pdfEncryption.mkey.clone();
        this.ownerKey = (byte[])pdfEncryption.ownerKey.clone();
        this.userKey = (byte[])pdfEncryption.userKey.clone();
        this.permissions = pdfEncryption.permissions;
        if (pdfEncryption.documentID != null) {
            this.documentID = (byte[])pdfEncryption.documentID.clone();
        }
        this.revision = pdfEncryption.revision;
        this.keyLength = pdfEncryption.keyLength;
        this.encryptMetadata = pdfEncryption.encryptMetadata;
        this.publicKeyHandler = pdfEncryption.publicKeyHandler;
    }

    public void setCryptoMode(int n2, int n3) {
        this.cryptoMode = n2;
        this.encryptMetadata = (n2 & 8) == 0;
        switch (n2 &= 7) {
            case 0: {
                this.encryptMetadata = true;
                this.keyLength = 40;
                this.revision = 2;
                break;
            }
            case 1: {
                this.keyLength = n3 > 0 ? n3 : 128;
                this.revision = 3;
                break;
            }
            case 2: {
                this.keyLength = 128;
                this.revision = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("No valid encryption mode");
            }
        }
    }

    public int getCryptoMode() {
        return this.cryptoMode;
    }

    public boolean isMetadataEncrypted() {
        return this.encryptMetadata;
    }

    private byte[] padPassword(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        if (byArray == null) {
            System.arraycopy(pad, 0, byArray2, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 32));
            if (byArray.length < 32) {
                System.arraycopy(pad, 0, byArray2, byArray.length, 32 - byArray.length);
            }
        }
        return byArray2;
    }

    private byte[] computeOwnerKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = this.md5.digest(byArray2);
        if (this.revision == 3 || this.revision == 4) {
            int n2;
            byte[] byArray5 = new byte[this.keyLength / 8];
            for (n2 = 0; n2 < 50; ++n2) {
                System.arraycopy(this.md5.digest(byArray4), 0, byArray4, 0, byArray5.length);
            }
            System.arraycopy(byArray, 0, byArray3, 0, 32);
            for (n2 = 0; n2 < 20; ++n2) {
                for (int i2 = 0; i2 < byArray5.length; ++i2) {
                    byArray5[i2] = (byte)(byArray4[i2] ^ n2);
                }
                this.arcfour.prepareARCFOURKey(byArray5);
                this.arcfour.encryptARCFOUR(byArray3);
            }
        } else {
            this.arcfour.prepareARCFOURKey(byArray4, 0, 5);
            this.arcfour.encryptARCFOUR(byArray, byArray3);
        }
        return byArray3;
    }

    private void setupGlobalEncryptionKey(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        this.documentID = byArray;
        this.ownerKey = byArray3;
        this.permissions = n2;
        this.mkey = new byte[this.keyLength / 8];
        this.md5.reset();
        this.md5.update(byArray2);
        this.md5.update(byArray3);
        byte[] byArray4 = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
        this.md5.update(byArray4, 0, 4);
        if (byArray != null) {
            this.md5.update(byArray);
        }
        if (!this.encryptMetadata) {
            this.md5.update(metadataPad);
        }
        byte[] byArray5 = new byte[this.mkey.length];
        System.arraycopy(this.md5.digest(), 0, byArray5, 0, this.mkey.length);
        if (this.revision == 3 || this.revision == 4) {
            for (int i2 = 0; i2 < 50; ++i2) {
                System.arraycopy(this.md5.digest(byArray5), 0, byArray5, 0, this.mkey.length);
            }
        }
        System.arraycopy(byArray5, 0, this.mkey, 0, this.mkey.length);
    }

    private void setupUserKey() {
        if (this.revision == 3 || this.revision == 4) {
            int n2;
            this.md5.update(pad);
            byte[] byArray = this.md5.digest(this.documentID);
            System.arraycopy(byArray, 0, this.userKey, 0, 16);
            for (n2 = 16; n2 < 32; ++n2) {
                this.userKey[n2] = 0;
            }
            for (n2 = 0; n2 < 20; ++n2) {
                for (int i2 = 0; i2 < this.mkey.length; ++i2) {
                    byArray[i2] = (byte)(this.mkey[i2] ^ n2);
                }
                this.arcfour.prepareARCFOURKey(byArray, 0, this.mkey.length);
                this.arcfour.encryptARCFOUR(this.userKey, 0, 16);
            }
        } else {
            this.arcfour.prepareARCFOURKey(this.mkey);
            this.arcfour.encryptARCFOUR(pad, this.userKey);
        }
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray2 == null || byArray2.length == 0) {
            byArray2 = this.md5.digest(PdfEncryption.createDocumentId());
        }
        n2 |= this.revision == 3 || this.revision == 4 ? -3904 : -64;
        byte[] byArray3 = this.padPassword(byArray);
        byte[] byArray4 = this.padPassword(byArray2);
        this.ownerKey = this.computeOwnerKey(byArray3, byArray4);
        this.documentID = PdfEncryption.createDocumentId();
        this.setupByUserPad(this.documentID, byArray3, this.ownerKey, n2 &= 0xFFFFFFFC);
    }

    public static byte[] createDocumentId() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        long l2 = System.currentTimeMillis();
        long l3 = Runtime.getRuntime().freeMemory();
        String string = l2 + "+" + l3 + "+" + seq++;
        return messageDigest.digest(string.getBytes());
    }

    public void setupByUserPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        this.setupByUserPad(byArray, this.padPassword(byArray2), byArray3, n2);
    }

    private void setupByUserPad(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        this.setupGlobalEncryptionKey(byArray, byArray2, byArray3, n2);
        this.setupUserKey();
    }

    public void setupByOwnerPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2) {
        this.setupByOwnerPad(byArray, this.padPassword(byArray2), byArray3, byArray4, n2);
    }

    private void setupByOwnerPad(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2) {
        byte[] byArray5 = this.computeOwnerKey(byArray4, byArray2);
        this.setupGlobalEncryptionKey(byArray, byArray5, byArray4, n2);
        this.setupUserKey();
    }

    public void setupByEncryptionKey(byte[] byArray, int n2) {
        this.mkey = new byte[n2 / 8];
        System.arraycopy(byArray, 0, this.mkey, 0, this.mkey.length);
    }

    public void setHashKey(int n2, int n3) {
        this.md5.reset();
        this.extra[0] = (byte)n2;
        this.extra[1] = (byte)(n2 >> 8);
        this.extra[2] = (byte)(n2 >> 16);
        this.extra[3] = (byte)n3;
        this.extra[4] = (byte)(n3 >> 8);
        this.md5.update(this.mkey);
        this.md5.update(this.extra);
        if (this.revision == 4) {
            this.md5.update(salt);
        }
        this.key = this.md5.digest();
        this.keySize = this.mkey.length + 5;
        if (this.keySize > 16) {
            this.keySize = 16;
        }
    }

    public static PdfObject createInfoId(byte[] byArray) {
        int n2;
        ByteBuffer byteBuffer = new ByteBuffer(90);
        byteBuffer.append('[').append('<');
        for (n2 = 0; n2 < 16; ++n2) {
            byteBuffer.appendHex(byArray[n2]);
        }
        byteBuffer.append('>').append('<');
        byArray = PdfEncryption.createDocumentId();
        for (n2 = 0; n2 < 16; ++n2) {
            byteBuffer.appendHex(byArray[n2]);
        }
        byteBuffer.append('>').append(']');
        return new PdfLiteral(byteBuffer.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (this.publicKeyHandler.getRecipientsSize() > 0) {
            Object object;
            Object object2;
            PdfArray pdfArray = null;
            pdfDictionary.put(PdfName.FILTER, PdfName.PUBSEC);
            pdfDictionary.put(PdfName.R, new PdfNumber(this.revision));
            try {
                pdfArray = this.publicKeyHandler.getEncodedRecipients();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            if (this.revision == 2) {
                pdfDictionary.put(PdfName.V, new PdfNumber(1));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S4);
                pdfDictionary.put(PdfName.RECIPIENTS, pdfArray);
            } else if (this.revision == 3 && this.encryptMetadata) {
                pdfDictionary.put(PdfName.V, new PdfNumber(2));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S4);
                pdfDictionary.put(PdfName.RECIPIENTS, pdfArray);
            } else {
                pdfDictionary.put(PdfName.R, new PdfNumber(4));
                pdfDictionary.put(PdfName.V, new PdfNumber(4));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S5);
                object2 = new PdfDictionary();
                ((PdfDictionary)object2).put(PdfName.RECIPIENTS, pdfArray);
                if (!this.encryptMetadata) {
                    ((PdfDictionary)object2).put(PdfName.ENCRYPTMETADATA, PdfBoolean.PDFFALSE);
                }
                if (this.revision == 4) {
                    ((PdfDictionary)object2).put(PdfName.CFM, PdfName.AESV2);
                } else {
                    ((PdfDictionary)object2).put(PdfName.CFM, PdfName.V2);
                }
                object = new PdfDictionary();
                ((PdfDictionary)object).put(PdfName.DEFAULTCRYPTFILER, (PdfObject)object2);
                pdfDictionary.put(PdfName.CF, (PdfObject)object);
                pdfDictionary.put(PdfName.STRF, PdfName.DEFAULTCRYPTFILER);
                pdfDictionary.put(PdfName.STMF, PdfName.DEFAULTCRYPTFILER);
            }
            object2 = null;
            object = null;
            try {
                object2 = MessageDigest.getInstance("SHA-1");
                ((MessageDigest)object2).update(this.publicKeyHandler.getSeed());
                for (int i2 = 0; i2 < this.publicKeyHandler.getRecipientsSize(); ++i2) {
                    object = this.publicKeyHandler.getEncodedRecipient(i2);
                    ((MessageDigest)object2).update((byte[])object);
                }
                if (!this.encryptMetadata) {
                    ((MessageDigest)object2).update(new byte[]{-1, -1, -1, -1});
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            byte[] byArray = ((MessageDigest)object2).digest();
            this.setupByEncryptionKey(byArray, this.keyLength);
        } else {
            pdfDictionary.put(PdfName.FILTER, PdfName.STANDARD);
            pdfDictionary.put(PdfName.O, new PdfLiteral(PdfContentByte.escapeString(this.ownerKey)));
            pdfDictionary.put(PdfName.U, new PdfLiteral(PdfContentByte.escapeString(this.userKey)));
            pdfDictionary.put(PdfName.P, new PdfNumber(this.permissions));
            pdfDictionary.put(PdfName.R, new PdfNumber(this.revision));
            if (this.revision == 2) {
                pdfDictionary.put(PdfName.V, new PdfNumber(1));
            } else if (this.revision == 3 && this.encryptMetadata) {
                pdfDictionary.put(PdfName.V, new PdfNumber(2));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
            } else {
                if (!this.encryptMetadata) {
                    pdfDictionary.put(PdfName.ENCRYPTMETADATA, PdfBoolean.PDFFALSE);
                }
                pdfDictionary.put(PdfName.R, new PdfNumber(4));
                pdfDictionary.put(PdfName.V, new PdfNumber(4));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
                PdfDictionary pdfDictionary2 = new PdfDictionary();
                pdfDictionary2.put(PdfName.LENGTH, new PdfNumber(16));
                pdfDictionary2.put(PdfName.AUTHEVENT, PdfName.DOCOPEN);
                if (this.revision == 4) {
                    pdfDictionary2.put(PdfName.CFM, PdfName.AESV2);
                } else {
                    pdfDictionary2.put(PdfName.CFM, PdfName.V2);
                }
                PdfDictionary pdfDictionary3 = new PdfDictionary();
                pdfDictionary3.put(PdfName.STDCF, pdfDictionary2);
                pdfDictionary.put(PdfName.CF, pdfDictionary3);
                pdfDictionary.put(PdfName.STRF, PdfName.STDCF);
                pdfDictionary.put(PdfName.STMF, PdfName.STDCF);
            }
        }
        return pdfDictionary;
    }

    public PdfObject getFileID() {
        return PdfEncryption.createInfoId(this.documentID);
    }

    public OutputStreamEncryption getEncryptionStream(OutputStream outputStream) {
        return new OutputStreamEncryption(outputStream, this.key, 0, this.keySize, this.revision);
    }

    public int calculateStreamSize(int n2) {
        if (this.revision == 4) {
            return (n2 & 0x7FFFFFF0) + 32;
        }
        return n2;
    }

    public byte[] encryptByteArray(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamEncryption outputStreamEncryption = this.getEncryptionStream(byteArrayOutputStream);
            outputStreamEncryption.write(byArray);
            outputStreamEncryption.finish();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public StandardDecryption getDecryptor() {
        return new StandardDecryption(this.key, 0, this.keySize, this.revision);
    }

    public byte[] decryptByteArray(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StandardDecryption standardDecryption = this.getDecryptor();
            byte[] byArray2 = standardDecryption.update(byArray, 0, byArray.length);
            if (byArray2 != null) {
                byteArrayOutputStream.write(byArray2);
            }
            if ((byArray2 = standardDecryption.finish()) != null) {
                byteArrayOutputStream.write(byArray2);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void addRecipient(Certificate certificate, int n2) {
        this.documentID = PdfEncryption.createDocumentId();
        this.publicKeyHandler.addRecipient(new PdfPublicKeyRecipient(certificate, n2));
    }

    public byte[] computeUserPassword(byte[] byArray) {
        byte[] byArray2 = this.computeOwnerKey(this.ownerKey, this.padPassword(byArray));
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            boolean bl = true;
            for (int i3 = 0; i3 < byArray2.length - i2; ++i3) {
                if (byArray2[i2 + i3] == pad[i3]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            byte[] byArray3 = new byte[i2];
            System.arraycopy(byArray2, 0, byArray3, 0, i2);
            return byArray3;
        }
        return byArray2;
    }
}

