/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.LargeElement;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;

public class Table
extends Rectangle
implements LargeElement {
    private int columns;
    private ArrayList rows = new ArrayList();
    private Point curPosition = new Point(0, 0);
    private Cell defaultCell = new Cell(true);
    private int lastHeaderRow = -1;
    private int alignment = 1;
    private float cellpadding;
    private float cellspacing;
    private float width = 80.0f;
    private boolean locked = false;
    private float[] widths;
    private boolean mTableInserted = false;
    protected boolean autoFillEmptyCells = false;
    boolean tableFitsPage = false;
    boolean cellsFitPage = false;
    float offset = Float.NaN;
    protected boolean convert2pdfptable = false;
    protected boolean notAddedYet = true;
    protected boolean complete = true;
    static /* synthetic */ Class class$com$lowagie$text$Table;
    static /* synthetic */ Class class$com$lowagie$text$Cell;

    public Table(int n2) throws BadElementException {
        this(n2, 1);
    }

    public Table(int n2, int n3) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultCell.setBorder(15);
        if (n2 <= 0) {
            throw new BadElementException("A table should have at least 1 column.");
        }
        this.columns = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.rows.add(new Row(n2));
        }
        this.curPosition = new Point(0, 0);
        this.widths = new float[n2];
        float f2 = 100.0f / (float)n2;
        for (int i3 = 0; i3 < n2; ++i3) {
            this.widths[i3] = f2;
        }
    }

    public Table(Table table) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.cloneNonPositionParameters(table);
        this.columns = table.columns;
        this.rows = table.rows;
        this.curPosition = table.curPosition;
        this.defaultCell = table.defaultCell;
        this.lastHeaderRow = table.lastHeaderRow;
        this.alignment = table.alignment;
        this.cellpadding = table.cellpadding;
        this.cellspacing = table.cellspacing;
        this.width = table.width;
        this.widths = table.widths;
        this.autoFillEmptyCells = table.autoFillEmptyCells;
        this.tableFitsPage = table.tableFitsPage;
        this.cellsFitPage = table.cellsFitPage;
        this.offset = table.offset;
        this.convert2pdfptable = table.convert2pdfptable;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 22;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public boolean isNestable() {
        return true;
    }

    public int getColumns() {
        return this.columns;
    }

    public int size() {
        return this.rows.size();
    }

    public Dimension getDimension() {
        return new Dimension(this.columns, this.size());
    }

    public Cell getDefaultCell() {
        return this.defaultCell;
    }

    public void setDefaultCell(Cell cell) {
        this.defaultCell = cell;
    }

    public int getLastHeaderRow() {
        return this.lastHeaderRow;
    }

    public void setLastHeaderRow(int n2) {
        this.lastHeaderRow = n2;
    }

    public int endHeaders() {
        this.lastHeaderRow = this.curPosition.x - 1;
        return this.lastHeaderRow;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public void setAlignment(String string) {
        if ("Left".equalsIgnoreCase(string)) {
            this.alignment = 0;
            return;
        }
        if ("right".equalsIgnoreCase(string)) {
            this.alignment = 2;
            return;
        }
        this.alignment = 1;
    }

    public float getPadding() {
        return this.cellpadding;
    }

    public void setPadding(float f2) {
        this.cellpadding = f2;
    }

    public float getSpacing() {
        return this.cellspacing;
    }

    public void setSpacing(float f2) {
        this.cellspacing = f2;
    }

    public void setAutoFillEmptyCells(boolean bl) {
        this.autoFillEmptyCells = bl;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f2) {
        this.width = f2;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public float[] getProportionalWidths() {
        return this.widths;
    }

    public void setWidths(float[] fArray) throws BadElementException {
        if (fArray.length != this.columns) {
            throw new BadElementException("Wrong number of columns.");
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.columns; ++i2) {
            f2 += fArray[i2];
        }
        this.widths[this.columns - 1] = 100.0f;
        for (int i3 = 0; i3 < this.columns - 1; ++i3) {
            float f3;
            this.widths[i3] = f3 = 100.0f * fArray[i3] / f2;
            int n2 = this.columns - 1;
            this.widths[n2] = this.widths[n2] - f3;
        }
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        this.setWidths(fArray);
    }

    public boolean isTableFitsPage() {
        return this.tableFitsPage;
    }

    public void setTableFitsPage(boolean bl) {
        this.tableFitsPage = bl;
        if (bl) {
            this.setCellsFitPage(true);
        }
    }

    public boolean isCellsFitPage() {
        return this.cellsFitPage;
    }

    public void setCellsFitPage(boolean bl) {
        this.cellsFitPage = bl;
    }

    public void setOffset(float f2) {
        this.offset = f2;
    }

    public float getOffset() {
        return this.offset;
    }

    public boolean isConvert2pdfptable() {
        return this.convert2pdfptable;
    }

    public void setConvert2pdfptable(boolean bl) {
        this.convert2pdfptable = bl;
    }

    public void addCell(Cell cell, int n2, int n3) throws BadElementException {
        this.addCell(cell, new Point(n2, n3));
    }

    public void addCell(Cell cell, Point point) throws BadElementException {
        if (cell == null) {
            throw new NullPointerException("addCell - cell has null-value");
        }
        if (point == null) {
            throw new NullPointerException("addCell - point has null-value");
        }
        if (cell.isTable()) {
            this.insertTable((Table)cell.getElements().next(), point);
        }
        if (point.x < 0) {
            throw new BadElementException("row coordinate of location must be >= 0");
        }
        if (point.y <= 0 && point.y > this.columns) {
            throw new BadElementException("column coordinate of location must be >= 0 and < nr of columns");
        }
        if (!this.isValidLocation(cell, point)) {
            throw new BadElementException("Adding a cell at the location (" + point.x + "," + point.y + ") with a colspan of " + cell.getColspan() + " and a rowspan of " + cell.getRowspan() + " is illegal (beyond boundaries/overlapping).");
        }
        if (cell.getBorder() == -1) {
            cell.setBorder(this.defaultCell.getBorder());
        }
        cell.fill();
        this.placeCell(this.rows, cell, point);
        this.setCurrentLocationToNextValidPosition(point);
    }

    public void addCell(Cell cell) {
        try {
            this.addCell(cell, this.curPosition);
        }
        catch (BadElementException badElementException) {
            // empty catch block
        }
    }

    public void addCell(Phrase phrase) throws BadElementException {
        this.addCell(phrase, this.curPosition);
    }

    public void addCell(Phrase phrase, Point point) throws BadElementException {
        Cell cell = new Cell(phrase);
        cell.setBorder(this.defaultCell.getBorder());
        cell.setBorderWidth(this.defaultCell.getBorderWidth());
        cell.setBorderColor(this.defaultCell.getBorderColor());
        cell.setBackgroundColor(this.defaultCell.getBackgroundColor());
        cell.setHorizontalAlignment(this.defaultCell.getHorizontalAlignment());
        cell.setVerticalAlignment(this.defaultCell.getVerticalAlignment());
        cell.setColspan(this.defaultCell.getColspan());
        cell.setRowspan(this.defaultCell.getRowspan());
        this.addCell(cell, point);
    }

    public void addCell(String string) throws BadElementException {
        this.addCell(new Phrase(string), this.curPosition);
    }

    public void addCell(String string, Point point) throws BadElementException {
        this.addCell(new Phrase(string), point);
    }

    public void insertTable(Table table) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(table, this.curPosition);
    }

    public void insertTable(Table table, int n2, int n3) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(table, new Point(n2, n3));
    }

    public void insertTable(Table table, Point point) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        if (point == null) {
            throw new NullPointerException("insertTable - point has null-value");
        }
        this.mTableInserted = true;
        table.complete();
        if (point.y > this.columns) {
            throw new IllegalArgumentException("insertTable -- wrong columnposition(" + point.y + ") of location; max =" + this.columns);
        }
        int n2 = point.x + 1 - this.rows.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.rows.add(new Row(this.columns));
            }
        }
        ((Row)this.rows.get(point.x)).setElement(table, point.y);
        this.setCurrentLocationToNextValidPosition(point);
    }

    public void addColumns(int n2) {
        int n3;
        ArrayList<Row> arrayList = new ArrayList<Row>(this.rows.size());
        int n4 = this.columns + n2;
        for (int i2 = 0; i2 < this.rows.size(); ++i2) {
            Row row = new Row(n4);
            for (n3 = 0; n3 < this.columns; ++n3) {
                row.setElement(((Row)this.rows.get(i2)).getCell(n3), n3);
            }
            for (n3 = this.columns; n3 < n4 && i2 < this.curPosition.x; ++n3) {
                row.setElement(null, n3);
            }
            arrayList.add(row);
        }
        float[] fArray = new float[n4];
        System.arraycopy(this.widths, 0, fArray, 0, this.columns);
        for (n3 = this.columns; n3 < n4; ++n3) {
            fArray[n3] = 0.0f;
        }
        this.columns = n4;
        this.widths = fArray;
        this.rows = arrayList;
    }

    public void deleteColumn(int n2) throws BadElementException {
        float[] fArray = new float[--this.columns];
        System.arraycopy(this.widths, 0, fArray, 0, n2);
        System.arraycopy(this.widths, n2 + 1, fArray, n2, this.columns - n2);
        this.setWidths(fArray);
        System.arraycopy(this.widths, 0, fArray, 0, this.columns);
        this.widths = fArray;
        int n3 = this.rows.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Row row = (Row)this.rows.get(i2);
            row.deleteColumn(n2);
            this.rows.set(i2, row);
        }
        if (n2 == this.columns) {
            this.curPosition.setLocation(this.curPosition.x + 1, 0);
        }
    }

    public boolean deleteRow(int n2) {
        if (n2 < 0 || n2 >= this.rows.size()) {
            return false;
        }
        this.rows.remove(n2);
        this.curPosition.setLocation(this.curPosition.x - 1, this.curPosition.y);
        return true;
    }

    public void deleteAllRows() {
        this.rows.clear();
        this.rows.add(new Row(this.columns));
        this.curPosition.setLocation(0, 0);
        this.lastHeaderRow = -1;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public void complete() {
        if (this.mTableInserted) {
            this.mergeInsertedTables();
            this.mTableInserted = false;
        }
        if (this.autoFillEmptyCells) {
            this.fillEmptyMatrixCells();
        }
    }

    public Object getElement(int n2, int n3) {
        return ((Row)this.rows.get(n2)).getCell(n3);
    }

    private void mergeInsertedTables() {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        float[] fArray = null;
        int[] nArray = new int[this.columns];
        float[][] fArrayArray = new float[this.columns][];
        int[] nArray2 = new int[this.rows.size()];
        ArrayList<Row> arrayList = null;
        boolean bl = false;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        Table table = null;
        for (n6 = 0; n6 < this.columns; ++n6) {
            n10 = 1;
            float[] fArray2 = null;
            for (n5 = 0; n5 < this.rows.size(); ++n5) {
                if (!(class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n5)).getCell(n6))) continue;
                bl = true;
                table = (Table)((Row)this.rows.get(n5)).getCell(n6);
                if (fArray2 == null) {
                    fArray2 = table.widths;
                    n10 = fArray2.length;
                    continue;
                }
                n4 = table.getDimension().width;
                float[] fArray3 = new float[n4 * fArray2.length];
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                n3 = 0;
                n2 = 0;
                int n11 = 0;
                f2 += fArray2[0];
                f3 += table.widths[0];
                while (n3 < fArray2.length && n2 < n4) {
                    if (f3 > f2) {
                        fArray3[n11] = f2 - f4;
                        if (++n3 < fArray2.length) {
                            f2 += fArray2[n3];
                        }
                    } else {
                        fArray3[n11] = f3 - f4;
                        ++n2;
                        if ((double)Math.abs(f3 - f2) < 1.0E-4 && ++n3 < fArray2.length) {
                            f2 += fArray2[n3];
                        }
                        if (n2 < n4) {
                            f3 += table.widths[n2];
                        }
                    }
                    f4 += fArray3[n11];
                    ++n11;
                }
                fArray2 = new float[n11];
                System.arraycopy(fArray3, 0, fArray2, 0, n11);
                n10 = n11;
            }
            fArrayArray[n6] = fArray2;
            n8 += n10;
            nArray[n6] = n10;
        }
        for (n5 = 0; n5 < this.rows.size(); ++n5) {
            n9 = 1;
            for (n6 = 0; n6 < this.columns; ++n6) {
                if (!(class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n5)).getCell(n6))) continue;
                bl = true;
                table = (Table)((Row)this.rows.get(n5)).getCell(n6);
                if (table.getDimension().height <= n9) continue;
                n9 = table.getDimension().height;
            }
            n7 += n9;
            nArray2[n5] = n9;
        }
        if (n8 != this.columns || n7 != this.rows.size() || bl) {
            fArray = new float[n8];
            int n12 = 0;
            for (n4 = 0; n4 < this.widths.length; ++n4) {
                if (nArray[n4] != 1) {
                    for (int i2 = 0; i2 < nArray[n4]; ++i2) {
                        fArray[n12] = this.widths[n4] * fArrayArray[n4][i2] / 100.0f;
                        ++n12;
                    }
                    continue;
                }
                fArray[n12] = this.widths[n4];
                ++n12;
            }
            arrayList = new ArrayList<Row>(n7);
            for (n5 = 0; n5 < n7; ++n5) {
                arrayList.add(new Row(n8));
            }
            n4 = 0;
            int n13 = 0;
            Object object = null;
            for (n5 = 0; n5 < this.rows.size(); ++n5) {
                n13 = 0;
                n9 = 1;
                for (n6 = 0; n6 < this.columns; ++n6) {
                    Object object2;
                    if ((class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n5)).getCell(n6))) {
                        table = (Table)((Row)this.rows.get(n5)).getCell(n6);
                        object2 = new int[table.widths.length + 1];
                        n3 = 0;
                        for (int i3 = 0; i3 < table.widths.length; ++i3) {
                            object2[i3] = n13 + n3;
                            float f5 = table.widths[i3];
                            float f6 = 0.0f;
                            while (n3 < nArray[n6]) {
                                int n14 = n3++;
                                if (!((double)Math.abs(f5 - (f6 += fArrayArray[n6][n14])) < 1.0E-4)) continue;
                            }
                        }
                        object2[i3] = n13 + n3;
                        for (n2 = 0; n2 < table.getDimension().height; ++n2) {
                            for (int i4 = 0; i4 < table.getDimension().width; ++i4) {
                                object = table.getElement(n2, i4);
                                if (object == null) continue;
                                Object object3 = n13 + i4;
                                if ((class$com$lowagie$text$Cell == null ? Table.class$("com.lowagie.text.Cell") : class$com$lowagie$text$Cell).isInstance(object)) {
                                    Cell cell = (Cell)object;
                                    object3 = object2[i4];
                                    Object object4 = object2[i4 + cell.getColspan()];
                                    cell.setColspan((int)(object4 - object3));
                                }
                                ((Row)arrayList.get(n2 + n4)).addElement(object, (int)object3);
                            }
                        }
                    } else if ((class$com$lowagie$text$Cell == null ? Table.class$("com.lowagie.text.Cell") : class$com$lowagie$text$Cell).isInstance(object2 = this.getElement(n5, n6))) {
                        ((Cell)object2).setRowspan(((Cell)((Row)this.rows.get(n5)).getCell(n6)).getRowspan() + nArray2[n5] - 1);
                        ((Cell)object2).setColspan(((Cell)((Row)this.rows.get(n5)).getCell(n6)).getColspan() + nArray[n6] - 1);
                        this.placeCell(arrayList, (Cell)object2, new Point(n4, n13));
                    }
                    n13 += nArray[n6];
                }
                n4 += nArray2[n5];
            }
            this.columns = n8;
            this.rows = arrayList;
            this.widths = fArray;
        }
    }

    private void fillEmptyMatrixCells() {
        try {
            for (int i2 = 0; i2 < this.rows.size(); ++i2) {
                for (int i3 = 0; i3 < this.columns; ++i3) {
                    if (((Row)this.rows.get(i2)).isReserved(i3)) continue;
                    this.addCell(this.defaultCell, new Point(i2, i3));
                }
            }
        }
        catch (BadElementException badElementException) {
            throw new ExceptionConverter(badElementException);
        }
    }

    private boolean isValidLocation(Cell cell, Point point) {
        if (point.x < this.rows.size()) {
            if (point.y + cell.getColspan() > this.columns) {
                return false;
            }
            int n2 = this.rows.size() - point.x > cell.getRowspan() ? cell.getRowspan() : this.rows.size() - point.x;
            int n3 = this.columns - point.y > cell.getColspan() ? cell.getColspan() : this.columns - point.y;
            for (int i2 = point.x; i2 < point.x + n2; ++i2) {
                for (int i3 = point.y; i3 < point.y + n3; ++i3) {
                    if (!((Row)this.rows.get(i2)).isReserved(i3)) continue;
                    return false;
                }
            }
        } else if (point.y + cell.getColspan() > this.columns) {
            return false;
        }
        return true;
    }

    private void assumeTableDefaults(Cell cell) {
        if (cell.getBorder() == -1) {
            cell.setBorder(this.defaultCell.getBorder());
        }
        if (cell.getBorderWidth() == -1.0f) {
            cell.setBorderWidth(this.defaultCell.getBorderWidth());
        }
        if (cell.getBorderColor() == null) {
            cell.setBorderColor(this.defaultCell.getBorderColor());
        }
        if (cell.getBackgroundColor() == null) {
            cell.setBackgroundColor(this.defaultCell.getBackgroundColor());
        }
        if (cell.getHorizontalAlignment() == -1) {
            cell.setHorizontalAlignment(this.defaultCell.getHorizontalAlignment());
        }
        if (cell.getVerticalAlignment() == -1) {
            cell.setVerticalAlignment(this.defaultCell.getVerticalAlignment());
        }
    }

    private void placeCell(ArrayList arrayList, Cell cell, Point point) {
        int n2;
        Row row = null;
        int n3 = point.x + cell.getRowspan() - arrayList.size();
        this.assumeTableDefaults(cell);
        if (point.x + cell.getRowspan() > arrayList.size()) {
            for (n2 = 0; n2 < n3; ++n2) {
                row = new Row(this.columns);
                arrayList.add(row);
            }
        }
        for (n2 = point.x + 1; n2 < point.x + cell.getRowspan(); ++n2) {
            if (((Row)arrayList.get(n2)).reserve(point.y, cell.getColspan())) continue;
            throw new RuntimeException("addCell - error in reserve");
        }
        row = (Row)arrayList.get(point.x);
        row.addElement(cell, point.y);
    }

    private void setCurrentLocationToNextValidPosition(Point point) {
        int n2 = point.x;
        int n3 = point.y;
        do {
            if (n3 + 1 == this.columns) {
                ++n2;
                n3 = 0;
                continue;
            }
            ++n3;
        } while (n2 < this.rows.size() && n3 < this.columns && ((Row)this.rows.get(n2)).isReserved(n3));
        this.curPosition = new Point(n2, n3);
    }

    public float[] getWidths(float f2, float f3) {
        float[] fArray = new float[this.columns + 1];
        float f4 = this.locked ? 100.0f * this.width / f3 : this.width;
        switch (this.alignment) {
            case 0: {
                fArray[0] = f2;
                break;
            }
            case 2: {
                fArray[0] = f2 + f3 * (100.0f - f4) / 100.0f;
                break;
            }
            default: {
                fArray[0] = f2 + f3 * (100.0f - f4) / 200.0f;
            }
        }
        f3 = f3 * f4 / 100.0f;
        for (int i2 = 1; i2 < this.columns; ++i2) {
            fArray[i2] = fArray[i2 - 1] + this.widths[i2 - 1] * f3 / 100.0f;
        }
        fArray[this.columns] = fArray[0] + f3;
        return fArray;
    }

    public Iterator iterator() {
        return this.rows.iterator();
    }

    public PdfPTable createPdfPTable() throws BadElementException {
        if (!this.convert2pdfptable) {
            throw new BadElementException("No error, just an old style table");
        }
        this.setAutoFillEmptyCells(true);
        this.complete();
        PdfPTable pdfPTable = new PdfPTable(this.widths);
        pdfPTable.setComplete(this.complete);
        if (this.isNotAddedYet()) {
            pdfPTable.setSkipFirstHeader(true);
        }
        pdfPTable.setTableEvent(SimpleTable.getDimensionlessInstance(this, this.cellspacing));
        pdfPTable.setHeaderRows(this.lastHeaderRow + 1);
        pdfPTable.setSplitLate(this.cellsFitPage);
        pdfPTable.setKeepTogether(this.tableFitsPage);
        if (!Float.isNaN(this.offset)) {
            pdfPTable.setSpacingBefore(this.offset);
        }
        pdfPTable.setHorizontalAlignment(this.alignment);
        if (this.locked) {
            pdfPTable.setTotalWidth(this.width);
            pdfPTable.setLockedWidth(true);
        } else {
            pdfPTable.setWidthPercentage(this.width);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            for (int i2 = 0; i2 < row.getColumns(); ++i2) {
                PdfPCell pdfPCell;
                Element element = (Element)row.getCell(i2);
                if (element == null) continue;
                if (element instanceof Table) {
                    pdfPCell = new PdfPCell(((Table)element).createPdfPTable());
                } else if (element instanceof Cell) {
                    pdfPCell = ((Cell)element).createPdfPCell();
                    pdfPCell.setPadding(this.cellpadding + this.cellspacing / 2.0f);
                    pdfPCell.setCellEvent(SimpleCell.getDimensionlessInstance((Cell)element, this.cellspacing));
                } else {
                    pdfPCell = new PdfPCell();
                }
                pdfPTable.addCell(pdfPCell);
            }
        }
        return pdfPTable;
    }

    public boolean isNotAddedYet() {
        return this.notAddedYet;
    }

    public void setNotAddedYet(boolean bl) {
        this.notAddedYet = bl;
    }

    public void flushContent() {
        this.setNotAddedYet(false);
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.getLastHeaderRow() + 1; ++i2) {
            arrayList.add(this.rows.get(i2));
        }
        this.rows = arrayList;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }

    public Cell getDefaultLayout() {
        return this.getDefaultCell();
    }

    public void setDefaultLayout(Cell cell) {
        this.defaultCell = cell;
    }
}

