/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPTableEvent;
import java.util.ArrayList;
import java.util.Iterator;

public class SimpleTable
extends Rectangle
implements PdfPTableEvent,
TextElementArray {
    private ArrayList content = new ArrayList();
    private float width = 0.0f;
    private float widthpercentage = 0.0f;
    private float cellspacing;
    private float cellpadding;
    private int alignment;

    public SimpleTable() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(2.0f);
    }

    public void addElement(SimpleCell simpleCell) throws BadElementException {
        if (!simpleCell.isCellgroup()) {
            throw new BadElementException("You can't add cells to a table directly, add them to a row first.");
        }
        this.content.add(simpleCell);
    }

    public Table createTable() throws BadElementException {
        int n2;
        SimpleCell simpleCell;
        if (this.content.isEmpty()) {
            throw new BadElementException("Trying to create a table without rows.");
        }
        SimpleCell simpleCell2 = (SimpleCell)this.content.get(0);
        int n3 = 0;
        Object object = simpleCell2.getContent().iterator();
        while (object.hasNext()) {
            simpleCell = (SimpleCell)object.next();
            n3 += simpleCell.getColspan();
        }
        object = new float[n3];
        float[] fArray = new float[n3];
        Table table = new Table(n3);
        table.setAlignment(this.alignment);
        table.setSpacing(this.cellspacing);
        table.setPadding(this.cellpadding);
        table.cloneNonPositionParameters(this);
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            simpleCell2 = (SimpleCell)iterator.next();
            int n4 = 0;
            Iterator iterator2 = simpleCell2.getContent().iterator();
            while (iterator2.hasNext()) {
                simpleCell = (SimpleCell)iterator2.next();
                table.addCell(simpleCell.createCell(simpleCell2));
                if (simpleCell.getColspan() == 1) {
                    if (simpleCell.getWidth() > 0.0f) {
                        object[n4] = simpleCell.getWidth();
                    }
                    if (simpleCell.getWidthpercentage() > 0.0f) {
                        fArray[n4] = simpleCell.getWidthpercentage();
                    }
                }
                n4 += simpleCell.getColspan();
            }
        }
        float f2 = 0.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            if (object[n2] == 0.0f) {
                f2 = 0.0f;
                break;
            }
            f2 += object[n2];
        }
        if (f2 > 0.0f) {
            table.setWidth(f2);
            table.setLocked(true);
            table.setWidths((float[])object);
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                if (fArray[n2] == 0.0f) {
                    f2 = 0.0f;
                    break;
                }
                f2 += fArray[n2];
            }
            if (f2 > 0.0f) {
                table.setWidths(fArray);
            }
        }
        if (this.width > 0.0f) {
            table.setWidth(this.width);
            table.setLocked(true);
        } else if (this.widthpercentage > 0.0f) {
            table.setWidth(this.widthpercentage);
        }
        return table;
    }

    public PdfPTable createPdfPTable() throws DocumentException {
        int n2;
        SimpleCell simpleCell;
        if (this.content.isEmpty()) {
            throw new BadElementException("Trying to create a table without rows.");
        }
        SimpleCell simpleCell2 = (SimpleCell)this.content.get(0);
        int n3 = 0;
        Object object = simpleCell2.getContent().iterator();
        while (object.hasNext()) {
            simpleCell = (SimpleCell)object.next();
            n3 += simpleCell.getColspan();
        }
        object = new float[n3];
        float[] fArray = new float[n3];
        PdfPTable pdfPTable = new PdfPTable(n3);
        pdfPTable.setTableEvent(this);
        pdfPTable.setHorizontalAlignment(this.alignment);
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            simpleCell2 = (SimpleCell)iterator.next();
            int n4 = 0;
            Iterator iterator2 = simpleCell2.getContent().iterator();
            while (iterator2.hasNext()) {
                simpleCell = (SimpleCell)iterator2.next();
                if (Float.isNaN(simpleCell.getSpacing_left())) {
                    simpleCell.setSpacing_left(this.cellspacing / 2.0f);
                }
                if (Float.isNaN(simpleCell.getSpacing_right())) {
                    simpleCell.setSpacing_right(this.cellspacing / 2.0f);
                }
                if (Float.isNaN(simpleCell.getSpacing_top())) {
                    simpleCell.setSpacing_top(this.cellspacing / 2.0f);
                }
                if (Float.isNaN(simpleCell.getSpacing_bottom())) {
                    simpleCell.setSpacing_bottom(this.cellspacing / 2.0f);
                }
                simpleCell.setPadding(this.cellpadding);
                pdfPTable.addCell(simpleCell.createPdfPCell(simpleCell2));
                if (simpleCell.getColspan() == 1) {
                    if (simpleCell.getWidth() > 0.0f) {
                        object[n4] = simpleCell.getWidth();
                    }
                    if (simpleCell.getWidthpercentage() > 0.0f) {
                        fArray[n4] = simpleCell.getWidthpercentage();
                    }
                }
                n4 += simpleCell.getColspan();
            }
        }
        float f2 = 0.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            if (object[n2] == 0.0f) {
                f2 = 0.0f;
                break;
            }
            f2 += object[n2];
        }
        if (f2 > 0.0f) {
            pdfPTable.setTotalWidth(f2);
            pdfPTable.setWidths((float[])object);
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                if (fArray[n2] == 0.0f) {
                    f2 = 0.0f;
                    break;
                }
                f2 += fArray[n2];
            }
            if (f2 > 0.0f) {
                pdfPTable.setWidths(fArray);
            }
        }
        if (this.width > 0.0f) {
            pdfPTable.setTotalWidth(this.width);
        }
        if (this.widthpercentage > 0.0f) {
            pdfPTable.setWidthPercentage(this.widthpercentage);
        }
        return pdfPTable;
    }

    public static SimpleTable getDimensionlessInstance(Rectangle rectangle, float f2) {
        SimpleTable simpleTable = new SimpleTable();
        simpleTable.cloneNonPositionParameters(rectangle);
        simpleTable.setCellspacing(f2);
        return simpleTable;
    }

    public void tableLayout(PdfPTable pdfPTable, float[][] fArray, float[] fArray2, int n2, int n3, PdfContentByte[] pdfContentByteArray) {
        float[] fArray3 = fArray[0];
        Rectangle rectangle = new Rectangle(fArray3[0], fArray2[fArray2.length - 1], fArray3[fArray3.length - 1], fArray2[0]);
        rectangle.cloneNonPositionParameters(this);
        int n4 = rectangle.getBorder();
        rectangle.setBorder(0);
        pdfContentByteArray[1].rectangle(rectangle);
        rectangle.setBorder(n4);
        rectangle.setBackgroundColor(null);
        pdfContentByteArray[2].rectangle(rectangle);
    }

    public float getCellpadding() {
        return this.cellpadding;
    }

    public void setCellpadding(float f2) {
        this.cellpadding = f2;
    }

    public float getCellspacing() {
        return this.cellspacing;
    }

    public void setCellspacing(float f2) {
        this.cellspacing = f2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f2) {
        this.width = f2;
    }

    public float getWidthpercentage() {
        return this.widthpercentage;
    }

    public void setWidthpercentage(float f2) {
        this.widthpercentage = f2;
    }

    public int type() {
        return 22;
    }

    public boolean isNestable() {
        return true;
    }

    public boolean add(Object object) {
        try {
            this.addElement((SimpleCell)object);
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (BadElementException badElementException) {
            throw new ExceptionConverter(badElementException);
        }
    }
}

