/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.Utilities;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Jpeg
extends Image {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APP2 = 226;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID = new byte[]{74, 70, 73, 70, 0};
    private byte[][] icc;

    Jpeg(Image image) {
        super(image);
    }

    public Jpeg(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Jpeg(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    public Jpeg(byte[] byArray, float f2, float f3) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = f2;
        this.scaledHeight = f3;
    }

    private static final int getShort(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static final int marker(int n2) {
        int n3;
        for (n3 = 0; n3 < VALID_MARKERS.length; ++n3) {
            if (n2 != VALID_MARKERS[n3]) continue;
            return 0;
        }
        for (n3 = 0; n3 < NOPARAM_MARKERS.length; ++n3) {
            if (n2 != NOPARAM_MARKERS[n3]) continue;
            return 2;
        }
        for (n3 = 0; n3 < UNSUPPORTED_MARKERS.length; ++n3) {
            if (n2 != UNSUPPORTED_MARKERS[n3]) continue;
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processParameters() throws BadElementException, IOException {
        int n2;
        int n3;
        this.type = 32;
        this.originalType = 1;
        InputStream inputStream = null;
        try {
            String string;
            if (this.rawData == null) {
                inputStream = this.url.openStream();
                string = this.url.toString();
            } else {
                inputStream = new ByteArrayInputStream(this.rawData);
                string = "Byte array";
            }
            if (inputStream.read() != 255 || inputStream.read() != 216) {
                throw new BadElementException(string + " is not a valid JPEG-file.");
            }
            n3 = 1;
            while (true) {
                int n4;
                int n5;
                int n6;
                if ((n6 = inputStream.read()) < 0) {
                    throw new IOException("Premature EOF while reading JPG.");
                }
                if (n6 != 255) continue;
                int n7 = inputStream.read();
                if (n3 != 0 && n7 == 224) {
                    n3 = 0;
                    n2 = Jpeg.getShort(inputStream);
                    if (n2 < 16) {
                        Utilities.skip(inputStream, n2 - 2);
                        continue;
                    }
                    byte[] byArray = new byte[JFIF_ID.length];
                    int n8 = inputStream.read(byArray);
                    if (n8 != byArray.length) {
                        throw new BadElementException(string + " corrupted JFIF marker.");
                    }
                    n5 = 1;
                    for (n4 = 0; n4 < byArray.length; ++n4) {
                        if (byArray[n4] == JFIF_ID[n4]) continue;
                        n5 = 0;
                        break;
                    }
                    if (n5 == 0) {
                        Utilities.skip(inputStream, n2 - 2 - byArray.length);
                        continue;
                    }
                    Utilities.skip(inputStream, 2);
                    n4 = inputStream.read();
                    int n9 = Jpeg.getShort(inputStream);
                    int n10 = Jpeg.getShort(inputStream);
                    if (n4 == 1) {
                        this.dpiX = n9;
                        this.dpiY = n10;
                    } else if (n4 == 2) {
                        this.dpiX = (int)((float)n9 * 2.54f + 0.5f);
                        this.dpiY = (int)((float)n10 * 2.54f + 0.5f);
                    }
                    Utilities.skip(inputStream, n2 - 2 - byArray.length - 7);
                    continue;
                }
                if (n7 == 238) {
                    String string2;
                    n2 = Jpeg.getShort(inputStream) - 2;
                    byte[] byArray = new byte[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        byArray[i2] = (byte)inputStream.read();
                    }
                    if (byArray.length < 12 || !(string2 = new String(byArray, 0, 5, "ISO-8859-1")).equals("Adobe")) continue;
                    this.invert = true;
                    continue;
                }
                if (n7 == 226) {
                    String string3;
                    n2 = Jpeg.getShort(inputStream) - 2;
                    byte[] byArray = new byte[n2];
                    for (int i3 = 0; i3 < n2; ++i3) {
                        byArray[i3] = (byte)inputStream.read();
                    }
                    if (byArray.length < 14 || !(string3 = new String(byArray, 0, 11, "ISO-8859-1")).equals("ICC_PROFILE")) continue;
                    n5 = byArray[12] & 0xFF;
                    n4 = byArray[13] & 0xFF;
                    if (this.icc == null) {
                        this.icc = new byte[n4][];
                    }
                    this.icc[n5 - 1] = byArray;
                    continue;
                }
                n3 = 0;
                int n11 = Jpeg.marker(n7);
                if (n11 == 0) {
                    Utilities.skip(inputStream, 2);
                    if (inputStream.read() != 8) {
                        throw new BadElementException(string + " must have 8 bits per component.");
                    }
                    this.scaledHeight = Jpeg.getShort(inputStream);
                    this.setTop(this.scaledHeight);
                    this.scaledWidth = Jpeg.getShort(inputStream);
                    this.setRight(this.scaledWidth);
                    this.colorspace = inputStream.read();
                    this.bpc = 8;
                    break;
                }
                if (n11 == 1) {
                    throw new BadElementException(string + ": unsupported JPEG marker: " + n7);
                }
                if (n11 == 2) continue;
                Utilities.skip(inputStream, Jpeg.getShort(inputStream) - 2);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        this.plainWidth = this.getWidth();
        this.plainHeight = this.getHeight();
        if (this.icc != null) {
            int n12 = 0;
            for (n3 = 0; n3 < this.icc.length; ++n3) {
                if (this.icc[n3] == null) {
                    this.icc = null;
                    return;
                }
                n12 += this.icc[n3].length - 14;
            }
            byte[] byArray = new byte[n12];
            n12 = 0;
            for (n2 = 0; n2 < this.icc.length; ++n2) {
                System.arraycopy(this.icc[n2], 14, byArray, n12, this.icc[n2].length - 14);
                n12 += this.icc[n2].length - 14;
            }
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(byArray);
            this.tagICC(iCC_Profile);
            this.icc = null;
        }
    }
}

