/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.xml;

import com.klg.jclass.util.xml.JCTablePopulator;
import com.klg.jclass.util.xml.JCTableXMLParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCXMLTableModel
extends DefaultTableModel
implements JCTablePopulator {
    protected JCTableXMLParser parser;
    protected String charsetName = "JISAutoDetect";

    public JCXMLTableModel() {
        this.parser = new JCTableXMLParser();
    }

    public JCXMLTableModel(Locale locale) {
        this.parser = new JCTableXMLParser(locale);
    }

    public JCXMLTableModel(InputStream inputStream) throws IOException {
        this.parser = new JCTableXMLParser();
        this.readFromStream(inputStream);
    }

    public JCXMLTableModel(InputStream inputStream, Locale locale) throws IOException {
        this.parser = new JCTableXMLParser(locale);
        this.readFromStream(inputStream);
    }

    public JCXMLTableModel(InputStream inputStream, String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("charsetName cannot be null");
        }
        this.charsetName = string;
        this.parser = new JCTableXMLParser();
        this.readFromStream(inputStream);
    }

    public JCXMLTableModel(InputStream inputStream, Locale locale, String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("charsetName cannot be null");
        }
        this.charsetName = string;
        this.parser = new JCTableXMLParser(locale);
        this.readFromStream(inputStream);
    }

    protected void readFromStream(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader;
        if (inputStream == null) {
            throw new IOException("Null InputStream passed to readFromStream()");
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.charsetName));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.charsetName.equals("JISAutoDetect")) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            throw unsupportedEncodingException;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (this.charsetName.equals("JISAutoDetect")) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            throw unsupportedOperationException;
        }
        this.read(bufferedReader);
    }

    public void read(Reader reader) throws IOException {
        this.parser.readAndParse(reader, this);
    }

    @Override
    public void setTableData(Vector<?> vector, Vector<?> vector2, Vector<?> vector3, int n2, int n3) {
        this.setDataVector(vector, vector3);
    }
}

