/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.xml;

import com.klg.jclass.util.io.JCParseException;
import com.klg.jclass.util.xml.JCTablePopulator;
import com.klg.jclass.util.xml.JCXMLDTDResolver;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JCTableXMLParser
implements Serializable {
    public static final String XML_DS = "JCTableData";
    public static final String XML_DS_COLUMNLABEL = "ColumnLabel";
    public static final String XML_DS_ROWLABEL = "RowLabel";
    public static final String XML_DS_ROW = "Row";
    public static final String XML_DS_ROW_CELL = "Cell";
    protected NumberFormat format = null;
    protected char decimalSeparator = (char)46;
    protected Locale locale = null;

    public JCTableXMLParser() {
        this(null);
    }

    public JCTableXMLParser(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        this.decimalSeparator = decimalFormatSymbols.getDecimalSeparator();
    }

    public void readAndParse(Reader reader, JCTablePopulator jCTablePopulator) throws IOException {
        Document document;
        InputSource inputSource = new InputSource(reader);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            inputSource.setSystemId("file:/template.xml");
            documentBuilder.setErrorHandler(new JCXMLErrorPrinter());
            documentBuilder.setEntityResolver(new JCXMLDTDResolver("JCTableData.dtd", jCTablePopulator.getClass()));
            document = documentBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace(System.err);
            throw new JCParseException("XML Parser Configuration Error", parserConfigurationException);
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
            throw new JCParseException("XML Parsing Error", sAXParseException);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
            throw new JCParseException("XML Error", sAXException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw iOException;
        }
        if (document == null) {
            return;
        }
        this.readTableData(document, jCTablePopulator);
    }

    protected void readTableData(Document document, JCTablePopulator jCTablePopulator) throws IOException {
        Node node;
        Object object;
        int n2;
        Object object2;
        Object object3;
        NodeList nodeList = document.getElementsByTagName(XML_DS);
        Node node2 = nodeList.item(0);
        node2.normalize();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        NodeList nodeList2 = ((Element)node2).getElementsByTagName(XML_DS_COLUMNLABEL);
        int n5 = nodeList2.getLength();
        if (n5 > 0) {
            bl2 = true;
        }
        n4 = Math.max(n4, n5);
        NodeList nodeList3 = ((Element)node2).getElementsByTagName(XML_DS_ROW);
        for (int i2 = 0; i2 < nodeList3.getLength(); ++i2) {
            object3 = nodeList3.item(i2);
            ++n3;
            object2 = ((Element)object3).getElementsByTagName(XML_DS_ROW_CELL);
            n2 = object2.getLength();
            n4 = Math.max(n4, n2);
            NodeList nodeList4 = ((Element)object3).getElementsByTagName(XML_DS_ROWLABEL);
            if (bl || nodeList4.getLength() <= 0) continue;
            bl = true;
        }
        Vector<Object> vector = new Vector<Object>();
        object3 = new Vector();
        object2 = new Vector();
        if (bl2) {
            n2 = 0;
            for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
                object = nodeList2.item(i3);
                Object object4 = null;
                if (object != null) {
                    object4 = (object = object.getFirstChild()) != null && object instanceof Text ? this.cvtToTableValue(object.getNodeValue()) : "";
                }
                ((Vector)object2).addElement(object4);
                ++n2;
            }
        }
        for (n2 = 0; n2 < nodeList3.getLength() && (node = nodeList3.item(n2)) != null; ++n2) {
            Object object5;
            if (bl) {
                object = null;
                NodeList nodeList5 = ((Element)node).getElementsByTagName(XML_DS_ROWLABEL);
                object5 = nodeList5.item(0);
                if (object5 != null) {
                    if ((object5 = object5.getFirstChild()) != null && object5 instanceof Text) {
                        object = this.cvtToTableValue(object5.getNodeValue());
                    }
                } else {
                    object = null;
                }
                ((Vector)object3).addElement(object);
            }
            object = new Vector();
            int n6 = 0;
            object5 = ((Element)node).getElementsByTagName(XML_DS_ROW_CELL);
            for (int i4 = 0; i4 < object5.getLength(); ++i4) {
                Node node3 = object5.item(i4);
                Object object6 = null;
                if (node3 != null && (node3 = node3.getFirstChild()) != null && node3 instanceof Text) {
                    object6 = this.cvtToTableValue(node3.getNodeValue());
                }
                ((Vector)object).addElement(object6);
                ++n6;
            }
            vector.addElement(object);
        }
        jCTablePopulator.setTableData(vector, (Vector<?>)object3, (Vector<?>)object2, n3, n4);
    }

    protected Object cvtToTableValue(String string) {
        if (this.format == null) {
            this.format = NumberFormat.getInstance(this.locale);
        }
        Object object = string;
        if (string != null) {
            try {
                String string2 = string.trim();
                object = string2.indexOf(this.decimalSeparator) >= 0 ? (Number)new Double(string2) : (Number)this.format.parse(string2);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return object;
    }
}

