/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.swing.JCMessageHelper;
import com.klg.jclass.util.swing.encode.Encoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import com.klg.jclass.util.swing.encode.resources.LocaleBundle;
import java.awt.Component;
import java.awt.Image;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JCEncodeComponent {
    public static final Encoding GIF = new Encoding("GIF", "CompuServe Graphic Interchange File", "com.klg.jclass.util.swing.encode.GIFEncoder", LocaleBundle.string("ENCODER_LOAD_ERROR"));
    public static final Encoding PNG = new Encoding("PNG", "Portable Network Graphics (javax.imageio) ", "com.klg.jclass.util.swing.encode.PNGImageIOEncoder", LocaleBundle.string("ENCODER_LOAD_ERROR"));
    public static final Encoding PNG_JCLASS = new Encoding("PNG_JCLASS", "Portable Network Graphics (JClass)", "com.klg.jclass.util.swing.encode.PNGEncoder", LocaleBundle.string("ENCODER_LOAD_ERROR"));
    public static final Encoding SVG = new Encoding("SVG", "Scalable Vector Graphics", "com.klg.jclass.util.swing.encode.SVGEncoder", LocaleBundle.string("ENCODER_LOAD_ERROR"));
    public static final Encoding SWF = new Encoding("SWF", "Shockwave Flash", "com.klg.jclass.util.swing.encode.swf.SWFEncoder", LocaleBundle.string("ENCODER_LOAD_ERROR"));
    public static final Encoding JPEG = new Encoding("JPEG", "Joint Photographic Experts Group (com.sun.image.codec)", "com.klg.jclass.util.swing.encode.JPEGEncoder", LocaleBundle.string("ENCODER_LOAD_ERROR"));
    public static final Encoding EPS = new Encoding("EPS", "Encapsulated PostScript", "com.klg.jclass.util.swing.encode.page.EPSEncoder", LocaleBundle.string("ENCODE_NEEDS_JCLASS_PAGELAYOUT"));
    public static final Encoding PCL = new Encoding("PCL", "HP Page Control Language Version 5", "com.klg.jclass.util.swing.encode.page.PCLEncoder", LocaleBundle.string("ENCODE_NEEDS_JCLASS_PAGELAYOUT"));
    public static final Encoding PS = new Encoding("PS", "Adobe PostScript Level 2", "com.klg.jclass.util.swing.encode.page.PSEncoder", LocaleBundle.string("ENCODE_NEEDS_JCLASS_PAGELAYOUT"));
    public static final Encoding PDF = new Encoding("PDF", "Adobe Acrobat Portable Document File", "com.klg.jclass.util.swing.encode.page.PDFEncoder", LocaleBundle.string("ENCODE_NEEDS_JCLASS_PAGELAYOUT"));
    public static final Encoding RTF = new Encoding("RTF", "Microsoft Rich Text Format", "com.klg.jclass.util.swing.encode.sreport.RTFEncoder", LocaleBundle.string("ENCODE_NEEDS_JCLASS_SERVERREPORT"));
    public static final Encoding[] ENCODINGS = new Encoding[]{PNG, GIF, JPEG, EPS, PCL, PDF, PS};
    public static final Encoding[] SERVER_ENCODINGS = new Encoding[]{PNG, GIF, JPEG, SWF, SVG, PDF, RTF};
    public static final Encoding[] IMAGE_ENCODINGS = new Encoding[]{PNG, GIF, JPEG, PNG_JCLASS};

    public static void encode(Encoding encoding, Component component, OutputStream outputStream) throws IOException, EncoderException {
        Encoder encoder = JCEncodeComponent.findEncoder(encoding, component.isShowing());
        if (encoder != null) {
            encoder.encode(component, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(Encoding encoding, Component component, File file) throws IOException, EncoderException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
            JCEncodeComponent.encode(encoding, component, (OutputStream)bufferedOutputStream);
        }
        finally {
            bufferedOutputStream.close();
        }
    }

    public static void encode(Encoding encoding, Image image, OutputStream outputStream) throws IOException, EncoderException {
        Encoder encoder = JCEncodeComponent.findEncoder(encoding, false);
        if (encoder != null) {
            encoder.encode(image, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(Encoding encoding, Image image, File file) throws IOException, EncoderException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
            JCEncodeComponent.encode(encoding, image, (OutputStream)bufferedOutputStream);
        }
        finally {
            bufferedOutputStream.close();
        }
    }

    public static Encoder findEncoder(Encoding encoding, boolean bl) throws EncoderException {
        Encoder encoder = encoding.getEncoder();
        if (encoder == null) {
            if (bl) {
                String string = LocaleBundle.string("ENCODE_DIALOG_TITLE");
                JCMessageHelper.showError(string, encoding.getFailureMessage());
            }
            throw new EncoderException(encoding.getFailureMessage());
        }
        return encoder;
    }

    public static boolean isImageBasedEncoding(Encoding encoding) {
        for (Encoding encoding2 : IMAGE_ENCODINGS) {
            if (encoding2 != encoding) continue;
            return true;
        }
        return false;
    }

    public static class Encoding {
        private String shortName;
        private String longName;
        private String encoderClass;
        private String failureMessage;

        public Encoding(String string, String string2, String string3, String string4) {
            this.shortName = string;
            this.longName = string2;
            this.encoderClass = string3;
            this.failureMessage = string4;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getLongName() {
            return this.longName;
        }

        public String toString() {
            return this.getLongName() + " (" + this.getShortName() + ")";
        }

        public String getFailureMessage() {
            return this.failureMessage;
        }

        public Encoder getEncoder() {
            Encoder encoder = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.encoderClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null) {
                try {
                    encoder = (Encoder)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return encoder;
        }
    }
}

