/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.swing.encode.AbstractImageEncoder;
import com.klg.jclass.util.swing.encode.EncodeTree;
import com.klg.jclass.util.swing.encode.EncoderException;
import com.klg.jclass.util.swing.encode.OutputBlock;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class GIFEncoder
extends AbstractImageEncoder {
    public void saveImage(Image image, OutputStream outputStream) throws IOException, EncoderException {
        int n2;
        byte by;
        int n3;
        int n4;
        byte by2;
        byte by3;
        int n5;
        int n6;
        int n7;
        boolean bl;
        byte[] byArray;
        int n8;
        int n9;
        ColorModel colorModel;
        block27: {
            int n10;
            if (image == null) {
                this.error("GIF encoding error: Image is NULL.");
            }
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), false);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                this.error("GIF encoding error: Unable to retrieve pixels from image.");
            }
            colorModel = pixelGrabber.getColorModel();
            n9 = colorModel.getPixelSize();
            n8 = (int)Math.pow(2.0, n9);
            byArray = null;
            if (n9 == 8) {
                byArray = (byte[])pixelGrabber.getPixels();
            }
            bl = false;
            n7 = 0;
            if (n9 <= 8) break block27;
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            byte[] byArray4 = new byte[256];
            for (int i2 = 0; i2 < 255; ++i2) {
                byArray2[i2] = 0;
                byArray3[i2] = 0;
                byArray4[i2] = 0;
            }
            int[] nArray = (int[])pixelGrabber.getPixels();
            byArray = new byte[nArray.length];
            n6 = 0;
            for (n10 = 0; n10 < nArray.length && n6 < 256; ++n10) {
                block29: {
                    block28: {
                        n5 = nArray[n10];
                        by3 = GIFEncoder.byteFromInt(colorModel.getRed(n5));
                        by2 = GIFEncoder.byteFromInt(colorModel.getGreen(n5));
                        n4 = GIFEncoder.byteFromInt(colorModel.getBlue(n5));
                        n3 = GIFEncoder.byteFromInt(colorModel.getAlpha(n5));
                        by = 0;
                        if (n3 != 0) break block28;
                        if (!bl) break block29;
                        by = 1;
                        byArray[n10] = GIFEncoder.byteFromInt(n7);
                        break block29;
                    }
                    for (n2 = 0; n2 < n6; ++n2) {
                        if (byArray2[n2] != by3 || byArray3[n2] != by2 || byArray4[n2] != n4 || bl && (!bl || n7 == n2)) continue;
                        by = 1;
                        byArray[n10] = GIFEncoder.byteFromInt(n2);
                        break;
                    }
                }
                if (by != 0) continue;
                if (n3 == 0) {
                    if (!bl) {
                        bl = true;
                        n7 = n6;
                    }
                } else {
                    byArray2[n6] = by3;
                    byArray3[n6] = by2;
                    byArray4[n6] = n4;
                }
                byArray[n10] = GIFEncoder.byteFromInt(n6);
                ++n6;
            }
            if (n6 > 255) {
                ColorModel colorModel2 = colorModel;
                if ((colorModel = this.palettizePixels(nArray, byArray, colorModel2)) == null) {
                    this.error("GIF encoding error: byte array is wrong size.");
                }
                bl = colorModel instanceof IndexColorModel ? (n7 = ((IndexColorModel)colorModel).getTransparentPixel()) != -1 : false;
            } else if (bl) {
                n10 = 0;
                n5 = 0;
                while (n5 <= 255 & n10 == 0) {
                    by3 = 0;
                    while (by3 <= 255 & n10 == 0) {
                        by2 = 0;
                        while (by2 <= 255 & n10 == 0) {
                            n4 = 0;
                            for (n3 = 0; n3 < n6; ++n3) {
                                if (byArray2[n3] != n5 || byArray3[n3] != by3 || byArray4[n3] != by2) continue;
                                n4 = 1;
                                break;
                            }
                            if (n4 == 0) {
                                byArray2[n7] = n5;
                                byArray3[n7] = by3;
                                byArray4[n7] = by2;
                                n10 = 1;
                            }
                            by2 = (byte)(by2 + 1);
                        }
                        by3 = (byte)(by3 + 1);
                    }
                    n5 = (byte)(n5 + 1);
                }
                colorModel = new IndexColorModel(8, 256, byArray2, byArray3, byArray4, n7);
            } else {
                colorModel = new IndexColorModel(8, 256, byArray2, byArray3, byArray4);
            }
            n9 = 8;
            n8 = (int)Math.pow(2.0, n9);
        }
        this.writeChar(outputStream, 'G');
        this.writeChar(outputStream, 'I');
        this.writeChar(outputStream, 'F');
        this.writeChar(outputStream, '8');
        if (bl) {
            this.writeChar(outputStream, '9');
        } else {
            this.writeChar(outputStream, '7');
        }
        this.writeChar(outputStream, 'a');
        short s = (short)image.getWidth(null);
        short s2 = (short)image.getHeight(null);
        byte by4 = (byte)(s & 0xFF);
        byte by5 = (byte)((s & 0xFF00) / 256);
        n6 = (byte)(s2 & 0xFF);
        byte by6 = (byte)((s2 & 0xFF00) / 256);
        outputStream.write(by4);
        outputStream.write(by5);
        outputStream.write(n6);
        outputStream.write(by6);
        n5 = 0;
        by3 = 0;
        by2 = 0;
        if ((--n9 & 4) != 0) {
            n5 = 1;
        }
        if ((n9 & 2) != 0) {
            by3 = 1;
        }
        if ((n9 & 1) != 0) {
            by2 = 1;
        }
        ++n9;
        outputStream.write(GIFEncoder.createByte(1, 1, 1, 1, 0, n5, by3, by2));
        outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
        outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
        n4 = 255;
        for (n3 = 0; n3 < n8; ++n3) {
            by = (byte)(n4 & colorModel.getRed(n3));
            n2 = (byte)(n4 & colorModel.getGreen(n3));
            byte by7 = (byte)(n4 & colorModel.getBlue(n3));
            outputStream.write(by);
            outputStream.write(n2);
            outputStream.write(by7);
        }
        if (bl) {
            outputStream.write(GIFEncoder.createByte(0, 0, 1, 0, 0, 0, 0, 1));
            outputStream.write(GIFEncoder.createByte(1, 1, 1, 1, 1, 0, 0, 1));
            outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 1, 0, 0));
            outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 1));
            outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
            outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
            outputStream.write((byte)(n7 & 0xFF));
            outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
        }
        outputStream.write(GIFEncoder.createByte(0, 0, 1, 0, 1, 1, 0, 0));
        outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
        outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
        outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
        outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
        outputStream.write(by4);
        outputStream.write(by5);
        outputStream.write(n6);
        outputStream.write(by6);
        outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, n5, by3, by2));
        this.compress(outputStream, byArray, n9);
        outputStream.write(GIFEncoder.createByte(0, 0, 1, 1, 1, 0, 1, 1));
    }

    public ColorModel palettizePixels(int[] nArray, byte[] byArray, ColorModel colorModel) {
        int n2;
        int n3;
        int n4;
        byte by;
        int n5;
        int n6;
        int n7;
        if (nArray.length != byArray.length) {
            return null;
        }
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        byte[] byArray4 = new byte[256];
        boolean[] blArray = new boolean[256];
        for (n7 = 0; n7 < 256; ++n7) {
            byArray2[n7] = 0;
            byArray3[n7] = 0;
            byArray4[n7] = 0;
            blArray[n7] = false;
        }
        n7 = 0;
        for (n6 = 0; n6 < nArray.length; ++n6) {
            n5 = nArray[n6];
            by = GIFEncoder.byteFromInt(colorModel.getAlpha(n5));
            if (by != 0) {
                n4 = colorModel.getRGB(n5);
                n3 = this.compressColor(n4);
                n2 = n3 & 0xFF;
                byArray2[n2] = (byte)(n3 & 0xE0 | ((n3 & 0xE0) != 0 ? 31 : 0));
                byArray3[n2] = (byte)(n3 << 3 & 0xE0 | ((n3 & 0x1C) != 0 ? 31 : 0));
                byArray4[n2] = (byte)(n3 << 6 & 0xC0 | ((n3 & 3) != 0 ? 63 : 0));
                blArray[n2] = true;
                byArray[n6] = GIFEncoder.byteFromInt(n2);
                continue;
            }
            n7 = 1;
        }
        if (n7 != 0) {
            n6 = -1;
            by = 0;
            for (n5 = 0; n5 < blArray.length && by == 0; ++n5) {
                if (blArray[n5]) continue;
                n6 = n5;
                by = 1;
            }
            if (n6 < 0) {
                n4 = 4;
                n3 = 0;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    int n8 = nArray[n2];
                    byte by2 = GIFEncoder.byteFromInt(colorModel.getAlpha(n8));
                    if (by2 == 0 || byArray[n2] != n4) continue;
                    byArray[n2] = GIFEncoder.byteFromInt(n3);
                }
                n6 = 4;
            }
            byArray2[n6] = (byte)(n6 & 0xE0 | ((n6 & 0xE0) != 0 ? 31 : 0));
            byArray3[n6] = (byte)(n6 << 3 & 0xE0 | ((n6 & 0x1C) != 0 ? 31 : 0));
            byArray4[n6] = (byte)(n6 << 6 & 0xC0 | ((n6 & 3) != 0 ? 31 : 0));
            for (n4 = 0; n4 < nArray.length; ++n4) {
                n3 = nArray[n4];
                n2 = GIFEncoder.byteFromInt(colorModel.getAlpha(n3));
                if (n2 != 0) continue;
                byArray[n4] = GIFEncoder.byteFromInt(n6);
            }
            return new IndexColorModel(8, 256, byArray2, byArray3, byArray4, n6);
        }
        return new IndexColorModel(8, 256, byArray2, byArray3, byArray4);
    }

    public void writeChar(OutputStream outputStream, char c2) throws IOException {
        char c3 = c2;
        int n2 = 0;
        for (int i2 = 0; i2 <= 7; ++i2) {
            if ((c3 & (byte)Math.pow(2.0, i2)) == 0) continue;
            n2 = (byte)(n2 | (byte)Math.pow(2.0, i2));
        }
        outputStream.write(n2);
    }

    void compress(OutputStream outputStream, byte[] byArray, int n2) throws EncoderException, IOException {
        byte by;
        int n3 = n2 + 1;
        int n4 = byArray.length;
        OutputBlock outputBlock = new OutputBlock(outputStream);
        int n5 = (int)Math.pow(2.0, n2);
        long l2 = n5 + 2;
        outputStream.write(GIFEncoder.byteFromInt(n2));
        if (n4 == 0) {
            this.error("GIF encoding error: Image contains no data.");
        }
        int n6 = 0;
        EncodeTree encodeTree = new EncodeTree(0);
        encodeTree.code = 0L;
        byte by2 = (int)Math.pow(2.0, n2);
        for (by = 1; by < by2; ++by) {
            encodeTree.addSibling(GIFEncoder.byteFromInt(by), by);
        }
        by = byArray[n6];
        ++n6;
        outputBlock.addCode(n5, n3);
        while (n6 < n4) {
            EncodeTree encodeTree2;
            EncodeTree encodeTree3 = encodeTree2 = encodeTree.findValue(by);
            while (encodeTree2.children != null) {
                encodeTree2 = encodeTree2.children.findValue(byArray[n6]);
                if (encodeTree2 == null) {
                    encodeTree2 = encodeTree3;
                    break;
                }
                encodeTree3 = encodeTree2;
                if (++n6 < n4) continue;
            }
            if (n6 >= n4) {
                outputBlock.addCode(encodeTree3.code, n3);
                break;
            }
            encodeTree2.addChild(byArray[n6], l2);
            outputBlock.addCode(encodeTree3.code, n3);
            if ((long)((int)Math.pow(2.0, n3)) == l2) {
                ++n3;
            }
            by = byArray[n6];
            if (++l2 == 4096L) {
                outputBlock.addCode(n5, n3);
                n3 = n2 + 1;
                l2 = n5 + 2;
                encodeTree2 = encodeTree;
                while (encodeTree2 != null) {
                    encodeTree2.children = null;
                    encodeTree2 = encodeTree2.sibling;
                }
            }
            if (++n6 < n4) continue;
            outputBlock.addCode(by, n3);
        }
        outputBlock.addCode(n5 + 1, n3);
        outputBlock.write();
        outputStream.write(GIFEncoder.createByte(0, 0, 0, 0, 0, 0, 0, 0));
    }
}

