/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.swing.encode.Encoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import com.klg.jclass.util.swing.encode.EncoderProperties;
import com.klg.jclass.util.swing.encode.Java3dImageable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractImageEncoder
implements Encoder,
EncoderProperties {
    protected boolean hiddenSurfaces = false;
    protected String componentName = null;

    public void encode(Image image, OutputStream outputStream) throws IOException, EncoderException {
        this.saveImage(image, outputStream);
    }

    public void encode(Component component, OutputStream outputStream) throws IOException, EncoderException {
        this.encode(AbstractImageEncoder.snapshot(component), outputStream);
    }

    public void setHiddenSurfaces(boolean bl) {
        this.hiddenSurfaces = bl;
    }

    public boolean hasHiddenSurfaces() {
        return this.hiddenSurfaces;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String string) {
        this.componentName = string;
    }

    public static Image snapshot(Component component) {
        Image image;
        Dimension dimension = component.getSize();
        try {
            image = new BufferedImage(dimension.width, dimension.height, 2);
        }
        catch (Exception exception) {
            image = component.createImage(dimension.width, dimension.height);
        }
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, component.getSize().width, component.getSize().height);
            component.paint(graphics);
            AbstractImageEncoder.snapshotJava3d(component, graphics);
        }
        return image;
    }

    protected static void snapshotJava3d(Component component, Graphics graphics) {
        Component[] componentArray;
        Component[] componentArray2;
        if (component instanceof Java3dImageable && (componentArray2 = ((Java3dImageable)((Object)component)).getJava3dAsImage((Point)(componentArray = new Point()))) != null) {
            graphics.drawImage((Image)componentArray2, componentArray.x, componentArray.y, null);
        }
        if (component instanceof Container && ((Container)component).getComponentCount() > 0) {
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                Point point = component2.getLocation();
                graphics.translate(point.x, point.y);
                AbstractImageEncoder.snapshotJava3d(component2, graphics);
                graphics.translate(-point.x, -point.y);
            }
        }
    }

    public abstract void saveImage(Image var1, OutputStream var2) throws IOException, EncoderException;

    public static byte createByte(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        byte by = 0;
        if (n9 == 1) {
            by = (byte)(by | 1);
        }
        if (n8 == 1) {
            by = (byte)(by | 2);
        }
        if (n7 == 1) {
            by = (byte)(by | 4);
        }
        if (n6 == 1) {
            by = (byte)(by | 8);
        }
        if (n5 == 1) {
            by = (byte)(by | 0x10);
        }
        if (n4 == 1) {
            by = (byte)(by | 0x20);
        }
        if (n3 == 1) {
            by = (byte)(by | 0x40);
        }
        if (n2 == 1) {
            by = (byte)(by | 0x80);
        }
        return by;
    }

    public static byte byteFromInt(int n2) {
        return (byte)(n2 & 0xFF);
    }

    public static byte[] bytesFromInt(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return byArray;
    }

    public static byte[] bytesFromLong(long l2) {
        byte[] byArray = new byte[]{(byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 & 0xFFL)};
        return byArray;
    }

    public static byte byteFromChar(char c2) {
        char c3 = c2;
        byte by = 0;
        for (int i2 = 0; i2 <= 7; ++i2) {
            if ((c3 & (byte)Math.pow(2.0, i2)) == 0) continue;
            by = (byte)(by | (byte)Math.pow(2.0, i2));
        }
        return by;
    }

    public byte compressColor(int n2) {
        return this.compressColor(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    public byte compressColor(int n2, int n3, int n4) {
        return (byte)(n2 & 0xE0 | n3 >> 3 & 0x1C | n4 >> 6 & 3);
    }

    protected void error(String string) throws EncoderException {
        throw new EncoderException(string);
    }

    public static BufferedImage makeBufferedImage(Image image, int n2) {
        if (image == null) {
            return null;
        }
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (n3 < 0 || n4 < 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }
}

