/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.beans;

import com.klg.jclass.beans.AbstractBeanEditor;
import com.klg.jclass.util.calendar.JCDateChooser;
import com.klg.jclass.util.swing.JCExitFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class DateChooserEditor
extends AbstractBeanEditor
implements ActionListener {
    public static final String DATECHOOSER_HELP = "DataChooser";
    protected Calendar date;
    protected JCDateChooser dateChooser;

    public DateChooserEditor() {
        super("com.klg.jclass.util.swing.beans.resources.LocaleInfo", DATECHOOSER_HELP, "Date Chooser Editor");
    }

    public Component getEditorComponent() {
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        this.dateChooser = new JCDateChooser();
        this.dateChooser.addActionListener(this);
        jPanel.add(this.dateChooser);
        return jPanel;
    }

    public String getJavaInitializationString() {
        String string = "null";
        if (this.date != null) {
            string = "new java.util.GregorianCalendar(" + this.date.get(1) + ", " + this.date.get(2) + ", " + this.date.get(5) + ")";
        }
        return string;
    }

    public Object getValue() {
        return this.date == null ? null : this.date.clone();
    }

    protected String getValueAsText() {
        String string = "none";
        if (this.date != null) {
            DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.getDefault());
            string = dateFormat.format(this.date.getTime());
        }
        return string;
    }

    public void setValue(Object object) {
        this.date = object == null ? null : (Calendar)((Calendar)object).clone();
        if (this.dateChooser != null) {
            Calendar calendar = this.date == null ? Calendar.getInstance() : this.date;
            this.dateChooser.setValue(calendar);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.dateChooser) {
            this.date = this.dateChooser.getValue();
            this.support.firePropertyChange(null, null, null);
        }
    }

    public static void main(String[] stringArray) {
        JCExitFrame jCExitFrame = new JCExitFrame();
        jCExitFrame.getContentPane().add(new DateChooserEditor());
        jCExitFrame.pack();
        jCExitFrame.setVisible(true);
    }
}

