/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCStringTokenizer;
import com.klg.jclass.util.JCTypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.UIResource;

public class JCSwingTypeConverter {
    public static final Color lightBlue = new Color(173, 216, 230);
    public static final int[] positionValues = new int[]{0, 1, 2, 3, 4, 5, 6};
    public static final String[] positionStrings = new String[]{"Default", "Above_Top", "Top", "Below_Top", "Above_Bottom", "Bottom", "Below_Bottom"};
    public static final int[] justificationValues = new int[]{0, 1, 2, 3, 4, 5};
    public static final String[] justificationStrings = new String[]{"Default", "Left", "Center", "Right", "Leading", "Trailing"};
    public static final int[] horizontalAlignmentValues = new int[]{2, 0, 4, 10, 11};
    public static final String[] horizontalAlignmentStrings = new String[]{"Left", "Center", "Right", "Leading", "Trailing"};
    public static final int[] verticalAlignmentValues = new int[]{1, 0, 3};
    public static final String[] verticalAlignmentStrings = new String[]{"Top", "Center", "Bottom"};

    public static Color[] toColorList(String string, Color[] colorArray) {
        Color[] colorArray2 = JCSwingTypeConverter.toColorList(string);
        return string != null ? colorArray2 : colorArray;
    }

    public static Color[] toColorList(String string) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Color[] colorArray = new Color[jCStringTokenizer.countTokens(',')];
        int n2 = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(',').trim();
            colorArray[n2] = JCSwingTypeConverter.toColor(string2);
            if (colorArray[n2] == null) {
                JCTypeConverter.error(string, string2);
            }
            ++n2;
        }
        return colorArray;
    }

    public static Color toColor(String string, Color color) {
        Color color2 = JCSwingTypeConverter.toColor(string);
        return string != null ? color2 : color;
    }

    public static Color toColor(String string) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String string2 = jCStringTokenizer.nextToken('-');
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string2.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string2.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string2.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase("darkGrey")) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase("grey")) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string2.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase("lightGrey")) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase("lightBlue")) {
            return lightBlue;
        }
        if (string2.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string2.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string2.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string2.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string2.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string2.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        try {
            if (string2.startsWith("#")) {
                String string3 = null;
                if (string2.length() >= 13) {
                    if (string2.length() >= 17) {
                        string3 = string2.substring(13, 17);
                    }
                    int n2 = string3 != null ? Integer.valueOf(string3, 16) / 256 : 255;
                    return new Color(Integer.valueOf(string2.substring(1, 5), 16) / 256, Integer.valueOf(string2.substring(5, 9), 16) / 256, Integer.valueOf(string2.substring(9, 13), 16) / 256, n2);
                }
                if (string2.length() >= 7) {
                    if (string2.length() >= 9) {
                        string3 = string2.substring(7, 9);
                    }
                    int n3 = string3 != null ? Integer.valueOf(string3, 16) : 255;
                    return new Color(Integer.valueOf(string2.substring(1, 3), 16), Integer.valueOf(string2.substring(3, 5), 16), Integer.valueOf(string2.substring(5, 7), 16), n3);
                }
                return new Color(Integer.valueOf(string2.substring(1), 16));
            }
            int n4 = Integer.parseInt(string2);
            int n5 = Integer.parseInt(jCStringTokenizer.nextToken('-'));
            int n6 = Integer.parseInt(jCStringTokenizer.nextToken('-'));
            int n7 = 255;
            String string4 = jCStringTokenizer.nextToken('-');
            if (string4 != null) {
                n7 = Integer.parseInt(string4);
            }
            return new Color(n4, n5, n6, n7);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String fromColorList(Color[] colorArray) {
        if (colorArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(JCSwingTypeConverter.fromColor(colorArray[i2]));
        }
        return new String(stringBuffer);
    }

    public static String fromColor(Color color) {
        if (color == null) {
            return null;
        }
        if (color.equals(Color.black)) {
            return "black";
        }
        if (color.equals(Color.blue)) {
            return "blue";
        }
        if (color.equals(Color.cyan)) {
            return "cyan";
        }
        if (color.equals(Color.darkGray)) {
            return "darkGray";
        }
        if (color.equals(Color.gray)) {
            return "gray";
        }
        if (color.equals(Color.green)) {
            return "green";
        }
        if (color.equals(lightBlue)) {
            return "lightBlue";
        }
        if (color.equals(Color.lightGray)) {
            return "lightGray";
        }
        if (color.equals(Color.magenta)) {
            return "magenta";
        }
        if (color.equals(Color.orange)) {
            return "orange";
        }
        if (color.equals(Color.pink)) {
            return "pink";
        }
        if (color.equals(Color.red)) {
            return "red";
        }
        if (color.equals(Color.white)) {
            return "white";
        }
        if (color.equals(Color.yellow)) {
            return "yellow";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(color.getRed());
        stringBuffer.append("-");
        stringBuffer.append(color.getGreen());
        stringBuffer.append("-");
        stringBuffer.append(color.getBlue());
        int n2 = color.getAlpha();
        if (n2 < 255) {
            stringBuffer.append("-");
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public static Font toFont(String string, Font font) {
        Font font2 = JCSwingTypeConverter.toFont(string);
        return font2 != null ? font2 : font;
    }

    public static Font toFont(String string) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        int n2 = jCStringTokenizer.countTokens('-');
        if (n2 < 3) {
            return null;
        }
        String string2 = jCStringTokenizer.nextToken('-');
        while (n2 > 3) {
            string2 = string2 + "-" + jCStringTokenizer.nextToken('-');
            --n2;
        }
        if (string2 == null) {
            return null;
        }
        string2 = string2.trim();
        String string3 = jCStringTokenizer.nextToken('-');
        int n3 = JCSwingTypeConverter.toFontStyle(string3);
        String string4 = jCStringTokenizer.nextToken('-');
        int n4 = 8;
        if (string4 != null) {
            n4 = Integer.parseInt(string4.trim());
        }
        return new Font(string2, n3, n4);
    }

    public static String fromFont(Font font) {
        if (font == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append("-");
        stringBuffer.append(JCSwingTypeConverter.fromFontStyle(font));
        stringBuffer.append("-");
        stringBuffer.append(font.getSize());
        return stringBuffer.toString();
    }

    public static String fromFontStyle(Font font) {
        if (font == null) {
            return "PLAIN";
        }
        switch (font.getStyle()) {
            case 2: {
                return "ITALIC";
            }
            case 1: {
                return "BOLD";
            }
            case 3: {
                return "BOLDITALIC";
            }
        }
        return "PLAIN";
    }

    public static int toFontStyle(String string) {
        int n2 = 0;
        if (string != null) {
            if ((string = string.trim()).equalsIgnoreCase("PLAIN")) {
                n2 = 0;
            }
            if (string.equalsIgnoreCase("ITALIC")) {
                n2 = 2;
            }
            if (string.equalsIgnoreCase("BOLD")) {
                n2 = 1;
            }
            if (string.equalsIgnoreCase("BOLDITALIC") || string.equalsIgnoreCase("BOLD_ITALIC")) {
                n2 = 3;
            }
        }
        return n2;
    }

    public static String fromFontStyleToXML(Font font) {
        switch (font.getStyle()) {
            case 2: {
                return "Italic";
            }
            case 1: {
                return "Bold";
            }
            case 3: {
                return "Bold_Italic";
            }
        }
        return "Plain";
    }

    public static Insets toInsets(String string, Insets insets) {
        if (string == null) {
            return insets;
        }
        int[] nArray = JCTypeConverter.toIntList(string, ',', null);
        if (nArray != null && nArray.length == 4) {
            return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return insets;
    }

    public static String fromInsets(Insets insets) {
        return insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right;
    }

    public static Dimension toDimension(String string, Dimension dimension) {
        int[] nArray = JCTypeConverter.toIntList(string, 'x', null);
        if (nArray != null && nArray.length == 2) {
            return new Dimension(nArray[0], nArray[1]);
        }
        return dimension;
    }

    public static Point toPoint(String string, Point point) {
        int[] nArray = JCTypeConverter.toIntList(string, ',', null);
        if (nArray != null && nArray.length == 2) {
            return new Point(nArray[0], nArray[1]);
        }
        return point;
    }

    public static String fromInsetsToIntList(Insets insets) {
        return JCSwingTypeConverter.fromInsetsToIntList(insets, ", ");
    }

    public static String fromInsetsToIntList(Insets insets, String string) {
        if (insets == null) {
            return "0" + string + "0" + string + "0" + string + "0";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(insets.top);
        stringBuffer.append(string);
        stringBuffer.append(insets.left);
        stringBuffer.append(string);
        stringBuffer.append(insets.bottom);
        stringBuffer.append(string);
        stringBuffer.append(insets.right);
        return stringBuffer.toString();
    }

    public static Border toBorder(String string) {
        JCStringTokenizer jCStringTokenizer;
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer2 = new JCStringTokenizer(string);
        char c2 = '|';
        String string2 = jCStringTokenizer2.nextToken(c2);
        if (string2 == null) {
            return null;
        }
        string2 = string2.trim();
        Border border = null;
        if (string2.equalsIgnoreCase("empty")) {
            String string3 = jCStringTokenizer2.nextToken(c2);
            String string4 = jCStringTokenizer2.nextToken(c2);
            String string5 = jCStringTokenizer2.nextToken(c2);
            String string6 = jCStringTokenizer2.nextToken(c2);
            if (string3 == null || string4 == null || string5 == null || string6 == null) {
                return null;
            }
            border = BorderFactory.createEmptyBorder(Integer.parseInt(string3), Integer.parseInt(string4), Integer.parseInt(string5), Integer.parseInt(string6));
        } else if (string2.equalsIgnoreCase("bevel")) {
            String string7 = jCStringTokenizer2.nextToken(c2);
            String string8 = jCStringTokenizer2.nextToken(c2);
            String string9 = jCStringTokenizer2.nextToken(c2);
            if (string7 != null) {
                int n2;
                int n3 = n2 = string7.equalsIgnoreCase("raised") ? 0 : 1;
                border = string8 == null || string9 == null ? new BevelBorder(n2) : new BevelBorder(n2, JCSwingTypeConverter.toColor(string8), JCSwingTypeConverter.toColor(string9));
            }
        } else if (string2.equalsIgnoreCase("softbevel")) {
            String string10 = jCStringTokenizer2.nextToken(c2);
            String string11 = jCStringTokenizer2.nextToken(c2);
            String string12 = jCStringTokenizer2.nextToken(c2);
            if (string10 != null) {
                int n4;
                int n5 = n4 = string10.equalsIgnoreCase("raised") ? 0 : 1;
                border = string11 == null || string12 == null ? new SoftBevelBorder(n4) : new SoftBevelBorder(n4, JCSwingTypeConverter.toColor(string11), JCSwingTypeConverter.toColor(string12));
            }
        } else if (string2.equalsIgnoreCase("etched")) {
            String string13 = jCStringTokenizer2.nextToken(c2);
            String string14 = jCStringTokenizer2.nextToken(c2);
            String string15 = jCStringTokenizer2.nextToken(c2);
            if (string13 != null) {
                int n6;
                int n7 = n6 = string13.equalsIgnoreCase("raised") ? 0 : 1;
                border = string14 == null || string15 == null ? new EtchedBorder(n6) : new EtchedBorder(n6, JCSwingTypeConverter.toColor(string14), JCSwingTypeConverter.toColor(string15));
            }
        } else if (string2.equalsIgnoreCase("matte")) {
            String string16 = jCStringTokenizer2.nextToken(c2);
            String string17 = jCStringTokenizer2.nextToken(c2);
            String string18 = jCStringTokenizer2.nextToken(c2);
            String string19 = jCStringTokenizer2.nextToken(c2);
            if (string16 == null || string17 == null || string18 == null || string19 == null) {
                return null;
            }
            String string20 = jCStringTokenizer2.nextToken(c2);
            border = BorderFactory.createMatteBorder(Integer.parseInt(string16), Integer.parseInt(string17), Integer.parseInt(string18), Integer.parseInt(string19), JCSwingTypeConverter.toColor(string20));
        } else if (string2.equals("line")) {
            String string21 = jCStringTokenizer2.nextToken(c2);
            String string22 = jCStringTokenizer2.nextToken(c2);
            Color color = JCSwingTypeConverter.toColor(string21, Color.black);
            int n8 = string22 == null ? 1 : Integer.parseInt(string22);
            n8 = Math.max(n8, 1);
            if (JCEnvironment.getJavaVersion() < 130) {
                border = new LineBorder(color, n8);
            } else {
                String string23 = jCStringTokenizer2.nextToken(c2);
                boolean bl = JCTypeConverter.toBoolean(string23, false);
                border = new LineBorder(color, n8, bl);
            }
        } else if (string2.equals("titled")) {
            String string24 = jCStringTokenizer2.nextToken(c2);
            String string25 = jCStringTokenizer2.nextToken(c2);
            String string26 = jCStringTokenizer2.nextToken(c2);
            String string27 = jCStringTokenizer2.nextToken(c2);
            String string28 = jCStringTokenizer2.nextToken(c2);
            if (string24 == null) {
                return null;
            }
            int n9 = JCTypeConverter.toEnum(string25, positionStrings, positionValues, 0);
            int n10 = JCTypeConverter.toEnum(string26, justificationStrings, justificationValues, 0);
            if (JCEnvironment.getJavaVersion() < 130 && n10 > 3) {
                n10 = 0;
            }
            Color color = JCSwingTypeConverter.toColor(string27);
            Font font = JCSwingTypeConverter.toFont(string28);
            Border border2 = null;
            if (jCStringTokenizer2.hasMoreTokens()) {
                border2 = JCSwingTypeConverter.toBorder(string.substring(jCStringTokenizer2.getPosition()));
            }
            border = BorderFactory.createTitledBorder(border2, string24, n10, n9, font, color);
        } else if (string2.equals("compound") && (jCStringTokenizer = new JCStringTokenizer(string)).nextToken('$') != null) {
            border = JCSwingTypeConverter.getCompoundBorder(string, jCStringTokenizer);
        }
        return border;
    }

    protected static Border getCompoundBorder(String string, JCStringTokenizer jCStringTokenizer) {
        if (string == null || jCStringTokenizer == null) {
            return null;
        }
        char c2 = '$';
        Border border = null;
        String string2 = jCStringTokenizer.nextToken(c2);
        if (string2 != null) {
            border = string2.startsWith("compound") ? JCSwingTypeConverter.getCompoundBorder(string, jCStringTokenizer) : JCSwingTypeConverter.toBorder(string2);
        }
        Border border2 = null;
        String string3 = jCStringTokenizer.nextToken(c2);
        if (string3 != null) {
            border2 = string3.startsWith("compound") ? JCSwingTypeConverter.getCompoundBorder(string, jCStringTokenizer) : JCSwingTypeConverter.toBorder(string3);
        }
        return new CompoundBorder(border, border2);
    }

    public static String fromBorder(Border border, Component component) {
        if (border == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "|";
        if (border instanceof MatteBorder) {
            stringBuffer.append("matte");
        } else if (border instanceof EmptyBorder) {
            stringBuffer.append("empty");
        } else if (border instanceof SoftBevelBorder) {
            stringBuffer.append("softbevel");
        } else if (border instanceof BevelBorder) {
            stringBuffer.append("bevel");
        } else if (border instanceof EtchedBorder) {
            stringBuffer.append("etched");
        } else if (border instanceof LineBorder) {
            stringBuffer.append("line");
        } else if (border instanceof TitledBorder) {
            stringBuffer.append("titled");
        } else if (border instanceof CompoundBorder) {
            stringBuffer.append("compound");
        } else {
            return null;
        }
        stringBuffer.append(string);
        if (border instanceof MatteBorder) {
            MatteBorder matteBorder = (MatteBorder)border;
            stringBuffer.append(JCSwingTypeConverter.fromInsetsToIntList(matteBorder.getBorderInsets(component), string));
            stringBuffer.append(string);
            String string2 = JCSwingTypeConverter.fromColor(matteBorder.getMatteColor());
            stringBuffer.append(string2 == null ? "" : string2);
        } else if (border instanceof EmptyBorder) {
            EmptyBorder emptyBorder = (EmptyBorder)border;
            stringBuffer.append(JCSwingTypeConverter.fromInsetsToIntList(emptyBorder.getBorderInsets(component), string));
        } else if (border instanceof BevelBorder) {
            BevelBorder bevelBorder = (BevelBorder)border;
            int n2 = bevelBorder.getBevelType();
            if (n2 == 0) {
                stringBuffer.append("raised");
            } else {
                stringBuffer.append("lowered");
            }
            Color color = bevelBorder.getHighlightInnerColor();
            Color color2 = bevelBorder.getShadowOuterColor();
            if (color != null || color2 != null) {
                String string3;
                stringBuffer.append(string);
                if (color == null) {
                    color = bevelBorder.getHighlightInnerColor(component);
                }
                stringBuffer.append((string3 = JCSwingTypeConverter.fromColor(color)) == null ? "" : string3);
                if (color2 == null) {
                    color2 = bevelBorder.getShadowOuterColor(component);
                }
                String string4 = JCSwingTypeConverter.fromColor(color2);
                stringBuffer.append(string);
                stringBuffer.append(string4 == null ? "" : string4);
            }
        } else if (border instanceof EtchedBorder) {
            EtchedBorder etchedBorder = (EtchedBorder)border;
            int n3 = etchedBorder.getEtchType();
            if (n3 == 0) {
                stringBuffer.append("raised");
            } else {
                stringBuffer.append("lowered");
            }
            Color color = etchedBorder.getHighlightColor();
            Color color3 = etchedBorder.getShadowColor();
            if (color != null || color3 != null) {
                String string5;
                stringBuffer.append(string);
                if (color == null) {
                    color = etchedBorder.getHighlightColor(component);
                }
                stringBuffer.append((string5 = JCSwingTypeConverter.fromColor(color)) == null ? "" : string5);
                if (color3 == null) {
                    color3 = etchedBorder.getShadowColor(component);
                }
                String string6 = JCSwingTypeConverter.fromColor(color3);
                stringBuffer.append(string);
                stringBuffer.append(string6 == null ? "" : string6);
            }
        } else if (border instanceof LineBorder) {
            LineBorder lineBorder = (LineBorder)border;
            stringBuffer.append(JCSwingTypeConverter.fromColor(lineBorder.getLineColor()));
            stringBuffer.append(string);
            stringBuffer.append(lineBorder.getThickness());
            if (JCEnvironment.getJavaVersion() >= 130) {
                stringBuffer.append(string);
                stringBuffer.append("" + lineBorder.getRoundedCorners());
            }
        } else if (border instanceof TitledBorder) {
            boolean bl;
            TitledBorder titledBorder = (TitledBorder)border;
            stringBuffer.append(JCSwingTypeConverter.escapeDelimiters(titledBorder.getTitle(), "|$", '\\'));
            stringBuffer.append(string);
            stringBuffer.append(JCTypeConverter.fromEnum(titledBorder.getTitlePosition(), positionStrings, positionValues));
            stringBuffer.append(string);
            stringBuffer.append(JCTypeConverter.fromEnum(titledBorder.getTitleJustification(), justificationStrings, justificationValues));
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromColor(titledBorder.getTitleColor()));
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromFont(titledBorder.getTitleFont()));
            Border border2 = titledBorder.getBorder();
            boolean bl2 = bl = !(border2 instanceof CompoundBorder) && !(border2 instanceof TitledBorder);
            if (border2 != null && !(border2 instanceof UIResource) && bl) {
                stringBuffer.append(string);
                stringBuffer.append(JCSwingTypeConverter.fromBorder(border2, component));
            }
        } else if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            Border border3 = compoundBorder.getOutsideBorder();
            Border border4 = compoundBorder.getInsideBorder();
            if (border3 == null && border4 == null) {
                return null;
            }
            if (border3 == null) {
                return JCSwingTypeConverter.fromBorder(border4, component);
            }
            if (border4 == null) {
                return JCSwingTypeConverter.fromBorder(border3, component);
            }
            char c2 = '$';
            if (stringBuffer.charAt(stringBuffer.length() - 1) != c2) {
                stringBuffer.append(c2);
            }
            stringBuffer.append(JCSwingTypeConverter.fromBorder(border3, component));
            if (stringBuffer.charAt(stringBuffer.length() - 1) != c2) {
                stringBuffer.append(c2);
            }
            stringBuffer.append(JCSwingTypeConverter.fromBorder(border4, component));
            if (stringBuffer.charAt(stringBuffer.length() - 1) != c2) {
                stringBuffer.append(c2);
            }
        }
        return stringBuffer.toString();
    }

    public static String escapeDelimiters(String string, String string2, char c2) {
        int n2;
        if (string == null || string2 == null || string2.length() == 0) {
            return string;
        }
        char[] cArray = new char[string2.length()];
        for (n2 = 0; n2 < string2.length(); ++n2) {
            cArray[n2] = string2.charAt(n2);
        }
        n2 = 0;
        for (char c3 : cArray) {
            if (string.indexOf(c3) < 0) continue;
            n2 = 1;
        }
        if (n2 == 0) {
            return string;
        }
        Object object = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = string.charAt(i2);
            for (char c4 : cArray) {
                char c5 = cArray[i2];
                if (n3 != c5) continue;
                ((StringBuffer)object).append(c2);
                break;
            }
            ((StringBuffer)object).append((char)n3);
        }
        return ((StringBuffer)object).toString();
    }

    public static int getVerticalSwingConstantFromAWT(float f2, int n2) {
        if (f2 == 1.0f) {
            return 3;
        }
        if (f2 == 0.5f) {
            return 0;
        }
        if (f2 == 0.0f) {
            return 1;
        }
        return n2;
    }

    public static int getHorizontalSwingConstantFromAWT(float f2, int n2) {
        if (f2 == 0.5f) {
            return 0;
        }
        if (f2 == 0.0f) {
            return 2;
        }
        if (f2 == 1.0f) {
            return 4;
        }
        return n2;
    }

    public static float getVerticalAWTFromSwingConstant(int n2, float f2) {
        if (n2 == 3) {
            return 1.0f;
        }
        if (n2 == 0) {
            return 0.5f;
        }
        if (n2 == 1) {
            return 0.0f;
        }
        return f2;
    }

    public static float getHorizontalAWTFromSwingConstant(int n2, float f2, boolean bl) {
        if (n2 == 0) {
            return 0.5f;
        }
        if (n2 == 2) {
            return 0.0f;
        }
        if (n2 == 4) {
            return 1.0f;
        }
        if (n2 == 11) {
            if (bl) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (n2 == 10) {
            if (bl) {
                return 0.0f;
            }
            return 1.0f;
        }
        return f2;
    }
}

