/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.label.JCLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCMultiPanel
extends JPanel
implements Serializable {
    public int componentOffset = 5;
    protected boolean legendPanel = false;
    protected CopyOnWriteArrayList<JComponent> componentList = new CopyOnWriteArrayList();
    protected GridLayout gridLayout;
    protected boolean showLabels = false;
    protected JLabel prototypeLabel = new JCLabel();
    protected LabelPosition labelPosition = LabelPosition.BOTTOM;
    protected CopyOnWriteArrayList<LabelPanel> labelList = null;
    protected Rectangle sourceBounds = null;
    protected Orientation orientation;

    public JCMultiPanel() {
        this(Orientation.HORIZONTAL);
    }

    public JCMultiPanel(Orientation orientation) {
        this.orientation = orientation;
        this.gridLayout = new GridLayout(1, 1, this.componentOffset, this.componentOffset);
        this.setLayout(this.gridLayout);
    }

    public JCMultiPanel(Orientation orientation, boolean bl) {
        this.orientation = orientation;
        this.gridLayout = new GridLayout(1, 1, this.componentOffset, this.componentOffset);
        this.setLayout(this.gridLayout);
        this.legendPanel = bl;
    }

    public CopyOnWriteArrayList<JComponent> getComponentList() {
        return this.componentList;
    }

    protected void addComponentToList(JComponent jComponent, int n2) {
        if (jComponent == null) {
            return;
        }
        if (n2 == -1) {
            this.componentList.add(jComponent);
        } else {
            this.componentList.add(n2, jComponent);
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            this.gridLayout.setColumns(this.componentList.size());
        } else {
            this.gridLayout.setRows(this.componentList.size());
        }
    }

    public Component add(JComponent jComponent) {
        if (this.showLabels) {
            if (this.labelList == null) {
                this.labelList = new CopyOnWriteArrayList();
            }
            JLabel jLabel = this.getPrototypeLabelClone();
            jLabel.setText(jComponent.getName());
            LabelPanel labelPanel = new LabelPanel(jComponent, jLabel);
            this.labelList.add(labelPanel);
            this.addComponentToList(jComponent, -1);
            return super.add(labelPanel);
        }
        this.addComponentToList(jComponent, -1);
        return super.add(jComponent);
    }

    public JComponent add(String string, JComponent jComponent) {
        jComponent.setName(string);
        if (this.showLabels) {
            if (this.labelList == null) {
                this.labelList = new CopyOnWriteArrayList();
            }
            JLabel jLabel = this.getPrototypeLabelClone();
            jLabel.setText(jComponent.getName());
            LabelPanel labelPanel = new LabelPanel(jComponent, jLabel);
            this.labelList.add(labelPanel);
            this.addComponentToList(jComponent, -1);
            return (JComponent)super.add(string, labelPanel);
        }
        this.addComponentToList(jComponent, -1);
        return (JComponent)super.add(string, jComponent);
    }

    public JComponent add(JComponent jComponent, int n2) {
        if (this.showLabels) {
            if (this.labelList == null) {
                this.labelList = new CopyOnWriteArrayList();
            }
            JLabel jLabel = this.getPrototypeLabelClone();
            jLabel.setText(jComponent.getName());
            LabelPanel labelPanel = new LabelPanel(jComponent, jLabel);
            this.addComponentToList(jComponent, n2);
            return (JComponent)super.add((Component)labelPanel, n2);
        }
        this.addComponentToList(jComponent, n2);
        return (JComponent)super.add((Component)jComponent, n2);
    }

    @Override
    public void remove(int n2) {
        if (this.showLabels) {
            this.labelList.remove(n2);
        }
        this.componentList.remove(n2);
        super.remove(n2);
    }

    @Override
    public void remove(Component component) {
        if (component == null) {
            return;
        }
        int n2 = this.componentList.indexOf(component);
        if (n2 > -1) {
            this.componentList.remove(n2);
            if (this.showLabels && this.labelList != null) {
                LabelPanel labelPanel = this.labelList.get(n2);
                super.remove(labelPanel);
                this.labelList.remove(labelPanel);
            } else {
                super.remove(component);
            }
        }
    }

    @Override
    public void removeAll() {
        if (this.labelList != null) {
            this.labelList.clear();
        }
        this.componentList.clear();
        super.removeAll();
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
        if (bl) {
            this.createLabels();
        } else {
            if (this.labelList != null) {
                for (LabelPanel labelPanel : this.labelList) {
                    labelPanel.removeAll();
                    super.remove(labelPanel);
                }
                this.labelList = null;
                for (int i2 = 0; i2 < this.componentList.size(); ++i2) {
                    super.add((Component)this.componentList.get(i2), i2);
                }
            }
            this.revalidate();
        }
    }

    protected void createLabels() {
        super.removeAll();
        this.labelList = new CopyOnWriteArrayList();
        for (JComponent jComponent : this.componentList) {
            JLabel jLabel = this.getPrototypeLabelClone();
            jLabel.setText(jComponent.getName());
            LabelPanel labelPanel = new LabelPanel(jComponent, jLabel);
            this.labelList.add(labelPanel);
            super.add(labelPanel);
        }
        this.revalidate();
    }

    public JLabel getPrototypeLabel() {
        return this.prototypeLabel;
    }

    public void setPrototypeLabel(JLabel jLabel) {
        this.prototypeLabel = jLabel;
        if (this.showLabels) {
            for (LabelPanel labelPanel : this.labelList) {
                JLabel jLabel2 = this.getPrototypeLabelClone();
                jLabel2.setText(labelPanel.getLabel().getText());
                labelPanel.setLabel(jLabel2);
            }
        }
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
        this.createLabels();
    }

    public int getComponentOffset() {
        return this.componentOffset;
    }

    public void setComponentOffset(int n2) {
        this.componentOffset = n2;
        this.gridLayout.setHgap(n2);
        this.gridLayout.setVgap(n2);
        this.revalidate();
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            if (orientation.equals((Object)Orientation.HORIZONTAL)) {
                this.gridLayout.setRows(1);
                this.gridLayout.setColumns(this.componentList.size());
            } else {
                this.gridLayout.setRows(this.componentList.size());
                this.gridLayout.setColumns(1);
            }
            this.revalidate();
        }
    }

    protected JLabel getPrototypeLabelClone() {
        JLabel jLabel = this.prototypeLabel instanceof JCLabel ? new JCLabel() : new JLabel();
        jLabel.setBackground(this.prototypeLabel.getBackground());
        jLabel.setBorder(this.prototypeLabel.getBorder());
        jLabel.setComponentOrientation(this.prototypeLabel.getComponentOrientation());
        jLabel.setFont(this.prototypeLabel.getFont());
        jLabel.setForeground(this.prototypeLabel.getForeground());
        jLabel.setHorizontalAlignment(this.prototypeLabel.getHorizontalAlignment());
        jLabel.setHorizontalTextPosition(this.prototypeLabel.getHorizontalTextPosition());
        jLabel.setOpaque(this.prototypeLabel.isOpaque());
        jLabel.setVerticalAlignment(this.prototypeLabel.getVerticalAlignment());
        jLabel.setVerticalTextPosition(this.prototypeLabel.getVerticalTextPosition());
        jLabel.setVisible(jLabel.isVisible());
        return jLabel;
    }

    protected class LabelPanel
    extends JPanel {
        private JComponent component = null;
        private JLabel label = null;

        protected LabelPanel(JComponent jComponent, JLabel jLabel) {
            this.component = jComponent;
            this.label = jLabel;
            this.setOpaque(false);
            this.remove(jComponent);
            this.setLayout(new BorderLayout(JCMultiPanel.this.componentOffset, JCMultiPanel.this.componentOffset));
            this.add((Component)jComponent, "Center");
            if (JCMultiPanel.this.labelPosition.equals((Object)LabelPosition.TOP)) {
                this.add((Component)this.createHorizontalBox(jLabel), "North");
            } else if (JCMultiPanel.this.labelPosition.equals((Object)LabelPosition.BOTTOM)) {
                this.add((Component)this.createHorizontalBox(jLabel), "South");
            } else if (JCMultiPanel.this.labelPosition.equals((Object)LabelPosition.LEFT)) {
                this.add((Component)this.createVerticalBox(jLabel), "West");
            } else if (JCMultiPanel.this.labelPosition.equals((Object)LabelPosition.RIGHT)) {
                this.add((Component)this.createVerticalBox(jLabel), "East");
            }
            if ((double)jComponent.getWidth() < jComponent.getPreferredSize().getWidth() || (double)jComponent.getHeight() < jComponent.getPreferredSize().getHeight()) {
                jComponent.setSize(jComponent.getPreferredSize());
            }
            jComponent.doLayout();
        }

        private Box createHorizontalBox(JLabel jLabel) {
            Box box = new Box(0);
            box.add(Box.createHorizontalGlue());
            box.add(jLabel);
            box.add(Box.createHorizontalGlue());
            box.setOpaque(false);
            return box;
        }

        private Box createVerticalBox(JLabel jLabel) {
            Box box = new Box(1);
            box.add(Box.createVerticalGlue());
            box.add(jLabel);
            box.add(Box.createVerticalGlue());
            box.setOpaque(false);
            return box;
        }

        public JComponent getComponent() {
            return this.component;
        }

        public void setComponent(JComponent jComponent) {
            this.component = jComponent;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public void setLabel(JLabel jLabel) {
            this.label = jLabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LabelPosition {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

