/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class JCGridLayout
extends GridLayout {
    protected int hgap;
    protected int vgap;
    protected int rows;
    protected int cols;
    protected int[] row_heights = new int[0];
    protected int[] col_widths = new int[0];
    public static final int VARIABLE = 0;

    public JCGridLayout(int n2, int n3) {
        this(n2, n3, 0, 0);
    }

    public JCGridLayout(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.rows = n2;
        this.cols = n3;
        this.hgap = n4;
        this.vgap = n5;
    }

    protected void getGridSizes(Container container, boolean bl) {
        int n2 = container.getComponentCount();
        if (n2 == 0) {
            return;
        }
        int n3 = this.rows;
        int n4 = this.cols;
        if (n3 > 0) {
            n4 = (n2 + n3 - 1) / n3;
        } else {
            n3 = (n2 + n4 - 1) / n4;
        }
        this.row_heights = new int[n3];
        this.col_widths = new int[n4];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            Component component = container.getComponent(i2);
            Dimension dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
            int n6 = i2 / n4;
            if (dimension.height > this.row_heights[n6]) {
                this.row_heights[n6] = dimension.height;
            }
            if (dimension.width <= this.col_widths[n5 = i2 % n4]) continue;
            this.col_widths[n5] = dimension.width;
        }
    }

    final int sum(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 0;
        for (int n3 : nArray) {
            n2 += n3;
        }
        return n2;
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGridSizes(container, false);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGridSizes(container, true);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    protected void setBounds(int n2, int n3, int n4, Component component, int n5, int n6, int n7, int n8) {
        component.setBounds(n5, n6, n7, n8);
    }

    public void layoutContainer(Container container) {
        int n2 = container.getComponentCount();
        if (n2 == 0) {
            return;
        }
        Insets insets = container.getInsets();
        this.getGridSizes(container, false);
        int n3 = this.rows;
        int n4 = this.cols;
        if (n3 > 0) {
            n4 = (n2 + n3 - 1) / n3;
        } else {
            n3 = (n2 + n4 - 1) / n4;
        }
        Dimension dimension = container.getSize();
        int n5 = insets.left + this.hgap;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n6 = insets.top + this.vgap;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n7 = i3 * n4 + i2;
                if (n7 < n2) {
                    int n8 = Math.max(0, Math.min(this.col_widths[i2], dimension.width - insets.right - n5));
                    int n9 = Math.max(0, Math.min(this.row_heights[i3], dimension.height - insets.bottom - n6));
                    this.setBounds(n7, i3, i2, container.getComponent(n7), n5, n6, n8, n9);
                }
                n6 += this.row_heights[i3] + this.vgap;
            }
            n5 += this.col_widths[i2] + this.hgap;
        }
    }
}

