/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCIntComparator;
import com.klg.jclass.util.JCMappingSort;
import com.klg.jclass.util.swing.DefaultRowComparator;
import com.klg.jclass.util.swing.JCComparableRow;
import com.klg.jclass.util.swing.JCRowComparator;
import com.klg.jclass.util.swing.JCRowSortTableModel;
import com.klg.jclass.util.swing.resources.LocaleBundle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRowSortTableModel
extends AbstractTableModel
implements JCRowSortTableModel,
TableModelListener {
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    protected int order = 1;
    protected TableModel tableModel = null;
    protected int sortColumn = -1;
    protected int[] indices = null;
    protected int[] reverseIndices = null;
    protected JCRowComparator rowComparator = null;
    protected int[][] keyColumnsArray;
    protected RowIntComparator rowIntComparator = null;
    protected boolean autoSort = false;
    protected boolean needsResorting = true;
    protected boolean needsReordering = true;

    public DefaultRowSortTableModel(TableModel tableModel, JCRowComparator jCRowComparator) {
        this(tableModel);
        this.rowComparator = jCRowComparator;
    }

    public DefaultRowSortTableModel(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public TableModel getModel() {
        return this.tableModel;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == this.tableModel) {
            return;
        }
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this);
        }
        this.tableModel = tableModel;
        tableModel.addTableModelListener(this);
    }

    @Override
    public void setKeyColumns(int n2, int[] nArray) {
        if (this.keyColumnsArray == null) {
            this.keyColumnsArray = new int[this.tableModel.getColumnCount()][];
        }
        this.keyColumnsArray[n2] = nArray;
    }

    @Override
    public int[] getKeyColumns(int n2) {
        return this.keyColumnsArray[n2];
    }

    @Override
    public boolean isDataSorted() {
        return this.indices != null && !this.needsReordering && !this.needsResorting;
    }

    @Override
    public boolean getAutoSort() {
        return this.autoSort;
    }

    @Override
    public void setAutoSort(boolean bl) {
        if (this.autoSort == bl) {
            return;
        }
        this.autoSort = bl;
        if (bl) {
            this.setDataSorted(true);
        }
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int n2) {
        if (n2 < 0) {
            String string = LocaleBundle.string("Sorting column number is less than 0");
            throw new IllegalArgumentException(string);
        }
        if (this.sortColumn == n2) {
            return;
        }
        this.sortColumn = n2;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    @Override
    public int getSortOrder() {
        return this.order;
    }

    @Override
    public void setSortOrder(int n2) {
        if (n2 == this.order) {
            return;
        }
        this.order = n2;
        this.needsReordering = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    @Override
    public void toggleSortOrder() {
        this.order = this.order == 1 ? -1 : 1;
        this.needsReordering = true;
    }

    @Override
    public int getUnsortedRow(int n2) {
        if (n2 < 0) {
            return n2;
        }
        if (this.indices == null) {
            return n2;
        }
        if (this.order == 1) {
            return this.indices[n2];
        }
        return this.indices[this.indices.length - n2 - 1];
    }

    @Override
    public int getSortedRow(int n2) {
        if (n2 < 0) {
            return n2;
        }
        if (this.reverseIndices == null) {
            return n2;
        }
        if (this.order == 1) {
            return this.reverseIndices[n2];
        }
        return this.reverseIndices.length - this.reverseIndices[n2] - 1;
    }

    public void setComparator(JCRowComparator jCRowComparator) {
        if (this.rowComparator == jCRowComparator) {
            return;
        }
        this.rowComparator = jCRowComparator;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public JCRowComparator getComparator() {
        return this.rowComparator;
    }

    @Override
    public void setDataSorted(boolean bl) {
        if (!bl) {
            this.unsort();
            return;
        }
        if (this.sortColumn == -1) {
            return;
        }
        if (!this.needsReordering && !this.needsResorting) {
            return;
        }
        if (this.needsResorting) {
            if (this.rowComparator == null) {
                this.rowComparator = new DefaultRowComparator(1);
            }
            if (this.keyColumnsArray == null) {
                this.keyColumnsArray = new int[this.tableModel.getColumnCount()][];
            }
            int[] nArray = new int[]{this.sortColumn};
            int[] nArray2 = this.keyColumnsArray[this.sortColumn];
            this.rowComparator.setKeyColumns(nArray2 != null ? nArray2 : nArray);
            this.setComparator(this.rowComparator);
            if (this.rowIntComparator == null) {
                this.rowIntComparator = new RowIntComparator();
            }
            if (this.indices == null) {
                this.indices = new int[this.tableModel.getRowCount()];
                this.reverseIndices = new int[this.tableModel.getRowCount()];
                for (int i2 = 0; i2 < this.indices.length; ++i2) {
                    this.indices[i2] = i2;
                }
            }
            JCMappingSort.sort(this.rowIntComparator, this.indices);
            this.doReverseMapping();
            this.needsResorting = false;
        }
        this.needsReordering = false;
        this.fireTableDataChanged();
    }

    public void unsort() {
        if (this.indices != null) {
            this.indices = null;
            this.reverseIndices = null;
            this.sortColumn = -1;
        }
        this.fireTableDataChanged();
    }

    protected void doReverseMapping() {
        if (this.indices == null || this.reverseIndices == null) {
            return;
        }
        for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
            this.reverseIndices[this.indices[i2]] = i2;
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    @Override
    public String getColumnName(int n2) {
        return this.tableModel.getColumnName(n2);
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return this.tableModel.getColumnClass(n2);
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return this.tableModel.isCellEditable(n2, n3);
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        return this.tableModel.getValueAt(this.getUnsortedRow(n2), n3);
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this.needsResorting = true;
        this.tableModel.setValueAt(object, this.getUnsortedRow(n2), n3);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.indices = null;
        this.reverseIndices = null;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        } else {
            this.fireTableDataChanged();
        }
    }

    class RowIntComparator
    implements JCIntComparator {
        private ComparableRow r1;
        private ComparableRow r2;

        RowIntComparator() {
            this.r1 = new ComparableRow();
            this.r2 = new ComparableRow();
        }

        public int compare(int n2, int n3) {
            this.r1.row = n2;
            this.r2.row = n3;
            return DefaultRowSortTableModel.this.rowComparator.compare(this.r1, this.r2);
        }
    }

    class ComparableRow
    implements JCComparableRow {
        private int row = -1;

        ComparableRow() {
        }

        public Object getValueAt(int n2) {
            return DefaultRowSortTableModel.this.tableModel.getValueAt(this.row, n2);
        }

        public int getRowIndex() {
            return this.row;
        }
    }
}

