/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.style;

import com.klg.jclass.util.style.Diamond;
import com.klg.jclass.util.style.JCShape;
import com.klg.jclass.util.style.JCStyle;
import com.klg.jclass.util.style.Triangle;
import com.klg.jclass.util.style.resources.LocaleBundle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;

public class JCSymbolStyle
extends JCStyle
implements Cloneable {
    public static final int NONE = 0;
    public static final int DOT = 1;
    public static final int BOX = 2;
    public static final int TRIANGLE = 3;
    public static final int DIAMOND = 4;
    public static final int STAR = 5;
    public static final int VERT_LINE = 6;
    public static final int HORIZ_LINE = 7;
    public static final int CROSS = 8;
    public static final int CIRCLE = 9;
    public static final int SQUARE = 10;
    public static final int OTHER = 11;
    public static final int LAST = 10;
    protected int shape = 1;
    protected int colorIndex;
    protected int shapeIndex = 1;
    protected Color color = null;
    protected int size = 6;
    protected JCShape customShape = null;

    public JCSymbolStyle(int n2, Color color, int n3) {
        this.setShape(n2);
        this.color = color;
        this.size = this.checkSize(n3);
    }

    public void draw(Graphics graphics, int n2, int n3) {
        this.draw(graphics, n2, n3, this.size, (Color)null);
    }

    public void draw(Graphics graphics, int n2, int n3, Color color) {
        this.draw(graphics, n2, n3, this.size, color);
    }

    public void draw(Graphics graphics, double d2, double d3, Color color) {
        this.draw(graphics, d2, d3, this.size, color);
    }

    public void draw(Graphics graphics, int n2, int n3, int n4) {
        this.draw(graphics, n2, n3, n4, (Color)null);
    }

    public void draw(Graphics graphics, int n2, int n3, int n4, Color color) {
        Color color2;
        if (this.shape == 0 || n4 <= 0) {
            return;
        }
        Color color3 = color2 = color != null ? color : this.color;
        if (color2 != null) {
            graphics.setColor(color2);
        }
        if (this.customShape != null) {
            this.customShape.resize(n4);
            this.customShape.draw(graphics, n2, n3);
            return;
        }
        boolean bl = n4 % 2 == 0;
        int n5 = n4 / 2;
        if (bl) {
            n5 = (n4 - 1) / 2;
        }
        int n6 = (int)((double)n4 / 2.8284271247461903);
        switch (this.shape) {
            case 0: {
                break;
            }
            case 1: {
                graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                break;
            }
            case 2: {
                graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                break;
            }
            case 5: {
                graphics.drawLine(n2 - n4 / 2, n3, n2 + n5, n3);
                graphics.drawLine(n2, n3 - n4 / 2, n2, n3 + n5);
                graphics.drawLine(n2 - n6, n3 - n6, n2 + n6, n3 + n6);
                graphics.drawLine(n2 - n6, n3 + n6, n2 + n6, n3 - n6);
                break;
            }
            case 6: {
                graphics.drawLine(n2, n3 - n4 / 2, n2, n3 + n5);
                break;
            }
            case 7: {
                graphics.drawLine(n2 - n4 / 2, n3, n2 + n5, n3);
                break;
            }
            case 8: {
                graphics.drawLine(n2, n3 - n4 / 2, n2, n3 + n5);
                graphics.drawLine(n2 - n4 / 2, n3, n2 + n5, n3);
                break;
            }
            case 9: {
                graphics.drawArc(n2 - n4 / 2, n3 - n4 / 2, n4 - 1, n4 - 1, 0, 360);
                break;
            }
            case 10: {
                graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4 - 1, n4 - 1);
            }
        }
    }

    public void draw(Graphics graphics, double d2, double d3, int n2, Color color) {
        Color color2;
        if (this.shape == 0 || n2 <= 0) {
            return;
        }
        Color color3 = color2 = color != null ? color : this.color;
        if (color2 != null) {
            graphics.setColor(color2);
        }
        if (this.customShape != null) {
            this.customShape.resize(n2);
            this.customShape.draw(graphics, d2, d3);
            return;
        }
        boolean bl = n2 % 2 == 0;
        int n3 = n2 / 2;
        if (bl) {
            n3 = (n2 - 1) / 2;
        }
        int n4 = (int)((double)n2 / 2.8284271247461903);
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d4 = n2 / 2;
        double d5 = n3;
        Line2D.Double double_ = new Line2D.Double(d2, d3 - d4, d2, d3 + d5);
        Line2D.Double double_2 = new Line2D.Double(d2 - d4, d3, d2 + d5, d3);
        switch (this.shape) {
            case 0: {
                break;
            }
            case 1: {
                graphics2D.fill(new Ellipse2D.Double(d2 - d4, d3 - d4, n2, n2));
                break;
            }
            case 2: {
                graphics2D.fill(new Rectangle2D.Double(d2 - d4, d3 - d4, n2, n2));
                break;
            }
            case 5: {
                graphics2D.draw(double_2);
                graphics2D.draw(double_);
                graphics2D.draw(new Line2D.Double(d2 - (double)n4, d3 - (double)n4, d2 + (double)n4, d3 + (double)n4));
                graphics2D.draw(new Line2D.Double(d2 - (double)n4, d3 + (double)n4, d2 + (double)n4, d3 - (double)n4));
                break;
            }
            case 6: {
                graphics2D.draw(double_);
                break;
            }
            case 7: {
                graphics2D.draw(double_2);
                break;
            }
            case 8: {
                graphics2D.draw(double_);
                graphics2D.draw(double_2);
                break;
            }
            case 9: {
                graphics2D.draw(new Arc2D.Double(d2 - d4, d3 - d4, n2 - 1, n2 - 1, 0.0, 360.0, 0));
                break;
            }
            case 10: {
                graphics2D.draw(new Rectangle2D.Double(d2 - d4, d3 - d4, n2 - 1, n2 - 1));
            }
        }
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int n2) {
        if (this.shape == n2) {
            return;
        }
        this.shapeIndex = n2;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.shape = n2;
                this.customShape = null;
                break;
            }
            case 3: {
                this.shape = n2;
                this.customShape = new Triangle();
                break;
            }
            case 4: {
                this.shape = n2;
                this.customShape = new Diamond();
                break;
            }
            default: {
                String string = LocaleBundle.string("Not symbolstyle enum");
                throw new IllegalArgumentException(string);
            }
        }
        this.setChanged(true, 17);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setChanged(true, 17);
    }

    public int getSize() {
        if (this.shape == 11 && this.customShape != null) {
            return this.customShape.getSize();
        }
        return this.size;
    }

    public void setSize(int n2) {
        if (this.size == n2) {
            return;
        }
        this.size = this.checkSize(n2);
        this.setChanged(true, 18);
    }

    protected int checkSize(int n2) {
        if (n2 < 0) {
            String string = LocaleBundle.string("Invalid symbol size");
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new IllegalArgumentException(MessageFormat.format(string, objectArray));
        }
        return n2;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public JCShape getCustomShape() {
        return this.customShape;
    }

    public void setCustomShape(JCShape jCShape) {
        if (this.customShape == jCShape) {
            return;
        }
        this.shape = jCShape == null ? 0 : 11;
        this.customShape = jCShape;
        this.setChanged(true, 17);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object.getClass().equals(this.getClass())) {
            JCSymbolStyle jCSymbolStyle = (JCSymbolStyle)object;
            if (this == jCSymbolStyle) {
                bl = true;
            } else {
                boolean bl2;
                boolean bl3 = this.color != null && this.color.equals(jCSymbolStyle.getColor()) || this.color == null && jCSymbolStyle.getColor() == null;
                boolean bl4 = bl2 = this.customShape != null && this.customShape.equals(jCSymbolStyle.getCustomShape()) || this.customShape == null && jCSymbolStyle.getCustomShape() == null;
                if (jCSymbolStyle.getColorIndex() == this.colorIndex && jCSymbolStyle.getShape() == this.shape && jCSymbolStyle.getSize() == this.size && bl3 && bl2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        int n2 = 17;
        int n3 = this.color == null ? 0 : this.color.hashCode();
        int n4 = this.customShape == null ? 0 : this.customShape.hashCode();
        n2 = 37 * n2 + this.colorIndex;
        n2 = 37 * n2 + this.shape;
        n2 = 37 * n2 + this.size;
        n2 = 37 * n2 + n3;
        n2 = 37 * n2 + n4;
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        JCSymbolStyle jCSymbolStyle = (JCSymbolStyle)super.clone();
        jCSymbolStyle.color = this.color;
        jCSymbolStyle.customShape = this.customShape;
        jCSymbolStyle.colorIndex = this.colorIndex;
        jCSymbolStyle.shape = this.shape;
        jCSymbolStyle.size = this.size;
        jCSymbolStyle.shapeIndex = this.shapeIndex;
        return jCSymbolStyle;
    }
}

