/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.property.html;

import com.klg.jclass.util.io.JCParseException;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.property.JCFileAccessor;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class JCHTMLFileAccessor
extends JCFileAccessor {
    public JCHTMLFileAccessor() {
    }

    public JCHTMLFileAccessor(Component component) {
        super(component);
    }

    public JCHTMLFileAccessor(Component component, LoadProperties loadProperties) {
        super(component, loadProperties);
    }

    public void getProperties(Object object) throws IOException {
        if (object == null) {
            throw new JCParseException("Cannot parse null object");
        }
        InputStream inputStream = null;
        boolean bl = false;
        String string = null;
        if (object instanceof String) {
            string = JCHTMLFileAccessor.loadFile((String)object);
        } else if (object instanceof URL) {
            inputStream = ((URL)object).openStream();
            string = JCHTMLFileAccessor.loadFile(inputStream);
            bl = true;
        } else if (object instanceof InputStream) {
            string = JCHTMLFileAccessor.loadFile((InputStream)object);
        } else if (object instanceof Reader) {
            string = JCHTMLFileAccessor.loadFile((Reader)object);
        }
        this.source = JCHTMLFileAccessor.findProperties(string);
        if (bl) {
            inputStream.close();
        }
    }

    public String getType() {
        return "HTML";
    }

    public String getSubDirectory() {
        return "html";
    }

    protected static String loadFile(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        String string2 = JCHTMLFileAccessor.loadFile(fileInputStream);
        ((InputStream)fileInputStream).close();
        return string2;
    }

    protected static String loadFile(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader;
        if (inputStream == null) {
            return null;
        }
        try {
            inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), "JISAutoDetect");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStreamReader = new InputStreamReader(new BufferedInputStream(inputStream));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            inputStreamReader = new InputStreamReader(new BufferedInputStream(inputStream));
        }
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return JCHTMLFileAccessor.loadFile(bufferedReader);
    }

    protected static String loadFile(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
            string = bufferedReader.readLine();
        }
        return new String(stringBuffer);
    }
}

