/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.property;

import com.klg.jclass.util.JCStringTokenizer;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.io.HTMLTextUtil;
import com.klg.jclass.util.io.JCIOException;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.property.FilePropertyAccessModel;
import com.klg.jclass.util.property.PropertyAccessModel;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCBaseAccessor
implements PropertyAccessModel,
FilePropertyAccessModel {
    protected Hashtable<String, Object> source = null;
    protected Component component;
    protected LoadProperties loadProperties;

    @Override
    public abstract void getProperties(Object var1) throws IOException;

    @Override
    public abstract String getType();

    @Override
    public abstract String getSubDirectory();

    @Override
    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public String getProperty(String string) {
        Object object = this.getPropertyObject(string);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    @Override
    public Object getPropertyObject(String string) {
        if (this.source == null || string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        Object object = this.source.get(string2);
        if (object == null && this.component != null) {
            object = this.source.get(this.component.getName() + "." + string2);
        }
        return object;
    }

    @Override
    public void setLoadProperties(LoadProperties loadProperties) {
        this.loadProperties = loadProperties;
    }

    @Override
    public LoadProperties getLoadProperties() {
        return this.loadProperties;
    }

    public boolean searchKeysForPrefix(String string) {
        if (this.source == null) {
            return false;
        }
        if (string == null) {
            return true;
        }
        String string2 = string.toLowerCase();
        Enumeration<String> enumeration = this.source.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public void printProperties() {
        if (this.source == null) {
            return;
        }
        Enumeration<String> enumeration = this.source.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            System.out.println("key:" + string + " value:" + this.getPropertyObject(string));
        }
    }

    @Override
    public void setProperty(String string, String string2) {
        this.setPropertyObject(string, string2);
    }

    @Override
    public void setPropertyObject(String string, Object object) {
        if (this.source == null || string == null) {
            return;
        }
        String string2 = string.toLowerCase();
        if (this.source.containsKey(string2) && object == null) {
            this.source.remove(string2);
        }
        if (object == null) {
            return;
        }
        this.source.put(string2, object);
    }

    @Override
    public InputStream getFilePropertyStream(String string, OutputProperties outputProperties) throws JCIOException {
        InputStream inputStream;
        String string2 = this.getProperty(string + "File");
        if (string2 == null || string2.length() == 0 || this.loadProperties == null) {
            return null;
        }
        String string3 = this.getProperty(string + "FileAccess");
        int n2 = this.loadProperties.getFileAccessEnumFromString(string3, false);
        if (outputProperties != null) {
            outputProperties.setPropertyName(string2);
            outputProperties.setFileAccess(n2);
        }
        try {
            inputStream = this.loadProperties.getInputStreamByAccessType(string2, n2);
        }
        catch (Exception exception) {
            throw new JCIOException(exception.getMessage(), exception);
        }
        return inputStream;
    }

    @Override
    public URL getPropertyURL(String string, OutputProperties outputProperties) throws MalformedURLException {
        if (this.loadProperties == null) {
            return null;
        }
        String string2 = this.getProperty(string + "image.fileName");
        if (!(string2 != null && string2.length() != 0 || (string2 = this.getProperty(string + "image")) != null && string2.length() != 0)) {
            return null;
        }
        String string3 = this.getProperty(string + "image.fileAccess");
        if (string3 == null && (string2.startsWith("http:") || string2.startsWith("file:") || string2.startsWith("data:"))) {
            string3 = "Url";
        }
        int n2 = this.loadProperties.getFileAccessEnumFromString(string3, false);
        if (outputProperties != null) {
            outputProperties.setPropertyName(string2);
            outputProperties.setFileAccess(n2);
        }
        return this.loadProperties.getURLByAccessType(string2, n2);
    }

    protected static Hashtable<String, Object> findProperties(String string) {
        int n2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string == null) {
            return hashtable;
        }
        while ((n2 = string.indexOf(60)) != -1) {
            int n3;
            int n4;
            String string2;
            string = string.substring(n2 + 1);
            JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
            jCStringTokenizer.strip_esc = false;
            String string3 = "";
            boolean bl = false;
            while (!bl) {
                string2 = jCStringTokenizer.nextToken('>');
                string3 = string3 + string2;
                if (string2.indexOf(60) == -1) {
                    bl = true;
                    continue;
                }
                string3 = string3 + ">";
            }
            if ((string3 = JCTypeConverter.trim(string3)) == null || string3.length() == 0) {
                return hashtable;
            }
            string = JCTypeConverter.trim(string.substring(jCStringTokenizer.getPosition()));
            if (string3.charAt(0) == '!' || string3.length() < 20 || Character.isWhitespace(string3.charAt(11)) || !string3.regionMatches(true, 0, "param name=", 0, 11)) continue;
            string3 = string3.substring(11);
            for (n4 = 1; n4 < string3.length() && !Character.isWhitespace(string3.charAt(n4)); ++n4) {
            }
            for (n3 = n4 + 1; n3 < string3.length() && Character.isWhitespace(string3.charAt(n3)); ++n3) {
            }
            if (n3 == string3.length() || !string3.regionMatches(true, n3, "value=", 0, 6)) continue;
            string2 = JCBaseAccessor.removeQuotes(string3.substring(0, n4).toLowerCase());
            String string4 = JCBaseAccessor.removeQuotes(string3.substring(n3 + 6));
            string4 = HTMLTextUtil.processText(string4);
            if (string2 == null) continue;
            hashtable.put(string2, string4);
        }
        return hashtable;
    }

    protected static String removeQuotes(String string) {
        String string2 = string;
        if (string.charAt(0) == '\"') {
            if (string.length() < 2) {
                return "";
            }
            string2 = string.substring(1);
            if (string2.charAt(string2.length() - 1) == '\"') {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }
}

