/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.label;

import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import com.klg.jclass.util.io.OutputProperties;
import com.klg.jclass.util.label.JCLabelUI;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import java.security.AccessControlException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCLabel
extends JLabel
implements Serializable,
ServerRenderable {
    public static final String ALTERNATIVE_LABEL_UI_PROPERTY = "jclass.server.useAlternativeLabelUI";
    public static Class<?> alternativeLabelUIClass = null;
    public static boolean useAlternativeLabelUI = true;
    protected transient Graphics prevSetGraphics = null;
    protected OutputProperties outputProperties = null;

    public JCLabel(String string, Icon icon, int n2) {
        this.setText(string);
        this.setIcon(icon);
        this.setHorizontalAlignment(n2);
        this.setAlignmentX(0.0f);
        this.updateUI();
    }

    public JCLabel(String string, int n2) {
        this(string, null, n2);
    }

    public JCLabel(String string) {
        this(string, null, 10);
    }

    public JCLabel(Icon icon, int n2) {
        this(null, icon, n2);
    }

    public JCLabel(Icon icon) {
        this(null, icon, 0);
    }

    public JCLabel() {
        this("", null, 10);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        JCLabel.assignAlternativeLabelUI(this);
    }

    public static void setAlternativeLabelUIClass(Class<?> clazz) {
        if (clazz != null && !LabelUI.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not a subclass of " + "javax.swing.plaf.LabelUI");
        }
        alternativeLabelUIClass = clazz;
    }

    public static void assignAlternativeLabelUI(JLabel jLabel) {
        if (jLabel == null || !useAlternativeLabelUI) {
            return;
        }
        LabelUI labelUI = null;
        if (alternativeLabelUIClass != null) {
            try {
                labelUI = (LabelUI)alternativeLabelUIClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
            }
            if (labelUI != null) {
                if (labelUI instanceof JCLabelUI) {
                    ((JCLabelUI)labelUI).setLabel(jLabel);
                }
                jLabel.setUI(labelUI);
            }
        }
    }

    public static boolean isUsingAlternativeLabelUI() {
        return useAlternativeLabelUI;
    }

    public OutputProperties getOutputProperties() {
        return this.outputProperties;
    }

    public void setOutputProperties(OutputProperties outputProperties) {
        this.outputProperties = outputProperties;
    }

    @Override
    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    @Override
    public void serverPaint(Graphics graphics) {
        ServerRenderer.paintComponent(graphics, this);
    }

    @Override
    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    @Override
    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    static {
        JCLabel.setAlternativeLabelUIClass(JCLabelUI.class);
        try {
            String string = System.getProperty(ALTERNATIVE_LABEL_UI_PROPERTY);
            if (string != null) {
                useAlternativeLabelUI = Boolean.valueOf(string);
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

