/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.internal;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.internal.JCEvalFrame;
import com.klg.jclass.util.internal.JCEvalInfo;
import com.klg.jclass.util.internal.JClassInfo;
import java.applet.Applet;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Calendar;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public final class JCEvalManager {
    public static final String fallbackClasspath = "./|./lib|../|../lib|../..|../../lib|../../..|../../../lib";
    public static Component referenceComponent = null;
    private static final int NUM_EVALS = JClassInfo.getEvalPackageNames().length;
    private static final boolean[] checkedExpiryDate = new boolean[NUM_EVALS];
    private static final Calendar[] expiryDate = new Calendar[NUM_EVALS];

    public static void setEval(String string) {
        SwingUtilities.invokeLater(new Invoker());
    }

    public static void setEval(String string, Component component) {
        referenceComponent = component;
        JCEvalManager.setEval(string);
    }

    public static boolean isExpired(String string) {
        Calendar calendar = JCEvalManager.getExpiry(string);
        Calendar calendar2 = Calendar.getInstance();
        Calendar calendar3 = JCEvalManager.getBuildDate(string);
        Calendar calendar4 = JCEvalManager.getExpiryDate(string);
        return calendar3 != null && calendar2.before(calendar3) || calendar4 != null && calendar2.after(calendar4) || calendar != null && calendar2.after(calendar);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray[0].equals("xzzy")) {
                String[] stringArray2;
                for (String string : stringArray2 = JCEvalManager.getAvailablePackages(stringArray[1])) {
                    String string2 = JCEvalManager.getProductName(string);
                    if (string2 == null) continue;
                    JCEvalManager.setExpiry(string, stringArray[2], Integer.parseInt(stringArray[3]));
                    System.out.println("JClass " + string2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static int getPackageIndex(String string) {
        String[] stringArray = JClassInfo.getEvalPackageNames();
        int n2 = -1;
        for (int i2 = 0; i2 < NUM_EVALS; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    public static Calendar getExpiry(String string) {
        Object object;
        Serializable serializable;
        String string2;
        int n2 = JCEvalManager.getPackageIndex(string);
        if (n2 >= 0 && checkedExpiryDate[n2]) {
            return expiryDate[n2];
        }
        String string3 = "|";
        try {
            string2 = System.getProperty("java.class.path");
        }
        catch (AccessControlException accessControlException) {
            string2 = null;
        }
        catch (Exception exception) {
            string2 = null;
        }
        try {
            serializable = JCEnvironment.getApplet(referenceComponent);
            if (serializable != null && ((Applet)serializable).getCodeBase() != null && (object = ((Applet)serializable).getCodeBase().getFile()) != null) {
                int n3 = ((String)object).indexOf("|");
                if (n3 >= 0) {
                    object = ((String)object).substring(n3 + 1);
                }
                if (object != null && ((String)object).length() > 0) {
                    string2 = (String)object + "|" + (String)object + (((String)object).charAt(((String)object).length() - 1) == '/' ? "lib" : "/lib");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 == null || string2.length() == 0) {
            string2 = fallbackClasspath;
        }
        string2 = string2.replace(System.getProperty("file.separator").charAt(0), '/');
        string2 = string2.replace(System.getProperty("path.separator").charAt(0), string3.charAt(0));
        serializable = null;
        object = new StringTokenizer(string2, string3);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string4 = ((StringTokenizer)object).nextToken();
            if (string4.charAt(string4.length() - 1) != '/') {
                if (string4.endsWith(".zip") || string4.endsWith(".ZIP") || string4.endsWith(".tar") || string4.endsWith(".TAR") || string4.endsWith(".jar") || string4.endsWith(".JAR")) {
                    string4 = string4.indexOf(47) != -1 ? string4.substring(0, string4.lastIndexOf(47)) : ".";
                }
                string4 = string4.concat("/");
            }
            if ((serializable = JCEvalManager.readExpiryFile("jc" + string + "data", string4)) == null) continue;
            break;
        }
        if (serializable == null || ((Calendar)serializable).get(1) > 2020) {
            serializable = Calendar.getInstance();
            ((Calendar)serializable).add(5, 1);
        }
        if (n2 >= 0) {
            JCEvalManager.checkedExpiryDate[n2] = true;
            JCEvalManager.expiryDate[n2] = serializable;
        }
        return serializable;
    }

    private static void setExpiry(String string, String string2, int n2) {
        JCEvalManager.writeExpiryFile("jc" + string + "data", string2, n2);
    }

    private static Calendar readExpiryFile(String string, String string2) {
        Calendar calendar = null;
        try {
            DataInputStream dataInputStream;
            block9: {
                dataInputStream = null;
                try {
                    FileInputStream fileInputStream = new FileInputStream(string2 + string);
                    dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
                }
                catch (Exception exception) {
                    Applet applet = JCEnvironment.getApplet(referenceComponent);
                    if (applet == null || applet.getCodeBase() == null) break block9;
                    String string3 = applet.getCodeBase().getFile();
                    try {
                        URL uRL;
                        if (string3 != null && string3.indexOf("|") >= 0) {
                            string3 = string3.substring(0, string3.indexOf("|") + 1);
                            uRL = new URL("file", string3 + string2, string);
                        } else {
                            uRL = new URL("http", string2, string);
                        }
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
                        dataInputStream = new DataInputStream(bufferedInputStream);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            if (dataInputStream != null) {
                calendar = Calendar.getInstance();
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readInt();
                int n4 = dataInputStream.readInt();
                calendar.set(n2, n3, n4, 0, 0, 0);
                dataInputStream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return calendar;
    }

    private static void writeExpiryFile(String string, String string2, int n2) {
        if (string == null || string2 == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, n2);
        String string3 = System.getProperty("file.separator");
        string2.replace(string3.charAt(0), '/');
        if (string2.charAt(string2.length() - 1) != '/') {
            string2 = string2.concat("/");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2 + string);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            dataOutputStream.writeInt(calendar.get(1));
            dataOutputStream.writeInt(calendar.get(2));
            dataOutputStream.writeInt(calendar.get(5));
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static JCEvalInfo getEvalInfo(String string) {
        Class<?> clazz;
        if (string == null) {
            return null;
        }
        try {
            clazz = Class.forName("com.klg.jclass." + string + ".JCEval");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        JCEvalInfo jCEvalInfo = null;
        try {
            jCEvalInfo = (JCEvalInfo)clazz.getMethod("getEvalInfo", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jCEvalInfo;
    }

    public static boolean isEval(String string) {
        return JCEvalManager.getEvalInfo(string) != null;
    }

    private static Calendar getBuildDate(String string) {
        Calendar calendar = null;
        JCEvalInfo jCEvalInfo = JCEvalManager.getEvalInfo(string);
        if (jCEvalInfo != null) {
            calendar = jCEvalInfo.getBuildDate();
        }
        return calendar;
    }

    private static Calendar getExpiryDate(String string) {
        Calendar calendar = null;
        JCEvalInfo jCEvalInfo = JCEvalManager.getEvalInfo(string);
        if (jCEvalInfo != null) {
            calendar = jCEvalInfo.getExpiryDate();
        }
        return calendar;
    }

    public static String getProductName(String string) {
        String string2 = null;
        JCEvalInfo jCEvalInfo = JCEvalManager.getEvalInfo(string);
        if (jCEvalInfo != null) {
            string2 = jCEvalInfo.getProductName();
        }
        return string2;
    }

    public static String[] getAvailablePackages(String string) {
        String[] stringArray = new String[]{string, "swing"};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            JCEvalInfo jCEvalInfo = JCEvalManager.getEvalInfo(string);
            if (jCEvalInfo != null) continue;
            stringArray[i2] = null;
        }
        return stringArray;
    }

    private static class Invoker
    implements Runnable {
        private Invoker() {
        }

        public void run() {
            JCEvalFrame.getEvalFrame().initialize();
        }
    }
}

