/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.OperandMismatchException;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Sum
extends Operation {
    public Sum(Expression expression) {
        super(expression);
    }

    public Sum(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Sum(Expression expression, Number number) {
        super(expression, number);
    }

    public Sum(Number number, Expression expression) {
        super(number, expression);
    }

    public Sum(Number number, Number number2) {
        super(number, number2);
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Sum is not defined on zero operands");
        }
        MathValue mathValue = null;
        MathValue mathValue2 = null;
        if (this.leftOperand != null) {
            mathValue = this.evaluateOperand(this.leftOperand);
        }
        if (this.rightOperand != null) {
            mathValue2 = this.evaluateOperand(this.rightOperand);
        }
        if (this.leftOperand == null) {
            return mathValue2;
        }
        if (this.rightOperand == null) {
            return mathValue;
        }
        return this.doSum(mathValue, mathValue2);
    }

    private MathValue evaluateOperand(Expression expression) {
        if (expression instanceof MathValue) {
            return (MathValue)expression;
        }
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            return this.evaluateOperand(expression.evaluate());
        }
        if (expression instanceof ExpressionList) {
            MathValue mathValue = null;
            Iterator iterator = ((ExpressionList)expression).iterator();
            while (iterator.hasNext()) {
                MathValue mathValue2 = this.evaluateOperand((Expression)iterator.next());
                if (mathValue == null) {
                    mathValue = mathValue2;
                    continue;
                }
                mathValue = this.doSum(mathValue, mathValue2);
            }
            return mathValue;
        }
        throw new IllegalArgumentException("Unrecognized operand type to Sum");
    }

    private MathValue doSum(MathValue mathValue, MathValue mathValue2) {
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathScalar) {
            MathScalar mathScalar = (MathScalar)mathValue;
            MathScalar mathScalar2 = (MathScalar)mathValue2;
            Number number = this.sumSimple(mathScalar.realValue, mathScalar2.realValue);
            return new MathScalar(number);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathVector) {
            MathVector mathVector = (MathVector)mathValue;
            MathVector mathVector2 = (MathVector)mathValue2;
            if (mathVector.size != mathVector2.size) {
                throw new OperandMismatchException("Cannot add mixed data sizes");
            }
            Number[] numberArray = new Number[mathVector.size];
            for (int i2 = 0; i2 < mathVector.size; ++i2) {
                numberArray[i2] = this.sumSimple(mathVector.realValues[i2], mathVector2.realValues[i2]);
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathMatrix) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathMatrix mathMatrix2 = (MathMatrix)mathValue2;
            if (mathMatrix.rows != mathMatrix2.rows || mathMatrix.columns != mathMatrix2.columns) {
                throw new OperandMismatchException("Cannot add mixed data sizes");
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix.columns];
            for (int i3 = 0; i3 < mathMatrix.rows; ++i3) {
                for (int i4 = 0; i4 < mathMatrix.columns; ++i4) {
                    numberArray[i3][i4] = this.sumSimple(mathMatrix.realValues[i3][i4], mathMatrix2.realValues[i3][i4]);
                }
            }
            return new MathMatrix(numberArray);
        }
        throw new OperandMismatchException("Cannot add mixed data sizes");
    }

    private Number sumSimple(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() + number2.doubleValue());
        }
        return new Integer(number.intValue() + number2.intValue());
    }
}

