/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.OperandMismatchException;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Product
extends Operation {
    public Product(Expression expression) {
        super(expression);
    }

    public Product(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Product(Expression expression, Number number) {
        super(expression, number);
    }

    public Product(Number number, Expression expression) {
        super(number, expression);
    }

    public Product(Number number, Number number2) {
        super(number, number2);
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Product is not defined on zero operands");
        }
        MathValue mathValue = null;
        MathValue mathValue2 = null;
        if (this.leftOperand != null) {
            mathValue = this.evaluateOperand(this.leftOperand);
        }
        if (this.rightOperand != null) {
            mathValue2 = this.evaluateOperand(this.rightOperand);
        }
        if (this.leftOperand == null) {
            return mathValue2;
        }
        if (this.rightOperand == null) {
            return mathValue;
        }
        return this.doProduct(mathValue, mathValue2);
    }

    private MathValue evaluateOperand(Expression expression) {
        if (expression instanceof MathValue) {
            return (MathValue)expression;
        }
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            return this.evaluateOperand(expression.evaluate());
        }
        if (expression instanceof ExpressionList) {
            MathValue mathValue = null;
            Iterator iterator = ((ExpressionList)expression).iterator();
            while (iterator.hasNext()) {
                MathValue mathValue2 = this.evaluateOperand((Expression)iterator.next());
                if (mathValue == null) {
                    mathValue = mathValue2;
                    continue;
                }
                mathValue = this.doProduct(mathValue, mathValue2);
            }
            return mathValue;
        }
        throw new IllegalArgumentException("Unrecognized operand type to Product");
    }

    private MathValue doProduct(MathValue mathValue, MathValue mathValue2) {
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathScalar) {
            MathScalar mathScalar = (MathScalar)mathValue;
            MathScalar mathScalar2 = (MathScalar)mathValue2;
            Number number = this.productSimple(mathScalar.realValue, mathScalar2.realValue);
            return new MathScalar(number);
        }
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathVector || mathValue instanceof MathVector && mathValue2 instanceof MathScalar) {
            MathVector mathVector;
            MathScalar mathScalar;
            if (mathValue instanceof MathScalar) {
                mathScalar = (MathScalar)mathValue;
                mathVector = (MathVector)mathValue2;
            } else {
                mathVector = (MathVector)mathValue;
                mathScalar = (MathScalar)mathValue2;
            }
            Number[] numberArray = new Number[mathVector.size];
            for (int i2 = 0; i2 < mathVector.size; ++i2) {
                numberArray[i2] = this.productSimple(mathScalar.realValue, mathVector.realValues[i2]);
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathMatrix || mathValue instanceof MathMatrix && mathValue2 instanceof MathScalar) {
            MathMatrix mathMatrix;
            MathScalar mathScalar;
            if (mathValue instanceof MathScalar) {
                mathScalar = (MathScalar)mathValue;
                mathMatrix = (MathMatrix)mathValue2;
            } else {
                mathMatrix = (MathMatrix)mathValue;
                mathScalar = (MathScalar)mathValue2;
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix.columns];
            for (int i3 = 0; i3 < mathMatrix.rows; ++i3) {
                for (int i4 = 0; i4 < mathMatrix.columns; ++i4) {
                    numberArray[i3][i4] = this.productSimple(mathScalar.realValue, mathMatrix.realValues[i3][i4]);
                }
            }
            return new MathMatrix(numberArray);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathVector) {
            MathVector mathVector = (MathVector)mathValue;
            MathVector mathVector2 = (MathVector)mathValue2;
            if (mathVector.size != mathVector2.size) {
                throw new OperandMismatchException("Cannot compute the dot product of different-sized vectors");
            }
            Number number = new Integer(0);
            for (int i5 = 0; i5 < mathVector.size; ++i5) {
                number = this.sum(number, this.productSimple(mathVector.realValues[i5], mathVector2.realValues[i5]));
            }
            return new MathScalar(number);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathMatrix) {
            MathVector mathVector = (MathVector)mathValue;
            MathMatrix mathMatrix = (MathMatrix)mathValue2;
            if (mathVector.size != mathMatrix.rows) {
                throw new OperandMismatchException("Vector and matrix sizes do not match");
            }
            Number[] numberArray = new Number[mathMatrix.columns];
            for (int i6 = 0; i6 < mathMatrix.columns; ++i6) {
                numberArray[i6] = new Integer(0);
                for (int i7 = 0; i7 < mathVector.size; ++i7) {
                    numberArray[i6] = this.sum(numberArray[i6], this.productSimple(mathVector.realValues[i7], mathMatrix.realValues[i7][i6]));
                }
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathVector) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathVector mathVector = (MathVector)mathValue2;
            if (mathVector.size != mathMatrix.columns) {
                throw new OperandMismatchException("Vector and matrix sizes do not match");
            }
            Number[] numberArray = new Number[mathMatrix.rows];
            for (int i8 = 0; i8 < mathMatrix.rows; ++i8) {
                numberArray[i8] = new Integer(0);
                for (int i9 = 0; i9 < mathVector.size; ++i9) {
                    numberArray[i8] = this.sum(numberArray[i8], this.productSimple(mathMatrix.realValues[i8][i9], mathVector.realValues[i9]));
                }
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathMatrix) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathMatrix mathMatrix2 = (MathMatrix)mathValue2;
            if (mathMatrix.columns != mathMatrix2.rows) {
                throw new OperandMismatchException("Cannot multiply matrices of non-complementary sizes");
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix2.columns];
            for (int i10 = 0; i10 < mathMatrix.rows; ++i10) {
                for (int i11 = 0; i11 < mathMatrix2.columns; ++i11) {
                    numberArray[i10][i11] = this.productSimple(mathMatrix.realValues[i10][i11], mathMatrix2.realValues[i10][i11]);
                    numberArray[i10][i11] = new Integer(0);
                    for (int i12 = 0; i12 < mathMatrix.columns; ++i12) {
                        numberArray[i10][i11] = this.sum(numberArray[i10][i11], this.productSimple(mathMatrix.realValues[i10][i12], mathMatrix2.realValues[i12][i11]));
                    }
                }
            }
            return new MathMatrix(numberArray);
        }
        throw new OperandMismatchException("Cannot multiply given operands");
    }

    private Number sum(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() + number2.doubleValue());
        }
        return new Integer(number.intValue() + number2.intValue());
    }

    private Number productSimple(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() * number2.doubleValue());
        }
        return new Integer(number.intValue() * number2.intValue());
    }
}

