/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.OperandMismatchException;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Multiply
extends Operation {
    public Multiply() {
    }

    public Multiply(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Multiply(Expression expression, Number number) {
        super(expression, number);
    }

    public Multiply(Number number, Expression expression) {
        super(number, expression);
    }

    public Multiply(Number number, Number number2) {
        super(number, number2);
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Multiplication is not defined on zero operands");
        }
        if (this.leftOperand == null) {
            return this.rightOperand.evaluate();
        }
        if (this.rightOperand == null) {
            return this.leftOperand.evaluate();
        }
        return this.getResult(this.leftOperand, this.rightOperand);
    }

    private Result getResult(Expression expression, Expression expression2) {
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expression = expression.evaluate();
        }
        if (expression2 instanceof Operation || expression2 instanceof ExpressionReference) {
            expression2 = expression2.evaluate();
        }
        if (expression instanceof MathValue && expression2 instanceof MathValue) {
            MathValue mathValue = (MathValue)expression;
            MathValue mathValue2 = (MathValue)expression2;
            return this.doMultiply(mathValue, mathValue2);
        }
        if (expression instanceof ExpressionList && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression;
            ExpressionList expressionList2 = (ExpressionList)expression2;
            if (expressionList.size() != expressionList2.size()) {
                throw new OperandMismatchException("Cannot multiply lists of different sizes");
            }
            Iterator iterator = expressionList.iterator();
            Iterator iterator2 = expressionList2.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression3 = (Expression)iterator.next();
                Expression expression4 = (Expression)iterator2.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression3, expression4));
            }
            return mathExpressionList;
        }
        if (expression instanceof MathValue && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression2;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression5 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression, expression5));
            }
            return mathExpressionList;
        }
        if (expression instanceof ExpressionList && expression2 instanceof MathValue) {
            ExpressionList expressionList = (ExpressionList)expression;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression6 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression6, expression2));
            }
            return mathExpressionList;
        }
        throw new OperandMismatchException("Cannot multiply given data types");
    }

    private MathValue doMultiply(MathValue mathValue, MathValue mathValue2) {
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathScalar) {
            MathScalar mathScalar = (MathScalar)mathValue;
            MathScalar mathScalar2 = (MathScalar)mathValue2;
            Number number = this.multiplySimple(mathScalar.realValue, mathScalar2.realValue);
            return new MathScalar(number);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathScalar || mathValue instanceof MathScalar && mathValue2 instanceof MathVector) {
            MathVector mathVector;
            MathScalar mathScalar;
            if (mathValue instanceof MathVector) {
                mathScalar = (MathScalar)mathValue;
                mathVector = (MathVector)mathValue2;
            } else {
                mathScalar = (MathScalar)mathValue2;
                mathVector = (MathVector)mathValue;
            }
            Number[] numberArray = new Number[mathVector.size];
            for (int i2 = 0; i2 < mathVector.size; ++i2) {
                numberArray[i2] = this.multiplySimple(mathVector.realValues[i2], mathScalar.realValue);
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathScalar) {
            MathMatrix mathMatrix;
            MathScalar mathScalar;
            if (mathValue instanceof MathVector) {
                mathScalar = (MathScalar)mathValue;
                mathMatrix = (MathMatrix)mathValue2;
            } else {
                mathScalar = (MathScalar)mathValue2;
                mathMatrix = (MathMatrix)mathValue;
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix.columns];
            for (int i3 = 0; i3 < mathMatrix.rows; ++i3) {
                for (int i4 = 0; i4 < mathMatrix.columns; ++i4) {
                    numberArray[i3][i4] = this.multiplySimple(mathMatrix.realValues[i3][i4], mathScalar.realValue);
                }
            }
            return new MathMatrix(numberArray);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathVector) {
            MathVector mathVector = (MathVector)mathValue;
            MathVector mathVector2 = (MathVector)mathValue2;
            if (mathVector.size != mathVector2.size) {
                throw new OperandMismatchException("Cannot compute the dot product of different-sized vectors");
            }
            Number number = new Integer(0);
            for (int i5 = 0; i5 < mathVector.size; ++i5) {
                number = this.sum(number, this.multiplySimple(mathVector.realValues[i5], mathVector2.realValues[i5]));
            }
            return new MathScalar(number);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathMatrix) {
            MathVector mathVector = (MathVector)mathValue;
            MathMatrix mathMatrix = (MathMatrix)mathValue2;
            if (mathVector.size != mathMatrix.rows) {
                throw new OperandMismatchException("Vector and matrix sizes do not match");
            }
            Number[] numberArray = new Number[mathMatrix.columns];
            for (int i6 = 0; i6 < mathMatrix.columns; ++i6) {
                numberArray[i6] = new Integer(0);
                for (int i7 = 0; i7 < mathVector.size; ++i7) {
                    numberArray[i6] = this.sum(numberArray[i6], this.multiplySimple(mathVector.realValues[i7], mathMatrix.realValues[i7][i6]));
                }
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathVector) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathVector mathVector = (MathVector)mathValue2;
            if (mathVector.size != mathMatrix.columns) {
                throw new OperandMismatchException("Vector and matrix sizes do not match");
            }
            Number[] numberArray = new Number[mathMatrix.rows];
            for (int i8 = 0; i8 < mathMatrix.rows; ++i8) {
                numberArray[i8] = new Integer(0);
                for (int i9 = 0; i9 < mathVector.size; ++i9) {
                    numberArray[i8] = this.sum(numberArray[i8], this.multiplySimple(mathMatrix.realValues[i8][i9], mathVector.realValues[i9]));
                }
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathMatrix) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathMatrix mathMatrix2 = (MathMatrix)mathValue2;
            if (mathMatrix.columns != mathMatrix2.rows) {
                throw new OperandMismatchException("Cannot multiply matrices of non-complementary sizes");
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix2.columns];
            for (int i10 = 0; i10 < mathMatrix.rows; ++i10) {
                for (int i11 = 0; i11 < mathMatrix2.columns; ++i11) {
                    numberArray[i10][i11] = this.multiplySimple(mathMatrix.realValues[i10][i11], mathMatrix2.realValues[i10][i11]);
                    numberArray[i10][i11] = new Integer(0);
                    for (int i12 = 0; i12 < mathMatrix.columns; ++i12) {
                        numberArray[i10][i11] = this.sum(numberArray[i10][i11], this.multiplySimple(mathMatrix.realValues[i10][i12], mathMatrix2.realValues[i12][i11]));
                    }
                }
            }
            return new MathMatrix(numberArray);
        }
        throw new OperandMismatchException("Cannot multiply the given data types");
    }

    private Number sum(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() + number2.doubleValue());
        }
        return new Integer(number.intValue() + number2.intValue());
    }

    private Number multiplySimple(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() * number2.doubleValue());
        }
        return new Integer(number.intValue() * number2.intValue());
    }
}

