/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.RealComparator;
import com.klg.jclass.util.formulae.Result;

public class Median
extends Operation {
    public Median(Expression expression) {
        super(expression);
    }

    public Median(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Median is not defined on zero operands");
        }
        MathExpressionList mathExpressionList = new MathExpressionList();
        if (this.leftOperand != null) {
            this.addElements(mathExpressionList, this.leftOperand);
        }
        if (this.rightOperand != null) {
            this.addElements(mathExpressionList, this.rightOperand);
        }
        int n2 = ((ExpressionList)mathExpressionList).size();
        int n3 = n2 / 2;
        MathValue mathValue = null;
        if (n2 % 2 == 0) {
            if (n2 > 0) {
                MathValue mathValue2 = this.findLocation(mathExpressionList, n3 - 1);
                MathValue mathValue3 = this.findLocation(mathExpressionList, n3);
                double d2 = mathValue2.numberValue().doubleValue();
                double d3 = mathValue3.numberValue().doubleValue();
                mathValue = new MathScalar((d2 + d3) / 2.0);
            }
        } else {
            mathValue = this.findLocation(mathExpressionList, n3);
        }
        return mathValue;
    }

    private void addElements(ExpressionList expressionList, Expression expression) {
        if (expression instanceof MathValue) {
            if (expression instanceof MathVector || expression instanceof MathMatrix) {
                throw new IllegalArgumentException("Median:  No ordering defined for vectors or matrices");
            }
            expressionList.add(expression);
        } else if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expressionList.add(expression.evaluate());
        } else if (expression instanceof ExpressionList) {
            for (Expression expression2 : (ExpressionList)expression) {
                this.addElements(expressionList, expression2);
            }
        } else {
            throw new IllegalArgumentException("Median: Unrecognised math type in ExpressionList");
        }
    }

    private MathValue findLocation(ExpressionList expressionList, int n2) {
        MathValue mathValue = (MathValue)expressionList.get(n2);
        RealComparator realComparator = new RealComparator();
        MathExpressionList mathExpressionList = new MathExpressionList();
        MathExpressionList mathExpressionList2 = new MathExpressionList();
        MathExpressionList mathExpressionList3 = new MathExpressionList();
        for (MathValue mathValue2 : expressionList) {
            if (realComparator.compare(mathValue2, mathValue) < 0) {
                ((ExpressionList)mathExpressionList).add(mathValue2);
                continue;
            }
            if (realComparator.compare(mathValue2, mathValue) > 0) {
                ((ExpressionList)mathExpressionList2).add(mathValue2);
                continue;
            }
            ((ExpressionList)mathExpressionList3).add(mathValue2);
        }
        if (((ExpressionList)mathExpressionList).size() >= n2 + 1) {
            return this.findLocation(mathExpressionList, n2);
        }
        if (((ExpressionList)mathExpressionList3).size() >= (n2 -= ((ExpressionList)mathExpressionList).size()) + 1) {
            return mathValue;
        }
        if (((ExpressionList)mathExpressionList2).size() >= (n2 -= ((ExpressionList)mathExpressionList3).size()) + 1) {
            return this.findLocation(mathExpressionList2, n2);
        }
        throw new IllegalArgumentException("Median: Invalid MathValues in list");
    }
}

