/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Ceiling
extends Operation {
    public Ceiling(Expression expression) {
        super(expression);
    }

    public Ceiling(Number number) {
        super(number);
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Ceiling is not defined on zero operands");
        }
        if (this.leftOperand != null && this.rightOperand != null) {
            throw new IllegalArgumentException("Ceiling is not a binary operator");
        }
        if (this.leftOperand == null) {
            return this.getResult(this.rightOperand);
        }
        return this.getResult(this.leftOperand);
    }

    private Result getResult(Expression expression) {
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expression = expression.evaluate();
        }
        if (expression instanceof MathValue) {
            MathValue mathValue = (MathValue)expression;
            return this.doCeiling(mathValue);
        }
        if (expression instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression2));
            }
            return mathExpressionList;
        }
        throw new IllegalArgumentException("Unrecognised math type to Ceiling");
    }

    private MathValue doCeiling(MathValue mathValue) {
        if (!(mathValue instanceof MathScalar)) {
            throw new IllegalArgumentException("Can't take the Ceiling of a vector or matrix.");
        }
        MathScalar mathScalar = (MathScalar)mathValue;
        Number number = this.ceilingSimple(mathScalar.realValue);
        return new MathScalar(number);
    }

    private Number ceilingSimple(Number number) {
        Number number2 = null;
        if (number instanceof Integer) {
            number2 = new Integer(number.intValue());
        }
        if (number instanceof Double) {
            number2 = new Double(Math.ceil(number.doubleValue()));
        }
        return number2;
    }
}

