/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Abs
extends Operation {
    public Abs(Expression expression) {
        super(expression);
    }

    public Abs(Number number) {
        super(number);
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Absolute value is not defined on zero operands");
        }
        if (this.leftOperand != null && this.rightOperand != null) {
            throw new IllegalArgumentException("Absolute value is not a binary operator");
        }
        if (this.leftOperand == null) {
            return this.getResult(this.rightOperand);
        }
        return this.getResult(this.leftOperand);
    }

    private Result getResult(Expression expression) {
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expression = expression.evaluate();
        }
        if (expression instanceof MathValue) {
            MathValue mathValue = (MathValue)expression;
            return this.doAbs(mathValue);
        }
        if (expression instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression2));
            }
            return mathExpressionList;
        }
        throw new IllegalArgumentException("Unrecognised math type to Absolute value");
    }

    private MathValue doAbs(MathValue mathValue) {
        if (!(mathValue instanceof MathScalar)) {
            throw new IllegalArgumentException("Can't compute the absolute value of a vector or matrix.");
        }
        MathScalar mathScalar = (MathScalar)mathValue;
        Number number = this.absSimple(mathScalar.realValue);
        return new MathScalar(number);
    }

    private Number absSimple(Number number) {
        Number number2 = null;
        if (number instanceof Integer) {
            number2 = new Integer(Math.abs(number.intValue()));
        }
        if (number instanceof Double) {
            number2 = new Double(Math.abs(number.doubleValue()));
        }
        return number2;
    }
}

