/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.swing.DefaultSpinBoxModel;
import com.klg.jclass.util.swing.JCSpinBox;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Locale;

public class MonthSpin
extends JCSpinBox
implements CalendarComponent,
JCValueListener,
ItemListener {
    protected Locale locale = null;
    protected JCValueModel calendarModel;
    protected int selectedMonth = 0;
    protected String[] months;
    protected boolean userSetMonths = false;
    protected JCListenerList actionListeners = null;
    protected boolean ignoreChange = false;

    public MonthSpin(JCValueModel jCValueModel, Locale locale) {
        this(jCValueModel, locale, null);
    }

    public MonthSpin(JCValueModel jCValueModel, Locale locale, String[] stringArray) {
        this.months = stringArray;
        if (this.months != null) {
            this.userSetMonths = true;
        }
        this.setLocale(locale);
        this.setCalendarModel(jCValueModel);
        this.addItemListener(this);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.locale == locale) {
            return;
        }
        super.setLocale(locale);
        this.locale = locale;
        boolean bl = false;
        int n2 = 0;
        if (this.getModel() != null) {
            n2 = this.getSelectedIndex();
            bl = true;
        }
        if (!this.userSetMonths) {
            this.months = JCCalendar.getMonths(this.locale, false);
        }
        this.setModel(new DefaultSpinBoxModel(this.months));
        if (bl) {
            this.setSelectedIndex((n2 + 1) % this.months.length);
            this.setSelectedIndex(n2);
        }
        this.repaint();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        if (this.calendarModel != null) {
            this.calendarModel.removeValueListener(this);
        }
        this.calendarModel = jCValueModel;
        this.valueChanged(null);
        this.calendarModel.addValueListener(this);
        this.repaint();
    }

    public JCValueModel getCalendarModel() {
        return this.calendarModel;
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
    }

    public JCCalendar getSpecialDates(JCCalendar jCCalendar) {
        return this.getSpecialDates();
    }

    public JCCalendar getSpecialDates() {
        return null;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.ignoreChange) {
            return;
        }
        this.ignoreChange = true;
        DefaultSpinBoxModel defaultSpinBoxModel = (DefaultSpinBoxModel)this.getModel();
        this.selectedMonth = defaultSpinBoxModel.getIndexOf(this.getModel().getSelectedItem());
        Calendar calendar = JCCalendar.copyCalendar((Calendar)this.calendarModel.getValue());
        calendar.set(2, this.selectedMonth);
        this.calendarModel.setValue(calendar);
        int n2 = ((Calendar)this.calendarModel.getValue()).get(2);
        if (n2 != this.selectedMonth) {
            this.setSelectedIndex(n2);
            this.selectedMonth = n2;
        }
        this.ignoreChange = false;
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        if (this.ignoreChange) {
            return;
        }
        this.ignoreChange = true;
        this.setSelectedIndex(((Calendar)this.calendarModel.getValue()).get(2));
        this.ignoreChange = false;
    }
}

