/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.DateActionEvent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.calendar.JCDateChooser;
import com.klg.jclass.util.value.CalendarValueModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DayTable
extends JScrollPane
implements CalendarComponent,
MouseListener,
MouseMotionListener {
    transient JCLocaleManager li = JCLocaleManager.getDefault();
    protected JCValueModel selectedDate;
    protected JCCalendar specialDates;
    protected int componentSpacing = 4;
    protected Color otherBackground;
    protected Color otherForeground;
    protected Color specialBackground;
    protected Color specialForeground;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected int tableCellSize;
    protected int cellSize = 0;
    protected Locale locale;
    protected String[] days = null;
    protected boolean userSetDays = false;
    protected int firstDayOfWeek;
    protected int year;
    protected int month;
    protected int day;
    protected int startingCell;
    protected boolean isDragging = false;
    protected static int NUM_ROWS = 6;
    protected static int NUM_DAYS = 7;
    protected static int MIN_CELL_SIZE = 25;
    protected JTable table;
    protected boolean editable = true;
    protected JCListenerList actionListeners = null;
    protected Calendar intermediateDate = null;
    protected DayModel dayModel;

    public DayTable(JCValueModel jCValueModel, JCCalendar jCCalendar, Locale locale) {
        this(jCValueModel, jCCalendar, locale, null);
    }

    public DayTable(JCValueModel jCValueModel, JCCalendar jCCalendar, Locale locale, String[] stringArray) {
        this.days = stringArray;
        if (this.days != null) {
            this.userSetDays = true;
        }
        this.table = new JTable();
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(21);
        this.setViewportView(this.table);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setDefaultRenderer(Integer.class, new Renderer());
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        if (jCValueModel == null) {
            jCValueModel = new CalendarValueModel(Calendar.getInstance());
        }
        this.selectedDate = jCValueModel;
        this.specialDates = jCCalendar;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
        this.setCalendarModel(jCValueModel);
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setSelectedDateBackground(Color color) {
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("selectionBackground", this.selectionBackground, color);
        this.selectionBackground = color;
        this.repaint();
    }

    public void setSelectedDateForeground(Color color) {
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("selectionForeground", this.selectionForeground, color);
        this.selectionForeground = color;
        this.repaint();
    }

    public void setSpecialDateBackground(Color color) {
        if (this.specialBackground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("specialBackground", this.specialBackground, color);
        this.specialBackground = color;
        this.repaint();
    }

    public void setSpecialDateForeground(Color color) {
        if (this.specialForeground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("specialForeground", this.specialForeground, color);
        this.specialForeground = color;
        this.repaint();
    }

    public void setOtherDateBackground(Color color) {
        if (this.otherBackground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("otherBackground", this.otherBackground, color);
        this.otherBackground = color;
        this.repaint();
    }

    public void setOtherDateForeground(Color color) {
        if (this.otherForeground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("otherForeground", this.otherForeground, color);
        this.otherForeground = color;
        this.repaint();
    }

    public void setLocale(Locale locale) {
        if (this.table != null) {
            if (locale == null) {
                throw new IllegalArgumentException("null is an invalid value for locale");
            }
            if (this.locale == locale) {
                return;
            }
            this.firePropertyChange("locale", this.locale, locale);
            this.locale = locale;
            Calendar calendar = Calendar.getInstance(this.locale);
            this.firstDayOfWeek = (calendar.getFirstDayOfWeek() + 6) % NUM_DAYS;
            this.calculateCalendar();
            if (this.dayModel != null && this.selectedDate != null) {
                this.selectedDate.removeValueListener(this.dayModel);
            }
            this.dayModel = new DayModel(this.locale);
            if (this.selectedDate != null) {
                this.selectedDate.addValueListener(this.dayModel);
            }
            this.table.setLocale(this.locale);
            this.table.setModel(this.dayModel);
            this.adjustSize();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.table != null) {
            this.table.setFont(font);
            this.table.getTableHeader().setFont(font);
            this.adjustSize();
        }
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        if (this.dayModel != null && this.selectedDate != null) {
            this.selectedDate.removeValueListener(this.dayModel);
        }
        this.selectedDate = jCValueModel;
        this.selectedDate.addValueListener(this.dayModel);
        this.calculateCalendar();
        this.table.repaint();
    }

    public JCValueModel getCalendarModel() {
        return this.selectedDate;
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
        this.specialDates = jCCalendar;
    }

    public JCCalendar getSpecialDates(JCCalendar jCCalendar) {
        return this.getSpecialDates();
    }

    public JCCalendar getSpecialDates() {
        return this.specialDates;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    protected void adjustSize() {
        this.calculateCellSize();
        Dimension dimension = this.table.getTableHeader().getPreferredSize();
        this.table.setPreferredSize(new Dimension(NUM_DAYS * this.tableCellSize, NUM_ROWS * this.tableCellSize + dimension.height));
    }

    public void addNotify() {
        super.addNotify();
        this.adjustSize();
    }

    public void setCellSize(int n2) {
        this.cellSize = n2;
    }

    public int getCellSize() {
        return this.cellSize > 0 ? this.cellSize : this.tableCellSize;
    }

    protected void calculateCalendar() {
        Calendar calendar = (Calendar)this.selectedDate.getValue();
        this.month = calendar.get(2);
        this.year = calendar.get(1);
        this.day = calendar.get(5);
        this.startingCell = JCCalendar.dayOfWeek(1, this.month, this.year);
        if (this.firstDayOfWeek != 0) {
            this.startingCell = (this.startingCell - this.firstDayOfWeek + NUM_DAYS) % NUM_DAYS;
        }
    }

    protected void calculateCellSize() {
        Object object;
        if (this.table == null) {
            return;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (this.cellSize > 0) {
            this.tableCellSize = this.cellSize;
        } else {
            this.tableCellSize = MIN_CELL_SIZE;
            object = this.table.getModel();
            for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
                int n2;
                TableColumn tableColumn = tableColumnModel.getColumn(i2);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.table.getTableHeader().getDefaultRenderer();
                }
                Object object2 = tableColumn.getHeaderValue();
                Component component = tableCellRenderer.getTableCellRendererComponent(this.table, object2, false, false, -1, -1);
                int n3 = component.getPreferredSize().width + this.componentSpacing;
                tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    Class<?> clazz = object.getColumnClass(i2);
                    tableCellRenderer = this.table.getDefaultRenderer(clazz);
                }
                int n4 = 0;
                for (n2 = 0; n2 < this.table.getRowCount(); ++n2) {
                    Object object3 = object.getValueAt(n2, i2);
                    component = tableCellRenderer.getTableCellRendererComponent(this.table, object3, false, false, n2, i2);
                    n4 = Math.max(n4, component.getPreferredSize().width);
                }
                n2 = Math.max(n4 + this.componentSpacing, n3);
                this.tableCellSize = Math.max(this.tableCellSize, n2);
            }
        }
        this.table.setRowHeight(this.tableCellSize);
        object = tableColumnModel.getColumns();
        while (object.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)object.nextElement();
            tableColumn.setMinWidth(this.tableCellSize);
            if (JCEnvironment.getJavaVersion() >= 130) continue;
            tableColumn.setWidth(this.tableCellSize);
        }
    }

    public void fireActionEvent() {
        this.fireActionEvent(false);
    }

    protected void fireActionEvent(boolean bl) {
        DateActionEvent dateActionEvent = new DateActionEvent((Object)this, 1001, "DateSelected", bl);
        Enumeration<Object> enumeration = JCListenerList.elements(this.actionListeners);
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(dateActionEvent);
        }
    }

    public int dayFromRowColumn(int n2, int n3) {
        return n3 - (this.startingCell - 1) + n2 * NUM_DAYS;
    }

    protected int getDayFromPoint(Point point) {
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.columnAtPoint(point);
        return this.dayFromRowColumn(n2, n3);
    }

    protected Calendar getCalendarFromDay(int n2) {
        Calendar calendar = JCCalendar.copyCalendar((Calendar)this.selectedDate.getValue());
        calendar.set(5, n2);
        return calendar;
    }

    protected Calendar getCalendarFromPoint(Point point) {
        return this.getCalendarFromDay(this.getDayFromPoint(point));
    }

    protected boolean isDayInCurrentMonth(int n2) {
        return n2 >= 1 && n2 <= JCCalendar.daysInMonth(this.month, this.year);
    }

    protected boolean isValidDate(Calendar calendar) {
        boolean bl = true;
        Container container = this.getParent();
        if (container instanceof JCDateChooser) {
            bl = ((JCDateChooser)container).boundsValidator.isValid(calendar);
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.editable) {
            return;
        }
        Calendar calendar = this.getCalendarFromPoint(mouseEvent.getPoint());
        if (this.isValidDate(calendar)) {
            this.intermediateDate = calendar;
            this.table.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.editable) {
            if (mouseEvent.getClickCount() >= 2) {
                this.fireActionEvent(true);
            }
            return;
        }
        this.intermediateDate = null;
        int n2 = this.getDayFromPoint(mouseEvent.getPoint());
        boolean bl = !this.isDragging || this.isDayInCurrentMonth(n2);
        this.isDragging = false;
        if (!bl) {
            return;
        }
        Calendar calendar = this.getCalendarFromDay(n2);
        boolean bl2 = false;
        if (calendar.equals(this.selectedDate.getValue()) && mouseEvent.getClickCount() >= 2) {
            bl2 = true;
        } else {
            this.selectedDate.setValue(calendar);
        }
        this.fireActionEvent(bl2);
        this.table.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Calendar calendar;
        if (!this.editable) {
            return;
        }
        int n2 = this.getDayFromPoint(mouseEvent.getPoint());
        if (this.isDayInCurrentMonth(n2) && this.isValidDate(calendar = this.getCalendarFromDay(n2))) {
            this.intermediateDate = calendar;
            this.isDragging = true;
            this.table.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n2 = JCEnvironment.isWorking("MotifPreferedWidthAjustment") + insets.top + insets.bottom;
        Dimension dimension = this.table.getTableHeader().getPreferredSize();
        return new Dimension(NUM_DAYS * this.tableCellSize + insets.left + insets.right, NUM_ROWS * this.tableCellSize + dimension.height + n2);
    }

    public boolean isSelectedDate(int n2, int n3) {
        Calendar calendar;
        int n4 = this.dayFromRowColumn(n2, n3);
        return this.intermediateDate != null ? n4 == (calendar = this.intermediateDate).get(5) : n4 == this.day;
    }

    public boolean isSelectedMonth(int n2, int n3) {
        int n4 = this.dayFromRowColumn(n2, n3);
        return this.isDayInCurrentMonth(n4);
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this.inferLookAndFeel();
    }

    public void updateUI() {
        super.updateUI();
        this.inferLookAndFeel();
    }

    protected void inferLookAndFeel() {
        this.setBackground(UIManager.getColor("Label.background"));
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setSpecialDateBackground(UIManager.getColor("Label.background"));
        this.setSpecialDateForeground(Color.blue);
        this.setSelectedDateBackground(UIManager.getColor("TextField.selectionBackground"));
        this.setSelectedDateForeground(UIManager.getColor("TextField.selectionForeground"));
        this.setOtherDateBackground(UIManager.getColor("Label.background"));
        this.setOtherDateForeground(UIManager.getColor("Label.disabledForeground"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DayModel
    implements TableModel,
    JCValueListener,
    Serializable {
        protected JCListenerList tableListeners = null;

        public DayModel(Locale locale) {
            if (!DayTable.this.userSetDays) {
                DayTable.this.days = JCCalendar.getDays(locale);
            }
        }

        @Override
        public int getRowCount() {
            return NUM_ROWS;
        }

        @Override
        public int getColumnCount() {
            return NUM_DAYS;
        }

        @Override
        public String getColumnName(int n2) {
            return DayTable.this.days[(n2 + DayTable.this.firstDayOfWeek) % 7];
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            int n4 = DayTable.this.dayFromRowColumn(n2, n3);
            if (n4 < 1) {
                int n5;
                int n6;
                if (DayTable.this.month - 1 < 0) {
                    n6 = 11;
                    n5 = DayTable.this.year - 1;
                } else {
                    n6 = DayTable.this.month - 1;
                    n5 = DayTable.this.year;
                }
                return new Integer(JCCalendar.daysInMonth(n6, n5) - (DayTable.this.startingCell - n3 - 1));
            }
            if (n4 > JCCalendar.daysInMonth(DayTable.this.month, DayTable.this.year)) {
                return new Integer(n4 - JCCalendar.daysInMonth(DayTable.this.month, DayTable.this.year));
            }
            return new Integer(n4);
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            throw new IllegalArgumentException("This TableModel is READ ONLY");
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.tableListeners = JCListenerList.add(this.tableListeners, tableModelListener);
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.tableListeners = JCListenerList.remove(this.tableListeners, tableModelListener);
        }

        protected Calendar copyCalendar(Calendar calendar) {
            if (calendar == null) {
                return null;
            }
            return (Calendar)calendar.clone();
        }

        @Override
        public void valueChanging(JCValueEvent jCValueEvent) {
        }

        @Override
        public void valueChanged(JCValueEvent jCValueEvent) {
            if (jCValueEvent == null) {
                return;
            }
            DayTable.this.calculateCalendar();
            TableModelEvent tableModelEvent = new TableModelEvent(this);
            Enumeration<Object> enumeration = JCListenerList.elements(this.tableListeners);
            while (enumeration.hasMoreElements()) {
                TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
                tableModelListener.tableChanged(tableModelEvent);
            }
        }
    }

    protected class Renderer
    extends JLabel
    implements TableCellRenderer,
    Serializable {
        protected Border bevel = new SoftBevelBorder(1);
        protected Border empty = new EmptyBorder(0, 0, 0, 0);

        protected Renderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            this.setHorizontalAlignment(0);
            this.setFont(jTable.getFont());
            if (DayTable.this.isSelectedDate(n2, n3)) {
                this.setForeground(DayTable.this.selectionForeground);
                this.setBackground(DayTable.this.selectionBackground);
                this.setBorder(this.bevel);
                this.setOpaque(true);
            } else {
                if (DayTable.this.isSelectedMonth(n2, n3)) {
                    int n4 = DayTable.this.dayFromRowColumn(n2, n3);
                    if (DayTable.this.specialDates != null && DayTable.this.specialDates.isSpecialDate(DayTable.this.year, DayTable.this.month, n4, n2 + 1)) {
                        this.setForeground(DayTable.this.specialForeground);
                        this.setBackground(DayTable.this.specialBackground);
                    } else {
                        this.setForeground(DayTable.this.getForeground());
                        this.setBackground(DayTable.this.getBackground());
                    }
                } else {
                    this.setForeground(DayTable.this.otherForeground);
                    this.setBackground(DayTable.this.otherBackground);
                }
                this.setBorder(this.empty);
                this.setOpaque(true);
            }
            if (object == null) {
                this.setText("");
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }
}

