/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.JCStringTokenizer;
import java.awt.Point;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCTypeConverter {
    public static boolean reportErrors = true;

    public static void error(String string, String string2) {
        JCTypeConverter.error("Error parsing '" + string2 + "' in " + string);
    }

    public static void error(String string) {
        System.err.println(string);
    }

    public static void parseError(String string) {
        if (reportErrors) {
            JCTypeConverter.error("Error parsing '" + string + "'");
        }
    }

    public static String trim(Object object) {
        String string;
        if (object == null || (string = object.toString()) == null) {
            return null;
        }
        int n2 = (string = string.trim()).indexOf(0);
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static int toInt(String string, int n2) {
        if (string == null) {
            return n2;
        }
        if (string.equalsIgnoreCase("max")) {
            return Integer.MAX_VALUE;
        }
        if (string.equalsIgnoreCase("min")) {
            return Integer.MIN_VALUE;
        }
        if (string.equalsIgnoreCase("maxint")) {
            return Integer.MAX_VALUE;
        }
        if (string.equalsIgnoreCase("novalue")) {
            return -999;
        }
        if (string.equalsIgnoreCase("variable")) {
            return -998;
        }
        if (string.equalsIgnoreCase("default")) {
            return -999;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            JCTypeConverter.parseError(string);
            return n2;
        }
    }

    public static double toDouble(String string, double d2) {
        if (string == null) {
            return d2;
        }
        try {
            double d3 = string.equalsIgnoreCase("MAX") ? Double.MAX_VALUE : (string.equalsIgnoreCase("MIN") ? Double.MIN_VALUE : (string.equalsIgnoreCase("INFINITY") ? Double.POSITIVE_INFINITY : Double.valueOf(string)));
            return d3;
        }
        catch (Exception exception) {
            JCTypeConverter.parseError(string);
            return d2;
        }
    }

    public static boolean toBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        try {
            return Boolean.valueOf(string);
        }
        catch (Exception exception) {
            JCTypeConverter.parseError(string);
            return bl;
        }
    }

    public static String[] toStringList(String string) {
        return JCTypeConverter.toStringList(string, ',');
    }

    public static String[] toStringList(String string, char c2) {
        return JCTypeConverter.toStringList(string, c2, true);
    }

    public static String[] toStringList(String string, char c2, boolean bl) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string, false);
        String[] stringArray = new String[jCStringTokenizer.countTokens(c2)];
        int n2 = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = jCStringTokenizer.nextToken(c2);
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = string3.trim()) == null) {
                string2 = "";
            }
            stringArray[n2] = bl ? string2 : string3;
            ++n2;
        }
        return stringArray;
    }

    public static Point[] toPointList(String string, char c2) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c2);
            if (string2 == null) continue;
            JCStringTokenizer jCStringTokenizer2 = new JCStringTokenizer(string2);
            String string3 = jCStringTokenizer2.nextToken(',');
            String string4 = jCStringTokenizer2.nextToken(',');
            if (string3 == null || string4 == null) continue;
            try {
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                arrayList.add(new Point(n2, n3));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return arrayList.toArray(new Point[arrayList.size()]);
    }

    public static String fromStringList(String[] stringArray) {
        return JCTypeConverter.fromStringList(stringArray, ',');
    }

    public static String fromStringList(String[] stringArray, char c2) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            if (i2 == stringArray.length - 1) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String fromStringList(List<String> list) {
        return JCTypeConverter.fromStringList(list, ',');
    }

    public static String fromStringList(List<String> list, char c2) {
        if (list == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            stringBuffer.append(list.get(i2));
            if (i2 == list.size() - 1) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String fromPointList(Point[] pointArray, char c2) {
        if (pointArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Point point : pointArray) {
            if (point == null) continue;
            stringBuffer.append(Integer.toString(point.x));
            stringBuffer.append(',');
            stringBuffer.append(Integer.toString(point.y));
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static int[] toIntList(String string, char c2) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        int[] nArray = new int[jCStringTokenizer.countTokens(c2)];
        int n2 = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c2).trim();
            nArray[n2] = JCTypeConverter.toInt(string2, 0);
            ++n2;
        }
        return nArray;
    }

    public static Integer[] toIntegerList(String string, char c2) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Integer[] integerArray = new Integer[jCStringTokenizer.countTokens(c2)];
        int n2 = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c2).trim();
            integerArray[n2] = new Integer(JCTypeConverter.toInt(string2, 0));
            ++n2;
        }
        return integerArray;
    }

    public static Double[] toDoubleList(String string, char c2) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Double[] doubleArray = new Double[jCStringTokenizer.countTokens(c2)];
        int n2 = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c2).trim();
            doubleArray[n2] = new Double(JCTypeConverter.toDouble(string2, 0.0));
            ++n2;
        }
        return doubleArray;
    }

    public static double[] toPrimitiveDoubleList(String string, char c2) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        double[] dArray = new double[jCStringTokenizer.countTokens(c2)];
        int n2 = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c2).trim();
            dArray[n2] = new Double(JCTypeConverter.toDouble(string2, 0.0));
            ++n2;
        }
        return dArray;
    }

    public static float[] toPrimitiveFloatList(String string, char c2) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        float[] fArray = new float[jCStringTokenizer.countTokens(c2)];
        int n2 = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c2).trim();
            fArray[n2] = new Double(JCTypeConverter.toDouble(string2, 0.0)).floatValue();
            ++n2;
        }
        return fArray;
    }

    public static String fromPrimitiveFloatList(float[] fArray, char c2) {
        String string = "";
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            string = string + fArray[i2];
            if (i2 >= fArray.length - 1) continue;
            string = string + c2;
        }
        return string;
    }

    public static int[] toIntList(String string, char c2, int[] nArray) {
        int[] nArray2 = JCTypeConverter.toIntList(string, c2);
        return nArray2 != null ? nArray2 : nArray;
    }

    public static Integer[] toIntegerList(String string, char c2, Integer[] integerArray) {
        Integer[] integerArray2 = JCTypeConverter.toIntegerList(string, c2);
        return integerArray2 != null ? integerArray2 : integerArray;
    }

    public static Double[] toDoubleList(String string, char c2, Double[] doubleArray) {
        Double[] doubleArray2 = JCTypeConverter.toDoubleList(string, c2);
        return doubleArray2 != null ? doubleArray2 : doubleArray;
    }

    public static String toNewLine(String string) {
        if (string == null || string.indexOf("\\n") == -1) {
            return string;
        }
        char[] cArray = new char[string.length()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (string.charAt(n3) == '\\' && n3 < cArray.length - 1 && string.charAt(n3 + 1) == 'n') {
                cArray[n2] = 10;
                ++n3;
            } else {
                cArray[n2] = string.charAt(n3);
            }
            ++n3;
            ++n2;
        }
        return new String(cArray, 0, n2);
    }

    public static String fromNewLine(String string) {
        int n2;
        if (string == null || string.indexOf(10) == -1) {
            return string;
        }
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '\n') continue;
            ++n3;
        }
        char[] cArray = new char[string.length() + n3];
        n2 = 0;
        int n4 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                cArray[n4++] = 92;
                cArray[n4] = 110;
            } else {
                cArray[n4] = string.charAt(n2);
            }
            ++n2;
            ++n4;
        }
        return new String(cArray, 0, n4);
    }

    public static Vector<String> toVector(String string, char c2) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Vector<String> vector = new Vector<String>(jCStringTokenizer.countTokens(c2));
        jCStringTokenizer.strip_esc = false;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c2);
            vector.addElement(string2);
        }
        return vector;
    }

    public static Vector<String> toVector(String string, char c2, Vector<String> vector) {
        Vector<String> vector2 = JCTypeConverter.toVector(string, c2);
        return vector2 != null ? vector2 : vector;
    }

    public static int toEnum(String string, String string2, String string3, String[][] stringArray, int[][] nArray, int n2) {
        int n3;
        if (string3 == null) {
            string3 = string2;
        }
        for (n3 = 0; n3 < stringArray.length && !stringArray[n3][0].equalsIgnoreCase(string2); ++n3) {
        }
        if (n3 == stringArray.length) {
            JCTypeConverter.error("Error converting '" + string + "' to " + string3);
            return n2;
        }
        string = string.trim();
        for (int i2 = 1; i2 < stringArray[n3].length; ++i2) {
            if (!string.equalsIgnoreCase(stringArray[n3][i2])) continue;
            return nArray[n3][i2 - 1];
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            JCTypeConverter.error("Error converting '" + string + "' to " + string3);
            return n2;
        }
    }

    public static int toEnum(String string, String string2, String[] stringArray, int[] nArray, int n2) {
        if (string == null) {
            return n2;
        }
        string = string.trim();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.equalsIgnoreCase(stringArray[i2])) continue;
            return nArray[i2];
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            JCTypeConverter.error("Error converting '" + string + "' to " + string2);
            return n2;
        }
    }

    public static long toEnum(String string, String string2, String[] stringArray, long[] lArray, long l2) {
        if (string == null) {
            return l2;
        }
        string = string.trim();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.equalsIgnoreCase(stringArray[i2])) continue;
            return lArray[i2];
        }
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            JCTypeConverter.error("Error converting '" + string + "' to " + string2);
            return l2;
        }
    }

    public static int toEnum(String string, String[] stringArray, int[] nArray, int n2) {
        if (string == null) {
            return n2;
        }
        string = string.trim();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.equalsIgnoreCase(stringArray[i2])) continue;
            return nArray[i2];
        }
        return n2;
    }

    public static int[] toEnumList(String string, String string2, String[] stringArray, int[] nArray, int[] nArray2) {
        if (string == null) {
            return nArray2;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        int[] nArray3 = new int[jCStringTokenizer.countTokens(',')];
        int n2 = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string3 = jCStringTokenizer.nextToken(',').trim();
            int n3 = nArray2 != null && n2 < nArray2.length ? nArray2[n2] : 0;
            nArray3[n2] = JCTypeConverter.toEnum(string3, string2, stringArray, nArray, n3);
            ++n2;
        }
        return nArray3;
    }

    public static String fromEnum(int n2, String[] stringArray, int[] nArray) {
        if (nArray == null || stringArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n2 != nArray[i2] || i2 >= stringArray.length) continue;
            return stringArray[i2];
        }
        return null;
    }

    public static String fromEnum(long l2, String[] stringArray, long[] lArray) {
        if (lArray == null || stringArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (l2 != lArray[i2] || i2 >= stringArray.length) continue;
            return stringArray[i2];
        }
        return null;
    }

    public static String fromEnum(int n2, String string, String string2, String[][] stringArray, int[][] nArray, String string3) {
        int n3;
        for (n3 = 0; n3 < stringArray.length && !stringArray[n3][0].equalsIgnoreCase(string2); ++n3) {
        }
        if (n3 == stringArray.length) {
            return null;
        }
        for (int i2 = 0; i2 < nArray[n3].length; ++i2) {
            if (nArray[n3][i2] != n2) continue;
            return stringArray[n3][i2 + 1];
        }
        try {
            return String.valueOf(n2);
        }
        catch (Exception exception) {
            JCTypeConverter.error("Error converting '" + n2 + "' to " + string);
            return string3;
        }
    }

    public static String fromMatchListObject(Object object, String[] stringArray, Object[] objectArray) {
        if (objectArray == null || stringArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (object != objectArray[i2] || i2 >= stringArray.length) continue;
            return stringArray[i2];
        }
        return null;
    }

    public static Object toMatchListObject(String string, String[] stringArray, Object[] objectArray) {
        if (string == null || objectArray == null || stringArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.equals(stringArray[i2]) || i2 >= objectArray.length) continue;
            return objectArray[i2];
        }
        return null;
    }

    public static void checkEnum(int n2, String string, int[] nArray) {
        for (int n3 : nArray) {
            if (n3 != n2) continue;
            return;
        }
        throw new IllegalArgumentException("invalid " + string + ": " + n2);
    }

    public static String toString(Object object) {
        if (!(object instanceof Vector)) {
            return JCTypeConverter.fromNewLine(object != null ? object.toString() : "");
        }
        Vector vector = (Vector)object;
        StringBuffer stringBuffer = new StringBuffer(vector.size());
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(JCTypeConverter.toString(vector.elementAt(i2)));
            if (i2 >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        return new String(stringBuffer);
    }

    public static Date toDate(String string, Date date) {
        if (string == null) {
            return date;
        }
        try {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
            simpleDateFormat.setCalendar(Calendar.getInstance());
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return date;
        }
    }

    public static String fromDate(Date date, String string) {
        if (date == null) {
            return string;
        }
        try {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
            simpleDateFormat.setCalendar(Calendar.getInstance());
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            return simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String removeEscape(String string) {
        if (string == null || string.indexOf(92) == -1) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            cArray[n4] = n3 + 1 < n2 && c2 == '\\' ? (string.charAt(++n3) == 'n' ? 10 : string.charAt(n3)) : c2;
            ++n3;
            ++n4;
        }
        return n4 > 0 ? new String(cArray, 0, n4) : null;
    }
}

