/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.data;

import com.klg.jclass.table.data.JCCSVFormatParser;
import com.klg.jclass.table.data.JCFileFormatParser;
import com.klg.jclass.table.data.JCStandardFormatParser;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;

public class JCInputStreamDataSource
extends JCVectorDataSource
implements Serializable {
    protected int dataFormat = -1;
    protected JCFileFormatParser customParser = null;

    public JCInputStreamDataSource(InputStream inputStream) throws IOException {
        this.readFromStream(inputStream);
    }

    public JCInputStreamDataSource(InputStream inputStream, int n2) throws IOException {
        this.dataFormat = n2;
        this.readFromStream(inputStream);
    }

    public JCInputStreamDataSource(InputStream inputStream, JCFileFormatParser jCFileFormatParser) throws IOException {
        this.dataFormat = 3;
        this.customParser = jCFileFormatParser;
        this.readFromStream(inputStream);
    }

    public JCInputStreamDataSource(JCFileFormatParser jCFileFormatParser) {
        this.dataFormat = 3;
        this.customParser = jCFileFormatParser;
    }

    public int getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(int n2) {
        this.dataFormat = n2;
    }

    public JCFileFormatParser getCustomParser() {
        return this.customParser;
    }

    public void setCustomParser(JCFileFormatParser jCFileFormatParser) {
        this.customParser = jCFileFormatParser;
    }

    protected JCInputStreamDataSource() {
    }

    protected void readFromStream(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.read(bufferedReader);
    }

    protected void read(Reader reader) throws IOException {
        JCFileFormatParser jCFileFormatParser = null;
        if (this.dataFormat == -1) {
            try {
                reader.mark(1024);
                this.dataFormat = JCInputStreamDataSource.detectFileFormat(reader);
                reader.reset();
            }
            catch (IOException iOException) {
                System.out.println("mark/reset not supported");
                this.dataFormat = 0;
            }
        }
        switch (this.dataFormat) {
            case 0: {
                jCFileFormatParser = new JCStandardFormatParser();
                break;
            }
            case 1: {
                jCFileFormatParser = new JCCSVFormatParser();
                break;
            }
            case 3: {
                jCFileFormatParser = this.customParser;
            }
        }
        if (jCFileFormatParser != null) {
            jCFileFormatParser.readAndParse(reader, this);
        }
    }

    public static int detectFileFormat(Reader reader) {
        int n2 = 1;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        try {
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(97, 122);
            streamTokenizer.wordChars(65, 90);
            streamTokenizer.wordChars(160, 255);
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.commentChar(47);
            streamTokenizer.quoteChar(34);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(39);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.lowerCaseMode(false);
            streamTokenizer.whitespaceChars(43, 43);
            int n3 = streamTokenizer.nextToken();
            if (n3 == -3 && streamTokenizer.sval != null && streamTokenizer.sval.equalsIgnoreCase("table")) {
                n2 = 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n2;
    }
}

