/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.beans.EnumString;
import com.klg.jclass.table.beans.SBLayoutWrapper;
import com.klg.jclass.table.beans.TablePropertyEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SBLayoutEditor
extends TablePropertyEditor
implements ActionListener,
FocusListener,
ItemListener {
    protected JComboBox horizPosition;
    protected JComboBox vertPosition;
    protected JComboBox horizAttachment;
    protected JComboBox vertAttachment;
    protected JComboBox horizDisplay;
    protected JComboBox vertDisplay;
    protected JComboBox horizTrack;
    protected JComboBox vertTrack;
    protected JTextField horizOffset;
    protected JTextField vertOffset;
    protected JTextField vertTrackColumn;
    protected JTextField horizTrackRow;
    protected static final String ALWAYS = "Always";
    protected static final String NEVER = "Never";
    protected static final String AS_NEEDED = "As needed";
    protected static final String BY_CELLS = "By cells";
    protected static final String AT_SIDE = "At side";
    protected static final String TO_CELLS = "To cells";
    protected static final String TO_TABLE = "To table";
    protected static final String LIVE = "Live";
    protected static final String COLUMN_NUMBER = "Column number";
    protected static final String ROW = "Row";
    protected static final String ROW_NUMBER = "Row number";
    protected static final String COLUMN = "Column";
    protected static EnumString[] EnumDisplay = new EnumString[]{new EnumString(1, "Always"), new EnumString(2, "Never"), new EnumString(0, "As needed")};
    protected static EnumString[] EnumPosition = new EnumString[]{new EnumString(0, "By cells"), new EnumString(1, "At side")};
    protected static EnumString[] EnumAttachment = new EnumString[]{new EnumString(0, "To cells"), new EnumString(1, "To table")};
    protected static EnumString[] EnumTrackRow = new EnumString[]{new EnumString(0, "Live"), new EnumString(1, "Column number"), new EnumString(2, "Row")};
    protected static EnumString[] EnumTrackColumn = new EnumString[]{new EnumString(0, "Live"), new EnumString(1, "Row number"), new EnumString(2, "Column")};

    public SBLayoutEditor() {
        super(0);
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        this.tableView.setSBLayout((SBLayoutWrapper)object);
        this.updateSBLayout();
        super.setValue(object);
    }

    public Object getValue() {
        return this.tableView.getSBLayout();
    }

    public String getAsText() {
        return this.getValue().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getSBLayout().getJavaInitializationString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.textChanged(actionEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.textChanged(focusEvent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        this.itemChanged(itemEvent);
    }

    protected JComponent makePropertyPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridx = -1;
        this.horizDisplay = new JComboBox();
        this.horizDisplay.addItem(ALWAYS);
        this.horizDisplay.addItem(NEVER);
        this.horizDisplay.addItem(AS_NEEDED);
        this.vertDisplay = new JComboBox();
        this.vertDisplay.addItem(ALWAYS);
        this.vertDisplay.addItem(NEVER);
        this.vertDisplay.addItem(AS_NEEDED);
        TablePropertyEditor.GroupPanel groupPanel = new TablePropertyEditor.GroupPanel(this, "Scrollbar Display");
        groupPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel.add((Component)this.horizDisplay, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel.add((Component)this.vertDisplay, gridBagConstraints);
        this.horizPosition = new JComboBox();
        this.horizPosition.addItem(BY_CELLS);
        this.horizPosition.addItem(AT_SIDE);
        this.vertPosition = new JComboBox();
        this.vertPosition.addItem(BY_CELLS);
        this.vertPosition.addItem(AT_SIDE);
        TablePropertyEditor.GroupPanel groupPanel2 = new TablePropertyEditor.GroupPanel(this, "Scrollbar Position");
        groupPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel2.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel2.add((Component)this.horizPosition, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel2.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel2.add((Component)this.vertPosition, gridBagConstraints);
        this.horizAttachment = new JComboBox();
        this.horizAttachment.addItem(TO_CELLS);
        this.horizAttachment.addItem(TO_TABLE);
        this.vertAttachment = new JComboBox();
        this.vertAttachment.addItem(TO_CELLS);
        this.vertAttachment.addItem(TO_TABLE);
        TablePropertyEditor.GroupPanel groupPanel3 = new TablePropertyEditor.GroupPanel(this, "Scrollbar Attachment");
        groupPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel3.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel3.add((Component)this.horizAttachment, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel3.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel3.add((Component)this.vertAttachment, gridBagConstraints);
        this.horizOffset = new JTextField("0", 2);
        this.vertOffset = new JTextField("0", 2);
        TablePropertyEditor.GroupPanel groupPanel4 = new TablePropertyEditor.GroupPanel(this, "Scrollbar Offset");
        groupPanel4.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel4.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel4.add((Component)this.horizOffset, gridBagConstraints);
        groupPanel4.add((Component)new JLabel("pixels  "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel4.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel4.add((Component)this.vertOffset, gridBagConstraints);
        groupPanel4.add((Component)new JLabel("pixels  "), gridBagConstraints);
        this.horizTrack = new JComboBox();
        this.horizTrack.addItem(LIVE);
        this.horizTrack.addItem(COLUMN_NUMBER);
        this.horizTrack.addItem(ROW);
        this.vertTrack = new JComboBox();
        this.vertTrack.addItem(LIVE);
        this.vertTrack.addItem(ROW_NUMBER);
        this.vertTrack.addItem(COLUMN);
        this.vertTrackColumn = new JTextField("0", 3);
        this.horizTrackRow = new JTextField("0", 3);
        TablePropertyEditor.GroupPanel groupPanel5 = new TablePropertyEditor.GroupPanel(this, "Scrollbar Tracking");
        groupPanel5.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel5.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel5.add((Component)this.horizTrack, gridBagConstraints);
        groupPanel5.add((Component)this.horizTrackRow, gridBagConstraints);
        groupPanel5.add((Component)new JLabel("row "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel5.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel5.add((Component)this.vertTrack, gridBagConstraints);
        groupPanel5.add((Component)this.vertTrackColumn, gridBagConstraints);
        groupPanel5.add((Component)new JLabel("column "), gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = -1;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        jPanel.add((Component)groupPanel2, gridBagConstraints);
        jPanel.add((Component)groupPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)groupPanel4, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)groupPanel5, gridBagConstraints);
        this.horizOffset.addActionListener(this);
        this.vertOffset.addActionListener(this);
        this.horizOffset.addFocusListener(this);
        this.vertOffset.addFocusListener(this);
        this.vertTrackColumn.addActionListener(this);
        this.horizTrackRow.addActionListener(this);
        this.vertTrackColumn.addFocusListener(this);
        this.horizTrackRow.addFocusListener(this);
        this.horizDisplay.addItemListener(this);
        this.vertDisplay.addItemListener(this);
        this.horizTrack.addItemListener(this);
        this.vertTrack.addItemListener(this);
        this.horizPosition.addItemListener(this);
        this.vertPosition.addItemListener(this);
        this.horizAttachment.addItemListener(this);
        this.vertAttachment.addItemListener(this);
        return jPanel;
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.updateSBLayout();
        this.support.firePropertyChange("sbLayout", null, this.getValue());
    }

    protected void updateSBLayout() {
        SBLayoutEditor.setSelectedItem(this.horizDisplay, SBLayoutEditor.toString(EnumDisplay, this.tableView.getHorizSBDisplay()));
        SBLayoutEditor.setSelectedItem(this.vertDisplay, SBLayoutEditor.toString(EnumDisplay, this.tableView.getVertSBDisplay()));
        SBLayoutEditor.setSelectedItem(this.horizTrack, SBLayoutEditor.toString(EnumTrackRow, this.tableView.getHorizSBTrack()));
        SBLayoutEditor.setSelectedItem(this.vertTrack, SBLayoutEditor.toString(EnumTrackColumn, this.tableView.getVertSBTrack()));
        SBLayoutEditor.setSelectedItem(this.horizPosition, SBLayoutEditor.toString(EnumPosition, this.tableView.getHorizSBPosition()));
        SBLayoutEditor.setSelectedItem(this.vertPosition, SBLayoutEditor.toString(EnumPosition, this.tableView.getVertSBPosition()));
        SBLayoutEditor.setSelectedItem(this.horizAttachment, SBLayoutEditor.toString(EnumAttachment, this.tableView.getHorizSBAttachment()));
        SBLayoutEditor.setSelectedItem(this.vertAttachment, SBLayoutEditor.toString(EnumAttachment, this.tableView.getVertSBAttachment()));
        this.updateTextField(this.vertOffset, this.tableView.getVertSBOffset());
        this.updateTextField(this.horizOffset, this.tableView.getHorizSBOffset());
        this.updateTextField(this.vertTrackColumn, this.tableView.getVertSBTrackColumn());
        this.updateTextField(this.horizTrackRow, this.tableView.getHorizSBTrackRow());
        this.setEnabled();
    }

    protected void setEnabled() {
        boolean bl = !((String)this.horizDisplay.getSelectedItem()).equalsIgnoreCase(NEVER);
        boolean bl2 = !((String)this.vertDisplay.getSelectedItem()).equalsIgnoreCase(NEVER);
        this.horizAttachment.setEnabled(bl);
        this.horizPosition.setEnabled(bl);
        this.horizOffset.setEnabled(bl);
        this.horizTrack.setEnabled(bl);
        String string = (String)this.horizTrack.getSelectedItem();
        this.horizTrackRow.setEnabled(bl && string.equalsIgnoreCase(ROW));
        this.vertAttachment.setEnabled(bl2);
        this.vertPosition.setEnabled(bl2);
        this.vertOffset.setEnabled(bl2);
        this.vertTrack.setEnabled(bl2);
        string = (String)this.vertTrack.getSelectedItem();
        this.vertTrackColumn.setEnabled(bl2 && string.equalsIgnoreCase(COLUMN));
    }

    protected void updateTextField(JTextField jTextField, int n2) {
        String string = n2 + "";
        if (!string.equalsIgnoreCase(jTextField.getText())) {
            jTextField.setText(string);
        }
    }

    private void textChanged(EventObject eventObject) {
        Object object = eventObject.getSource();
        if (object.equals(this.horizOffset)) {
            this.tableView.setHorizSBOffset(SBLayoutEditor.getInt(this.horizOffset.getText()));
        } else if (object.equals(this.vertOffset)) {
            this.tableView.setVertSBOffset(SBLayoutEditor.getInt(this.vertOffset.getText()));
        } else if (object.equals(this.horizTrackRow)) {
            this.tableView.setHorizSBTrackRow(SBLayoutEditor.getInt(this.horizTrackRow.getText()));
        } else if (object.equals(this.vertTrackColumn)) {
            this.tableView.setVertSBTrackColumn(SBLayoutEditor.getInt(this.vertTrackColumn.getText()));
        } else {
            return;
        }
        this.support.firePropertyChange("sbLayout", null, this.getValue());
    }

    private void itemChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.horizPosition)) {
            String string = (String)this.horizPosition.getSelectedItem();
            this.tableView.setHorizSBPosition(SBLayoutEditor.toIntValue(EnumPosition, string));
        } else if (object.equals(this.vertPosition)) {
            String string = (String)this.vertPosition.getSelectedItem();
            this.tableView.setVertSBPosition(SBLayoutEditor.toIntValue(EnumPosition, string));
        } else if (object.equals(this.horizAttachment)) {
            String string = (String)this.horizAttachment.getSelectedItem();
            this.tableView.setHorizSBAttachment(SBLayoutEditor.toIntValue(EnumAttachment, string));
        } else if (object.equals(this.vertAttachment)) {
            String string = (String)this.vertAttachment.getSelectedItem();
            this.tableView.setVertSBAttachment(SBLayoutEditor.toIntValue(EnumAttachment, string));
        } else if (object.equals(this.horizDisplay)) {
            String string = (String)this.horizDisplay.getSelectedItem();
            this.tableView.setHorizSBDisplay(SBLayoutEditor.toIntValue(EnumDisplay, string));
        } else if (object.equals(this.vertDisplay)) {
            String string = (String)this.vertDisplay.getSelectedItem();
            this.tableView.setVertSBDisplay(SBLayoutEditor.toIntValue(EnumDisplay, string));
        } else if (object.equals(this.horizTrack)) {
            String string = (String)this.horizTrack.getSelectedItem();
            this.tableView.setHorizSBTrack(SBLayoutEditor.toIntValue(EnumTrackRow, string));
        } else if (object.equals(this.vertTrack)) {
            String string = (String)this.vertTrack.getSelectedItem();
            this.tableView.setVertSBTrack(SBLayoutEditor.toIntValue(EnumTrackColumn, string));
        } else {
            return;
        }
        this.setEnabled();
        this.support.firePropertyChange("sbLayout", null, this.getValue());
    }
}

