/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.table.CellBorderModel;
import com.klg.jclass.table.CellRangeValue;
import com.klg.jclass.table.CellStyleModel;
import com.klg.jclass.table.JCCellBorder;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCVersion;
import com.klg.jclass.table.PositionCellSize;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.beans.CellSizeWrapper;
import com.klg.jclass.table.beans.DataWrapper;
import com.klg.jclass.table.beans.FrozenCellLayoutWrapper;
import com.klg.jclass.table.beans.JCLiveCellStyle;
import com.klg.jclass.table.beans.LabelLayoutWrapper;
import com.klg.jclass.table.beans.SBLayoutWrapper;
import com.klg.jclass.table.beans.SpannedCellsWrapper;
import com.klg.jclass.table.beans.StyleWrapper;
import com.klg.jclass.table.data.JCBeanFileDataSource;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCTableModelDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;

public class LiveTable
extends JCTable {
    protected JCCellRenderer cellRenderer = null;
    protected static int numColumns = 5;
    protected static int numRows = 10;

    public LiveTable() {
        this(true);
    }

    public LiveTable(boolean bl) {
        this.makeDataSource(bl);
        this.setPopupMenuEnabled(true);
    }

    public int getFrameBorderType() {
        CellBorderModel cellBorderModel = this.getFrameBorder();
        int n2 = 0;
        if (cellBorderModel instanceof JCCellBorder) {
            n2 = ((JCCellBorder)cellBorderModel).getBorderType();
        }
        return n2;
    }

    public void setFrameBorderType(int n2) {
        this.setFrameBorder(new JCCellBorder(n2));
        this.requestChange(4);
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public DataWrapper getData() {
        TableDataModel tableDataModel = this.getDataSource();
        DataWrapper dataWrapper = null;
        if (tableDataModel instanceof JCBeanFileDataSource) {
            dataWrapper = new DataWrapper(((JCBeanFileDataSource)tableDataModel).getName());
        } else if (tableDataModel instanceof JCVectorDataSource) {
            JCVectorDataSource jCVectorDataSource = (JCVectorDataSource)tableDataModel;
            dataWrapper = new DataWrapper(tableDataModel.getNumRows(), tableDataModel.getNumColumns(), this.createArray(jCVectorDataSource.getRowLabels()), this.createArray(jCVectorDataSource.getColumnLabels()), this.createArray2D(jCVectorDataSource.getCells()));
        } else {
            dataWrapper = new DataWrapper(tableDataModel);
        }
        return dataWrapper;
    }

    public void setData(DataWrapper dataWrapper) {
        if (dataWrapper == null) {
            return;
        }
        if (dataWrapper.isFile) {
            this.setDataSource(new JCBeanFileDataSource(dataWrapper.fileName));
        } else {
            JCEditableVectorDataSource jCEditableVectorDataSource = new JCEditableVectorDataSource(dataWrapper.rows, dataWrapper.columns, this.createVector(dataWrapper.rowLabels), this.createVector(dataWrapper.columnLabels), this.createVector(dataWrapper.cellValues));
            this.setDataSource(jCEditableVectorDataSource);
        }
    }

    public FrozenCellLayoutWrapper getFrozenCellLayout() {
        return new FrozenCellLayoutWrapper(this.frozen_rows, this.frozen_columns, this.frozen_row_placement, this.frozen_column_placement);
    }

    public void setFrozenCellLayout(FrozenCellLayoutWrapper frozenCellLayoutWrapper) {
        if (frozenCellLayoutWrapper == null) {
            return;
        }
        this.frozen_rows = frozenCellLayoutWrapper.rows;
        this.frozen_row_placement = frozenCellLayoutWrapper.rowPlacement;
        this.frozen_columns = frozenCellLayoutWrapper.columns;
        this.frozen_column_placement = frozenCellLayoutWrapper.columnPlacement;
        this.requestChange(8);
    }

    public LabelLayoutWrapper getLabelLayout() {
        return new LabelLayoutWrapper(this.row_label_display, this.column_label_display, this.row_label_offset, this.column_label_offset, this.row_label_placement, this.column_label_placement);
    }

    public void setLabelLayout(LabelLayoutWrapper labelLayoutWrapper) {
        if (labelLayoutWrapper == null) {
            return;
        }
        this.row_label_display = labelLayoutWrapper.rowDisplay;
        this.row_label_offset = labelLayoutWrapper.rowOffset;
        this.row_label_placement = labelLayoutWrapper.rowPlacement;
        this.column_label_display = labelLayoutWrapper.columnDisplay;
        this.column_label_offset = labelLayoutWrapper.columnOffset;
        this.column_label_placement = labelLayoutWrapper.columnPlacement;
        this.requestChange(2);
    }

    public SBLayoutWrapper getSBLayout() {
        return new SBLayoutWrapper(this.hsb_display, this.vsb_display, this.hsb_attach, this.vsb_attach, this.hsb_offset, this.vsb_offset, this.hsb_position, this.vsb_position, this.hsb_track, this.vsb_track, this.hsb_track_row, this.vsb_track_column);
    }

    public void setSBLayout(SBLayoutWrapper sBLayoutWrapper) {
        if (sBLayoutWrapper == null) {
            return;
        }
        this.hsb_display = sBLayoutWrapper.hsbDisplay;
        this.hsb_attach = sBLayoutWrapper.hsbAttach;
        this.hsb_offset = sBLayoutWrapper.hsbOffset;
        this.hsb_position = sBLayoutWrapper.hsbPosition;
        this.hsb_track = sBLayoutWrapper.hsbTrack;
        this.hsb_track_row = sBLayoutWrapper.hsbTrackRow;
        this.vsb_display = sBLayoutWrapper.vsblDisplay;
        this.vsb_attach = sBLayoutWrapper.vsbAttach;
        this.vsb_offset = sBLayoutWrapper.vsbOffset;
        this.vsb_position = sBLayoutWrapper.vsbPosition;
        this.vsb_track = sBLayoutWrapper.vsbTrack;
        this.vsb_track_column = sBLayoutWrapper.vsbTrackColumn;
        this.requestChange(8);
    }

    public StyleWrapper getStyles() {
        List list = this.getCellStyleValues();
        CellRangeValue[] cellRangeValueArray = new CellRangeValue[list.size()];
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            cellRangeValueArray[n2] = (CellRangeValue)iterator.next();
            ++n2;
        }
        return new StyleWrapper(cellRangeValueArray);
    }

    public void setStyles(StyleWrapper styleWrapper) {
        if (styleWrapper == null) {
            return;
        }
        for (int i2 = 0; i2 < styleWrapper.styles.length; ++i2) {
            CellRangeValue cellRangeValue = styleWrapper.styles[i2];
            CellStyleModel cellStyleModel = (CellStyleModel)cellRangeValue.value;
            if (cellStyleModel instanceof JCLiveCellStyle) {
                ((JCLiveCellStyle)cellStyleModel).setTable(this);
            }
            this.setCellStyle(new JCCellRange(cellRangeValue.start_row, cellRangeValue.start_column, cellRangeValue.end_row, cellRangeValue.end_column), cellStyleModel);
        }
        this.requestChange(2);
    }

    public void setSwingDataModel(TableModel tableModel) {
        JCTableModelDataSource jCTableModelDataSource = new JCTableModelDataSource(tableModel);
        if (jCTableModelDataSource.isEnabled()) {
            this.setDataSource(jCTableModelDataSource);
        }
    }

    public TableModel getSwingDataModel() {
        TableDataModel tableDataModel = this.getDataSource();
        TableModel tableModel = null;
        if (tableDataModel instanceof JCTableModelDataSource) {
            tableModel = ((JCTableModelDataSource)tableDataModel).getTableModel();
        }
        return tableModel;
    }

    public CellSizeWrapper getCellSize() {
        return new CellSizeWrapper(this.makePositionsArray(this.getRowHeightValues()), this.makePositionsArray(this.getColumnWidthValues()));
    }

    protected PositionCellSize[] makePositionsArray(List list) {
        PositionCellSize[] positionCellSizeArray = new PositionCellSize[list.size()];
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof PositionCellSize)) {
                throw new IllegalArgumentException("Range item is not a PositionCellSize instance");
            }
            positionCellSizeArray[n2] = (PositionCellSize)e2;
            ++n2;
        }
        return positionCellSizeArray;
    }

    public void setCellSize(CellSizeWrapper cellSizeWrapper) {
        int n2;
        if (cellSizeWrapper == null) {
            return;
        }
        for (n2 = 0; n2 < cellSizeWrapper.rowPositions.length; ++n2) {
            this.setRowCellSize(cellSizeWrapper.rowPositions[n2].position, cellSizeWrapper.rowPositions[n2].cell_size);
        }
        for (n2 = 0; n2 < cellSizeWrapper.columnPositions.length; ++n2) {
            this.setColumnCellSize(cellSizeWrapper.columnPositions[n2].position, cellSizeWrapper.columnPositions[n2].cell_size);
        }
    }

    public SpannedCellsWrapper getSpannedCells() {
        Collection collection = this.getSpannedRanges();
        JCCellRange[] jCCellRangeArray = null;
        if (collection == null) {
            jCCellRangeArray = new JCCellRange[]{};
        } else {
            jCCellRangeArray = new JCCellRange[collection.size()];
            Iterator iterator = collection.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof JCCellRange)) {
                    throw new IllegalArgumentException("Range item is not a JCCellRange instance");
                }
                jCCellRangeArray[n2] = (JCCellRange)e2;
                ++n2;
            }
        }
        return new SpannedCellsWrapper(jCCellRangeArray);
    }

    public void setSpannedCells(SpannedCellsWrapper spannedCellsWrapper) {
        if (spannedCellsWrapper == null) {
            return;
        }
        Vector<JCCellRange> vector = new Vector<JCCellRange>();
        for (int i2 = 0; i2 < spannedCellsWrapper.spannedCells.length; ++i2) {
            vector.addElement(spannedCellsWrapper.spannedCells[i2]);
        }
        this.setSpannedRanges(vector);
    }

    protected void makeDataSource(boolean bl) {
        int n2;
        JCVectorDataSource jCVectorDataSource = bl ? new JCEditableVectorDataSource() : new JCVectorDataSource();
        jCVectorDataSource.setNumRows(numRows);
        jCVectorDataSource.setNumColumns(numColumns);
        this.setVisibleRows(numRows);
        this.setVisibleColumns(numColumns);
        for (n2 = 0; n2 < jCVectorDataSource.getNumColumns(); ++n2) {
            jCVectorDataSource.setColumnLabel(n2, "Col: " + n2);
        }
        for (n2 = 0; n2 < jCVectorDataSource.getNumRows(); ++n2) {
            jCVectorDataSource.setRowLabel(n2, "Row: " + n2);
            for (int i2 = 0; i2 < jCVectorDataSource.getNumColumns(); ++i2) {
                jCVectorDataSource.setCell(n2, i2, "Cell");
            }
        }
        this.setDataSource(jCVectorDataSource);
        LiveTable.setNumEditorRows(numRows);
        LiveTable.setNumEditorColumns(numColumns);
    }

    public CellStyleModel createCellStyle() {
        return new JCLiveCellStyle(this, this.cellRenderer);
    }

    public void setCellRenderer(JCCellRenderer jCCellRenderer) {
        this.cellRenderer = jCCellRenderer;
    }

    public static int getNumEditorColumns() {
        return numColumns;
    }

    public static void setNumEditorColumns(int n2) {
        numColumns = n2;
    }

    public static int getNumEditorRows() {
        return numRows;
    }

    public static void setNumEditorRows(int n2) {
        numRows = n2;
    }

    protected JCCellRange getSelectedRange() {
        Collection collection = this.getSelectedCells();
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        return iterator.hasNext() ? (JCCellRange)iterator.next() : null;
    }

    protected String[] createArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            stringArray[i2] = (String)vector.get(i2);
        }
        return stringArray;
    }

    protected String[][] createArray2D(Vector vector) {
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Object e2 = vector.elementAt(i2);
            if (!(e2 instanceof Vector)) continue;
            n2 = Math.max(((Vector)e2).size(), n2);
        }
        String[][] stringArray = new String[vector.size()][n2];
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            Object e3 = vector.elementAt(i3);
            if (!(e3 instanceof Vector)) continue;
            stringArray[i3] = new String[((Vector)e3).size()];
            for (int i4 = 0; i4 < ((Vector)e3).size(); ++i4) {
                Object e4 = ((Vector)e3).elementAt(i4);
                if (!(e4 instanceof String)) continue;
                stringArray[i3][i4] = (String)e4;
            }
        }
        return stringArray;
    }

    protected Vector createVector(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            vector.add(stringArray[i2]);
        }
        return vector;
    }

    protected Vector createVector(String[][] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Vector vector = new Vector();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Vector<String> vector2 = new Vector<String>();
            for (int i3 = 0; i3 < stringArray[i2].length; ++i3) {
                vector2.addElement(stringArray[i2][i3]);
            }
            vector.addElement(vector2);
        }
        return vector;
    }
}

