/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.beans.ColorChooser;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import java.awt.Color;
import java.beans.PropertyEditorSupport;
import javax.swing.JFrame;

public class ColorEditor
extends PropertyEditorSupport {
    static String[] color_names = new String[]{"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", "LightBlue", "Magenta", "Orange", "Pink", "Red", "Yellow", "White", "Custom"};
    ColorChooser chooser = new ColorChooser(this);

    public String[] getTags() {
        return color_names;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Color color = null;
        if (string.equals("Custom")) {
            this.chooser = new ColorChooser(this);
            this.chooser.pack();
            this.chooser.setVisible(true);
        } else {
            color = JCSwingTypeConverter.toColor(string);
            if (color == null) {
                throw new IllegalArgumentException("invalid color: " + string);
            }
            this.setValue(color);
        }
    }

    protected boolean eqColor(Color color, Color color2) {
        return color.getRed() == color2.getRed() && color.getGreen() == color2.getGreen() && color.getBlue() == color2.getBlue();
    }

    public String getAsText() {
        Color color = this.getColor();
        if (color == null) {
            return "Black";
        }
        if (this.eqColor(color, Color.black)) {
            return "Black";
        }
        if (this.eqColor(color, Color.blue)) {
            return "Blue";
        }
        if (this.eqColor(color, Color.cyan)) {
            return "Cyan";
        }
        if (this.eqColor(color, Color.darkGray)) {
            return "DarkGray";
        }
        if (this.eqColor(color, Color.gray)) {
            return "Gray";
        }
        if (this.eqColor(color, Color.green)) {
            return "Green";
        }
        if (this.eqColor(color, JCSwingTypeConverter.lightBlue)) {
            return "LightBlue";
        }
        if (this.eqColor(color, Color.lightGray)) {
            return "LightGray";
        }
        if (this.eqColor(color, Color.magenta)) {
            return "Magenta";
        }
        if (this.eqColor(color, Color.orange)) {
            return "Orange";
        }
        if (this.eqColor(color, Color.pink)) {
            return "Pink";
        }
        if (this.eqColor(color, Color.red)) {
            return "Red";
        }
        if (this.eqColor(color, Color.white)) {
            return "White";
        }
        if (this.eqColor(color, Color.yellow)) {
            return "Yellow";
        }
        return "Custom";
    }

    public String getJavaInitializationString() {
        if (this.getValue() == null) {
            return "Color.black";
        }
        return "new Color(" + this.getColor().getRGB() + ")";
    }

    Color getColor() {
        return (Color)this.getValue();
    }

    void selectColor(Color color) {
        if (color != null) {
            this.setColor(color);
        }
    }

    private void setColor(Color color) {
        if (color != null) {
            this.setValue(color);
            this.firePropertyChange();
        }
    }

    public JFrame findParent() {
        return new JFrame();
    }
}

