/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaRenderer;
import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.CellSize;
import com.klg.jclass.table.EditTraverseHandler;
import com.klg.jclass.table.InputHandler;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCResizeCellEvent;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.SortableDataViewModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.Timer;

public class MouseInputHandler
extends InputHandler
implements Serializable,
ActionListener,
MouseListener,
MouseMotionListener {
    protected static final int DEFAULT_CURSOR = 0;
    protected static final int TRAV_CURSOR = 2;
    protected static final int NONTRAV_CURSOR = 1;
    protected static final int CORNER_CURSOR = 5;
    protected static final int HORIZ_CURSOR = 11;
    protected static final int VERT_CURSOR = 9;
    protected static final int MOVE_CURSOR = 12;
    protected static final int WAIT_CURSOR = 3;
    protected static final int NO_RESIZE = 0;
    protected static final int HORIZ_RESIZE = 1;
    protected static final int VERT_RESIZE = 2;
    protected static final int CORNER_RESIZE = 3;
    protected JCCellPosition initial_cell = new JCCellPosition();
    protected JCCellPosition position = new JCCellPosition();
    protected boolean multi_cell_drag = false;
    protected int resizeRow = -999;
    protected int resizeColumn = -999;
    protected int resizeHeight;
    protected int resizeWidth;
    protected CellSize resizeRowCellSize;
    protected CellSize resizeColumnCellSize;
    protected Point resizePoint;
    protected boolean needs_resize_begin_event = false;
    protected JCResizeCellEvent resize_motion_event = null;
    protected static final int AUTO_SCROLL_DEC = -1;
    protected static final int AUTO_SCROLL_NONE = 0;
    protected static final int AUTO_SCROLL_INC = 1;
    protected static final int AUTO_SCROLL_AMOUNT = 20;
    protected int auto_scroll_horiz = 0;
    protected int auto_scroll_vert = 0;
    protected transient Timer auto_scroll_timer;
    protected JCCellPosition auto_scroll_initial_cell;
    protected int auto_scroll_x;
    protected int auto_scroll_y;
    protected boolean AUTOSCROLLING = false;
    protected boolean DRAGGING = false;
    protected boolean RESIZING = false;
    protected boolean SORTING = false;

    public MouseInputHandler(JCTable jCTable) {
        super(jCTable);
    }

    public final boolean isLeftButton(int n2) {
        return (n2 & 0x10) != 0;
    }

    public final boolean isMiddleButton(int n2) {
        return (n2 & 8) != 0;
    }

    public final boolean isRightButton(int n2) {
        return (n2 & 4) != 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n2;
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = mouseEvent.getModifiers();
        if (!this.table.isRepaintEnabled()) {
            return;
        }
        this.table.getFocusManager().requestFocus();
        this.getCellPosition(n3, n4, this.initial_cell);
        this.multi_cell_drag = false;
        if (this.resizeRow != -999 || this.resizeColumn != -999) {
            this.resizeRowCellSize = this.table.getRowCellSize(this.initial_cell.row);
            this.resizeColumnCellSize = this.table.getColumnCellSize(this.initial_cell.column);
            this.resizeBegin(n3, n4);
            this.RESIZING = true;
            return;
        }
        boolean bl = false;
        if (this.isValidCellPosition(this.initial_cell)) {
            n2 = this.table.getAction(mouseEvent, this.initial_cell.row, this.initial_cell.column);
            if (n2 == 3 || n2 == 5) {
                if (this.isValidDragPosition(this.initial_cell)) {
                    this.DRAGGING = true;
                    this.table.cancelEdit(true);
                    this.table.clearSelection();
                    this.performDrag(this.initial_cell);
                    return;
                }
            } else {
                if (n2 == 2 && this.initial_cell.row == -1) {
                    this.SORTING = true;
                    this.table.cancelEdit(true);
                    this.table.clearSelection();
                    return;
                }
                if (n2 == 1 && this.initial_cell.row == -1 || n2 == 4 && this.initial_cell.column == -1) {
                    bl = true;
                }
            }
        }
        this.traverse(mouseEvent, this.initial_cell, true);
        if (this.isLeftButton(n5) || bl) {
            n2 = 0;
            if (this.isShift(n5)) {
                n2 = 2;
            } else if (this.isControl(n5)) {
                n2 = 1;
                this.multi_cell_drag = true;
            }
            this.SELECTING = this.table.getSelectionModel() != null ? this.table.getSelectionModel().select(n2, this.initial_cell.row, this.initial_cell.column) : false;
        }
    }

    protected boolean isValidDragPosition(JCCellPosition jCCellPosition) {
        if (jCCellPosition.row == -1) {
            return jCCellPosition.column >= this.table.getFrozenColumns();
        }
        if (jCCellPosition.column == -1) {
            return jCCellPosition.row >= this.table.getFrozenRows();
        }
        return false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (!this.table.isRepaintEnabled()) {
            return;
        }
        JCCellPosition jCCellPosition = new JCCellPosition();
        this.getCellPosition(n2, n3, jCCellPosition);
        if (!jCCellPosition.equals(this.initial_cell)) {
            this.multi_cell_drag = true;
        }
        if (this.RESIZING) {
            this.resizeDrag(n2, n3);
        } else {
            if (this.isValidCellPosition(jCCellPosition) && this.isValidCellPosition(this.initial_cell)) {
                if (this.AUTOSCROLLING) {
                    this.stopAutoScroll(true);
                }
                if (this.DRAGGING) {
                    this.SELECTING = false;
                    if (this.isValidDragPosition(jCCellPosition)) {
                        this.performDrag(jCCellPosition);
                    }
                }
            } else if (!this.isValidCellPosition(jCCellPosition)) {
                CellArea cellArea = this.table.cellAreaHandler.cellArea;
                if (this.isAutoScrollRow()) {
                    this.auto_scroll_vert = n3 < cellArea.getBounds().y ? -1 : (n3 > cellArea.getBounds().y + cellArea.getBounds().height ? 1 : 0);
                    if (this.initial_cell.row == -1) {
                        this.auto_scroll_vert = 0;
                    }
                }
                if (this.isAutoScrollColumn()) {
                    this.auto_scroll_horiz = n2 < cellArea.getBounds().y ? -1 : (n2 > cellArea.getBounds().x + cellArea.getBounds().width ? 1 : 0);
                    if (this.initial_cell.column == -1) {
                        this.auto_scroll_horiz = 0;
                    }
                }
                this.startAutoScroll(n2, n3);
            }
            if (this.SELECTING) {
                this.getCellPosition(n2, n3, this.position);
                this.SELECTING = this.table.getSelectionModel().select(2, this.position.row, this.position.column);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (!this.table.isRepaintEnabled()) {
            return;
        }
        int n4 = this.auto_scroll_vert;
        int n5 = this.auto_scroll_horiz;
        if (this.AUTOSCROLLING) {
            this.stopAutoScroll(true);
        }
        JCCellPosition jCCellPosition = new JCCellPosition();
        this.getCellPosition(n2, n3, jCCellPosition);
        EditTraverseHandler editTraverseHandler = this.table.getEditTraverseHandler();
        if (this.RESIZING) {
            this.resizeEnd(n2, n3);
            this.RESIZING = false;
            return;
        }
        if (this.DRAGGING) {
            this.DRAGGING = false;
            if (this.isValidDragPosition(jCCellPosition)) {
                this.endDrag(jCCellPosition);
            } else {
                JCCellPosition jCCellPosition2 = new JCCellPosition();
                if (jCCellPosition.row == -1) {
                    jCCellPosition2.row = -1;
                    jCCellPosition2.column = this.table.getFrozenColumns();
                    this.endDrag(jCCellPosition2);
                } else if (jCCellPosition.column == -1) {
                    jCCellPosition2.row = this.table.getFrozenRows();
                    jCCellPosition2.column = -1;
                    this.endDrag(jCCellPosition2);
                } else if (n4 != 0 || n5 != 0) {
                    jCCellPosition2.row = this.table.cellAreaHandler.drop_row;
                    if (n4 == 1 && jCCellPosition2.row != -1) {
                        --jCCellPosition2.row;
                    }
                    jCCellPosition2.column = this.table.cellAreaHandler.drop_column;
                    if (n5 == 1 && jCCellPosition2.column != -1) {
                        --jCCellPosition2.column;
                    }
                    this.endDrag(jCCellPosition2);
                } else {
                    this.cancelDrag();
                }
            }
            return;
        }
        if (this.SORTING) {
            if (this.table.getDataView() instanceof SortableDataViewModel) {
                Cursor cursor = this.table.getCursor();
                this.table.setCursor(3);
                SortableDataViewModel sortableDataViewModel = (SortableDataViewModel)this.table.getDataView();
                int n6 = sortableDataViewModel.getDataColumn(jCCellPosition.column);
                int n7 = 0;
                if (this.table.sort_column == n6 && this.table.sort_direction == 0) {
                    n7 = 1;
                }
                this.table.sortByColumn(n6, n7);
                this.table.setCursor(cursor);
                this.SORTING = false;
            }
            return;
        }
        if (!(this.table.isAutoEdit() || !this.table.getDataView().isEditable() || this.initial_cell.row != jCCellPosition.row || this.initial_cell.column != jCCellPosition.column || this.SELECTING && this.multi_cell_drag || !this.table.isEditable(jCCellPosition.row, jCCellPosition.column) || this.table.getDataView().getCellEditor(jCCellPosition.row, jCCellPosition.column) == null)) {
            JCCellEditor jCCellEditor = editTraverseHandler.getCellEditor();
            if (this.table.pointer_traverse_forces_edit || jCCellEditor == null) {
                editTraverseHandler.traverse(jCCellPosition.row, jCCellPosition.column, false, mouseEvent, 0, true);
                return;
            }
            if (jCCellEditor != null) {
                Component component = jCCellEditor.getComponent();
                this.table.getFocusManager().requestFocus(component);
            }
        }
        if (this.SELECTING) {
            this.table.getSelectionModel().select(4, jCCellPosition.row, jCCellPosition.column);
            this.SELECTING = false;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.table.isRepaintEnabled() && !this.DRAGGING && !this.RESIZING && this.table.isTrackCursor()) {
            this.table.setCursor(this.trackResizeCursor(mouseEvent.getX(), mouseEvent.getY()));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.RESIZING && this.table.isTrackCursor()) {
            this.table.setCursor(0);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    protected int trackResizeCursor(int n2, int n3) {
        this.getCellPosition(n2, n3, this.position);
        int n4 = this.position.row;
        int n5 = this.position.column;
        int n6 = 1;
        if (n4 == -999 || n5 == -999) {
            return n6;
        }
        switch (this.getResizeDirection(n2, n3, n4, n5)) {
            case 1: {
                n6 = 11;
                break;
            }
            case 2: {
                n6 = 9;
                break;
            }
            case 3: {
                n6 = 5;
                break;
            }
            default: {
                n6 = this.isTraversable(n4, n5) ? 2 : 1;
            }
        }
        return n6;
    }

    protected int getResizeDirection(int n2, int n3, int n4, int n5) {
        JCCellRange jCCellRange;
        int n6;
        int n7 = 4;
        this.resizeRow = -999;
        this.resizeColumn = -999;
        Rectangle rectangle = this.table.getCellAreaHandler().getBounds(n4, n5);
        CellArea cellArea = this.table.getCellAreaHandler().find(n4, n5);
        if (cellArea == null) {
            return 0;
        }
        Point point = this.table.getCellAreaHandler().getCellOrigin();
        if (cellArea.getType() == 0) {
            n2 += -point.x;
            n3 += -point.y;
        } else if (cellArea.getType() == 3 || cellArea.getType() == 6) {
            n3 += -point.y;
        } else if (cellArea.getType() == 1 || cellArea.getType() == 2) {
            n2 += -point.x;
        }
        int n8 = rectangle.x;
        if (n2 - n8 < n7) {
            --n5;
        }
        if (n3 - (n6 = rectangle.y) < n7) {
            --n4;
        }
        if (!this.table.isResizable(n4, n5)) {
            return 0;
        }
        int n9 = 0;
        if (n5 < -1) {
            return 0;
        }
        int n10 = rectangle.x + rectangle.width;
        if (Math.abs(n10 - n2) < n7) {
            this.resizeColumn = n5;
            n9 |= 1;
        }
        if (n4 < -1) {
            return 0;
        }
        int n11 = rectangle.y + rectangle.height;
        if (Math.abs(n11 - n3) < n7) {
            this.resizeRow = n4;
            n9 |= 2;
        }
        if (n9 & true && this.table.allow_cell_resize == 1) {
            this.resizeRow = -999;
            this.resizeColumn = -999;
            return 0;
        }
        if ((n9 & 2) != 0 && this.table.allow_cell_resize == 2) {
            this.resizeRow = -999;
            this.resizeColumn = -999;
            return 0;
        }
        if (this.table.spanHandler != null && (jCCellRange = this.table.getSpannedRange(n4, n5)) != null) {
            if ((n9 & 2) != 0 && n4 != jCCellRange.end_row) {
                n9 &= 0xFFFFFFFD;
            }
            if ((n9 & 1) != 0 && n5 != jCCellRange.end_column) {
                n9 &= 0xFFFFFFFE;
            }
        }
        return n9;
    }

    protected void resizeBegin(int n2, int n3) {
        this.resizePoint = new Point(n2, n3);
        CellLayoutModel cellLayoutModel = this.table.getCellLayout();
        this.resizeWidth = this.resizeColumn != -999 ? cellLayoutModel.getWidth(this.resizeColumn) : -999;
        this.resizeHeight = this.resizeRow != -999 ? cellLayoutModel.getHeight(this.resizeRow) : -999;
        this.needs_resize_begin_event = true;
    }

    protected void resizeDrag(int n2, int n3) {
        Serializable serializable;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.needs_resize_begin_event) {
            if (this.table.resizeListeners != null) {
                if (this.resize_motion_event == null) {
                    this.resize_motion_event = new JCResizeCellEvent(this.table, 1, this.resizeRow, this.resizeColumn, this.resizeWidth, this.resizeHeight);
                } else {
                    this.resize_motion_event.type = 1;
                    this.resize_motion_event.row = this.resizeRow;
                    this.resize_motion_event.column = this.resizeColumn;
                    this.resize_motion_event.current_row_height = this.resizeHeight;
                    this.resize_motion_event.current_column_width = this.resizeWidth;
                    this.resize_motion_event.new_row_height = -999;
                    this.resize_motion_event.new_column_width = -999;
                    this.resize_motion_event.cancelled = false;
                }
                this.table.fireJCResizeCellEvent(this.resize_motion_event);
                if (this.resize_motion_event.isCancelled()) {
                    this.cancelResize();
                    this.resize_motion_event.type = 4;
                    this.table.fireJCResizeCellEvent(this.resize_motion_event);
                    return;
                }
            }
            this.needs_resize_begin_event = false;
        }
        int n8 = -999;
        int n9 = -999;
        if (this.resizeRow != -999) {
            n7 = n3 - this.resizePoint.y;
            n6 = this.table.getCellLayout().getHeight(this.resizeRow);
            if (n6 + n7 < 0) {
                this.resizePoint.y = n3 - n7;
                n7 = 0;
            } else {
                this.resizePoint.y = n3;
            }
            n8 = this.table.getCellLayout().getHeight(this.resizeRow) + n7;
            if (n8 < 5) {
                n8 = 5;
            }
            n9 = n8;
            if (this.resizeRowCellSize != null) {
                n8 = Math.min(Math.max(n8, this.resizeRowCellSize.getMinValue()), this.resizeRowCellSize.getMaxValue());
            }
        }
        n7 = -999;
        n6 = -999;
        if (this.resizeColumn != -999) {
            int n10 = n2 - this.resizePoint.x;
            int n11 = this.table.getCellLayout().getWidth(this.resizeColumn);
            if (n11 + n10 < 0) {
                this.resizePoint.x = n2 - n10;
                n10 = 0;
            } else {
                this.resizePoint.x = n2;
            }
            n7 = this.table.getCellLayout().getWidth(this.resizeColumn) + n10;
            if (n7 < 5) {
                n7 = 5;
            }
            n6 = n7;
            if (this.resizeColumnCellSize != null) {
                n7 = Math.min(Math.max(n7, this.resizeColumnCellSize.getMinValue()), this.resizeColumnCellSize.getMaxValue());
            }
        }
        if (this.table.resizeMotionListeners != null) {
            JCResizeCellEvent jCResizeCellEvent = new JCResizeCellEvent(this.table, 3, this.resizeRow, this.resizeColumn, this.resizeWidth, this.resizeHeight);
            jCResizeCellEvent.setNewColumnWidth(n7);
            jCResizeCellEvent.setNewRowHeight(n8);
            this.table.fireJCResizeCellMotionEvent(jCResizeCellEvent);
            if (jCResizeCellEvent.isCancelled()) {
                n8 = this.resizeHeight;
                n7 = this.resizeWidth;
                jCResizeCellEvent.setNewColumnWidth(-999);
                jCResizeCellEvent.setNewRowHeight(-999);
            } else {
                n8 = jCResizeCellEvent.getNewRowHeight();
                n7 = jCResizeCellEvent.getNewColumnWidth();
            }
        }
        this.resizePoint.x += n7 - n6;
        this.resizePoint.y += n8 - n9;
        EditTraverseHandler editTraverseHandler = this.table.getEditTraverseHandler();
        CellAreaRenderer cellAreaRenderer = this.table.getCellAreaHandler().getCellAreaRenderer();
        if (this.resizeRow != -999) {
            this.table.getCellLayout().setHeight(this.resizeRow, n8);
            if (this.table.resize_interactive) {
                n5 = this.table.getDataSource().getNumRows() - 1;
                n4 = this.table.getCellLayout().getRowPosition(n5) + this.table.getCellLayout().getHeight(n5);
                if (n4 < this.table.getSize().height) {
                    if (this.table.store_image_enabled) {
                        this.table.store_image = null;
                    }
                    this.table.repaint(0, n4, this.table.getSize().width, this.table.getSize().height - n4);
                }
                if (editTraverseHandler.getEditRow() == this.resizeRow) {
                    editTraverseHandler.setHeight(n8);
                } else {
                    editTraverseHandler.repositionEditor();
                }
                this.table.doLayout();
                serializable = this.table.getVisibleCells();
                if (n8 - this.resizeHeight < 0 && ((JCCellRange)serializable).end_row == this.table.getNumRows() - 1 && ((JCCellRange)serializable).start_row > this.table.getFrozenRows()) {
                    this.table.repaint();
                } else {
                    cellAreaRenderer.repaintRange(this.resizeRow, -1, this.table.getDataSource().getNumRows() - 1, this.table.getDataSource().getNumColumns() - 1);
                }
            } else {
                n5 = this.table.getDataSource().getNumRows() - 1;
                n4 = this.table.getCellLayout().getRowPosition(n5) + this.table.getCellLayout().getHeight(n5);
                if (n4 < this.table.getSize().height) {
                    serializable = this.table.getCellBounds(this.resizeRow, -1);
                    if (this.table.store_image_enabled) {
                        this.table.store_image = null;
                    }
                    this.table.repaint(serializable.x, n4, serializable.width, this.table.getSize().height - n4);
                }
                cellAreaRenderer.repaintRange(this.resizeRow, -1, this.table.getNumRows() - 1, -1);
            }
        }
        if (this.resizeColumn != -999) {
            this.table.getCellLayout().setWidth(this.resizeColumn, n7);
            if (this.table.resize_interactive) {
                n5 = this.table.getDataSource().getNumColumns() - 1;
                n4 = this.table.getCellLayout().getColumnPosition(n5) + this.table.getCellLayout().getWidth(n5);
                if (n4 < this.table.getSize().width) {
                    if (this.table.store_image_enabled) {
                        this.table.store_image = null;
                    }
                    this.table.repaint(n4, 0, this.table.getSize().width - n4, this.table.getSize().height);
                }
                if (editTraverseHandler.getEditColumn() == this.resizeColumn) {
                    editTraverseHandler.setWidth(n7);
                } else {
                    editTraverseHandler.repositionEditor();
                }
                this.table.doLayout();
                serializable = this.table.getVisibleCells();
                if (n7 - this.resizeWidth < 0 && ((JCCellRange)serializable).end_column == this.table.getNumColumns() - 1 && ((JCCellRange)serializable).start_column > this.table.getFrozenColumns()) {
                    this.table.repaint();
                } else {
                    cellAreaRenderer.repaintRange(-1, this.resizeColumn, this.table.getDataSource().getNumRows() - 1, this.table.getDataSource().getNumColumns() - 1);
                }
            } else {
                n5 = this.table.getDataSource().getNumColumns() - 1;
                n4 = this.table.getCellLayout().getColumnPosition(n5) + this.table.getCellLayout().getWidth(n5);
                if (n4 < this.table.getSize().width) {
                    serializable = this.table.getCellBounds(-1, this.resizeColumn);
                    if (this.table.store_image_enabled) {
                        this.table.store_image = null;
                    }
                    this.table.repaint(n4, serializable.y, this.table.getSize().width - n4, serializable.height);
                }
                cellAreaRenderer.repaintRange(-1, this.resizeColumn, -1, this.table.getNumColumns() - 1);
            }
        }
    }

    protected void resizeEnd(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        this.needs_resize_begin_event = false;
        this.resize_motion_event = null;
        int n7 = -999;
        int n8 = -999;
        boolean bl = false;
        if (this.resizeRow != -999 && (n7 = Math.max(5, (n6 = this.table.getCellLayout().getHeight(this.resizeRow)) + n3 - this.resizePoint.y)) != this.resizeHeight) {
            bl = true;
        }
        if (this.resizeColumn != -999 && (n8 = Math.max(5, (n6 = this.table.getCellLayout().getWidth(this.resizeColumn)) + n2 - this.resizePoint.x)) != this.resizeWidth) {
            bl = true;
        }
        if (!bl) {
            this.resizeRow = -999;
            this.resizeColumn = -999;
            return;
        }
        JCResizeCellEvent jCResizeCellEvent = null;
        if (this.table.resizeListeners != null) {
            jCResizeCellEvent = new JCResizeCellEvent(this.table, 2, this.resizeRow, this.resizeColumn, this.resizeWidth, this.resizeHeight);
            jCResizeCellEvent.setNewColumnWidth(n8);
            jCResizeCellEvent.setNewRowHeight(n7);
            this.table.fireJCResizeCellEvent(jCResizeCellEvent);
            if (jCResizeCellEvent.isCancelled()) {
                n7 = this.resizeHeight;
                n8 = this.resizeWidth;
                jCResizeCellEvent.setNewColumnWidth(-999);
                jCResizeCellEvent.setNewRowHeight(-999);
            } else {
                n7 = jCResizeCellEvent.getNewRowHeight();
                n8 = jCResizeCellEvent.getNewColumnWidth();
            }
        }
        if (this.resizeRowCellSize != null) {
            n7 = Math.min(Math.max(n7, this.resizeRowCellSize.getMinValue()), this.resizeRowCellSize.getMaxValue());
        }
        if (this.resizeColumnCellSize != null) {
            n8 = Math.min(Math.max(n8, this.resizeColumnCellSize.getMinValue()), this.resizeColumnCellSize.getMaxValue());
        }
        CellAreaRenderer cellAreaRenderer = this.table.getCellAreaHandler().getCellAreaRenderer();
        if (this.resizeRow != -999) {
            if (this.table.isResizeEven()) {
                this.table.setPixelHeight(-998, n7);
            } else {
                this.table.setPixelHeight(this.resizeRow, n7);
            }
            n5 = this.table.getDataSource().getNumRows() - 1;
            n4 = this.table.getCellLayout().getRowPosition(n5) + this.table.getCellLayout().getHeight(n5);
            if (n4 < this.table.getSize().height) {
                this.table.repaint(0, n4, this.table.getSize().width, this.table.getSize().height - n4);
            }
            this.table.doLayout();
            cellAreaRenderer.repaintRange(this.resizeRow, -1, this.table.getDataSource().getNumRows() - 1, this.table.getDataSource().getNumColumns() - 1);
        }
        if (this.resizeColumn != -999) {
            if (this.table.isResizeEven()) {
                this.table.setPixelWidth(-998, n8);
            } else {
                this.table.setPixelWidth(this.resizeColumn, n8);
            }
            n5 = this.table.getDataSource().getNumColumns() - 1;
            n4 = this.table.getCellLayout().getColumnPosition(n5) + this.table.getCellLayout().getWidth(n5);
            if (n4 < this.table.getSize().width) {
                this.table.repaint(n4, 0, this.table.getSize().width - n4, this.table.getSize().height);
            }
            this.table.doLayout();
            cellAreaRenderer.repaintRange(-1, this.resizeColumn, this.table.getDataSource().getNumRows() - 1, this.table.getDataSource().getNumColumns() - 1);
        }
        if (this.table.resizeListeners != null && jCResizeCellEvent != null) {
            jCResizeCellEvent.type = 4;
            this.table.fireJCResizeCellEvent(jCResizeCellEvent);
        }
        this.resizeRow = -999;
        this.resizeColumn = -999;
    }

    protected void cancelResize() {
        this.RESIZING = false;
        this.resizeRow = -999;
        this.resizeColumn = -999;
    }

    protected final boolean isAutoScrollRow() {
        int n2 = this.table.getAutoScroll();
        return n2 == 1 || n2 == 3;
    }

    protected final boolean isAutoScrollColumn() {
        int n2 = this.table.getAutoScroll();
        return n2 == 2 || n2 == 3;
    }

    protected final boolean isResizing() {
        return this.RESIZING;
    }

    protected final boolean isTraversable(int n2, int n3) {
        return n2 != -1 && n3 != -1;
    }

    protected final boolean isValidCellPosition(JCCellPosition jCCellPosition) {
        return jCCellPosition != null && jCCellPosition.row != -999 && jCCellPosition.column != -999;
    }

    protected boolean traverse(MouseEvent mouseEvent, JCCellPosition jCCellPosition, boolean bl) {
        Component component;
        if (this.isResizing()) {
            return false;
        }
        EditTraverseHandler editTraverseHandler = this.table.getEditTraverseHandler();
        JCCellEditor jCCellEditor = editTraverseHandler.getCellEditor();
        JCTable jCTable = null;
        if (jCCellEditor != null && (component = jCCellEditor.getComponent()) != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof JCTable)) continue;
                jCTable = (JCTable)container;
                break;
            }
        }
        if (this.table == jCTable && !editTraverseHandler.commit(true)) {
            return false;
        }
        if (jCCellPosition.row == -1 || jCCellPosition.column == -1) {
            return false;
        }
        if (jCCellPosition.row == -999 || jCCellPosition.column == -999) {
            return false;
        }
        return editTraverseHandler.traverse(jCCellPosition.row, jCCellPosition.column, false, mouseEvent, 0, false);
    }

    protected void performDrag(JCCellPosition jCCellPosition) {
        int n2 = this.initial_cell.row;
        int n3 = this.initial_cell.column;
        this.table.setCursor(12);
        if (this.initial_cell.row == -1) {
            n3 = jCCellPosition.column;
            if (n3 == -1) {
                return;
            }
            if (jCCellPosition.column > this.initial_cell.column) {
                ++n3;
            }
            this.table.cellAreaHandler.performDrag(this.initial_cell.row, this.initial_cell.column, n2, n3);
        } else if (this.initial_cell.column == -1) {
            n2 = jCCellPosition.row;
            if (n2 == -1) {
                return;
            }
            if (jCCellPosition.row > this.initial_cell.row) {
                ++n2;
            }
            this.table.cellAreaHandler.performDrag(this.initial_cell.row, this.initial_cell.column, n2, n3);
        }
    }

    protected void cancelDrag() {
        this.table.cellAreaHandler.cancelDrag();
        this.table.repaint();
    }

    protected void endDrag(JCCellPosition jCCellPosition) {
        this.table.cellAreaHandler.endDrag();
        int n2 = jCCellPosition.row;
        if (jCCellPosition.row > this.initial_cell.row) {
            ++n2;
        }
        int n3 = jCCellPosition.column;
        if (jCCellPosition.column > this.initial_cell.column) {
            ++n3;
        }
        if (this.initial_cell.row == -1) {
            if (this.initial_cell.column != jCCellPosition.column) {
                this.table.dragColumn(this.initial_cell.column, n3);
            }
        } else if (this.initial_cell.row != jCCellPosition.row) {
            this.table.dragRow(this.initial_cell.row, n2);
        }
    }

    private void startAutoScroll(int n2, int n3) {
        this.auto_scroll_x = n2;
        this.auto_scroll_y = n3;
        if (this.auto_scroll_vert != 0 || this.auto_scroll_horiz != 0) {
            if (this.auto_scroll_timer == null) {
                this.auto_scroll_timer = new Timer(10, this);
            }
            if (!this.auto_scroll_timer.isRunning()) {
                this.auto_scroll_timer.start();
                this.AUTOSCROLLING = true;
            }
        }
    }

    private void stopAutoScroll(boolean bl) {
        if (bl || this.auto_scroll_horiz == 0 && this.auto_scroll_vert == 0) {
            if (this.auto_scroll_timer != null) {
                this.auto_scroll_timer.stop();
            }
            this.AUTOSCROLLING = false;
            this.auto_scroll_horiz = 0;
            this.auto_scroll_vert = 0;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n2 = -999;
        int n3 = -999;
        if (this.AUTOSCROLLING && (this.auto_scroll_horiz != 0 || this.auto_scroll_vert != 0)) {
            int n4;
            if (this.auto_scroll_vert == 1) {
                n4 = this.table.getVisibleCells().end_row + 1;
                if (n4 >= this.table.getNumRows()) {
                    this.auto_scroll_vert = 0;
                } else {
                    this.table.makeRowVisible(n4);
                    if (this.SELECTING) {
                        n2 = n4;
                        n3 = this.table.XtoColumn(this.auto_scroll_x);
                    } else if (this.DRAGGING) {
                        this.performDrag(new JCCellPosition(n4, -1));
                    }
                }
            } else if (this.auto_scroll_vert == -1) {
                n4 = this.table.getVisibleCells().start_row - 1;
                if (n4 < 0) {
                    this.auto_scroll_vert = 0;
                } else {
                    this.table.makeRowVisible(n4);
                    if (this.SELECTING) {
                        n2 = n4;
                        n3 = this.table.XtoColumn(this.auto_scroll_x);
                    } else if (this.DRAGGING) {
                        this.performDrag(new JCCellPosition(n4, -1));
                    }
                }
            }
            if (this.auto_scroll_horiz == 1) {
                n4 = this.table.getVisibleCells().end_column + 1;
                if (n4 >= this.table.getNumColumns()) {
                    this.auto_scroll_horiz = 0;
                } else {
                    this.table.makeColumnVisible(n4);
                    if (this.SELECTING) {
                        n2 = this.table.YtoRow(this.auto_scroll_y);
                        n3 = n4;
                    } else if (this.DRAGGING) {
                        this.performDrag(new JCCellPosition(-1, n4));
                    }
                }
            } else if (this.auto_scroll_horiz == -1) {
                n4 = this.table.getVisibleCells().start_column - 1;
                if (n4 < 0) {
                    this.auto_scroll_horiz = 0;
                } else {
                    this.table.makeColumnVisible(n4);
                    if (this.SELECTING) {
                        n2 = this.table.YtoRow(this.auto_scroll_y);
                        n3 = n4;
                    } else if (this.DRAGGING) {
                        this.performDrag(new JCCellPosition(-1, n4));
                    }
                }
            }
            if (this.SELECTING && this.table.getSelectionModel() != null && n2 != -999 && n3 != -999) {
                this.SELECTING = this.table.getSelectionModel().select(2, n2, n3);
            }
        }
    }
}

