/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellBorderModel;
import com.klg.jclass.table.CellStyleModel;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class JCTableCellInfo
implements TableCellInfoModel,
Serializable {
    protected JCTable table;
    protected int row;
    protected int column;
    protected CellStyleModel style;
    protected Object data;
    protected Insets margin_insets;
    protected Insets border_insets;
    private Rectangle drawing_area = new Rectangle();

    public void initialize(JCTable jCTable, Object object, int n2, int n3) {
        this.initialize(jCTable, object, n2, n3, null);
    }

    public void initialize(JCTable jCTable, Object object, int n2, int n3, CellStyleModel cellStyleModel) {
        this.table = jCTable;
        this.row = n2;
        this.column = n3;
        this.style = cellStyleModel == null ? jCTable.getCellStyle(n2, n3) : cellStyleModel;
        this.data = object;
    }

    public CellStyleModel getCellStyle() {
        return this.style;
    }

    public Color getBackground() {
        Color color;
        int n2 = this.style.getRepeatBackground();
        if (n2 != 0 && (color = this.getRepeatColor(this.row, this.column, n2, this.style.getRepeatBackgroundColors())) != null) {
            return color;
        }
        return this.style.getBackground();
    }

    public Color getForeground() {
        Color color;
        int n2 = this.style.getRepeatForeground();
        if (n2 != 0 && (color = this.getRepeatColor(this.row, this.column, n2, this.style.getRepeatForegroundColors())) != null) {
            return color;
        }
        return this.style.getForeground();
    }

    public Color getSelectedBackground() {
        Color color = this.getSelectedColor(this.table.getSelectedBackgroundMode());
        return color != null ? color : this.getBackground();
    }

    public Color getSelectedForeground() {
        Color color = this.getSelectedColor(this.table.getSelectedForegroundMode());
        return color != null ? color : this.getForeground();
    }

    protected Color getSelectedColor(int n2) {
        if (n2 == 0) {
            return this.table.getSelectedBackground();
        }
        if (n2 == 1) {
            return this.table.getSelectedForeground();
        }
        if (n2 == 2) {
            return this.getBackground();
        }
        if (n2 == 3) {
            return this.getForeground();
        }
        return null;
    }

    public Font getFont() {
        return this.style.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.table.getFontMetrics(this.style.getFont());
    }

    public int getHorizontalAlignment() {
        return this.style.getHorizontalAlignment();
    }

    public int getVerticalAlignment() {
        return this.style.getVerticalAlignment();
    }

    public Insets getMarginInsets() {
        int n2 = this.table.getMarginHeight();
        int n3 = this.table.getMarginWidth();
        if (this.margin_insets == null || this.margin_insets.left != n3 && this.margin_insets.top != n2) {
            this.margin_insets = new Insets(n2, n3, n2, n3);
        }
        return this.margin_insets;
    }

    public Insets getBorderInsets() {
        int n2 = this.table.getCellBorderWidth();
        if (this.border_insets == null || this.border_insets.left != n2) {
            this.border_insets = new Insets(n2, n2, n2, n2);
        }
        return this.border_insets;
    }

    public int getBorderStyle() {
        return 0;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = this.table.getCellAreaHandler().getBounds(this.row, this.column, this.drawing_area);
        Insets insets = this.getBorderInsets();
        Insets insets2 = this.getMarginInsets();
        rectangle.x = insets.left + insets2.left;
        rectangle.y = insets.top + insets2.top;
        rectangle.width -= insets.left + insets2.left + insets.right + insets2.right;
        rectangle.height -= insets.top + insets2.top + insets.bottom + insets2.bottom;
        return rectangle;
    }

    public boolean isEditable() {
        return this.style.isEditable();
    }

    public boolean isEnabled() {
        return this.style.isTraversable();
    }

    public boolean getSelectAll() {
        return false;
    }

    public int getClipHints() {
        return this.style.getClipHints();
    }

    public Class getDataType() {
        Class clazz = this.style.getDataType();
        if (clazz != null) {
            return clazz;
        }
        clazz = this.table.getColumnClass(this.column);
        if (clazz != null) {
            return clazz;
        }
        if (this.data != null) {
            return this.data.getClass();
        }
        return null;
    }

    public JCTable getTable() {
        return this.table;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public CellBorderModel getCellBorder() {
        return this.style.getCellBorder();
    }

    public int getCellBorderSides() {
        return this.style.getCellBorderSides();
    }

    protected Color getRepeatColor(int n2, int n3, int n4, Color[] colorArray) {
        if (colorArray == null) {
            return null;
        }
        int n5 = colorArray.length;
        int n6 = n4 == 1 ? n2 : n3;
        int n7 = n6 < 0 ? (n5 - -1 * n6 % n5) % n5 : n6 % n5;
        return colorArray[n7];
    }
}

