/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.DataViewModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.StringCellRangeFlavor;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;

public class InputHandler
implements Serializable {
    protected JCTable table;
    protected boolean SELECTING = false;

    public InputHandler(JCTable jCTable) {
        this.table = jCTable;
    }

    public void getCellPosition(int n2, int n3, JCCellPosition jCCellPosition) {
        if (jCCellPosition == null) {
            return;
        }
        CellAreaHandler cellAreaHandler = this.table.getCellAreaHandler();
        jCCellPosition.row = cellAreaHandler.getRow(n2, n3);
        jCCellPosition.column = cellAreaHandler.getColumn(n2, n3);
    }

    public boolean isShift(int n2) {
        return (n2 & 1) != 0;
    }

    public boolean isControl(int n2) {
        return (n2 & 2) != 0;
    }

    public boolean isAlt(int n2) {
        return (n2 & 8) != 0;
    }

    public boolean isMeta(int n2) {
        return (n2 & 4) != 0;
    }

    public boolean isCell(int n2, int n3) {
        return n2 > -1 && n3 > -1;
    }

    public boolean isLabel(int n2, int n3) {
        return n2 == -1 || n3 == -1;
    }

    public boolean isCopyAction(AWTEvent aWTEvent, int n2, int n3) {
        return this.table.getAction(aWTEvent, n2, n3) == 6;
    }

    public boolean isPasteAction(AWTEvent aWTEvent, int n2, int n3) {
        return this.table.getAction(aWTEvent, n2, n3) == 7;
    }

    public void performCopyAction() {
        JCCellRange jCCellRange;
        Object object;
        if (this.table.getSelectedCells() != null && this.table.getSelectedCells().size() > 0) {
            object = (JCCellRange)this.table.getSelectedCells().iterator().next();
            jCCellRange = new JCCellRange(Math.min(((JCCellRange)object).start_row, ((JCCellRange)object).end_row), Math.min(((JCCellRange)object).start_column, ((JCCellRange)object).end_column), Math.max(((JCCellRange)object).start_row, ((JCCellRange)object).end_row), Math.max(((JCCellRange)object).start_column, ((JCCellRange)object).end_column));
        } else {
            jCCellRange = new JCCellRange(this.table.current_row, this.table.current_column, this.table.current_row, this.table.current_column);
        }
        object = new StringCellRangeFlavor(this.table, jCCellRange);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, (ClipboardOwner)object);
    }

    public void performPasteAction() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        if (transferable != null) {
            try {
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                    String string = dataFlavorArray[i2].getHumanPresentableName();
                    if (string.equals("CellRange")) {
                        Vector vector = (Vector)transferable.getTransferData(dataFlavorArray[i2]);
                        this.loadPasteData(vector);
                        return;
                    }
                    if (!string.equals("Unicode String")) continue;
                    String string2 = (String)transferable.getTransferData(dataFlavorArray[i2]);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n", false);
                    Vector vector = new Vector();
                    while (stringTokenizer.hasMoreElements()) {
                        String string3 = (String)stringTokenizer.nextElement();
                        if (string3 == null) continue;
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "\t", false);
                        Vector<String> vector2 = new Vector<String>();
                        while (stringTokenizer2.hasMoreElements()) {
                            vector2.addElement(stringTokenizer2.nextToken());
                        }
                        vector.addElement(vector2);
                    }
                    this.loadPasteData(vector);
                    return;
                }
            }
            catch (IOException iOException) {
                System.out.println("Error pasting data: " + iOException.getMessage());
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println("Error pasting data: " + unsupportedFlavorException.getMessage());
            }
        }
    }

    protected void loadPasteData(Vector vector) {
        JCCellRange jCCellRange;
        Collection collection = this.table.getSelectedCells();
        if (collection != null && collection.size() > 0) {
            JCCellRange jCCellRange2 = (JCCellRange)collection.iterator().next();
            jCCellRange = new JCCellRange(Math.min(jCCellRange2.start_row, jCCellRange2.end_row), Math.min(jCCellRange2.start_column, jCCellRange2.end_column), Math.max(jCCellRange2.start_row, jCCellRange2.end_row), Math.max(jCCellRange2.start_column, jCCellRange2.end_column));
        } else {
            jCCellRange = new JCCellRange(this.table.current_row, this.table.current_column, this.table.getNumRows() - 1, this.table.getNumColumns() - 1);
        }
        if (jCCellRange.end_row == Integer.MAX_VALUE) {
            jCCellRange.end_row = this.table.getNumRows() - 1;
        }
        if (jCCellRange.end_column == Integer.MAX_VALUE) {
            jCCellRange.end_column = this.table.getNumColumns() - 1;
        }
        if (jCCellRange != null) {
            int n2 = vector.size();
            if (n2 == 0) {
                return;
            }
            int n3 = ((Vector)vector.elementAt(0)).size();
            int n4 = jCCellRange.start_row;
            for (int i2 = 0; n4 <= jCCellRange.end_row && i2 < n2; ++n4, ++i2) {
                Vector vector2 = (Vector)vector.elementAt(i2);
                int n5 = jCCellRange.start_column;
                for (int i3 = 0; n5 <= jCCellRange.end_column && i3 < n3; ++n5, ++i3) {
                    DataViewModel dataViewModel = this.table.getDataView();
                    if (n5 == -1 || n4 == -1) {
                        TableDataModel tableDataModel = dataViewModel.getDataSource();
                        if (!(tableDataModel instanceof JCVectorDataSource)) continue;
                        JCVectorDataSource jCVectorDataSource = (JCVectorDataSource)tableDataModel;
                        if (n5 == -1) {
                            jCVectorDataSource.setRowLabel(n4, vector2.elementAt(i3));
                            continue;
                        }
                        if (n4 != -1) continue;
                        jCVectorDataSource.setColumnLabel(n5, vector2.elementAt(i3));
                        continue;
                    }
                    dataViewModel.setTableDataItem(vector2.elementAt(i3), n4, n5);
                }
            }
        }
    }
}

