/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.swing.JCVersion;
import com.klg.jclass.swing.JCWizardListener;
import com.klg.jclass.util.JCListenerList;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public abstract class BaseWizard
extends JPanel {
    protected CardLayout cardLayout;
    protected Container cardOwner;
    protected transient JCListenerList listeners;
    protected transient ActionListener nextListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BaseWizard.this.next();
        }
    };
    protected transient ActionListener previousListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BaseWizard.this.previous();
        }
    };
    protected transient ActionListener finishListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BaseWizard.this.finish();
        }
    };
    protected transient ActionListener cancelListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BaseWizard.this.cancel();
        }
    };
    protected transient ActionListener helpListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BaseWizard.this.help();
        }
    };

    public BaseWizard() {
        this.cardLayout = new CardLayout();
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public boolean isLastPage(Component component) {
        return component == this.getComponent(this.getComponentCount() - 1);
    }

    public void show(String string) {
        this.cardLayout.show(this.cardOwner, string);
    }

    protected abstract Component getCurrentPage();

    public void first() {
        this.cardLayout.first(this.cardOwner);
    }

    public void last() {
        this.cardLayout.last(this.cardOwner);
    }

    public abstract boolean next();

    public abstract boolean previous();

    public abstract boolean cancel();

    public abstract void help();

    public abstract boolean finish();

    public void addWizardListener(JCWizardListener jCWizardListener) {
        this.listeners = JCListenerList.add(this.listeners, jCWizardListener);
    }

    public void removeWizardListener(JCWizardListener jCWizardListener) {
        this.listeners = JCListenerList.remove(this.listeners, jCWizardListener);
    }
}

