/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.ttf;

import com.klg.jclass.page.resources.LocaleBundle;
import com.klg.jclass.page.ttf.FontFileReader;
import com.klg.jclass.page.ttf.Glyphs;
import com.klg.jclass.page.ttf.TTFCmapEntry;
import com.klg.jclass.page.ttf.TTFDirTabEntry;
import com.klg.jclass.page.ttf.TTFFontNames;
import com.klg.jclass.page.ttf.TTFMtxEntry;
import com.klg.jclass.page.ttf.UnicodeMapping;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class TTFFile {
    public static final int UNPARSED = 0;
    public static final int PARSE_OK = 1;
    public static final int PARSE_WARNING = 2;
    public static final int PARSE_FATAL = 3;
    static final byte NTABS = 24;
    static final int NMACGLYPHS = 258;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    static String encoding = "WinAnsiEncoding";
    short firstChar = 0;
    boolean is_embeddable = true;
    boolean hasSerifs = true;
    Hashtable dirTabs;
    Hashtable kerningTab;
    Hashtable ansiKerningTab;
    Vector cmaps;
    Vector unicodeMapping;
    Hashtable unicodeToGlyphTable;
    Hashtable compositeGlyphs;
    double version;
    int upem;
    int nhmtx;
    int post_format;
    int loca_format;
    long lastLoca = 0L;
    int nglyphs;
    int nmglyphs;
    TTFMtxEntry[] mtx_tab;
    int[] mtx_encoded = null;
    String fontName = "";
    String fullName = "";
    String notice = "";
    String familyName = "";
    String subFamilyName = "";
    double italicAngle = 0.0;
    long isFixedPitch = 0L;
    int fontBBox1 = 0;
    int fontBBox2 = 0;
    int fontBBox3 = 0;
    int fontBBox4 = 0;
    int capHeight = 0;
    int underlinePosition = 0;
    int underlineThickness = 0;
    int xHeight = 0;
    int ascender = 0;
    int descender = 0;
    short lastChar = 0;
    int[] ansiWidth;
    Hashtable ansiIndex;
    long dirTabOffset = 0L;
    byte[] panose = null;
    int ibmFamilyClass = 0;
    int ibmFamilySubclass = 0;
    int status = 0;
    StringBuffer statusMessage = null;
    String fontFileName = null;

    void seek_tab(FontFileReader fontFileReader, String string, long l2) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(string);
        if (tTFDirTabEntry == null) {
            System.err.println("Warning: TTF: Dirtab " + string + " not found.");
            return;
        }
        fontFileReader.seek_set(tTFDirTabEntry.offset + l2);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n2) {
        if (n2 > this.status) {
            this.status = n2;
        }
    }

    public void addToStatusMessage(String string) {
        if (string == null) {
            return;
        }
        if (this.statusMessage == null) {
            this.statusMessage = new StringBuffer();
        }
        boolean bl = false;
        if (this.statusMessage.length() == 0) {
            bl = true;
        }
        if (!bl) {
            this.statusMessage.append('\n');
        }
        this.statusMessage.append(string);
    }

    public String getStatusMessage() {
        if (this.statusMessage == null) {
            return "";
        }
        return this.statusMessage.toString();
    }

    public void setFontFileName(String string) {
        this.fontFileName = string;
    }

    protected void addNoUnicodeStatusMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocaleBundle.string("No Unicode CMap"));
        String string = "xxx";
        int n2 = stringBuffer.toString().indexOf(string);
        if (n2 >= 0) {
            stringBuffer.replace(n2, n2 + string.length(), this.fullName);
        }
        this.addToStatusMessage(stringBuffer.toString());
        if (this.fontFileName != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("    (");
            stringBuffer.append(this.fontFileName);
            stringBuffer.append(")");
            this.addToStatusMessage(stringBuffer.toString());
        }
    }

    protected void addInvalidFileStatusMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocaleBundle.string("Invalid TTF"));
        this.addToStatusMessage(stringBuffer.toString());
        if (this.fontFileName != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("    (");
            stringBuffer.append(this.fontFileName);
            stringBuffer.append(")");
            this.addToStatusMessage(stringBuffer.toString());
        }
    }

    public int get_ttf_funit(int n2) {
        int n3;
        if (n2 < 0) {
            long l2 = n2 % this.upem;
            long l3 = 1000L * l2;
            long l4 = l2 / l3;
            n3 = -(-1000 * n2 / this.upem - (int)l4);
        } else {
            n3 = n2 / this.upem * 1000 + n2 % this.upem * 1000 / this.upem;
        }
        return n3;
    }

    private boolean readCMAP(FontFileReader fontFileReader) throws IOException {
        int n2;
        int n3;
        int n4;
        this.unicodeMapping = new Vector();
        this.unicodeToGlyphTable = new Hashtable();
        int n5 = 0;
        this.seek_tab(fontFileReader, "cmap", 2L);
        int n6 = fontFileReader.readTTFUShort();
        long l2 = 0L;
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = fontFileReader.readTTFUShort();
            n2 = fontFileReader.readTTFUShort();
            long l3 = fontFileReader.readTTFULong();
            if (n3 != 3 || n2 != 1) continue;
            l2 = l3;
        }
        if (l2 <= 0L) {
            this.addNoUnicodeStatusMessage();
            this.setStatus(2);
            return false;
        }
        this.seek_tab(fontFileReader, "cmap", l2);
        n4 = fontFileReader.readTTFUShort();
        n3 = fontFileReader.readTTFUShort();
        if (n4 == 4) {
            int n7;
            int n8;
            fontFileReader.skip(2L);
            n2 = fontFileReader.readTTFUShort();
            int n9 = fontFileReader.readTTFUShort();
            int n10 = fontFileReader.readTTFUShort();
            int n11 = fontFileReader.readTTFUShort();
            int[] nArray = new int[n2 / 2];
            int[] nArray2 = new int[n2 / 2];
            int[] nArray3 = new int[n2 / 2];
            int[] nArray4 = new int[n2 / 2];
            for (n8 = 0; n8 < n2 / 2; ++n8) {
                nArray[n8] = fontFileReader.readTTFUShort();
            }
            fontFileReader.skip(2L);
            for (n8 = 0; n8 < n2 / 2; ++n8) {
                nArray2[n8] = fontFileReader.readTTFUShort();
            }
            for (n8 = 0; n8 < n2 / 2; ++n8) {
                nArray3[n8] = fontFileReader.readTTFShort();
            }
            n8 = fontFileReader.getCurrentPos();
            for (n7 = 0; n7 < n2 / 2; ++n7) {
                nArray4[n7] = fontFileReader.readTTFUShort();
            }
            n7 = fontFileReader.getCurrentPos();
            for (int i2 = 0; i2 < nArray2.length && nArray2[i2] != 65535; ++i2) {
                for (int i3 = nArray2[i2]; i3 <= nArray[i2]; ++i3) {
                    Object object;
                    Object object2;
                    int n12;
                    if (i3 < 256 && i3 > this.lastChar) {
                        this.lastChar = (short)i3;
                    }
                    if (n5 >= this.mtx_tab.length) continue;
                    if (nArray4[i2] != 0) {
                        int n13 = n7 + (nArray4[i2] / 2 + (i3 - nArray2[i2]) + i2 - n2 / 2) * 2;
                        fontFileReader.seek_set(n13);
                        n12 = fontFileReader.readTTFUShort() + nArray3[i2] & 0xFFFF;
                        this.unicodeMapping.addElement(new UnicodeMapping(n12, i3));
                        this.unicodeToGlyphTable.put(new Integer(i3), new Integer(n12));
                        this.mtx_tab[n12].unicodeIndex.addElement(new Integer(i3));
                        object2 = (Vector)this.ansiIndex.get(new Integer(i3));
                        if (object2 != null) {
                            object = ((Vector)object2).elements();
                            while (object.hasMoreElements()) {
                                Integer n14 = (Integer)object.nextElement();
                                this.ansiWidth[n14.intValue()] = this.mtx_tab[n12].wx;
                            }
                        }
                    } else {
                        n12 = i3 + nArray3[i2] & 0xFFFF;
                        if (n12 < this.mtx_tab.length) {
                            this.mtx_tab[n12].unicodeIndex.addElement(new Integer(i3));
                        } else {
                            System.err.println("Glyph " + n12 + " out of range: " + this.mtx_tab.length);
                        }
                        this.unicodeMapping.addElement(new UnicodeMapping(n12, i3));
                        this.unicodeToGlyphTable.put(new Integer(i3), new Integer(n12));
                        Vector vector = (Vector)this.ansiIndex.get(new Integer(i3));
                        if (vector != null) {
                            object2 = vector.elements();
                            while (object2.hasMoreElements()) {
                                object = (Integer)object2.nextElement();
                                this.ansiWidth[((Integer)object).intValue()] = this.mtx_tab[n12].wx;
                            }
                        }
                    }
                    if (n12 >= this.mtx_tab.length || this.mtx_tab[n12].unicodeIndex.size() >= 2) continue;
                    ++n5;
                }
            }
        }
        return true;
    }

    private boolean isUnicode(FontFileReader fontFileReader) throws IOException {
        boolean bl = false;
        this.seek_tab(fontFileReader, "cmap", 2L);
        int n2 = fontFileReader.readTTFUShort();
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = fontFileReader.readTTFUShort();
            int n4 = fontFileReader.readTTFUShort();
            long l3 = fontFileReader.readTTFULong();
            if (n3 != 3 || n4 != 1) continue;
            l2 = l3;
        }
        return l2 > 0L;
    }

    private void print_max_min() {
        int n2 = 255;
        int n3 = 0;
        for (int i2 = 0; i2 < this.mtx_tab.length; ++i2) {
            if (this.mtx_tab[i2].index < n2) {
                n2 = this.mtx_tab[i2].index;
            }
            if (this.mtx_tab[i2].index <= n3) continue;
            n3 = this.mtx_tab[i2].index;
        }
        System.err.println("Min: " + n2);
        System.err.println("Max: " + n3);
    }

    public void readFont(FontFileReader fontFileReader) throws IOException {
        this.readFont(fontFileReader, null);
    }

    private void initAnsiWidths() {
        int n2;
        this.ansiWidth = new int[256];
        for (n2 = 0; n2 < 256; ++n2) {
            this.ansiWidth[n2] = this.mtx_tab[0].wx;
        }
        this.ansiIndex = new Hashtable();
        for (n2 = 32; n2 < Glyphs.winAnsiEncoding.length; ++n2) {
            Integer n3 = new Integer(n2);
            Integer n4 = new Integer(Glyphs.winAnsiEncoding[n2]);
            Vector<Integer> vector = (Vector<Integer>)this.ansiIndex.get(n4);
            if (vector == null) {
                vector = new Vector<Integer>();
                this.ansiIndex.put(n4, vector);
            }
            vector.addElement(n3);
        }
    }

    public void readFont(FontFileReader fontFileReader, String string) throws IOException {
        this.setStatus(1);
        if (!this.checkTTC(fontFileReader, string, false)) {
            throw new IOException("Failed to read font");
        }
        if (!this.readDirTabs(fontFileReader)) {
            this.addInvalidFileStatusMessage();
            this.setStatus(3);
            return;
        }
        this.readName(fontFileReader);
        if (!this.isUnicode(fontFileReader)) {
            this.addNoUnicodeStatusMessage();
            this.setStatus(3);
            return;
        }
        this.readFontHeader(fontFileReader);
        this.getNumGlyphs(fontFileReader);
        this.readHorizontalHeader(fontFileReader);
        this.readHorizontalMetrics(fontFileReader);
        this.initAnsiWidths();
        this.readPostscript(fontFileReader);
        this.readOS2(fontFileReader);
        this.readIndexToLocation(fontFileReader);
        this.readGlyf(fontFileReader);
        this.readPCLT(fontFileReader);
        if (!this.readCMAP(fontFileReader)) {
            this.setStatus(3);
            return;
        }
        this.createCMaps();
        this.readKerning(fontFileReader);
    }

    public void writeReducedFont(OutputStream outputStream, FontFileReader fontFileReader, SortedSet sortedSet, SortedSet sortedSet2) throws IOException {
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object32;
        TreeSet<Object> treeSet = null;
        if (sortedSet2 != null) {
            treeSet = new TreeSet(sortedSet2);
            for (Object object32 : sortedSet2) {
                object2 = (List)this.compositeGlyphs.get(object32);
                if (object2 == null) continue;
                for (int i2 = 0; i2 < object2.size(); ++i2) {
                    treeSet.add(object2.get(i2));
                }
            }
        } else {
            treeSet = new TreeSet<Object>();
        }
        if (sortedSet != null) {
            for (Object object32 : sortedSet) {
                if ((Integer)object32 == 128) {
                    object32 = new Integer(8364);
                }
                if ((object2 = (Integer)this.unicodeToGlyphTable.get(object32)) == null) continue;
                treeSet.add(object2);
                List list = (List)this.compositeGlyphs.get(object2);
                if (list == null) continue;
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    treeSet.add(list.get(i3));
                }
            }
        }
        fontFileReader.seek_set(this.dirTabOffset);
        int n4 = this.dirTabs.size();
        object32 = new ByteArrayOutputStream();
        object2 = new ByteArrayOutputStream();
        this.reduceGLYF(fontFileReader, (ByteArrayOutputStream)object32, (ByteArrayOutputStream)object2, treeSet);
        byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
        byte[] byArray2 = ((ByteArrayOutputStream)object32).toByteArray();
        fontFileReader.seek_set(this.dirTabOffset);
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (this.dirTabs.get("EBLC") != null && this.dirTabs.get("EBDT") != null) {
            TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("EBLC");
            TTFDirTabEntry tTFDirTabEntry2 = (TTFDirTabEntry)this.dirTabs.get("EBDT");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            this.reduceEBLC(fontFileReader, byteArrayOutputStream, byteArrayOutputStream2, treeSet);
            byArray3 = byteArrayOutputStream.toByteArray();
            byArray4 = byteArrayOutputStream2.toByteArray();
            if (byArray3.length == 0) {
                --n4;
                byArray3 = null;
            }
            if (byArray4.length == 0) {
                --n4;
                byArray4 = null;
            }
        }
        if (this.dirTabs.get("vhea") != null) {
            --n4;
        }
        if (this.dirTabs.get("vmtx") != null) {
            --n4;
        }
        if (this.dirTabs.get("DSIG") != null) {
            --n4;
        }
        boolean bl = false;
        if ((sortedSet == null || sortedSet.size() == 0) && this.dirTabs.get("cmap") != null) {
            --n4;
            bl = true;
        }
        fontFileReader.seek_set(this.dirTabOffset);
        long l2 = 12 + n4 * 16;
        long l3 = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(fontFileReader.readBytes(4));
        byteArrayOutputStream.write(this.shortToBytes(n4));
        byteArrayOutputStream.write(fontFileReader.readBytes(6));
        TreeMap treeMap = new TreeMap(this.dirTabs);
        Set set = treeMap.keySet();
        for (String string : set) {
            Object object4 = (TTFDirTabEntry)this.dirTabs.get(string);
            object = null;
            if (string.equals("glyf")) {
                object = byArray2;
            } else if (string.equals("loca")) {
                object = byArray;
            } else if (string.equals("EBLC")) {
                if (byArray3 == null) continue;
                object = byArray3;
            } else if (string.equals("EBDT")) {
                if (byArray4 == null) continue;
                object = byArray4;
            } else {
                if (string.equals("vhea") || string.equals("vmtx") || string.equals("DSIG") || bl && string.equals("cmap")) continue;
                object = fontFileReader.getBytes((int)((TTFDirTabEntry)object4).offset, (int)((TTFDirTabEntry)object4).length);
            }
            if (string.equals("head")) {
                object[8] = 0;
                object[9] = 0;
                object[10] = 0;
                object[11] = 0;
            }
            byteArrayOutputStream.write(((TTFDirTabEntry)object4).tag);
            long l4 = this.calcCheckSum((byte[])object);
            byteArrayOutputStream.write(this.longToBytes(l4));
            byteArrayOutputStream.write(this.longToBytes(l2));
            byteArrayOutputStream.write(this.longToBytes(((byte[])object).length));
            l2 += (long)((byte[])object).length;
            n3 = ((byte[])object).length % 4;
            if (n3 > 0) {
                n2 = 4 - n3;
                l2 += (long)n2;
            }
            if ((l3 += l4) < 0x100000000L) continue;
            l3 -= 0x100000000L;
        }
        if ((l3 += this.calcCheckSum(byteArrayOutputStream.toByteArray())) >= 0x100000000L) {
            l3 -= 0x100000000L;
        }
        int n5 = 0;
        for (Object object4 : set) {
            object = (TTFDirTabEntry)this.dirTabs.get(object4);
            byte[] byArray5 = null;
            if (((String)object4).equals("glyf")) {
                byArray5 = byArray2;
            } else if (((String)object4).equals("loca")) {
                byArray5 = byArray;
            } else if (((String)object4).equals("EBLC")) {
                if (byArray3 == null) continue;
                byArray5 = byArray3;
            } else if (((String)object4).equals("EBDT")) {
                if (byArray4 == null) continue;
                byArray5 = byArray4;
            } else {
                if (((String)object4).equals("vhea") || ((String)object4).equals("vmtx") || ((String)object4).equals("DSIG") || bl && ((String)object4).equals("cmap")) continue;
                byArray5 = fontFileReader.getBytes((int)object.offset, (int)object.length);
            }
            if (((String)object4).equals("head")) {
                n5 = byteArrayOutputStream.size();
                byArray5[8] = 0;
                byArray5[9] = 0;
                byArray5[10] = 0;
                byArray5[11] = 0;
            }
            byteArrayOutputStream.write(byArray5);
            int n6 = byArray5.length % 4;
            if (n6 <= 0) continue;
            n3 = 4 - n6;
            for (n2 = 0; n2 < n3; ++n2) {
                byteArrayOutputStream.write(0);
            }
        }
        long l5 = 2981146554L - l3;
        if (l5 < 0L) {
            l5 += 0x100000000L;
        }
        byte[] byArray6 = this.longToBytes(l5);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        byArray7[n5 + 8] = byArray6[0];
        byArray7[n5 + 9] = byArray6[1];
        byArray7[n5 + 10] = byArray6[2];
        byArray7[n5 + 11] = byArray6[3];
        outputStream.write(byArray7);
    }

    protected byte[] longToBytes(long l2) {
        byte[] byArray = new byte[4];
        for (int i2 = 3; i2 >= 0; --i2) {
            byArray[i2] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return byArray;
    }

    protected byte[] shortToBytes(int n2) {
        byte[] byArray = new byte[2];
        for (int i2 = 1; i2 >= 0; --i2) {
            byArray[i2] = (byte)(n2 & 0xFF);
            n2 >>= 8;
        }
        return byArray;
    }

    protected long bytesToLong(byte[] byArray) throws IOException {
        long l2 = byArray[0];
        l2 = (l2 << 8) + (long)byArray[1];
        l2 = (l2 << 8) + (long)byArray[2];
        l2 = (l2 << 8) + (long)byArray[3];
        return l2;
    }

    protected int bytesToShort(byte[] byArray) throws IOException {
        int n2 = byArray[0];
        n2 = (n2 << 8) + byArray[1];
        return n2;
    }

    public long calcCheckSum(byte[] byArray) {
        long l2 = 0L;
        long l3 = (byArray.length + 3) / 4;
        int n2 = 0;
        while (l3-- > 0L) {
            long l4 = 0L;
            for (int i2 = 0; i2 < 4; ++i2) {
                if (n2 + i2 < byArray.length) {
                    byte by;
                    if (i2 != 0) {
                        l4 <<= 8;
                    }
                    if ((by = byArray[n2 + i2]) < 0) {
                        l4 += (long)(by + 256);
                        continue;
                    }
                    l4 += (long)by;
                    continue;
                }
                l4 <<= 8;
            }
            if ((l2 += l4) >= 0x100000000L) {
                l2 -= 0x100000000L;
            }
            n2 += 4;
        }
        return l2;
    }

    public List readFontNames(FontFileReader fontFileReader) throws IOException {
        this.setStatus(1);
        Vector<String> vector = new Vector<String>();
        if (this.checkTTCForFontNames(fontFileReader, vector, false, false)) {
            return vector;
        }
        if (!this.readDirTabs(fontFileReader)) {
            this.addInvalidFileStatusMessage();
            this.setStatus(3);
            return vector;
        }
        this.readName(fontFileReader);
        if (this.isUnicode(fontFileReader)) {
            vector.add(this.fontName);
        } else {
            this.addNoUnicodeStatusMessage();
            this.setStatus(2);
        }
        return vector;
    }

    public List readAllFontNames(FontFileReader fontFileReader) throws IOException {
        this.setStatus(1);
        Vector<TTFFontNames> vector = new Vector<TTFFontNames>();
        if (this.checkTTCForFontNames(fontFileReader, vector, false, true)) {
            return vector;
        }
        if (!this.readDirTabs(fontFileReader)) {
            this.addInvalidFileStatusMessage();
            this.setStatus(3);
            return vector;
        }
        this.readName(fontFileReader);
        if (this.isUnicode(fontFileReader)) {
            TTFFontNames tTFFontNames = new TTFFontNames();
            tTFFontNames.fontName = this.fontName;
            tTFFontNames.fullName = this.fullName;
            tTFFontNames.familyName = this.familyName;
            tTFFontNames.subFamilyName = this.subFamilyName;
            vector.add(tTFFontNames);
        } else {
            this.addNoUnicodeStatusMessage();
            this.setStatus(2);
        }
        return vector;
    }

    private void createCMaps() {
        UnicodeMapping unicodeMapping;
        this.cmaps = new Vector();
        TTFCmapEntry tTFCmapEntry = new TTFCmapEntry();
        Enumeration enumeration = this.unicodeMapping.elements();
        UnicodeMapping unicodeMapping2 = unicodeMapping = (UnicodeMapping)enumeration.nextElement();
        tTFCmapEntry.unicodeStart = unicodeMapping.uIdx;
        tTFCmapEntry.glyphStartIndex = unicodeMapping.gIdx;
        while (enumeration.hasMoreElements()) {
            unicodeMapping = (UnicodeMapping)enumeration.nextElement();
            if (unicodeMapping2.uIdx + 1 != unicodeMapping.uIdx || unicodeMapping2.gIdx + 1 != unicodeMapping.gIdx) {
                tTFCmapEntry.unicodeEnd = unicodeMapping2.uIdx;
                this.cmaps.addElement(tTFCmapEntry);
                tTFCmapEntry = new TTFCmapEntry();
                tTFCmapEntry.unicodeStart = unicodeMapping.uIdx;
                tTFCmapEntry.glyphStartIndex = unicodeMapping.gIdx;
            }
            unicodeMapping2 = unicodeMapping;
        }
        tTFCmapEntry.unicodeEnd = unicodeMapping.uIdx;
        this.cmaps.addElement(tTFCmapEntry);
    }

    public void printStuff() {
        System.err.println("Font name: " + this.fontName);
        System.err.println("Full name: " + this.fullName);
        System.err.println("Family name: " + this.familyName);
        System.err.println("Subfamily name: " + this.subFamilyName);
        System.err.println("Notice:    " + this.notice);
        System.err.println("xHeight:   " + this.get_ttf_funit(this.xHeight));
        System.err.println("capheight: " + this.get_ttf_funit(this.capHeight));
        System.err.println("ItalicAngle: " + this.italicAngle);
        System.err.println();
        System.err.println("Ascender:    " + this.get_ttf_funit(this.ascender));
        System.err.println("Descender:   " + this.get_ttf_funit(this.descender));
        System.err.println("FontBBox:    [" + this.get_ttf_funit(this.fontBBox1) + " " + this.get_ttf_funit(this.fontBBox2) + " " + this.get_ttf_funit(this.fontBBox3) + " " + this.get_ttf_funit(this.fontBBox4) + "]");
    }

    public static void main(String[] stringArray) {
        try {
            TTFFile tTFFile = new TTFFile();
            FontFileReader fontFileReader = new FontFileReader(stringArray[0]);
            String string = null;
            if (stringArray.length >= 2) {
                string = stringArray[1];
            }
            tTFFile.readFont(fontFileReader, string);
            tTFFile.printStuff();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    public String getWindowsName() {
        return new String(this.familyName + "," + this.subFamilyName);
    }

    public String getPostscriptName() {
        if ("Regular".equals(this.subFamilyName) || "Roman".equals(this.subFamilyName)) {
            return this.familyName;
        }
        return this.familyName + "," + this.subFamilyName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getCharSetName() {
        return encoding;
    }

    public int getCapHeight() {
        return this.get_ttf_funit(this.capHeight);
    }

    public int getXHeight() {
        return this.get_ttf_funit(this.xHeight);
    }

    public boolean isSerif() {
        return this.hasSerifs;
    }

    public int getFlags() {
        int n2 = 32;
        if (this.italicAngle != 0.0) {
            n2 |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            n2 |= 2;
        }
        if (this.hasSerifs) {
            n2 |= 1;
        }
        return n2;
    }

    public String getStemV() {
        return "0";
    }

    public String getItalicAngle() {
        String string = Double.toString(this.italicAngle);
        return string;
    }

    public double getItalicAngleValue() {
        return this.italicAngle;
    }

    public int[] getFontBBox() {
        int[] nArray = new int[]{this.get_ttf_funit(this.fontBBox1), this.get_ttf_funit(this.fontBBox2), this.get_ttf_funit(this.fontBBox3), this.get_ttf_funit(this.fontBBox4)};
        return nArray;
    }

    public int getLowerCaseAscent() {
        return this.get_ttf_funit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.get_ttf_funit(this.descender);
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getFirstChar() {
        return this.firstChar;
    }

    public int[] getWidths() {
        int[] nArray = new int[this.mtx_tab.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.get_ttf_funit(this.mtx_tab[i2].wx);
        }
        return nArray;
    }

    public int getCharWidth(int n2) {
        return this.get_ttf_funit(this.ansiWidth[n2]);
    }

    public Hashtable getKerning() {
        return this.kerningTab;
    }

    public Hashtable getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public boolean isEmbeddable() {
        return this.is_embeddable;
    }

    public TTFMtxEntry getGlyphMetricsByUnicode(int n2) {
        int n3 = this.unicodeToGlyphCode(n2);
        if (n3 == -1) {
            return null;
        }
        return this.mtx_tab[n3];
    }

    public TTFMtxEntry getGlyphMetricsByGlyphCode(int n2) {
        if (n2 < this.mtx_tab.length) {
            return this.mtx_tab[n2];
        }
        return null;
    }

    public List glyphCodeToUnicodes(int n2) {
        return this.mtx_tab[n2].unicodeIndex;
    }

    public int unicodeToGlyphCode(int n2) {
        Integer n3 = (Integer)this.unicodeToGlyphTable.get(new Integer(n2));
        if (n3 == null) {
            return -1;
        }
        return n3;
    }

    public int getGlyphWidthByUnicode(int n2) {
        int n3 = this.unicodeToGlyphCode(n2);
        if (n3 == -1) {
            return 0;
        }
        return this.getGlyphWidthByGlyphCode(n3);
    }

    public int getGlyphWidthByGlyphCode(int n2) {
        return this.get_ttf_funit(this.mtx_tab[n2].getWx());
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public int getIBMFamilyClass() {
        return this.ibmFamilyClass;
    }

    public int getIBMFamilySubclass() {
        return this.ibmFamilySubclass;
    }

    protected boolean readDirTabs(FontFileReader fontFileReader) throws IOException {
        long l2 = fontFileReader.readTTFULong();
        if (l2 != 1953658213L && l2 != 65536L) {
            return false;
        }
        int n2 = fontFileReader.readTTFUShort();
        fontFileReader.skip(6L);
        this.dirTabs = new Hashtable();
        TTFDirTabEntry[] tTFDirTabEntryArray = new TTFDirTabEntry[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            tTFDirTabEntryArray[i2] = new TTFDirTabEntry();
            String string = tTFDirTabEntryArray[i2].read(fontFileReader);
            this.dirTabs.put(string, tTFDirTabEntryArray[i2]);
        }
        return true;
    }

    protected void readFontHeader(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "head", 0L);
        this.version = fontFileReader.readTTFFixedDecimal();
        fontFileReader.skip(4L);
        fontFileReader.skip(4L);
        fontFileReader.skip(6L);
        this.upem = fontFileReader.readTTFUShort();
        fontFileReader.skip(16L);
        this.fontBBox1 = fontFileReader.readTTFShort();
        this.fontBBox2 = fontFileReader.readTTFShort();
        this.fontBBox3 = fontFileReader.readTTFShort();
        this.fontBBox4 = fontFileReader.readTTFShort();
        fontFileReader.skip(6L);
        this.loca_format = fontFileReader.readTTFShort();
    }

    protected void getNumGlyphs(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "maxp", 4L);
        this.nglyphs = fontFileReader.readTTFUShort();
    }

    protected void readHorizontalHeader(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "hhea", 4L);
        this.ascender = fontFileReader.readTTFShort();
        this.descender = fontFileReader.readTTFShort();
        fontFileReader.skip(26L);
        this.nhmtx = fontFileReader.readTTFUShort();
    }

    protected void readHorizontalMetrics(FontFileReader fontFileReader) throws IOException {
        int n2;
        this.seek_tab(fontFileReader, "hmtx", 0L);
        int n3 = this.nglyphs > this.nhmtx ? this.nglyphs : this.nhmtx;
        this.mtx_tab = new TTFMtxEntry[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.mtx_tab[n2] = new TTFMtxEntry();
        }
        for (n2 = 0; n2 < this.nhmtx; ++n2) {
            this.mtx_tab[n2].wx = fontFileReader.readTTFUShort();
            this.mtx_tab[n2].lsb = fontFileReader.readTTFShort();
        }
        if (this.nhmtx < n3) {
            n2 = this.mtx_tab[this.nhmtx - 1].wx;
            for (int i2 = this.nhmtx; i2 < n3; ++i2) {
                this.mtx_tab[i2].wx = n2;
                this.mtx_tab[i2].lsb = fontFileReader.readTTFShort();
            }
        }
    }

    private final void readPostscript(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "post", 0L);
        this.post_format = fontFileReader.readTTFLong();
        this.italicAngle = fontFileReader.readTTFFixedDecimal();
        this.underlinePosition = fontFileReader.readTTFShort();
        this.underlineThickness = fontFileReader.readTTFShort();
        this.isFixedPitch = fontFileReader.readTTFULong();
        fontFileReader.skip(16L);
        switch (this.post_format) {
            case 65536: {
                for (int i2 = 0; i2 < Glyphs.mac_glyph_names.length && i2 < this.mtx_tab.length; ++i2) {
                    this.mtx_tab[i2].name = Glyphs.mac_glyph_names[i2];
                }
                break;
            }
            case 131072: {
                int n2;
                int n3 = 0;
                int n4 = fontFileReader.readTTFUShort();
                for (n2 = 0; n2 < n4; ++n2) {
                    this.mtx_tab[n2].index = fontFileReader.readTTFUShort();
                    if (this.mtx_tab[n2].index <= 257) continue;
                    ++n3;
                }
                String[] stringArray = new String[n3];
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    stringArray[n2] = fontFileReader.readTTFString(fontFileReader.readTTFUByte());
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    if (this.mtx_tab[n2].index < 258) {
                        this.mtx_tab[n2].name = Glyphs.mac_glyph_names[this.mtx_tab[n2].index];
                        continue;
                    }
                    int n5 = this.mtx_tab[n2].index - 258;
                    this.mtx_tab[n2].name = stringArray[n5];
                }
                break;
            }
            case 196608: {
                break;
            }
            default: {
                System.err.println("Unknown Postscript format : " + this.post_format);
            }
        }
    }

    private final void readOS2(FontFileReader fontFileReader) throws IOException {
        if (this.dirTabs.get("OS/2") != null) {
            this.seek_tab(fontFileReader, "OS/2", 8L);
            int n2 = fontFileReader.readTTFUShort();
            this.is_embeddable = n2 != 2;
            fontFileReader.readBytes(20);
            int n3 = fontFileReader.readTTFUShort();
            this.ibmFamilyClass = n3 >> 8;
            this.ibmFamilySubclass = n3 & 0xF;
            this.panose = fontFileReader.readBytes(10);
        } else {
            this.is_embeddable = true;
        }
    }

    protected final void readIndexToLocation(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "loca", 0L);
        for (int i2 = 0; i2 < this.nglyphs; ++i2) {
            this.mtx_tab[i2].offset = this.loca_format == 1 ? fontFileReader.readTTFULong() : (long)(fontFileReader.readTTFUShort() << 1);
        }
        this.lastLoca = this.loca_format == 1 ? fontFileReader.readTTFULong() : (long)(fontFileReader.readTTFUShort() << 1);
    }

    private final void readGlyf(FontFileReader fontFileReader) throws IOException {
        this.compositeGlyphs = new Hashtable();
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        for (int i2 = 0; i2 < this.nglyphs; ++i2) {
            long l2 = 0L;
            l2 = i2 < this.nglyphs - 1 ? this.mtx_tab[i2 + 1].offset - this.mtx_tab[i2].offset : this.lastLoca - this.mtx_tab[i2].offset;
            if (l2 > 0L) {
                fontFileReader.seek_set(tTFDirTabEntry.offset + this.mtx_tab[i2].offset);
                short s = fontFileReader.readTTFShort();
                this.mtx_tab[i2].bbox[0] = fontFileReader.readTTFShort();
                this.mtx_tab[i2].bbox[1] = fontFileReader.readTTFShort();
                this.mtx_tab[i2].bbox[2] = fontFileReader.readTTFShort();
                this.mtx_tab[i2].bbox[3] = fontFileReader.readTTFShort();
                if (s != -1) continue;
                Vector<Integer> vector = new Vector<Integer>();
                Integer n2 = null;
                int n3 = 0;
                boolean bl = true;
                while (bl) {
                    n3 = fontFileReader.readTTFUShort();
                    n2 = new Integer(fontFileReader.readTTFUShort());
                    vector.addElement(n2);
                    if ((n3 & 1) > 0) {
                        fontFileReader.skip(4L);
                    } else {
                        fontFileReader.skip(2L);
                    }
                    if ((n3 & 8) > 0) {
                        fontFileReader.skip(2L);
                    } else if ((n3 & 0x40) > 0) {
                        fontFileReader.skip(4L);
                    } else if ((n3 & 0x80) > 0) {
                        fontFileReader.skip(8L);
                    }
                    if ((n3 & 0x20) > 0) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                }
                this.compositeGlyphs.put(new Integer(i2), vector);
                continue;
            }
            this.mtx_tab[i2].bbox[0] = this.mtx_tab[0].bbox[0];
            this.mtx_tab[i2].bbox[1] = this.mtx_tab[0].bbox[1];
            this.mtx_tab[i2].bbox[2] = this.mtx_tab[0].bbox[2];
            this.mtx_tab[i2].bbox[3] = this.mtx_tab[0].bbox[3];
        }
    }

    private final void readName(FontFileReader fontFileReader) throws IOException {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        this.seek_tab(fontFileReader, "name", 2L);
        int n5 = fontFileReader.getCurrentPos();
        int n6 = fontFileReader.readTTFUShort();
        int n7 = fontFileReader.readTTFUShort() + n5 - 2;
        n5 += 4;
        while (n6-- > 0) {
            fontFileReader.seek_set(n5);
            n2 = fontFileReader.readTTFUShort();
            n3 = fontFileReader.readTTFUShort();
            n4 = fontFileReader.readTTFUShort();
            int n8 = fontFileReader.readTTFUShort();
            int n9 = fontFileReader.readTTFUShort();
            if ((n2 == 1 && n3 == 0 || n2 == 3 && n3 == 1) && (n8 == 1 || n8 == 2 || n8 == 0 || n8 == 4 || n8 == 6)) {
                fontFileReader.seek_set(n7 + fontFileReader.readTTFUShort());
                String string = n2 == 3 ? fontFileReader.readTTFString(n9, "UTF-16BE") : fontFileReader.readTTFString(n9);
                switch (n8) {
                    case 0: {
                        this.notice = string;
                        break;
                    }
                    case 1: {
                        this.familyName = string;
                        break;
                    }
                    case 2: {
                        this.subFamilyName = string;
                        break;
                    }
                    case 4: {
                        this.fullName = string;
                        break;
                    }
                    case 6: {
                        this.fontName = string;
                    }
                }
                if (!this.notice.equals("") && !this.fullName.equals("") && !this.fontName.equals("") && !this.familyName.equals("") && !this.subFamilyName.equals("")) break;
            }
            n5 += 12;
        }
    }

    private final void readPCLT(FontFileReader fontFileReader) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("PCLT");
        if (tTFDirTabEntry != null) {
            fontFileReader.seek_set(tTFDirTabEntry.offset + 4L + 4L + 2L);
            this.xHeight = fontFileReader.readTTFUShort();
            fontFileReader.skip(4L);
            this.capHeight = fontFileReader.readTTFUShort();
            fontFileReader.skip(34L);
            int n2 = fontFileReader.readTTFUByte();
            n2 >>= 6;
            this.hasSerifs = (n2 &= 3) != 1;
        } else {
            for (int i2 = 0; i2 < this.mtx_tab.length; ++i2) {
                if (!"H".equals(this.mtx_tab[i2].name)) continue;
                this.capHeight = this.mtx_tab[i2].bbox[3] - this.mtx_tab[i2].bbox[1];
            }
        }
    }

    protected final void reduceGLYF(FontFileReader fontFileReader, ByteArrayOutputStream byteArrayOutputStream, ByteArrayOutputStream byteArrayOutputStream2, SortedSet sortedSet) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        int n2 = 0;
        for (int i2 = 0; i2 < this.nglyphs; ++i2) {
            long l2;
            long l3;
            if (this.loca_format == 1) {
                byteArrayOutputStream2.write(this.longToBytes(n2));
            } else {
                byteArrayOutputStream2.write(this.shortToBytes(n2 >> 1));
            }
            if (i2 != 0 && !sortedSet.contains(new Integer(i2)) || (l3 = (l2 = i2 + 1 < this.nglyphs ? this.mtx_tab[i2 + 1].offset : this.lastLoca) - this.mtx_tab[i2].offset) <= 0L) continue;
            fontFileReader.seek_set(tTFDirTabEntry.offset + this.mtx_tab[i2].offset);
            byteArrayOutputStream.write(fontFileReader.readBytes((int)l3));
            n2 = (int)((long)n2 + l3);
        }
        if (this.loca_format == 1) {
            byteArrayOutputStream2.write(this.longToBytes(n2));
        } else {
            byteArrayOutputStream2.write(this.shortToBytes(n2 >> 1));
        }
    }

    protected final void reduceEBLC(FontFileReader fontFileReader, ByteArrayOutputStream byteArrayOutputStream, ByteArrayOutputStream byteArrayOutputStream2, SortedSet sortedSet) throws IOException {
        long l2 = 4L;
        int n2 = 48;
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("EBLC");
        TTFDirTabEntry tTFDirTabEntry2 = (TTFDirTabEntry)this.dirTabs.get("EBDT");
        fontFileReader.seek_set(tTFDirTabEntry2.offset);
        byteArrayOutputStream2.write(fontFileReader.readBytes(4));
        fontFileReader.seek_set(tTFDirTabEntry.offset);
        byteArrayOutputStream.write(fontFileReader.readBytes(4));
        int n3 = (int)fontFileReader.readTTFULong();
        long[] lArray = new long[n3];
        long[] lArray2 = new long[n3];
        long[] lArray3 = new long[n3];
        Vector<Integer> vector = new Vector<Integer>();
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray[i2] = fontFileReader.readTTFULong();
            lArray2[i2] = fontFileReader.readTTFULong();
            lArray3[i2] = fontFileReader.readTTFULong();
            fontFileReader.skip(28L);
            int n4 = fontFileReader.readTTFUShort();
            int n5 = fontFileReader.readTTFUShort();
            SortedSet<Integer> sortedSet2 = sortedSet.subSet(new Integer(n4), new Integer(n5 + 1));
            if (sortedSet2.size() > 0) {
                vector.add(new Integer(i2));
            }
            fontFileReader.skip(1L);
            fontFileReader.skip(1L);
            fontFileReader.skip(1L);
            fontFileReader.skip(1L);
        }
        if (vector.size() == 0) {
            byteArrayOutputStream.reset();
            byteArrayOutputStream2.reset();
            return;
        }
        byteArrayOutputStream.write(this.longToBytes(vector.size()));
        long l3 = 8 + vector.size() * 48;
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            int n6;
            int n7 = (Integer)vector.get(i3);
            long l4 = tTFDirTabEntry.offset + lArray[n7];
            fontFileReader.seek_set(l4);
            Vector<Integer> vector2 = new Vector<Integer>();
            int[] nArray = new int[(int)lArray3[n7]];
            int[] nArray2 = new int[(int)lArray3[n7]];
            long[] lArray4 = new long[(int)lArray3[n7]];
            int n8 = 0;
            while ((long)n8 < lArray3[n7]) {
                nArray[n8] = fontFileReader.readTTFUShort();
                nArray2[n8] = fontFileReader.readTTFUShort();
                lArray4[n8] = fontFileReader.readTTFULong();
                SortedSet<Integer> sortedSet3 = sortedSet.subSet(new Integer(nArray[n8]), new Integer(nArray2[n8]));
                if (sortedSet3.size() != 0) {
                    vector2.add(new Integer(n8));
                }
                ++n8;
            }
            long l5 = vector2.size() * 8;
            ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[vector2.size()];
            for (n6 = 0; n6 < vector2.size(); ++n6) {
                int n9 = (Integer)vector2.get(n6);
                byteArrayOutputStream3.write(this.shortToBytes(nArray[n9]));
                byteArrayOutputStream3.write(this.shortToBytes(nArray2[n9]));
                byteArrayOutputStream3.write(this.longToBytes(l5));
                fontFileReader.seek_set(l4 + lArray4[n9]);
                int n10 = fontFileReader.readTTFUShort();
                int n11 = fontFileReader.readTTFUShort();
                long l6 = fontFileReader.readTTFULong();
                byteArrayOutputStreamArray[n6] = new ByteArrayOutputStream();
                byteArrayOutputStreamArray[n6].write(this.shortToBytes(n10));
                byteArrayOutputStreamArray[n6].write(this.shortToBytes(n11));
                byteArrayOutputStreamArray[n6].write(this.longToBytes(l2));
                if (n10 == 1) {
                    long l7 = fontFileReader.readTTFULong();
                    for (int i4 = 1; i4 < nArray2[n9] - nArray[n9] + 1 + 1; ++i4) {
                        long l8 = fontFileReader.readTTFULong();
                        long l9 = l8 - l7;
                        byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + l6 + l7), (int)l9);
                        byteArrayOutputStreamArray[n6].write(this.longToBytes((int)l2));
                        byteArrayOutputStream2.write(byArray);
                        l2 += (long)byArray.length;
                        l7 = l8;
                    }
                    byteArrayOutputStreamArray[n6].write(this.longToBytes((int)l2));
                } else if (n10 == 2) {
                    long l10 = fontFileReader.readTTFULong();
                    byteArrayOutputStreamArray[n6].write(this.longToBytes(l10));
                    byteArrayOutputStreamArray[n6].write(fontFileReader.readBytes(8));
                    byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + l6), (int)l10);
                    byteArrayOutputStream2.write(byArray);
                    l2 += (long)byArray.length;
                } else if (n10 == 3) {
                    int n12 = fontFileReader.readTTFUShort();
                    int n13 = 0;
                    for (int i5 = 1; i5 < nArray2[n9] - nArray[n9] + 1 + 1; ++i5) {
                        int n14 = fontFileReader.readTTFUShort();
                        int n15 = n14 - n12;
                        n13 += n15;
                        byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + l6 + (long)n12), n15);
                        byteArrayOutputStreamArray[n6].write(this.shortToBytes((int)l2));
                        byteArrayOutputStream2.write(byArray);
                        l2 += (long)byArray.length;
                        n12 = n14;
                    }
                    byteArrayOutputStreamArray[n6].write(this.shortToBytes((int)l2));
                    while (fontFileReader.getCurrentPos() % 4 != 0) {
                        fontFileReader.skip(1L);
                        byteArrayOutputStreamArray[n6].write(0);
                    }
                } else if (n10 == 4) {
                    long l11 = fontFileReader.readTTFULong();
                    byteArrayOutputStreamArray[n6].write(this.longToBytes(l11));
                    int n16 = fontFileReader.readTTFUShort();
                    int n17 = fontFileReader.readTTFUShort();
                    int n18 = 1;
                    while ((long)n18 < l11 + 1L) {
                        int n19 = fontFileReader.readTTFUShort();
                        int n20 = fontFileReader.readTTFUShort();
                        int n21 = n20 - n17;
                        byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + (long)n17), n21);
                        byteArrayOutputStreamArray[n6].write(this.shortToBytes(n16));
                        byteArrayOutputStreamArray[n6].write(this.shortToBytes((int)l2));
                        byteArrayOutputStream2.write(byArray);
                        l2 += (long)byArray.length;
                        n16 = n19;
                        n17 = n20;
                        ++n18;
                    }
                    byteArrayOutputStreamArray[n6].write(this.shortToBytes(n16));
                    byteArrayOutputStreamArray[n6].write(this.shortToBytes((int)l2));
                } else if (n10 == 5) {
                    long l12 = fontFileReader.readTTFULong();
                    byteArrayOutputStreamArray[n6].write(this.longToBytes(l12));
                    byteArrayOutputStreamArray[n6].write(fontFileReader.readBytes(8));
                    long l13 = fontFileReader.readTTFULong();
                    byteArrayOutputStreamArray[n6].write(this.longToBytes(l13));
                    int n22 = 0;
                    while ((long)n22 < l13) {
                        int n23 = fontFileReader.readTTFUShort();
                        byteArrayOutputStreamArray[n6].write(this.shortToBytes(n23));
                        ++n22;
                    }
                    while (fontFileReader.getCurrentPos() % 4 != 0) {
                        fontFileReader.skip(1L);
                        byteArrayOutputStreamArray[n6].write(0);
                    }
                    byte[] byArray = fontFileReader.getBytes((int)(tTFDirTabEntry2.offset + l6), (int)l12);
                    byteArrayOutputStream2.write(byArray);
                    l2 += (long)byArray.length;
                }
                l5 += (long)byteArrayOutputStreamArray[n6].size();
            }
            for (n6 = 0; n6 < vector2.size(); ++n6) {
                byteArrayOutputStream3.write(byteArrayOutputStreamArray[n6].toByteArray());
            }
            long l14 = tTFDirTabEntry.offset + 8L + (long)(n7 * n2);
            fontFileReader.seek_set(l14);
            byteArrayOutputStream.write(this.longToBytes(l3));
            byteArrayOutputStream.write(this.longToBytes(byteArrayOutputStream3.size()));
            byteArrayOutputStream.write(this.longToBytes(vector2.size()));
            byteArrayOutputStream.write(this.longToBytes(0L));
            fontFileReader.skip(16L);
            byteArrayOutputStream.write(fontFileReader.readBytes(12));
            byteArrayOutputStream.write(fontFileReader.readBytes(12));
            byteArrayOutputStream.write(fontFileReader.readBytes(2));
            byteArrayOutputStream.write(fontFileReader.readBytes(2));
            byteArrayOutputStream.write(fontFileReader.readBytes(4));
            l3 = 8 + vector.size() * 48 + byteArrayOutputStream3.size();
        }
        byteArrayOutputStream.write(byteArrayOutputStream3.toByteArray());
    }

    private final void readKerning(FontFileReader fontFileReader) throws IOException {
        this.kerningTab = new Hashtable();
        this.ansiKerningTab = new Hashtable();
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("kern");
        if (tTFDirTabEntry != null) {
            Object object;
            Integer n2;
            this.seek_tab(fontFileReader, "kern", 2L);
            for (int i2 = fontFileReader.readTTFUShort(); i2 > 0; --i2) {
                fontFileReader.skip(4L);
                int n3 = fontFileReader.readTTFUShort();
                if ((n3 & 1) == 0 || (n3 & 2) != 0 || (n3 & 4) != 0) {
                    System.err.println("Warning: TTF: only Kern format 1 is supported.  This is format " + (n3 & 3));
                    return;
                }
                if (n3 >> 8 != 0) {
                    System.err.println("Warning: TTF: Ignoring this kerning table.");
                    continue;
                }
                n3 = fontFileReader.readTTFUShort();
                fontFileReader.skip(6L);
                while (n3-- > 0) {
                    int n4 = fontFileReader.readTTFUShort();
                    int n5 = fontFileReader.readTTFUShort();
                    short s = fontFileReader.readTTFShort();
                    if (s == 0) continue;
                    n2 = new Integer(n4);
                    object = (Hashtable)this.kerningTab.get(n2);
                    if (object == null) {
                        object = new Hashtable();
                    }
                    object.put(new Integer(n5), new Integer(this.get_ttf_funit(s)));
                    this.kerningTab.put(n2, object);
                }
            }
            Enumeration enumeration = this.kerningTab.keys();
            while (enumeration.hasMoreElements()) {
                Integer n6 = (Integer)enumeration.nextElement();
                Hashtable<Integer, Integer[]> hashtable = new Hashtable<Integer, Integer[]>();
                Hashtable hashtable2 = (Hashtable)this.kerningTab.get(n6);
                Enumeration<Object> enumeration2 = hashtable2.keys();
                while (enumeration2.hasMoreElements()) {
                    n2 = (Integer)enumeration2.nextElement();
                    object = (Integer[])hashtable2.get(n2);
                    Enumeration enumeration3 = this.mtx_tab[n2.intValue()].unicodeIndex.elements();
                    while (enumeration3.hasMoreElements()) {
                        Integer n7 = (Integer)enumeration3.nextElement();
                        Integer[] integerArray = this.unicodeToWinAnsi(n7);
                        for (int i3 = 0; i3 < integerArray.length; ++i3) {
                            hashtable.put(integerArray[i3], (Integer[])object);
                        }
                    }
                }
                if (hashtable.size() <= 0) continue;
                enumeration2 = this.mtx_tab[n6.intValue()].unicodeIndex.elements();
                while (enumeration2.hasMoreElements()) {
                    n2 = (Integer)enumeration2.nextElement();
                    object = this.unicodeToWinAnsi(n2);
                    for (int i4 = 0; i4 < ((Integer[])object).length; ++i4) {
                        this.ansiKerningTab.put(object[i4], hashtable);
                    }
                }
            }
        }
    }

    public Vector getCMaps() {
        return this.cmaps;
    }

    protected final boolean checkTTC(FontFileReader fontFileReader, String string, boolean bl) throws IOException {
        String string2 = fontFileReader.readTTFString(4);
        if ("ttcf".equals(string2)) {
            int n2;
            fontFileReader.skip(4L);
            int n3 = (int)fontFileReader.readTTFULong();
            long[] lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = fontFileReader.readTTFULong();
            }
            if (bl) {
                System.err.println("This is a TrueType collection file with" + n3 + " fonts");
                System.err.println("Containing the following fonts: ");
            }
            n2 = 0;
            this.dirTabOffset = 0L;
            for (int i2 = 0; i2 < n3; ++i2) {
                fontFileReader.seek_set(lArray[i2]);
                if (!this.readDirTabs(fontFileReader)) {
                    this.addInvalidFileStatusMessage();
                    this.setStatus(2);
                }
                this.readName(fontFileReader);
                if (this.fontName.equals(string)) {
                    if (bl) {
                        System.err.println("* " + this.fullName);
                    }
                    if (this.isUnicode(fontFileReader)) {
                        n2 = 1;
                        this.dirTabOffset = lArray[i2];
                    } else {
                        this.addNoUnicodeStatusMessage();
                        this.setStatus(2);
                    }
                } else if (bl) {
                    System.err.println(this.fullName);
                }
                this.notice = "";
                this.fullName = "";
                this.familyName = "";
                this.fontName = "";
                this.subFamilyName = "";
            }
            fontFileReader.seek_set(this.dirTabOffset);
            return n2 != 0;
        }
        fontFileReader.seek_set(0L);
        return true;
    }

    protected final boolean checkTTCForFontNames(FontFileReader fontFileReader, List list, boolean bl, boolean bl2) throws IOException {
        String string = fontFileReader.readTTFString(4);
        if ("ttcf".equals(string)) {
            int n2;
            fontFileReader.skip(4L);
            int n3 = (int)fontFileReader.readTTFULong();
            long[] lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = fontFileReader.readTTFULong();
            }
            if (bl) {
                System.err.println("This is a TrueType collection file with" + n3 + " fonts");
                System.err.println("Containing the following fonts: ");
            }
            n2 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                fontFileReader.seek_set(lArray[i2]);
                if (!this.readDirTabs(fontFileReader)) {
                    this.addInvalidFileStatusMessage();
                    this.setStatus(2);
                }
                this.readName(fontFileReader);
                if (bl) {
                    System.err.println(this.fullName);
                }
                if (this.isUnicode(fontFileReader)) {
                    if (bl2) {
                        TTFFontNames tTFFontNames = new TTFFontNames();
                        tTFFontNames.fontName = this.fontName;
                        tTFFontNames.fullName = this.fullName;
                        tTFFontNames.familyName = this.familyName;
                        tTFFontNames.subFamilyName = this.subFamilyName;
                        list.add(tTFFontNames);
                    } else {
                        list.add(this.fontName);
                    }
                } else {
                    this.addNoUnicodeStatusMessage();
                    this.setStatus(2);
                }
                this.notice = "";
                this.fullName = "";
                this.familyName = "";
                this.fontName = "";
                this.subFamilyName = "";
            }
            fontFileReader.seek_set(0L);
            return true;
        }
        fontFileReader.seek_set(0L);
        return false;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getNotice() {
        return this.notice;
    }

    public boolean isFixedPitch() {
        return this.isFixedPitch != 0L;
    }

    public double getVersion() {
        return this.version;
    }

    public int getUnderlinePosition() {
        return this.get_ttf_funit(this.underlinePosition);
    }

    public int getUnderlineThickness() {
        return this.get_ttf_funit(this.underlineThickness);
    }

    private Integer[] unicodeToWinAnsi(int n2) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i2 = 32; i2 < Glyphs.winAnsiEncoding.length; ++i2) {
            if (n2 != Glyphs.winAnsiEncoding[i2]) continue;
            vector.addElement(new Integer(i2));
        }
        Object[] objectArray = new Integer[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

